/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bytecode.JavaAssembler;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.EvaluateAssembler;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.EvaluateFunction;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.ExprVisitor;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.Treewalker;
import coldfusion.runtime.CFPage;
import coldfusion.util.AbstractCache;
import coldfusion.util.LruCache;
import coldfusion.util.SoftCache;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;

public class ExprClassLoader
extends ClassLoader {
    public static ThreadLocal inWebSocketScope = new ThreadLocal();
    private static long id;
    private static final ExprCache stmtCache;
    private static final ExprCache setCache;
    private static final Set keywords;

    private ExprClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    Class defineSet(ExprNode lval) throws IOException {
        String className = ExprClassLoader.createName("Set");
        Treewalker.postorder(lval, new ExprVisitor());
        EvaluateAssembler asm = new EvaluateAssembler(className);
        byte[] classBytes = asm.assembleSet(lval);
        return this.defineClass(className, classBytes, 0, classBytes.length);
    }

    Class defineStatement(ASTcfscriptStatement statement) throws IOException {
        statement.preTransformAssignment(JavaAssembler.doubleClass);
        Treewalker.postorder(statement, new ExprVisitor());
        String className = ExprClassLoader.createName("Statement");
        EvaluateAssembler asm = new EvaluateAssembler(className);
        byte[] bytes = asm.assembleStatement(statement);
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    public static Object evaluate(String expr, CFPage page) throws ParseException {
        if ((expr = expr.trim()).length() == 0) {
            return expr;
        }
        switch (expr.charAt(0)) {
            case 'T': 
            case 't': {
                if (!expr.equalsIgnoreCase("true")) break;
                return expr;
            }
            case 'F': 
            case 'f': {
                if (!expr.equalsIgnoreCase("false")) break;
                return expr;
            }
        }
        if (ExprClassLoader.isIdentifierExpr(expr)) {
            return page._autoscalarize(expr);
        }
        return ExprClassLoader.compileStatement(expr).evaluate(page, null);
    }

    public static boolean isIdentifierExpr(String expr) {
        int exprLen = expr.length();
        boolean legal = true;
        boolean start = true;
        boolean dot = false;
        block4: for (int i = 0; i < exprLen && legal; ++i) {
            char c = expr.charAt(i);
            switch (c) {
                case '.': {
                    dot = true;
                    if (start) {
                        legal = false;
                    }
                    start = true;
                    continue block4;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (start) {
                        legal = false;
                    }
                    start = false;
                    continue block4;
                }
                default: {
                    start = false;
                    if (c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue block4;
                    legal = false;
                }
            }
        }
        return !start && legal && (dot || !keywords.contains(expr.toLowerCase()));
    }

    public static EvaluateFunction compileStatementForWebSokcet(String expr) throws ParseException {
        inWebSocketScope.set(Boolean.TRUE);
        EvaluateFunction exprFunction = ExprClassLoader.compileStatement(expr);
        inWebSocketScope.remove();
        return exprFunction;
    }

    public static EvaluateFunction compileStatement(final String expr) throws ParseException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return (EvaluateFunction)stmtCache.get(expr);
        }
        try {
            return (EvaluateFunction)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (EvaluateFunction)stmtCache.get(expr);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    private static synchronized String createName(String prefix) {
        return prefix + id++;
    }

    public static void set(String name, Object value, CFPage page) {
        String varName = name.trim();
        if (ExprClassLoader.isIdentifierExpr(varName)) {
            page._set(varName, value);
        } else {
            ((EvaluateFunction)setCache.get(name)).evaluate(page, value);
        }
    }

    private static void saveClass(String className, byte[] classBytes) throws IOException {
        try (FileOutputStream out = new FileOutputStream(className + ".clas");){
            out.write(classBytes);
        }
    }

    public static void main(String[] args) throws Throwable {
        CFPage testPage = null;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String expr = args[i];
                System.out.print(expr + " => ");
                ExprClassLoader.test(expr, testPage);
            }
        } else {
            int c;
            StringBuffer b = new StringBuffer();
            System.out.print("=> ");
            System.out.flush();
            while ((c = System.in.read()) != -1) {
                b.append((char)c);
                if (c != 10) continue;
                String expr = b.toString();
                ExprClassLoader.test(expr, testPage);
                b = new StringBuffer();
                System.out.print("=> ");
                System.out.flush();
            }
        }
    }

    private static void test(String expr, CFPage page) {
        try {
            Object value = ExprClassLoader.evaluate(expr, page);
            System.out.println(value);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    static {
        stmtCache = new ExprCache(new StatementCache());
        setCache = new ExprCache(new SetCache());
        String[] words = new String[]{"imp", "eqv", "xor", "or", "and", "not", "eq", "equal", "is", "neq", "lt", "lte", "le", "gt", "gte", "ge", "contains", "mod"};
        keywords = new HashSet(words.length);
        for (int i = 0; i < words.length; ++i) {
            keywords.add(words[i]);
        }
    }

    private static class ExprCache
    extends SoftCache {
        final AbstractCache secondary;

        ExprCache(AbstractCache secondary) {
            this.secondary = secondary;
        }

        @Override
        public synchronized void clear() {
            super.clear();
            this.secondary.clear();
        }

        @Override
        protected Object fetchSerial(Object expr) {
            return this.secondary.get(expr);
        }

        @Override
        public synchronized void setSize(int capacity) {
            super.setSize(capacity);
            this.secondary.setSize(capacity);
        }

        @Override
        public synchronized void remove(Object expr) {
            super.remove(expr);
            this.secondary.remove(expr);
        }

        public String toString() {
            return "Expression Soft Cache";
        }
    }

    static class StatementCache
    extends LruCache {
        StatementCache() {
        }

        @Override
        protected Object fetch(Object expr) {
            ASTcfscriptStatement statement = EvaluateEngine.parse((String)expr, null);
            try {
                ExprClassLoader loader = new ExprClassLoader();
                return (EvaluateFunction)loader.defineStatement(statement).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ParseException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    static class SetCache
    extends LruCache {
        SetCache() {
        }

        @Override
        protected Object fetch(Object expr) {
            ExprNode lval = EvaluateEngine.parseCFMLExpr((String)expr, null);
            try {
                ExprClassLoader loader = new ExprClassLoader();
                return (EvaluateFunction)loader.defineSet(lval).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

