/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bytecode.JavaAssembler;
import coldfusion.compiler.ASTcfbreak;
import coldfusion.compiler.ASTcfcase;
import coldfusion.compiler.ASTcfcatch;
import coldfusion.compiler.ASTcfcontinue;
import coldfusion.compiler.ASTcfimport;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcfswitch;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.ASTtoolkit;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.FactoredNodeAggregation;
import coldfusion.compiler.ImplicitInitializerTransformer;
import coldfusion.compiler.LocalVariableReference;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.SliceMetadataNode;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.Token;
import coldfusion.compiler.TreeTransformer;
import coldfusion.compiler.validation.FunctionInvalidParameterExceptionVariadic;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.Closure;
import coldfusion.runtime.ParamValueAnnotation;
import coldfusion.runtime.ParametersAnnotation;
import jakarta.servlet.jsp.tagext.Tag;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public final class ExprVisitor
implements TreeTransformer {
    private NeoTranslationContext tc;
    private static final Method checkCfimport = JavaAssembler.getInstanceMethod(CfJspPage.class, "_checkCFImport", new Class[0]);
    private static final int MAX_STRING = 8191;
    static final Method getBaseTagList = JavaAssembler.getInstanceMethod(CFPage.class, "GetBaseTagList", new Class[0]);
    static final Method getBaseTagListParent = JavaAssembler.getInstanceMethod(CFPage.class, "GetBaseTagList", new Class[]{Tag.class});

    public ExprVisitor() {
        this(null);
    }

    public ExprVisitor(NeoTranslationContext tc) {
        this.tc = tc;
    }

    @Override
    public Node preTransform(Node n) {
        switch (n.id) {
            case 3: {
                ASTcfscriptStatement cfscriptstmtNode = (ASTcfscriptStatement)n;
                if (cfscriptstmtNode.stmtType != 3) break;
                ImplicitInitializerTransformer.pretransformInitializer(cfscriptstmtNode);
            }
        }
        return n;
    }

    @Override
    public Node transform(Node n) {
        switch (n.id) {
            case 16: {
                return this.cfimport((ASTcfimport)n);
            }
            case 10001: {
                return this.call((ASTruntimeCall)n);
            }
            case 17: {
                return this.cfswitch((ASTcfswitch)n);
            }
            case 9: {
                return this.cfbreak((ASTcfbreak)n);
            }
            case 10: {
                return this.cfcontinue((ASTcfcontinue)n);
            }
            case 8: {
                this.insertCast(n, 0, String.class, true);
                return n;
            }
            case 5: {
                if (n.getNamedAttribute("RVAL") != null) {
                    this.insertCast(n, "RVAL", Object.class);
                } else {
                    n.setNamedAttribute("RVAL", ASTtoolkit.literal(n, null));
                }
                return n;
            }
            case 24: {
                ExprNode exprValueNode = ((TagNode)n).getAttrNode("default");
                if (exprValueNode != null) {
                    this.insertCast(n, "default", Object.class);
                }
                return n;
            }
            case 28: {
                if (n instanceof SliceMetadataNode) {
                    ExprNode[] exprNodes;
                    block26: for (ExprNode node : exprNodes = new ExprNode[]{((SliceMetadataNode)n).getStartIndex(), ((SliceMetadataNode)n).getEndIndex(), ((SliceMetadataNode)n).getStep()}) {
                        if (!(node instanceof ASToperator)) continue;
                        switch (((ASToperator)node).id) {
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 207: 
                            case 209: 
                            case 210: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 231: 
                            case 232: 
                            case 233: 
                            case 234: {
                                this.insertCast((Node)node, node.getType(), true);
                                continue block26;
                            }
                            case 215: {
                                this.insertCast((Node)node, node.getType(), true);
                            }
                        }
                    }
                }
                return n;
            }
            case 3: {
                ASTcfscriptStatement cfscript = (ASTcfscriptStatement)n;
                switch (cfscript.getStatementType()) {
                    case 3: {
                        this.assignment(n);
                        break;
                    }
                    case 1: 
                    case 11: {
                        n.id = 4;
                    }
                }
                return n;
            }
            case 27: {
                return this.literal((ASTliteral)n);
            }
            case 21: {
                ASTtagAttribute tagAttr = (ASTtagAttribute)n;
                Node attrValue = tagAttr.getValueNode();
                Node newVal = this.transform(attrValue);
                if (newVal != attrValue) {
                    tagAttr.setRuntimeValue(newVal);
                }
                return n;
            }
            case 14: {
                ASTcfcatch asTcfcatch = (ASTcfcatch)n;
                List<ExprNode> pipedExceptions = asTcfcatch.getAdditionalExceptionExpr();
                if (pipedExceptions != null && !pipedExceptions.isEmpty()) {
                    ListIterator<ExprNode> iterator = pipedExceptions.listIterator();
                    while (iterator.hasNext()) {
                        Node oldExpr = iterator.next();
                        Node newExpr = this.transform(oldExpr);
                        if (newExpr == oldExpr) continue;
                        iterator.set((ExprNode)newExpr);
                    }
                    asTcfcatch.validate();
                }
                return n;
            }
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 231: 
            case 232: 
            case 233: 
            case 234: {
                this.insertCast(n, ((ExprNode)n).getType(), true);
                return n;
            }
            case 215: {
                this.insertCast(n, ((ExprNode)n).getType(), false);
                return n;
            }
            case 224: 
            case 225: {
                this.insertCast(n, String.class, true);
                return n;
            }
        }
        return n;
    }

    public void insertCast(Node parent, Class type, boolean ignoreForClient) {
        int count = parent.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            this.insertCast(parent, i, type, ignoreForClient);
        }
    }

    public void insertCast(Node parent, int i, Class type, boolean ignoreForClient) {
        Node child = parent.jjtGetChild(i);
        child = ASTtoolkit.cast(child, type);
        parent.jjtAddChild(child, i);
    }

    private void insertCast(Node parent, String attr, Class type) {
        Node childNode = parent.getNamedAttribute(attr);
        if (childNode instanceof ExprNode) {
            ExprNode child = (ExprNode)childNode;
            if (child == null) {
                child = new ASTliteral(null, parent);
            }
            child = ASTtoolkit.cast(child, type);
            parent.setNamedAttribute(attr, child);
        }
    }

    private void assignment(Node node) {
        if (node.getNamedAttribute("RVAL") instanceof ExprNode) {
            ASTruntimeCall methCall;
            ExprNode rval = (ExprNode)node.getNamedAttribute("RVAL");
            if (rval != null && rval.id == 10001 && (methCall = (ASTruntimeCall)rval).isBuiltin() && !methCall.getFunctionName().equalsIgnoreCase("isNull")) {
                Method m = null;
                m = methCall.isVariadic() ? methCall.getVariadicMethod() : methCall.getMethod(CFPage.class);
                if (m != null && m.getReturnType() == Void.TYPE) {
                    throw new VoidReturnAssignmentException(methCall.getFunctionName(), methCall.getNameToken());
                }
            }
            this.insertCast(node, "RVAL", Object.class);
        }
    }

    public Node cfswitch(ASTcfswitch cfswitch) {
        cfswitch.lookupTableName = this.tc.createLookupTable();
        if (cfswitch.isCFSWITCH) {
            cfswitch.setWhitespaceSuppression(2);
        }
        Node[] children = cfswitch.children;
        boolean nonCaseOK = false;
        if (!cfswitch.isCFSWITCH && children != null && children.length == 1 && children[0] instanceof ASTcfscriptStatement && ((ASTcfscriptStatement)children[0]).getStatementType() == 1) {
            children = children[0].children;
        }
        for (int i = 0; children != null && i < children.length; ++i) {
            Node n = children[i];
            if (n == null || n instanceof ASTpcdata) continue;
            if (n instanceof ASTcfcase) {
                if (cfswitch.isCFSWITCH) continue;
                nonCaseOK = true;
                continue;
            }
            if (n instanceof ASTcfbreak && nonCaseOK) {
                nonCaseOK = false;
                continue;
            }
            if (nonCaseOK) continue;
            throw new UnknownSwitchChildException(n, cfswitch.isCFSWITCH);
        }
        return cfswitch;
    }

    public Node cfbreak(ASTcfbreak cfbreak) {
        if (!cfbreak.isCFScript()) {
            cfbreak.getSelfFactoringTarget();
        }
        return cfbreak;
    }

    public Node cfcontinue(ASTcfcontinue cfcontinue) {
        if (!cfcontinue.isCFScript()) {
            cfcontinue.getSelfFactoringTarget();
        }
        return cfcontinue;
    }

    private static Vector breakUpLongLiteral(String literal) {
        int len;
        Vector<String> newElements = new Vector<String>();
        int pos = 0;
        do {
            if ((len = literal.length() - pos) > 8191) {
                len = 8191;
            }
            newElements.add(literal.substring(pos, pos + len));
        } while ((pos += len) < literal.length());
        return newElements;
    }

    private Node literal(ASTliteral literal) {
        Vector newTokens = new Vector(literal.tokens.size());
        for (int t = 0; t < literal.tokens.size(); ++t) {
            String s;
            Object o = literal.tokens.get(t);
            if (o instanceof String && (s = (String)o).length() > 8191) {
                newTokens.addAll(ExprVisitor.breakUpLongLiteral(s));
                continue;
            }
            newTokens.add(o);
        }
        literal.tokens = newTokens;
        if (literal.tokens.size() > 1) {
            ASToperator concat = new ASToperator(202);
            if (literal.isSpreadOperationType()) {
                concat.setSpreadOperation(true);
            }
            for (int i = literal.tokens.size() - 1; i >= 0; --i) {
                Object o = literal.tokens.get(i);
                if (o instanceof ExprNode) {
                    concat.jjtAddChild((ExprNode)o, i);
                } else {
                    ASTliteral tempLiteral = new ASTliteral(o, literal);
                    if (literal.isSpreadOperationType()) {
                        tempLiteral.setSpreadOperation(true);
                    }
                    concat.jjtAddChild(tempLiteral, i);
                }
                concat.setOperator(null, 202, String.class);
            }
            concat.setStartToken(literal.getStartToken());
            concat.setEndToken(literal.getEndToken());
            concat.jjtSetParent(literal.jjtGetParent());
            concat.setType(String.class);
            this.insertCast((Node)concat, concat.getType(), true);
            return concat;
        }
        Object o = literal.tokens.get(0);
        if (o instanceof ExprNode) {
            ExprNode expr = (ExprNode)o;
            literal.setType(expr.getType());
        }
        return literal;
    }

    String tagParentVarName(Node node) {
        ASTfunctionDefinition enclosingFunction = node.getFunctionDef();
        Object result = null;
        for (Node n = node.jjtGetParent(); n != enclosingFunction && result == null; n = n.jjtGetParent()) {
            if (n instanceof TagNode && ((TagNode)n).getTagVar() != null) {
                return ((TagNode)n).getTagVar();
            }
            if (!(n instanceof FactoredNodeAggregation)) continue;
            return ((FactoredNodeAggregation)n).getParentVar();
        }
        return "parent";
    }

    private String getFullNameforArgument(String functionName, String paramName, int paramCount) {
        if ((paramName.equalsIgnoreCase("IV") || paramName.equalsIgnoreCase("Salt")) && (functionName.equalsIgnoreCase("encrypt") || functionName.equalsIgnoreCase("encryptbinary") || functionName.equalsIgnoreCase("decrypt"))) {
            return "IV_Salt";
        }
        switch (functionName) {
            case "arrayfind": 
            case "arrayfindall": {
                if (!paramName.equalsIgnoreCase("value") && !paramName.equalsIgnoreCase("callback")) break;
                return "value_Callback";
            }
            case "spreadsheetgetcolumncount": 
            case "spreadsheetread": {
                if (!paramName.equalsIgnoreCase("sheetname") && !paramName.equalsIgnoreCase("sheetnumber")) break;
                return "sheetName_SheetNumber";
            }
            case "replacenocase": {
                if (!paramName.equalsIgnoreCase("replacement") && !paramName.equalsIgnoreCase("callback")) break;
                return "replacement_Callback";
            }
            case "objectload": {
                if (!paramName.equalsIgnoreCase("object") && !paramName.equalsIgnoreCase("filepath")) break;
                return "object_FilePath";
            }
            case "fileread": {
                if (!paramName.equalsIgnoreCase("charset") && !paramName.equalsIgnoreCase("buffersize")) break;
                return "charset_BufferSize";
            }
            case "listsort": {
                if (paramCount != 3 || !paramName.equalsIgnoreCase("order") && !paramName.equalsIgnoreCase("delimiter")) break;
                return "Order_Delimiter";
            }
            case "queryaddrow": {
                if (!paramName.equalsIgnoreCase("number") && !paramName.equalsIgnoreCase("data")) break;
                return "number_Data";
            }
            case "querynew": {
                if (paramCount != 1 || !paramName.equalsIgnoreCase("columnnames") && !paramName.equalsIgnoreCase("data")) break;
                return "columnNames_Data";
            }
            case "tobase64": {
                if (!paramName.equalsIgnoreCase("string") && !paramName.equalsIgnoreCase("binarydata")) break;
                return "string_BinaryData";
            }
            case "structsort": {
                if (paramCount != 2 || !paramName.equalsIgnoreCase("sorttype") && !paramName.equalsIgnoreCase("callback")) break;
                return "sortType_Callback";
            }
            case "structnew": {
                if (!paramName.equalsIgnoreCase("sorttype") && !paramName.equalsIgnoreCase("callback")) break;
                return "sortType_Callback";
            }
            case "ormindex": {
                if (!paramName.equalsIgnoreCase("entityname") && !paramName.equalsIgnoreCase("instance")) break;
                return "entityName_Instance";
            }
            case "filegetmimetype": {
                if (!paramName.equalsIgnoreCase("file") && !paramName.equalsIgnoreCase("filepath")) break;
                return "file_FilePath";
            }
            case "entityload": {
                if (paramName.equalsIgnoreCase("unique") || paramName.equalsIgnoreCase("order")) {
                    return "unique_Order";
                }
                if (!paramName.equalsIgnoreCase("id") && !paramName.equalsIgnoreCase("filter")) break;
                return "id_Filter";
            }
            case "createobject": {
                if (paramName.equalsIgnoreCase("action") || paramName.equalsIgnoreCase("dotnetport")) {
                    return "action_DotnetPort";
                }
                if (paramName.equalsIgnoreCase("server") || paramName.equalsIgnoreCase("locale") || paramName.equalsIgnoreCase("jarversion")) {
                    return "server_Locale_jarversion";
                }
                if (!paramName.equalsIgnoreCase("context") && !paramName.equalsIgnoreCase("portname") && !paramName.equalsIgnoreCase("assembly") && !paramName.equalsIgnoreCase("jarname")) break;
                return "context_PortName_Assembly_jarname";
            }
        }
        return paramName;
    }

    private Node call(ASTruntimeCall call) {
        if (!call.isAssociativeArrayNotation() && call.getFunctionName().equalsIgnoreCase("isNull") && call.getStem() instanceof ASTsimpleVariableReference && "ISNULL".equalsIgnoreCase(((ASTsimpleVariableReference)call.getStem()).getCodegenVariableName())) {
            if (call.arguments.children[0] instanceof ASTtagAttribute && !call.isNew()) {
                call.setNamedParameterFunctionCall(true);
                String argName = ((ASTtagAttribute)call.arguments.children[0]).getName();
                if (!argName.equalsIgnoreCase("value")) {
                    throw new FunctionInvalidParameterExceptionVariadic("IsNull", Arrays.asList("value"));
                }
                Node grandChildren = call.arguments.children[0].getNamedAttribute(argName);
                call.arguments.jjtAddChild(grandChildren, 0);
            }
            if (call.arguments.children[0] instanceof ASTliteral) {
                ASTliteral falseLit = new ASTliteral(false);
                falseLit.jjtSetParent(call.jjtGetParent());
                return falseLit;
            }
            call.setType(Boolean.TYPE);
            return call;
        }
        if (call.isBuiltin()) {
            ArrayList<String> multiParameterNamedFunctions = new ArrayList<String>(Arrays.asList("createobject", "tobase64", "structsort", "structnew", "ormindex", "filegetmimetype", "entityload", "encrypt", "encryptbinary", "decrypt", "listsort", "fileread", "objectload", "replacenocase", "spreadsheetgetcolumncount", "spreadsheetread", "arrayfind", "arrayfindall", "queryaddrow", "querynew"));
            int childCount = call.arguments.jjtGetNumChildren();
            call.setNamedParameterFunctionCall(false);
            HashMap<String, Node> functionArgsMap = new HashMap<String, Node>();
            String functionName = call.getFunctionName().toLowerCase();
            for (int i = 0; i < childCount; ++i) {
                if (!(call.arguments.children[i] instanceof ASTtagAttribute) || call.isNew()) continue;
                call.setNamedParameterFunctionCall(true);
                String argName = ((ASTtagAttribute)call.arguments.children[i]).getName();
                Node grandChildren = call.arguments.children[i].getNamedAttribute(argName);
                if (multiParameterNamedFunctions.contains(functionName)) {
                    argName = this.getFullNameforArgument(functionName, argName, childCount);
                }
                functionArgsMap.put(argName.toLowerCase(), grandChildren);
                call.arguments.jjtAddChild(grandChildren, i);
            }
            if (call.isNamedParameterFunctionCall()) {
                Node childNode;
                Method builtInMethod = call.findAndSetApproximateMethod(functionArgsMap, CFPage.class);
                List<Parameter> paramList = Arrays.asList(builtInMethod.getParameters());
                ArrayList<String> paramNameList = new ArrayList<String>();
                for (Parameter parameter : paramList) {
                    paramNameList.add(parameter.getName().toLowerCase());
                }
                for (String funcArgName : functionArgsMap.keySet()) {
                    if (paramNameList.contains(funcArgName)) continue;
                    throw new FunctionInvalidParameterExceptionVariadic(builtInMethod.getName(), paramNameList);
                }
                Map<String, String> paramDefaultValuesMap = this.getParamDefaultValuesMap(builtInMethod);
                for (int i = 0; i < builtInMethod.getParameterCount(); ++i) {
                    Node childNode2 = (Node)functionArgsMap.get(paramNameList.get(i));
                    if (childNode2 == null) {
                        String nodeValue = paramDefaultValuesMap.get(paramNameList.get(i));
                        if (nodeValue == null) {
                            throw new FunctionInvalidParameterExceptionVariadic(builtInMethod.getName(), paramNameList);
                        }
                        childNode2 = nodeValue.isEmpty() ? new ASTliteral(null) : new ASTliteral(nodeValue);
                    }
                    call.arguments.jjtAddChild(childNode2, i);
                }
                if ((call.getFunctionName().equalsIgnoreCase("valuelist") || call.getFunctionName().equalsIgnoreCase("quotedvaluelist")) && (childNode = call.arguments.children[0]) instanceof ASTstructureReference) {
                    childNode = new ASTliteral(childNode.getStartToken().image);
                    call.arguments.jjtAddChild(childNode, 0);
                }
            } else {
                call.setMethod();
            }
            childCount = call.arguments.jjtGetNumChildren();
            if (call.arguments.getMethod().equals(getBaseTagList) && childCount == 0) {
                call.arguments.setMethod(getBaseTagListParent);
                LocalVariableReference ref = new LocalVariableReference(call.arguments, this.tagParentVarName(call));
                call.arguments.jjtAddChild(ref, 0);
                childCount = 1;
                ref.setType(Tag.class);
            }
            if (call.isNew()) {
                ASTliteral newCfcName = null;
                if (call.getNewArgumentCfc() instanceof ASTliteral) {
                    newCfcName = (ASTliteral)call.getNewArgumentCfc();
                    call.setNewArgumentCfc((ExprNode)this.literal(newCfcName));
                }
            } else {
                for (int i = 0; i < childCount; ++i) {
                    Class reqType = call.arguments.getParamType(i);
                    if (reqType.isAssignableFrom(Closure.class)) continue;
                    this.insertCast(call.arguments, i, reqType, true);
                }
            }
        } else {
            call.arguments.setVariadic(true);
            call.setType(Object.class);
        }
        return call;
    }

    private Node cfimport(ASTcfimport cfimport) {
        if (cfimport.shouldCheckLic()) {
            return ASTtoolkit.statementLevelExpr(new ASTruntimeCall(cfimport.jjtGetParent(), checkCfimport, new Node[0]));
        }
        return cfimport;
    }

    private Map<String, String> getParamDefaultValuesMap(Method method) {
        HashMap<String, String> paramvalueMap = new HashMap<String, String>();
        if (method.isAnnotationPresent(ParametersAnnotation.class)) {
            ParamValueAnnotation[] annotations;
            for (ParamValueAnnotation annotation : annotations = method.getAnnotation(ParametersAnnotation.class).value()) {
                if (!(annotation instanceof ParamValueAnnotation)) continue;
                ParamValueAnnotation paramValueAnnotation = annotation;
                paramvalueMap.put(paramValueAnnotation.name().toLowerCase(), paramValueAnnotation.value());
            }
        }
        return paramvalueMap;
    }

    public static class VoidReturnAssignmentException
    extends ParseException {
        private String meth = null;

        VoidReturnAssignmentException(String methName, Token tok) {
            super(tok);
            this.meth = methName;
        }

        public String getMethodName() {
            return this.meth;
        }
    }

    public static class UnknownSwitchChildException
    extends ParseException {
        boolean isCfswitch;

        public UnknownSwitchChildException(Node invalidNode, boolean isCfswitch) {
            super(invalidNode.getStartToken());
            this.isCfswitch = isCfswitch;
        }

        @Override
        public String getMessage() {
            if (this.isCfswitch) {
                return UnknownSwitchChildException.getString(this, "messageCFSWITCH", this.locale);
            }
            return UnknownSwitchChildException.getString(this, "messageScript", this.locale);
        }
    }
}

