/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTDestructParamValidator;
import coldfusion.compiler.ASTDestructring;
import coldfusion.compiler.ASTObjectDestructuring;
import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcfargument;
import coldfusion.compiler.ASTcfcase;
import coldfusion.compiler.ASTcffunction;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTexprlist;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTparameterDefinition;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.ASTvariableDefinition;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.FactoredNodeAggregation;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.Node;
import coldfusion.compiler.StatementNode;
import coldfusion.compiler.StmtAssembler;
import coldfusion.compiler.Token;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.UndefinedStaticVariableException;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import coldfusion.tools.Compiler;
import coldfusion.util.FastHashtable;
import coldfusion.util.Key;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class FunctionAssembler
extends StmtAssembler {
    static final Class LocalScopeClass = LocalScope.class;
    static final Class keyClass = Key.class;
    static final Method bindInternalKeyValue = FunctionAssembler.getInstanceMethod(LocalScopeClass, "bindInternal", new Class[]{keyClass, ObjectClass});
    static final Method bindInternal = FunctionAssembler.getInstanceMethod(LocalScopeClass, "bindInternal", new Class[]{StringClass});
    static final Method bindInternalFinal = FunctionAssembler.getInstanceMethod(LocalScopeClass, "bindInternal_Final", new Class[]{StringClass});
    static final Method localPutVariable = FunctionAssembler.getInstanceMethod(LocalScopeClass, "putVariable", new Class[]{VariableClass});
    private static final Method getStaticScope = FunctionAssembler.getDeclaredMethod(UDFMethodClass, "getStaticScope", new Class[0]);
    static Method runFunction = FunctionAssembler.getDeclaredMethod(UDFMethodClass, "runFunction", new Class[]{LocalScopeClass, ObjectClass, CFPageClass, ArgumentCollectionClass});
    static Method getParamList = FunctionAssembler.getDeclaredMethod(UDFMethodClass, "getParamList", new Class[0]);
    static Method getName = FunctionAssembler.getDeclaredMethod(UDFMethodClass, "getName", new Class[0]);
    static Method throwUnsupportedException = FunctionAssembler.getStaticMethod(UDFMethodClass, "throwUnSupportedException", new Class[]{StringClass});
    static Field THIS = FunctionAssembler.getStaticField(keyClass, "THIS");
    static Field ARGUMENTS = FunctionAssembler.getStaticField(keyClass, "ARGUMENTS");
    private ASTfunctionDefinition function;
    private final String className;
    private ASTDestructParamValidator astDestructParamValidator = null;
    Object localScopeParam;
    Object argumentsParam;
    Object functionVar;
    static Method variableSet = FunctionAssembler.getInstanceMethod(VariableClass, "set", new Class[]{ObjectClass});
    static Method argumentGet = FunctionAssembler.getInstanceMethod(ArgumentCollectionClass, "get", new Class[]{intClass});
    static Method argumentGetVar = FunctionAssembler.getInstanceMethod(ArgumentCollectionClass, "getVariable", new Class[]{intClass});
    static Method argumentPut = FunctionAssembler.getInstanceMethod(ArgumentCollectionClass, "put", new Class[]{ObjectClass, ObjectClass});
    static Method validateArg = FunctionAssembler.getDeclaredMethod(UDFMethodClass, "_validateArg", new Class[]{StringClass, booleanClass, StringClass, ObjectClass});
    static Method validateArgVar = FunctionAssembler.getDeclaredMethod(UDFMethodClass, "_validateArg", new Class[]{StringClass, booleanClass, StringClass, VariableClass});
    static Method validateArgVarWithValidator = FunctionAssembler.getDeclaredMethod(UDFMethodClass, "_validateArgWithValidator", new Class[]{StringClass, StringClass, VariableClass, CFTYpeValidatorClass, booleanClass});
    static Method validateRequiredArg = FunctionAssembler.getDeclaredMethod(UDFMethodClass, "_validateRequiredArg", new Class[]{StringClass, StringClass, VariableClass, CFTYpeValidatorClass});

    public FunctionAssembler(NeoTranslationContext tc, ASTfunctionDefinition function) {
        this.tc = tc;
        this.function = function;
        this.className = tc.getClassName() + "$func" + function.getCodeGenName();
    }

    String getClassName() {
        return this.className;
    }

    void assemble(Map classes) throws IOException {
        this.assemble(classes, false);
    }

    private boolean isInterfaceDefaultFunction() {
        Node[] nodeAr;
        boolean isDefault = false;
        ASTexprlist exprList = this.function.attrList;
        if (exprList != null && (nodeAr = exprList.children) != null) {
            for (Node node : nodeAr) {
                ASTliteral literal;
                ASTtagAttribute astTagAttr;
                Node valNode;
                if (!(node instanceof ASTtagAttribute) || (valNode = (astTagAttr = (ASTtagAttribute)node).getNamedAttribute("default")) == null || !(valNode instanceof ASTliteral) || (literal = (ASTliteral)valNode) == null || literal.tokens == null || literal.tokens.size() <= 0 || !"true".equalsIgnoreCase((String)literal.tokens.get(0))) continue;
                isDefault = true;
            }
        }
        return isDefault;
    }

    void assemble(Map classes, boolean isInterface) throws IOException {
        Class superClass = this.isUDFClosure(this.function.getCodeGenName()) ? ClosureClass : UDFMethodClass;
        String pagePath = Compiler.removeAndGetBuildPathIfAdminPage(this.tc.getPagePath());
        this.startClass(this.className, superClass, new Class[0], pagePath);
        if (isInterface) {
            if (this.isInterfaceDefaultFunction()) {
                this.function();
            }
        } else {
            this.function();
        }
        this.functionMetaData();
        classes.put(this.className, this.getBytes());
    }

    private Object function() {
        this.implementMethod(runFunction, new String[]{"__localScope", "instance", "parentPage", "__arguments"});
        this.functionVar = this.findLocal("this");
        this.pageVar = this.findLocal("parentPage");
        this.outVar = this.createLocal(JspWriterClass, "out");
        this.valueVar = this.createLocal(ObjectClass, "value");
        this.parentVar = this.createLocal(TagClass, "parent");
        this.localScopeParam = this.findLocal("__localScope");
        this.argumentsParam = this.findLocal("__arguments");
        Object instanceParam = this.findLocal("instance");
        if (this.tc.staticSupport()) {
            Object staticScopeField = this.createField(StaticScopeClass, this.getStaticScopeVarName(), 10);
            this.load(this.findLocal("this"));
            this.invoke(getStaticScope);
            this.putstatic(staticScopeField);
        }
        this.declareImports();
        Object argumentsVar = this.createLocal(VariableClass, "ARGUMENTS");
        Object label = this.load(this.localScopeParam);
        this.getstatic(ARGUMENTS);
        this.load(this.argumentsParam);
        this.invoke(bindInternalKeyValue);
        this.store(argumentsVar);
        Object thisVar = this.createLocal(VariableClass, "THIS");
        this.load(this.localScopeParam);
        this.getstatic(THIS);
        this.load(instanceParam);
        this.invoke(bindInternalKeyValue);
        this.store(thisVar);
        this.addLineNumber(label, this.function.getStartToken().beginLine);
        Map<String, String> functionlocalFinalVars = this.tc.getFunctionFinalVariables().get(this.function.functionName.image.toUpperCase());
        for (String name : this.function.localVars.keySet()) {
            ASTvariableDefinition vardef = (ASTvariableDefinition)this.function.localVars.get(name);
            if ("LOCAL".equalsIgnoreCase(vardef.name)) continue;
            Object var = this.createLocal(VariableClass, vardef.name);
            if (vardef.isTemporary()) {
                this.newinstance(VariableClass);
                this.aconst(vardef.name);
                this.invokespecial(newVariableClass);
            } else {
                this.load(this.localScopeParam);
                this.aconst(vardef.name);
                if (functionlocalFinalVars != null && functionlocalFinalVars.containsKey(name.toUpperCase())) {
                    this.invoke(bindInternalFinal);
                } else {
                    this.invoke(bindInternal);
                }
            }
            this.store(var);
        }
        this.load(this.pageVar);
        this.getfield(pageContext);
        this.invoke(getOut);
        this.store(this.outVar);
        this.load(this.pageVar);
        this.getfield(pageParent);
        this.store(this.parentVar);
        this.tc.setallowAllProcessing(true);
        this.block(this.function.children);
        this.tc.setallowAllProcessing(false);
        Object end = this.label();
        this.patchBreaks(this.function, end);
        this.patchContinues(this.function, end);
        this.aconst(null);
        this.mreturn(runFunction.getReturnType());
        return label;
    }

    @Override
    Object assembleStatement(Node node) {
        Object label;
        switch (node.id) {
            case 22: {
                label = this.paramDef((ASTparameterDefinition)node);
                this.addLineNumber(label, node.getLine());
                break;
            }
            case 23: {
                ASTcfargument cfargumentNode = (ASTcfargument)node;
                ExprNode typeNode = cfargumentNode.getAttrNode("type");
                String type = typeNode != null ? EvaluateEngine._String(typeNode) : null;
                label = type != null && type.equalsIgnoreCase("ASTObjectDestructuring") ? this.complexArgumentDefStmt(cfargumentNode, type) : this.argumentDefStmt(cfargumentNode, type);
                if (this.disableLineFeed) break;
                this.addLineNumber(label, node.getLine());
                break;
            }
            case 6: {
                label = this.varDefStmt((ASTvariableDefinition)node);
                if (!this.disableLineFeed) {
                    this.addLineNumber(label, node.getLine());
                }
                int numOfChildren = node.jjtGetNumChildren();
                for (int i = 0; i < numOfChildren; ++i) {
                    Node child = node.jjtGetChild(i);
                    if (!(child instanceof ASTcfscriptStatement)) continue;
                    super.assembleStatement(child);
                }
                break;
            }
            case 18: 
            case 43334: {
                ASTfunctionDefinition tempNode = (ASTfunctionDefinition)node;
                Token localToken = Token.newToken(0);
                localToken.image = "LOCAL";
                ASTsimpleVariableReference parent = new ASTsimpleVariableReference(localToken);
                ASTstructureReference struct = new ASTstructureReference(new String[]{tempNode.getNameToken().image});
                struct.jjtSetParent(node.jjtGetParent());
                struct.setStem(parent);
                label = this.assignClosureToStruct(struct, tempNode);
                break;
            }
            default: {
                return super.assembleStatement(node);
            }
        }
        return label;
    }

    private Object varDefStmt(ASTvariableDefinition var) {
        if (var.initializer != null) {
            Object variable = this.findLocal(var.name);
            Object label = this.load(variable);
            this.cast(var.initializer, ObjectClass);
            this.invokeVoid(variableSet);
            return label;
        }
        return this.label();
    }

    private Object paramDef(ASTparameterDefinition paramdef) {
        int count = paramdef.params.size();
        if (paramdef.isContainsDestructArguments()) {
            this.initializeASTDeStructParamValidator();
        }
        if (count > 0) {
            Object label = null;
            for (int i = 0; i < count; ++i) {
                if (paramdef.children != null && i < paramdef.children.length) {
                    Object l1 = this.assembleStatement(paramdef.children[i]);
                    if (label == null) {
                        label = l1;
                    }
                    if (label != null) continue;
                    System.out.println("null from " + paramdef.children[i]);
                    throw new NullPointerException();
                }
                String pName = (String)paramdef.params.elementAt(i);
                Object pVar = this.createLocal(VariableClass, pName);
                this.load(this.functionVar);
                this.aconst(pName);
                this.zconst(true);
                this.aconst(null);
                this.load(this.argumentsParam);
                this.iconst(i);
                this.invoke(argumentGetVar);
                this.invoke(validateArgVar);
                this.store(pVar);
                Object l1 = this.load(this.localScopeParam);
                this.load(pVar);
                this.invoke(localPutVariable);
                if (label == null) {
                    label = l1;
                }
                if (label != null) continue;
                throw new NullPointerException();
            }
            return label;
        }
        return this.label();
    }

    private Object complexArgumentDefStmt(ASTcfargument cfargument, String type) {
        Object label = null;
        Object paramVar = this.createLocal(VariableClass, cfargument.paramName);
        int functionCallParamIndex = Integer.valueOf(cfargument.paramName.toLowerCase().replace("__cf_internal_sdref_", ""));
        this.load(this.argumentsParam);
        this.iconst(functionCallParamIndex);
        this.invoke(argumentGetVar);
        label = this.store(paramVar);
        ASTparameterDefinition paramDef = (ASTparameterDefinition)cfargument.jjtGetParent();
        this.load(this.findLocal(cfargument.paramName));
        this.invoke(getValueOfVar);
        this.store(paramVar);
        Object funcParam = paramDef.complexParams.get(cfargument.paramIndex);
        if (funcParam instanceof ASTDestructring) {
            ASTObjectDestructuring deStructuringParams = (ASTObjectDestructuring)paramDef.complexParams.get(cfargument.paramIndex);
            this.astDestructParamValidator.validateAndAddParam(deStructuringParams);
            deStructuringParams.handle(this, paramVar, false, 0, null);
        } else if (funcParam instanceof ASTcfscriptStatement) {
            ASTcfscriptStatement cfscriptStatement = (ASTcfscriptStatement)funcParam;
            this.assignStatement(cfscriptStatement.getExpression("LVAL"), cfscriptStatement.getNode("RVAL"));
            ASTObjectDestructuring deStructuringParams = (ASTObjectDestructuring)cfscriptStatement.getExpression("LVAL");
            this.astDestructParamValidator.validateAndAddParam(deStructuringParams);
            deStructuringParams.handle(this, paramVar, false, 0, null);
        }
        return label;
    }

    private void initializeASTDeStructParamValidator() {
        if (this.astDestructParamValidator == null) {
            this.astDestructParamValidator = new ASTDestructParamValidator();
        }
        this.astDestructParamValidator.setFunctionName(this.function.functionName.image);
    }

    private Object argumentDefStmt(ASTcfargument cfargument, String type) {
        ExprNode defaultNode = cfargument.getAttrNode("default");
        ExprNode requiredNode = cfargument.getAttrNode("required");
        Node closure = null;
        if (defaultNode == null) {
            closure = cfargument.getNamedAttribute("default");
        }
        boolean required = requiredNode != null && Cast._boolean(EvaluateEngine._String(requiredNode));
        Object label = null;
        if (defaultNode != null || closure != null) {
            label = this.load(this.argumentsParam);
            this.iconst(cfargument.paramIndex);
            this.invoke(argumentGet);
            Object ifstart = this.ifacmpne(null, null);
            if (closure != null) {
                this.load(this.argumentsParam);
                this.aconst(cfargument.paramName);
                String funcClassName = this.tc.getClassName() + "$func" + ((ASTcffunction)closure).getCodeGenName();
                this.newinstance(funcClassName);
                this.invokespecial(funcClassName, "<init>");
                this.invokeVoid(argumentPut);
            }
            if (defaultNode != null) {
                if (defaultNode.getType() == null) {
                    defaultNode.setType(ObjectClass);
                }
                this.load(this.argumentsParam);
                this.aconst(cfargument.paramName);
                this.cast(defaultNode, ObjectClass);
                this.invokeVoid(argumentPut);
            }
            this.setTarget(ifstart, this.label());
        }
        Object paramVar = this.createLocal(VariableClass, cfargument.paramName);
        this.generateValidationCode(required, type, cfargument);
        Object l1 = this.store(paramVar);
        ASTparameterDefinition paramDef = (ASTparameterDefinition)cfargument.jjtGetParent();
        if (paramDef.isContainsDestructArguments()) {
            this.astDestructParamValidator.setParamKeys(cfargument.paramName);
        }
        if (label == null) {
            label = l1;
        }
        return label;
    }

    private void generateValidationCode(boolean required, String type, ASTcfargument cfargument) {
        boolean isJava = this.isJavaFunction(cfargument);
        if (type != null) {
            if (required) {
                this.initArgumentCodeGen(type, cfargument);
                if (type.equalsIgnoreCase("any")) {
                    this.nullconst();
                    this.invoke(validateRequiredArg);
                } else {
                    String validator = CFTypeValidatorFactory.getValidatorString(type);
                    if (validator != null) {
                        this.getstatic(FunctionAssembler.getStaticField(CFTypeValidatorFactory.class, validator));
                    } else {
                        this.nullconst();
                    }
                    this.invoke(validateRequiredArg);
                }
            } else if (type.equalsIgnoreCase("any")) {
                this.load(this.argumentsParam);
                this.iconst(cfargument.paramIndex);
                this.invoke(argumentGetVar);
            } else {
                this.initArgumentCodeGen(type, cfargument);
                String validator = CFTypeValidatorFactory.getValidatorString(type);
                if (validator != null) {
                    this.getstatic(FunctionAssembler.getStaticField(CFTypeValidatorFactory.class, validator));
                } else {
                    this.nullconst();
                }
                this.zconst(isJava);
                this.invoke(validateArgVarWithValidator);
            }
        } else if (required) {
            this.initArgumentCodeGen(type, cfargument);
            this.nullconst();
            this.invoke(validateRequiredArg);
        } else {
            this.load(this.argumentsParam);
            this.iconst(cfargument.paramIndex);
            this.invoke(argumentGetVar);
        }
    }

    private boolean isJavaFunction(ASTcfargument cfargument) {
        List<Node> childs;
        ASTexprlist node;
        Node functionNode;
        boolean isJava = false;
        if (cfargument != null && cfargument.jjtGetParent() != null && (functionNode = cfargument.jjtGetParent().jjtGetParent()) != null && functionNode instanceof ASTcffunction && null != (node = ((ASTcffunction)functionNode).attrList) && (childs = node.getAllChildren()) != null) {
            for (Node child : childs) {
                String stype;
                Node typeNode;
                ASTtagAttribute tagAtr;
                String attrName;
                if (!(child instanceof ASTtagAttribute) || (attrName = (tagAtr = (ASTtagAttribute)child).getName()) == null || !attrName.equalsIgnoreCase("type") || !((typeNode = tagAtr.getValueNode()) instanceof ASTliteral)) continue;
                ASTliteral literalNode = (ASTliteral)typeNode;
                if (literalNode.tokens == null || (stype = (String)literalNode.tokens.get(0)) == null || !stype.equalsIgnoreCase("java")) continue;
                isJava = true;
                break;
            }
        }
        return isJava;
    }

    public void initArgumentCodeGen(String type, ASTcfargument cfargument) {
        this.load(this.functionVar);
        this.aconst(cfargument.paramName);
        this.aconst(type);
        this.load(this.argumentsParam);
        this.iconst(cfargument.paramIndex);
        this.invoke(argumentGetVar);
    }

    private void functionMetaData() {
        String name = this.function.functionName.image;
        this.implementMethod(getParamList, new String[0]);
        ASTparameterDefinition astParamDef = this.function.getParameterdefinition();
        Object[] paramArray = astParamDef == null ? new String[]{} : astParamDef.params.toArray();
        this.newarray(StringClass, paramArray);
        this.areturn();
        this.implementMethod(getName, new String[0]);
        this.aconst(name);
        this.areturn();
        Object metaDataField = this.createField(ObjectClass, "metaData", 24);
        this.implementMethod(getMetaData, new String[0]);
        this.getstatic(metaDataField);
        this.areturn();
        if (this.function instanceof ASTcffunction) {
            ASTcffunction cffunction = (ASTcffunction)this.function;
            this.createAccessor(cffunction.attrMap);
            this.attrGetter(cffunction.attrMap, "ReturnType");
            this.attrGetter(cffunction.attrMap, "Roles");
            this.attrGetter(cffunction.attrMap, "Output");
        }
        String oldMethod = this.setMethod("<clinit>");
        this.newinstance(AttributeCollectionClass);
        ArrayList attrData = this.beginAttrMetadata(this.function.attrList);
        if (this.function.attrList == null || this.function.isAnonymousClosure()) {
            attrData.add("Name");
            attrData.add(name);
        }
        ASTparameterDefinition paramDef = this.function.getParameterdefinition();
        attrData.add("Parameters");
        ArrayList<AttributeCollection> paramData = new ArrayList<AttributeCollection>();
        boolean first = true;
        if (paramDef != null) {
            if (paramDef.children != null) {
                for (int i = 0; i < paramDef.children.length; ++i) {
                    if (first) {
                        first = false;
                    }
                    ASTcfargument cfargument = (ASTcfargument)paramDef.children[i];
                    paramData.add(new AttributeCollection(this.cfargumentMetadata(cfargument).toArray()));
                }
            } else {
                int count = paramDef.params.size();
                for (int i = 0; i < count; ++i) {
                    String paramName = paramDef.params.get(i).toString();
                    paramData.add(new AttributeCollection(new Object[]{"Name", paramName, "Required", "true"}));
                }
            }
        }
        attrData.add(paramData.toArray());
        this.newarray(ObjectClass, attrData.toArray());
        this.invokespecial(newAttributeCollection);
        this.putstatic(metaDataField);
        this.setMethod(oldMethod);
    }

    private void createAccessor(FastHashtable attrMap) {
        Object attrValueObj = attrMap.get("Access");
        if (attrValueObj != null && attrValueObj instanceof ExprNode) {
            ExprNode node = (ExprNode)attrValueObj;
            String value = EvaluateEngine._String(node);
            int accessor = 0;
            if (value.equalsIgnoreCase("private")) {
                accessor = 2;
            } else if (value.equalsIgnoreCase("package")) {
                accessor = 1;
            } else if (value.equalsIgnoreCase("remote")) {
                accessor = 3;
            }
            String methodName = "getAccess";
            this.startMethod(methodName, new Class[0], new String[0], intClass, 17);
            this.setMethod(methodName);
            this.iconst(accessor);
            this.ireturn();
        }
    }

    ArrayList cfargumentMetadata(ASTcfargument cfargument) {
        ArrayList<String> argData = new ArrayList<String>();
        Enumeration i = cfargument.getAttrNames();
        while (i.hasMoreElements()) {
            String name = (String)i.nextElement();
            argData.add(name);
            ExprNode expr = cfargument.getAttrNode(name);
            try {
                String value = "";
                if (expr != null) {
                    value = EvaluateEngine._String(expr);
                }
                argData.add(value);
            }
            catch (NeoException ex) {
                argData.add("[runtime expression]");
            }
        }
        return argData;
    }

    private Object getStaticVars(ASTsimpleVariableReference var) {
        if (var.isTruelyStatic()) {
            Object label = this.load(this.pageVar);
            this.resolveStatic(var, null);
            if (var.isLeafReference) {
                this.callAutoscalarizeVar(var);
            } else {
                this.callAutoscalarizeVarNonLeafRef(var);
            }
            return label;
        }
        return null;
    }

    @Override
    Object get(ASTsimpleVariableReference var) {
        if (var.referenceNeedsSymTabSupport(this)) {
            Object staticVar = this.getStaticVars(var);
            if (staticVar != null) {
                return staticVar;
            }
            this.checkNonStaticAccess(var);
            return super.get(var);
        }
        String varReference = var.getCodegenVariableName();
        Object staticVar = this.getStaticVars(var);
        if (staticVar != null) {
            return staticVar;
        }
        Object varLocal = this.findLocal(varReference);
        if (var.isLeafReference) {
            Object label = this.load(this.pageVar);
            this.load(varLocal);
            this.callAutoscalarizeVar(var);
            return label;
        }
        Object label = this.load(this.pageVar);
        this.load(varLocal);
        this.callAutoscalarizeVarNonLeafRef(var);
        return label;
    }

    private void checkNonStaticAccess(ASTsimpleVariableReference var) {
        if (this.isStaticMethodVar(var) && !"LOCAL".equalsIgnoreCase(var.getCodegenVariableName()) && !"static".equalsIgnoreCase(var.getCodegenVariableName())) {
            throw new UndefinedStaticVariableException(var.getCodegenVariableName(), "It must be a static or local/var scoped variable.");
        }
    }

    private boolean resolveStatic(ASTsimpleVariableReference var, Object varField) {
        if (var.isStaticAccessor()) {
            this.resolveStaticAccessorVariable(var);
        } else if (var.isStatic()) {
            this.load(this.pageVar);
            this.getstatic(this.findField(this.getStaticScopeVarName()));
            if (varField != null) {
                this.getstatic(varField);
            } else {
                this.aconst(var.getCodegenVariableName());
            }
            if (var.getFunctionDef() != null && var.isLval()) {
                this.aconst(var.getAccessModifier());
                this.invoke(_declareStaticVariable);
            } else {
                if (this instanceof FunctionAssembler) {
                    this.load(this.functionVar);
                } else {
                    this.aconst(null);
                }
                this.invoke(_resolveStaticVariable);
            }
        } else {
            return false;
        }
        return true;
    }

    private void callAutoscalarizeVarNonLeafRef(ASTsimpleVariableReference var) {
        if (var.isSafePreHook()) {
            this.zconst(true);
            this.invoke(getVarSafe);
        } else {
            this.invoke(getVar);
        }
    }

    private void callAutoscalarizeVar(ASTsimpleVariableReference var) {
        int incrDecrOp = this.isIncrDecrOperand(var);
        if (this.isIncrDecrOperand(var) != -1) {
            this.iconst(incrDecrOp);
            this.invoke(getScalarVarIncrDecr);
        } else {
            this.invoke(this.isSafeOperator ? _getScalarVar : getScalarVar);
        }
    }

    private boolean checkLineNumber(ASTsimpleVariableReference var, boolean forAssignment) {
        StatementNode target;
        boolean useSuper = false;
        ASTvariableDefinition origin = (ASTvariableDefinition)this.function.localVars.get(var.getCodegenVariableName());
        StatementNode statementNode = target = origin != null ? (StatementNode)origin.jjtGetParent() : null;
        while (target != null && !(target instanceof ASTstart) && !(target instanceof FactoredNodeAggregation)) {
            if (target instanceof ASTfunctionDefinition) {
                if (var.getLine() > origin.getLine() || (forAssignment ? var.getLine() == origin.getLine() && var.getStartToken().beginColumn > origin.getStartToken().beginColumn : var.getLine() == origin.getLine() && var.getStartToken().beginColumn > origin.getEndToken().endColumn)) break;
                useSuper = true;
                break;
            }
            if (target instanceof ASTcfscriptStatement || target instanceof ASTcfcase) {
                StatementNode endPoint;
                Node node = endPoint = target.children != null ? target.children[target.jjtGetNumChildren() - 1] : target;
                if (var.getLine() > origin.getLine() && var.getLine() < endPoint.getEndToken().endLine || (!forAssignment ? var.getLine() == origin.getLine() && var.getStartToken().beginColumn > origin.getEndToken().endColumn : var.getLine() == origin.getLine() && var.getStartToken().beginColumn > origin.getStartToken().beginColumn)) break;
                if (var.getLine() == endPoint.getEndToken().endLine && var.getStartToken().beginColumn < endPoint.getEndToken().endColumn) break;
                useSuper = true;
                break;
            }
            target = (StatementNode)target.jjtGetParent();
        }
        return useSuper;
    }

    @Override
    Method simpleref(ASTsimpleVariableReference ref, Method stringMethod, Method varMethod) {
        boolean needSymTabSupport;
        Node parentNode = ref.jjtGetParent();
        boolean bl = needSymTabSupport = parentNode instanceof ASTstructureReference || parentNode instanceof ASTarrayReference;
        if (ref.referenceNeedsSymTabSupport(this, needSymTabSupport)) {
            if (ref.isStaticAccessor()) {
                this.resolveStaticAccessorVariable(ref);
                return varMethod;
            }
            if (ref.isTruelyStatic()) {
                if (!ASTsimpleVariableReference.isBuiltinScopeName(ref.getCodegenVariableName())) {
                    this.load(this.pageVar);
                    this.getstatic(this.findField(this.getStaticScopeVarName()));
                    this.aconst(ref.getCodegenVariableName());
                    if (ref.getFunctionDef() != null && ref.isLval()) {
                        this.aconst(ref.getAccessModifier());
                        this.invoke(_declareStaticVariable);
                    } else {
                        if (this instanceof FunctionAssembler) {
                            this.load(this.functionVar);
                        } else {
                            this.aconst(null);
                        }
                        this.invoke(_resolveStaticVariable);
                    }
                    return varMethod;
                }
            }
            this.checkNonStaticAccess(ref);
            return super.simpleref(ref, stringMethod, varMethod);
        }
        Object local = this.findLocal(ref.getCodegenVariableName());
        this.load(local);
        return varMethod;
    }

    private boolean isStaticMethodVar(ASTsimpleVariableReference ref) {
        ASTfunctionDefinition def = ref.getFunctionDef();
        return def != null && def.isStatic() && !def.isParameter(ref.getCodegenVariableName());
    }

    private void resolveStaticAccessorVariable(ASTsimpleVariableReference ref) {
        this.load(this.pageVar);
        this.aconst(ref.getAccessorReference());
        this.aconst(ref.getCodegenVariableName());
        if (this instanceof FunctionAssembler) {
            this.load(this.functionVar);
        } else {
            this.aconst(null);
        }
        this.invoke(_resolveStaticAccessorVariable);
    }

    @Override
    Object assignVar(ASTsimpleVariableReference var, ExprNode rval) {
        if ("LOCAL".equalsIgnoreCase(var.getCodegenVariableName()) && var.getFunctionDef() != null) {
            Object label = this.load(this.pageVar);
            this.load(this.pageVar);
            this.aconst(var.getCodegenVariableName().toUpperCase());
            this.invoke(get);
            this.assembleExpr(rval);
            this.invokeVoid(mergeToLocal);
            return label;
        }
        if (var.referenceNeedsSymTabSupport(this, true) && !var.isStatic()) {
            this.checkNonStaticAccess(var);
            return super.assignVar(var, rval);
        }
        Object varLocal = this.findLocal(var.getCodegenVariableName());
        if (varLocal != null) {
            Object label = this.load(varLocal);
            Method methodToInvoke = this.generateSetVarCode(rval);
            this.invokeVoid(methodToInvoke);
            return label;
        }
        if (this.resolveStatic(var, null)) {
            this.invokeVoid(this.generateSetVarCode(rval));
        }
        return this.label();
    }

    @Override
    protected Object factoredNode(FactoredNodeAggregation factor) {
        Object method = this.createFactoredMethod(factor);
        Object label = this.load(this.functionVar);
        this.load(this.tagParentVar(factor));
        this.load(this.outVar);
        this.load(this.pageVar);
        this.invokespecial(method);
        Object factorIf = this.ifacmpne(null, null);
        this.aconst(null);
        this.doReturn(factor);
        this.setTarget(factorIf, this.label());
        return label;
    }

    @Override
    protected Object createFactoredMethod(FactoredNodeAggregation factor) {
        String parentVarName = factor.getParentVar();
        Object method = this.startMethod(factor.callSite, new Class[]{TagClass, JspWriterClass, CFPageClass}, new String[]{parentVarName, "out", "parentPage"}, ObjectClass, 2);
        String oldMethod = this.setMethod(factor.callSite);
        Object oldValueVar = this.valueVar;
        Object oldParentVar = this.parentVar;
        Object oldOutVar = this.outVar;
        Object oldPageVar = this.pageVar;
        this.valueVar = this.createLocal(ObjectClass, "value");
        this.parentVar = this.findLocal(parentVarName);
        this.outVar = this.findLocal("out");
        this.pageVar = this.findLocal("parentPage");
        this.block(factor.children);
        this.load(this.pageVar);
        this.areturn();
        this.setMethod(oldMethod);
        this.valueVar = oldValueVar;
        this.parentVar = oldParentVar;
        this.outVar = oldOutVar;
        this.pageVar = oldPageVar;
        return method;
    }

    public ASTfunctionDefinition getFunction() {
        return this.function;
    }
}

