/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.CompilerInternalException;
import coldfusion.compiler.IntegerStack;
import coldfusion.compiler.Node;
import java.util.Stack;

class JJTcfml40State {
    private Stack nodes = new Stack();
    private IntegerStack marks = new IntegerStack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;
    private boolean valid = true;

    JJTcfml40State() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
        this.valid = true;
    }

    void setValid(boolean valid) {
        this.valid = valid;
    }

    Node rootNode() {
        return (Node)this.nodes.elementAt(0);
    }

    void pushNode(Node n) {
        if (!this.valid) {
            return;
        }
        this.nodes.push(n);
        ++this.sp;
    }

    Node popNode() {
        return this.popNode(false);
    }

    Node popNode(boolean cherishStackState) {
        if (!this.valid) {
            return null;
        }
        if (--this.sp < this.mk) {
            if (!cherishStackState) {
                this.mk = this.marks.pop();
            } else {
                this.setValid(false);
                throw new CompilerInternalException(this);
            }
        }
        return (Node)this.nodes.pop();
    }

    Node peekNode() {
        return (Node)this.nodes.peek();
    }

    Node peekNode(int n) {
        if (!this.valid) {
            return null;
        }
        return (Node)this.nodes.get(this.nodes.size() - (1 + n));
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void clearNodeScope(Node n) {
        if (!this.valid) {
            return;
        }
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.pop();
    }

    void openNodeScope(Node n) {
        if (!this.valid) {
            return;
        }
        this.marks.push(this.mk);
        this.mk = this.sp;
        n.jjtOpen();
    }

    void closeNodeScope(Node n, int num) {
        if (!this.valid) {
            return;
        }
        this.mk = this.marks.pop();
        while (num-- > 0) {
            Node c = this.popNode();
            c.jjtSetParent(n);
            n.jjtAddChild(c, num);
        }
        n.jjtClose();
        this.pushNode(n);
        this.node_created = true;
    }

    void closeNodeScope(Node n, boolean condition) {
        if (!this.valid) {
            return;
        }
        if (condition) {
            int a = this.nodeArity();
            this.mk = this.marks.pop();
            while (a-- > 0) {
                Node c = this.popNode();
                c.jjtSetParent(n);
                n.jjtAddChild(c, a);
            }
            n.jjtClose();
            this.pushNode(n);
            this.node_created = true;
        } else {
            this.mk = this.marks.pop();
            this.node_created = false;
        }
    }
}

