/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfproperty;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.AccessModifier;
import coldfusion.compiler.DuplicateCaseException;
import coldfusion.compiler.NeoTranslator;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.TagInfoNotFoundException;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.TemplateReader;
import coldfusion.compiler.Token;
import coldfusion.jsp.JRunTagLibraryInfo;
import coldfusion.jsp.JSTTagInfo;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.InvalidUsageException;
import coldfusion.util.FastHashtable;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public final class NeoTranslationContext {
    private Map knownTags = new FastHashtable();
    private Map knownBuiltInTags = new FastHashtable();
    private Map nsMap = new FastHashtable();
    private ArrayList<String> importList = new ArrayList(5);
    private File canonicalPageFile;
    private ServletContext application;
    private String className;
    List<File> dependency;
    long lastModified;
    private int tagCount;
    private int closureCount;
    private int implicitArrayStructCount;
    private Class baseClassType;
    private boolean staticProcessing = false;
    private boolean allowAllProcessing = false;
    private boolean staticSupport = false;
    private Map variables = new FastHashtable();
    private Map<String, Integer> staticVariables = new FastHashtable();
    private Map finalVariables = new FastHashtable();
    private Map implicitVariables = new FastHashtable();
    private Map<String, Map<String, String>> functionFinalVariables = new FastHashtable();
    private Map<String, Map<String, String>> functionNonLocalFinalVariables = new FastHashtable();
    private Map<String, Map<String, String>> functionNonLocalPrefixedFinalVariables = new FastHashtable();
    private Map<String, String> finalVariablesAsDSKey = new HashMap<String, String>();
    private int tempCounter = 0;
    private Map switchLookups = new FastHashtable();
    private Hashtable udfTable = new Hashtable();
    private Hashtable closureTable = new Hashtable();
    private Map propertyTable = new LinkedHashMap();
    private boolean escapeSingleQuotes = false;
    private Map taglibMap = new FastHashtable();
    private Map staticObjects = new FastHashtable();
    private boolean loadDeviceDetectionPlugin;
    private boolean loadAPIPlugin;
    private int clientBlockCount = 0;
    private String pageEncoding;
    private static final String UNKNOWN_TAG = ">unknowntag<";
    private static final String UNDEFINED_TAG = ">undefined<";
    private int deviceTimeout = 10;
    private boolean enableDebugLog = false;

    NeoTranslationContext(Vector cftags, ServletContext application, File canonicalFile, String className) throws IOException {
        this.application = application;
        this.canonicalPageFile = canonicalFile;
        this.className = className;
        this.tagCount = 0;
        this.closureCount = 0;
        this.setBaseClass(CFPage.class);
        this.knownTags = new FastHashtable();
        this.nsMap = new FastHashtable();
        int count = cftags.size();
        for (int i = 0; i < count; ++i) {
            NeoTranslator.CfTagsElement el = (NeoTranslator.CfTagsElement)cftags.elementAt(i);
            JRunTagLibraryInfo info = JRunTagLibraryInfo.lookupTLI(el.tagFile, this.application, el.uri);
            this.registerTli(info, "cf");
        }
        this.registerTaglib("cf_", ".");
        this.registerTaglib("cfa_", ".");
    }

    boolean registerTaglib(String namespace, String uri) throws IOException {
        JRunTagLibraryInfo info = JRunTagLibraryInfo.lookupTLI(this.application, uri, this.getPageFile());
        return this.registerTli(info, namespace);
    }

    private boolean registerTli(JRunTagLibraryInfo info, String namespace) {
        boolean retVal = info.isCfmDir();
        Vector<CallSite> v = (Vector<CallSite>)this.nsMap.get(namespace);
        if (v == null) {
            v = new Vector<CallSite>();
            this.nsMap.put(namespace, v);
        }
        int taglibCount = v.size();
        String prefix = namespace.length() == 0 ? "_" + taglibCount : (!namespace.endsWith(":") ? namespace + taglibCount : namespace.substring(0, namespace.length() - 1) + taglibCount);
        v.addElement((CallSite)((Object)prefix));
        this.taglibMap.put(prefix, info);
        this.clearUnknownTags();
        return retVal;
    }

    private void clearUnknownTags() {
        Iterator iter = this.knownTags.keySet().iterator();
        while (iter.hasNext()) {
            String tag = (String)iter.next();
            if (this.knownTags.get(tag) != UNKNOWN_TAG) continue;
            iter.remove();
        }
    }

    boolean isKnownTag(String tag) {
        try {
            return this.findTagName(tag) != null;
        }
        catch (TagInfoNotFoundException ex) {
            return true;
        }
    }

    boolean isKnownTagNoCustom(String tag) {
        try {
            return this.findTagName(tag) != null;
        }
        catch (TagInfoNotFoundException ex) {
            return false;
        }
    }

    boolean isKnownBuiltInTag(String tag) {
        try {
            Object tagInfoObject = this.knownBuiltInTags.get(tag);
            if (tagInfoObject == UNDEFINED_TAG) {
                return false;
            }
            if (tagInfoObject != null) {
                return true;
            }
            JRunTagLibraryInfo libInfo = (JRunTagLibraryInfo)((Object)this.taglibMap.get("cf0"));
            if (libInfo != null) {
                TagInfo tagInfo = libInfo.getTag(tag);
                if (tagInfo == null) {
                    tagInfo = libInfo.getTag(tag.toLowerCase());
                }
                if (tagInfo != null) {
                    this.knownBuiltInTags.put(tag, tagInfo);
                    return true;
                }
                this.knownBuiltInTags.put(tag, UNDEFINED_TAG);
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    TagInfo getTagInfo(String tag) throws ParseException {
        TagInfo info = this.findTagName(tag);
        if (info == null) {
            throw new TagInfoNotFoundException(tag);
        }
        return info;
    }

    private TagInfo findTagName(String cftag) throws TagInfoNotFoundException {
        String namespace;
        Object tagInfoObject = this.knownTags.get(cftag);
        if (tagInfoObject == UNKNOWN_TAG) {
            return null;
        }
        if (tagInfoObject == UNDEFINED_TAG) {
            throw new TagInfoNotFoundException(cftag);
        }
        TagInfo info = (TagInfo)tagInfoObject;
        if (info != null) {
            return info;
        }
        int i = cftag.indexOf(58);
        if (i == -1) {
            namespace = cftag;
            while (!this.nsMap.containsKey(namespace = namespace.substring(0, i = namespace.length() - 1)) && --i > 0) {
            }
        } else {
            i = !this.nsMap.containsKey(cftag.substring(0, i + 1)) ? -1 : ++i;
        }
        if (i != -1) {
            String tagName;
            namespace = cftag.substring(0, i);
            String string = tagName = namespace.equalsIgnoreCase("cfa_") ? cftag : cftag.substring(i);
            if (namespace.equalsIgnoreCase("cf_") || namespace.equalsIgnoreCase("cfa_")) {
                File location = VFSFileFactory.getFileObject(this.getPageFile().getParentFile(), cftag + ".cfm");
                JSTTagInfo tagInfo = new JSTTagInfo(location, tagName, "dont-need-the-classname", "JSP", null, null, null, new TagAttributeInfo[0]);
                this.knownTags.put(cftag, tagInfo);
                return tagInfo;
            }
            Vector v = (Vector)this.nsMap.get(namespace);
            if (v != null) {
                int count = v.size();
                for (int j = 0; j < count; ++j) {
                    String prefix = (String)v.elementAt(j);
                    JRunTagLibraryInfo libInfo = (JRunTagLibraryInfo)((Object)this.taglibMap.get(prefix));
                    if (libInfo == null) continue;
                    TagInfo tagInfo = libInfo.getTag(tagName);
                    if (tagInfo == null) {
                        tagInfo = libInfo.getTag(tagName.toLowerCase());
                    }
                    if (tagInfo != null) {
                        this.knownTags.put(cftag, tagInfo);
                        return tagInfo;
                    }
                    TagInfo[] tags = libInfo.getTags();
                    for (int k = 0; tags != null && k < tags.length; ++k) {
                        String t = tags[k].getTagName();
                        String cfname = namespace + t;
                        if (namespace.equalsIgnoreCase("cfa_") || this.knownTags.containsKey(cfname)) continue;
                        this.knownTags.put(cfname, tags[k]);
                        if (!cfname.equalsIgnoreCase(cftag)) continue;
                        return tags[k];
                    }
                }
            }
        }
        if (i <= 0) {
            this.knownTags.put(cftag, UNKNOWN_TAG);
            return null;
        }
        this.knownTags.put(cftag, UNDEFINED_TAG);
        throw new TagInfoNotFoundException(cftag);
    }

    void setBaseClass(Class type) {
        this.baseClassType = type;
    }

    Class getBaseClass() {
        return this.baseClassType;
    }

    int getTempCounter() {
        return this.tempCounter++;
    }

    String declarePageVariable(String name) {
        return this.declarePageVariable(name, false, false, false);
    }

    void saveFunctionFinalVariables(String functionName, String varName) {
        functionName = functionName.toUpperCase();
        varName = varName.toUpperCase();
        if (this.functionFinalVariables.get(functionName) != null) {
            if (this.functionFinalVariables.get(functionName).get(varName) == null) {
                this.functionFinalVariables.get(functionName).put(varName, varName);
            }
        } else {
            FastHashtable funFinalVarMap = new FastHashtable();
            funFinalVarMap.put(varName, varName);
            this.functionFinalVariables.put(functionName, funFinalVarMap);
        }
    }

    void saveFunctionFinalNonLocalVariables(String functionName, String varName) {
        functionName = functionName.toUpperCase();
        varName = varName.toUpperCase();
        if (this.functionNonLocalFinalVariables.get(functionName) != null) {
            if (this.functionNonLocalFinalVariables.get(functionName).get(varName) == null) {
                this.functionNonLocalFinalVariables.get(functionName).put(varName, varName);
            }
        } else {
            FastHashtable funFinalVarMap = new FastHashtable();
            funFinalVarMap.put(varName, varName);
            this.functionNonLocalFinalVariables.put(functionName, funFinalVarMap);
        }
    }

    void saveFunctionNonLocalPrefixedFinalVariable(String functionName, String varName) {
        functionName = functionName.toUpperCase();
        varName = varName.toUpperCase();
        if (this.functionNonLocalPrefixedFinalVariables.get(functionName) != null) {
            if (this.functionNonLocalPrefixedFinalVariables.get(functionName).get(varName) == null) {
                this.functionNonLocalPrefixedFinalVariables.get(functionName).put(varName, varName);
            }
        } else {
            FastHashtable funFinalVarMap = new FastHashtable();
            funFinalVarMap.put(varName, varName);
            this.functionNonLocalPrefixedFinalVariables.put(functionName, funFinalVarMap);
        }
    }

    String declarePageVariable(String name, boolean isImplicit, boolean isFinal, boolean isStatic) {
        return this.declarePageVariable(name, isImplicit, isFinal, isStatic, 16);
    }

    String declarePageVariable(String name, boolean isImplicit, boolean isFinal, boolean isStatic, int accessModifier) {
        if (!this.isDeclared(name, isImplicit, isFinal, isStatic)) {
            name = name.toUpperCase();
            if (isStatic) {
                int z = 0;
                if (isFinal) {
                    z |= 2;
                }
                if (isImplicit) {
                    z |= 1;
                }
                if (AccessModifier.isValidAccessModifier(accessModifier)) {
                    z |= accessModifier;
                }
                this.staticVariables.put(name, z);
            } else if (isImplicit) {
                this.implicitVariables.put(name, name);
            } else if (isFinal) {
                this.finalVariables.put(name, name);
            } else {
                this.variables.put(name, name);
            }
            return name;
        }
        if (isFinal && !this.finalVariables.containsKey(name)) {
            if (this.variables.containsKey(name)) {
                this.variables.remove(name);
            }
            this.finalVariables.put(name, name);
        }
        return name.toUpperCase();
    }

    private boolean isDeclared(String name, boolean isImplicit, boolean isFinal, boolean isStatic) {
        name = name.toUpperCase();
        if (isStatic) {
            if (this.variables.containsKey(name) || this.finalVariables.containsKey(name)) {
                throw new InvalidUsageException(name, "non-static", "static");
            }
            return this.staticVariables.containsKey(name);
        }
        if (this.staticVariables.containsKey(name)) {
            throw new InvalidUsageException(name, "static", "non-static", "You might want to use static. prefix with variable");
        }
        if (isImplicit) {
            return this.implicitVariables.containsKey(name);
        }
        if (isFinal) {
            return this.finalVariables.containsKey(name) || this.variables.containsKey(name);
        }
        return this.variables.containsKey(name) || this.finalVariables.containsKey(name);
    }

    String createLookupTable() {
        String result = "__HTSWT_" + Integer.toString(this.switchLookups.size());
        this.switchLookups.put(result, new Hashtable());
        return result;
    }

    Integer registerCase(String tableName, Object caseKey, TagNode cfcase) throws ParseException {
        Hashtable hLookups = (Hashtable)this.switchLookups.get(tableName);
        if (hLookups == null) {
            throw new IllegalArgumentException("Requested switch normalization table " + tableName + " was not found.");
        }
        if (hLookups.get(caseKey) != null) {
            throw new DuplicateCaseException(caseKey, cfcase);
        }
        Integer result = hLookups.size();
        hLookups.put(caseKey, result);
        return result;
    }

    void registerUserDefinedFunction(ASTfunctionDefinition syntaxNode) {
        String UDFName = syntaxNode.getCodeGenName();
        ASTfunctionDefinition putResult = this.udfTable.put(UDFName, syntaxNode);
        if (putResult != null) {
            throw new StaticDuplicateFunctionDefinitionException(syntaxNode.getUserName(), syntaxNode.getNameToken());
        }
    }

    ASTfunctionDefinition unregisterUserDefinedFunction(String name) {
        return (ASTfunctionDefinition)this.udfTable.remove(name);
    }

    void registerUserDefinedClosure(ASTfunctionDefinition syntaxNode) {
        String UDCName = syntaxNode.getCodeGenName();
        ASTfunctionDefinition putResult = this.closureTable.put(UDCName, syntaxNode);
        if (putResult != null) {
            throw new StaticDuplicateFunctionDefinitionException(syntaxNode.getUserName(), syntaxNode.getNameToken());
        }
    }

    void registerProperty(ASTcfproperty node) {
        String name = node.getCodeGenName();
        if (this.propertyTable.put(name, node) != null) {
            throw new StaticDuplicatePropertyDefinitionException(node.nameToken);
        }
    }

    void registerImportPath(String path) {
        this.importList.add(path);
    }

    String getImportPath() {
        StringBuffer specificPaths = new StringBuffer();
        StringBuffer starpaths = new StringBuffer();
        for (String element : this.importList) {
            if (element.indexOf(46) == 0) {
                element = element.substring(1);
            }
            if (element.lastIndexOf(46) == element.length() - 1) {
                element = element.substring(0, element.length() - 1);
            }
            if (element.endsWith("*")) {
                starpaths.append(element);
                starpaths.append(",");
                continue;
            }
            specificPaths.append(element);
            specificPaths.append(",");
        }
        String importPaths = specificPaths.toString() + starpaths.toString();
        if (importPaths.length() > 0 && !importPaths.endsWith(",")) {
            importPaths = importPaths + ",";
        }
        return importPaths;
    }

    Map getVariables() {
        return this.variables;
    }

    Map<String, Integer> getStaticVariables() {
        return this.staticVariables;
    }

    Map getImplicitVariables() {
        return this.implicitVariables;
    }

    Hashtable getUdfTable() {
        return this.udfTable;
    }

    Hashtable getClosureTable() {
        return this.closureTable;
    }

    Map getPropertyTable() {
        return this.propertyTable;
    }

    void resetPropertyTable() {
        this.propertyTable.clear();
    }

    Map getSwitchLookups() {
        return this.switchLookups;
    }

    boolean getEscapeSingleQuotes() {
        return this.escapeSingleQuotes;
    }

    void setEscapeSingleQuotes(boolean setting) {
        this.escapeSingleQuotes = setting;
    }

    public void setPageDependency(File pageFile) {
        this.dependency = new ArrayList<File>(1);
        this.dependency.add(pageFile);
        this.lastModified = pageFile.lastModified();
    }

    public void setPageDependecy(List<File> dependencies) {
        this.dependency = dependencies;
    }

    int getTagCount() {
        return this.tagCount++;
    }

    int getClosureCount() {
        return this.closureCount++;
    }

    TemplateReader getPageReader() throws IOException {
        InputStream stream = VFSFileFactory.getInputStream(this.canonicalPageFile.getAbsolutePath());
        return new TemplateReader(stream);
    }

    TemplateReader getPageReader(File file) throws IOException {
        InputStream stream = VFSFileFactory.getInputStream(file.getAbsolutePath());
        return new TemplateReader(stream);
    }

    String getClassName() {
        return this.className;
    }

    File getPageFile() {
        return this.canonicalPageFile;
    }

    String getPagePath() {
        return this.canonicalPageFile.getPath();
    }

    public String createStaticObject(Class clazz) {
        String result = "_sCt" + this.staticObjects.size();
        this.staticObjects.put(result, clazz);
        return result;
    }

    public Map getStaticObjects() {
        return this.staticObjects;
    }

    public int getImplicitArrayStructCount() {
        return this.implicitArrayStructCount++;
    }

    public String getPageEncoding() {
        return this.pageEncoding;
    }

    public void setPageEncoding(String pageEncoding) {
        this.pageEncoding = pageEncoding;
    }

    public Map getFinalVariables() {
        return this.finalVariables;
    }

    public Map<String, Map<String, String>> getFunctionFinalVariables() {
        return this.functionFinalVariables;
    }

    public void setFunctionFinalVariables(Map<String, Map<String, String>> functionFinalVariables) {
        this.functionFinalVariables = functionFinalVariables;
    }

    public Map<String, Map<String, String>> getFunctionNonLocalFinalVariables() {
        return this.functionNonLocalFinalVariables;
    }

    public void setFunctionNonLocalFinalVariables(Map<String, Map<String, String>> functionNonLocalFinalVariables) {
        this.functionNonLocalFinalVariables = functionNonLocalFinalVariables;
    }

    public Map<String, Map<String, String>> getFunctionNonLocalPrefixedFinalVariables() {
        return this.functionNonLocalPrefixedFinalVariables;
    }

    public void setFunctionNonLocalPrefixedFinalVariables(Map<String, Map<String, String>> functionNonLocalPrefixedFinalVariables) {
        this.functionNonLocalPrefixedFinalVariables = functionNonLocalPrefixedFinalVariables;
    }

    public Map<String, String> getFinalVariablesAsDSKey() {
        return this.finalVariablesAsDSKey;
    }

    public void setStaticProcessing(boolean flag) {
        this.staticProcessing = flag;
    }

    public boolean isProcessingStatic() {
        return this.staticProcessing;
    }

    public void setallowAllProcessing(boolean flag) {
        this.allowAllProcessing = flag;
    }

    public boolean allowAllProcessing() {
        return this.allowAllProcessing;
    }

    public void setStaticSupport(boolean flag) {
        this.staticSupport = flag;
    }

    public boolean staticSupport() {
        return this.staticSupport;
    }

    public static class StaticDuplicateFunctionDefinitionException
    extends ParseException {
        public String routineName;

        StaticDuplicateFunctionDefinitionException(String name, Token nameToken) {
            super(nameToken);
            this.routineName = name;
        }
    }

    public static class StaticDuplicatePropertyDefinitionException
    extends ParseException {
        public String propertyName;

        StaticDuplicatePropertyDefinitionException(Token nameToken) {
            super(nameToken);
            this.propertyName = nameToken.image;
        }
    }
}

