/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASCII_CharStream;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ChangeToComponentStateException;
import coldfusion.compiler.ClassReader;
import coldfusion.compiler.ConflictingEncodingSpecificationException;
import coldfusion.compiler.ExprVisitor;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.Node;
import coldfusion.compiler.PageDependencyInfo;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.SemanticAnalyzer;
import coldfusion.compiler.TemplateAssembler;
import coldfusion.compiler.TemplateOptimizer;
import coldfusion.compiler.TemplateReader;
import coldfusion.compiler.TreeTransformer;
import coldfusion.compiler.Treewalker;
import coldfusion.compiler.cfml40;
import coldfusion.compiler.validation.CFMLCodeValidator;
import coldfusion.compiler.validation.CFMLCompileError;
import coldfusion.compiler.validation.CfPathValidator;
import coldfusion.jsp.JRunTagLibraryInfo;
import coldfusion.log.CFLogs;
import coldfusion.runtime.CompilationEventListener;
import coldfusion.runtime.EventListeners;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.tools.CFMLCodeAnalyzer;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class NeoTranslator {
    private Vector cftags;
    private static final boolean BLOCK_JAVA_BYTE_COMPILATION = Boolean.valueOf(System.getProperty("coldfusion.compiler.block.bytecode", "true"));
    static ExecutorService executorService = null;
    private boolean saveClasses = true;
    private static JRunTagLibraryInfo cftaglibInfo = null;
    private static ThreadLocal<HashSet> fileCheckThreadLocal = new ThreadLocal();
    private ServletContext application;
    public final String outputDir;
    private ConcurrentHashMap<String, PageState> pages = new ConcurrentHashMap();
    private static Object oc;
    public static boolean verbose;
    private static final char[] hexDigits;

    public static ExecutorService initializeExecutorService() {
        int threads = 1;
        threads = Runtime.getRuntime().availableProcessors() * 2;
        if (threads > 10) {
            threads = 10;
        }
        return Executors.newFixedThreadPool(threads);
    }

    public static void shutDownExecutorService() {
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public NeoTranslator(ServletContext application) throws IOException {
        Utils.setupCompiler(application);
        Utils.parseWebXml(application);
        this.application = application;
        this.outputDir = (String)application.getAttribute("coldfusion.compiler.outputDir");
        this.scanTags();
        for (int i = 0; i < this.cftags.size(); ++i) {
            CfTagsElement el = (CfTagsElement)this.cftags.elementAt(i);
            if (!el.uri.equalsIgnoreCase(application.getInitParameter("cftags"))) continue;
            cftaglibInfo = JRunTagLibraryInfo.lookupTLI(el.tagFile, this.application, el.uri);
        }
        if (executorService == null) {
            executorService = NeoTranslator.initializeExecutorService();
        }
    }

    private void scanTags() {
        this.cftags = new Vector();
        String tagroot = this.application.getInitParameter("cftags");
        if (tagroot != null) {
            this.cftags.addElement(new CfTagsElement(new File(this.application.getRealPath(tagroot)), tagroot));
        }
    }

    public Map translateJava(String pageCanonicalPath, boolean force) throws IOException {
        PageState ps = this.getPageState(pageCanonicalPath);
        if (force || this.needsTranslating(ps)) {
            Map result = this.translateJava(ps);
            this.fireCompilationEvent(ps.canonicalFile);
            return result;
        }
        return null;
    }

    public ASTstart translateToASTNode(String pageCanonicalPath) throws IOException {
        NeoTranslationContext tc = new NeoTranslationContext(this.cftags, this.application, new File(pageCanonicalPath), "dummy");
        ASTstart startNode = this.parsePage(tc);
        return startNode;
    }

    public boolean needsTranslating(String pageCanonicalPath) {
        RuntimeService runtimeService = null;
        try {
            runtimeService = ServiceFactory.getRuntimeService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (runtimeService != null && runtimeService.isInRequestTemplateCacheEnabled()) {
            HashSet<String> fileCheckset = fileCheckThreadLocal.get();
            if (fileCheckset == null) {
                fileCheckset = new HashSet<String>();
                fileCheckThreadLocal.set(fileCheckset);
            } else if (fileCheckset.contains(pageCanonicalPath)) {
                return false;
            }
            fileCheckset.add(pageCanonicalPath);
        }
        return this.needsTranslating(this.getPageState(pageCanonicalPath));
    }

    public static void removeFileCheckThreadLocal() {
        fileCheckThreadLocal.remove();
    }

    public static String getClassName(File pageFile) {
        String fileName = pageFile.getName();
        StringBuffer buf = new StringBuffer(fileName.length() + 20);
        char[] rep = new char[4];
        buf.append("cf");
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                if (c == '/') {
                    buf.append('_');
                    buf.append('_');
                    continue;
                }
                int len = NeoTranslator.getCharAsChars(c, rep);
                buf.append(rep, 0, len);
                continue;
            }
            buf.append(c);
        }
        int hc = pageFile.hashCode();
        if (hc < 0) {
            hc ^= 0xFFFFFFFF;
        }
        buf.append(hc);
        return buf.toString();
    }

    public boolean isNewPage(String pageCanonicalPath) {
        return !this.pages.containsKey(pageCanonicalPath);
    }

    public void setSourceLastModified(String pageCanonicalPath, long lastModified) {
        PageState ps = new PageState(pageCanonicalPath);
        ps.pdi = new PageDependencyInfo(ps.canonicalFile, lastModified);
        this.pages.put(pageCanonicalPath, ps);
    }

    private PageState getPageState(final String pageCanonicalPath) {
        PageState result = null;
        if (System.getSecurityManager() == null) {
            return this._getPageState(pageCanonicalPath);
        }
        try {
            result = (PageState)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return NeoTranslator.this._getPageState(pageCanonicalPath);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return result;
    }

    private PageState _getPageState(String pageCanonicalPath) {
        PageState ps = this.pages.get(pageCanonicalPath);
        if (ps == null) {
            ps = new PageState(pageCanonicalPath);
            File classFile = new File(this.getBasePath(ps.className) + ".class");
            if (classFile.isFile()) {
                long lastModified = ps.canonicalFile.lastModified();
                ps.pdi = classFile.lastModified() >= lastModified ? new PageDependencyInfo(ps.canonicalFile, lastModified) : null;
            }
            this.pages.put(pageCanonicalPath, ps);
        }
        return ps;
    }

    private Map translateJava(PageState pageState) throws IOException {
        Map map;
        long before = System.currentTimeMillis();
        NeoTranslationContext tc = new NeoTranslationContext(this.cftags, this.application, pageState.canonicalFile, pageState.className);
        TemplateReader in = tc.getPageReader();
        try {
            Map classes;
            if (in.isClasses()) {
                String filePAth;
                if (BLOCK_JAVA_BYTE_COMPILATION && !CfPathValidator.validatePath(filePAth = pageState.canonicalFile.getPath(), true)) {
                    CFLogs.SERVER_LOG.info("ColdFusion, by default, disables the execution of bytecode in .cfm and .cfc files:" + filePAth);
                    throw new IOException(RB.getString((Object)this, "TemplateReader.Block.ByteCode.Compilation", (Object)"coldfusion.compiler.block.bytecode", (Object)filePAth));
                }
                classes = this.parseClasses(tc);
                File pageFile = tc.getPageFile();
                pageState.pdi = new PageDependencyInfo(pageFile, pageFile.lastModified());
            } else {
                if (oc != null) {
                    Map pageFile = null;
                    return pageFile;
                }
                ASTstart startNode = this.parseAndTransform(tc, in);
                classes = new TemplateAssembler().assemble(startNode, tc);
                if (verbose) {
                    System.out.print("assembled " + tc.getPageFile().getName());
                }
                PageDependencyInfo pageDependencyInfo = pageState.pdi = tc.dependency.size() == 1 ? new PageDependencyInfo(tc.dependency.get(0), tc.lastModified) : new PageDependencyInfo(tc.dependency);
                if (this.saveClasses) {
                    executorService.execute(() -> {
                        try {
                            this.saveClasses(classes);
                        }
                        catch (IOException ioe) {
                            this.deletePageState(pageState.canonicalFile);
                            CFLogs.SERVER_LOG.error(ioe);
                        }
                    });
                }
                if (verbose) {
                    this.printInfo(classes);
                    System.out.println(System.currentTimeMillis() - before + " millis");
                }
            }
            map = classes;
        }
        catch (RuntimeException re) {
            this.deletePageState(pageState.canonicalFile);
            throw re;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return map;
    }

    private ASTstart parseAndTransform(NeoTranslationContext tc, TemplateReader in) {
        ASTstart startNode = this.parsePage(tc, in);
        if (startNode.parser.supportStatic()) {
            tc.setStaticSupport(true);
        }
        tc.setPageDependency(tc.getPageFile());
        if (verbose) {
            System.out.print(this.countNodes(startNode) + " nodes ");
        }
        this.validate(startNode);
        Treewalker.postorder(startNode, new SemanticAnalyzer(tc));
        Treewalker.postorder(startNode, new ExprVisitor(tc));
        Treewalker.postorder(startNode, new TemplateOptimizer());
        for (Map.Entry entry : tc.getClosureTable().entrySet()) {
            String string = (String)entry.getKey();
        }
        return startNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map parseClasses(NeoTranslationContext tc) throws IOException {
        File classFile = tc.getPageFile();
        byte[] b = null;
        try (FileInputStream fin = null;){
            int n;
            fin = new FileInputStream(classFile);
            int len = (int)classFile.length();
            b = new byte[len];
            for (int off = 0; off < len; off += n, len -= n) {
                n = fin.read(b, off, len);
                if (n >= 1) continue;
                System.out.println("early eof " + n + " " + classFile);
                throw new IOException("Error reading file");
            }
        }
        Hashtable<String, Object> classes = new Hashtable<String, Object>();
        int pos = 0;
        ClassReader reader = new ClassReader(b);
        while (pos < b.length) {
            int end_of_class = reader.findEndOfClass(pos);
            int len = end_of_class - pos;
            byte[] newClass = new byte[len];
            System.arraycopy(b, pos, newClass, 0, len);
            String className = new ClassReader(newClass).getClassName();
            classes.put(className, newClass);
            if (className.indexOf("$") == -1) {
                classes.put("MainClassName", className);
            }
            pos = end_of_class;
        }
        return classes;
    }

    private int countNodes(ASTstart startNode) {
        class NodeCounter
        implements TreeTransformer {
            int count = 0;

            NodeCounter() {
            }

            @Override
            public Node preTransform(Node n) {
                return n;
            }

            @Override
            public Node transform(Node n) {
                ++this.count;
                return n;
            }
        }
        NodeCounter counter = new NodeCounter();
        Treewalker.postorder(startNode, counter);
        return counter.count;
    }

    void validate(ASTstart root) throws ParseException {
        JJTreeVisitor validator;
        CFMLCompileError errors = null;
        try {
            String aggregateError = this.application.getInitParameter("coldfusion.compiler.errorAggregate");
            if (aggregateError != null && aggregateError.equalsIgnoreCase("true")) {
                errors = new CFMLCompileError();
                validator = new CFMLCodeValidator(errors);
            } else {
                validator = new CFMLCodeValidator();
            }
        }
        catch (RuntimeException ex) {
            validator = new JJTreeVisitor();
        }
        root.accept(validator);
        if (errors != null && !errors.getValidationResult().isEmpty()) {
            throw errors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTstart parsePage(NeoTranslationContext tc) throws IOException {
        ASTstart startNode = null;
        try (TemplateReader in = tc.getPageReader();){
            startNode = this.parsePage(tc, in);
        }
        return startNode;
    }

    ASTstart parsePage(NeoTranslationContext tc, TemplateReader in) {
        return this.parsePage(tc, in, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTstart parsePage(NeoTranslationContext tc, TemplateReader in, boolean script) {
        ASTstart result;
        ASCII_CharStream charStream;
        block20: {
            charStream = new ASCII_CharStream(in);
            cfml40 parser = new cfml40(charStream);
            if (script) {
                parser.token_source.SwitchTo(4);
            }
            parser.setTranslationContext(tc);
            parser.setInputEncoding(in.getEncoding());
            tc.setPageEncoding(in.getEncoding());
            try {
                result = parser.start();
            }
            catch (ConflictingEncodingSpecificationException cex) {
                if (!in.explicitEncodingSet()) {
                    in.resetEncoding(cex.desiredEncoding, tc);
                    tc.setPageEncoding(cex.desiredEncoding);
                    tc.resetPropertyTable();
                    result = this.parsePage(tc, in);
                }
                throw cex;
            }
            catch (ChangeToComponentStateException ex) {
                TemplateReader pageReader;
                try {
                    pageReader = tc.getPageReader();
                }
                catch (IOException e) {
                    pageReader = in;
                }
                charStream = new ASCII_CharStream(pageReader);
                parser = new cfml40(charStream);
                parser.token_source.SwitchTo(4);
                parser.setTranslationContext(tc);
                parser.setInputEncoding(pageReader.getEncoding());
                tc.setPageEncoding(pageReader.getEncoding());
                try {
                    result = parser.start();
                }
                catch (ConflictingEncodingSpecificationException cex) {
                    if (!pageReader.explicitEncodingSet()) {
                        pageReader.resetEncoding(cex.desiredEncoding);
                        tc.setPageEncoding(cex.desiredEncoding);
                        tc.resetPropertyTable();
                        result = this.parsePage(tc, pageReader, true);
                        break block20;
                    }
                    throw cex;
                }
                finally {
                    try {
                        pageReader.close();
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (verbose) {
            System.out.print(charStream.getEndLine() + " lines ");
        }
        return result;
    }

    private long[] toLongArray(Vector v) {
        if (v == null) {
            return null;
        }
        long[] longs = new long[v.size()];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = (Long)v.elementAt(i);
        }
        return longs;
    }

    private File[] toFileArray(Vector v) {
        if (v == null) {
            return null;
        }
        File[] files = new File[v.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = (File)v.elementAt(i);
        }
        return files;
    }

    private void printInfo(Map bytes) {
        if (bytes != null) {
            Iterator i = bytes.keySet().iterator();
            int total = 0;
            while (i.hasNext()) {
                String classname = (String)i.next();
                byte[] b = (byte[])bytes.get(classname);
                if (b == null) continue;
                total += b.length;
            }
            System.out.print(" " + total + " bytes ");
        }
    }

    private boolean needsTranslating(PageState ps) {
        long last_modified;
        if (ps.pdi == null) {
            return true;
        }
        File[] dependency = ps.pdi.dependency;
        if (dependency != null) {
            for (int i = 0; i < dependency.length; ++i) {
                if (dependency[i].lastModified() == ps.pdi.lastModified[i]) continue;
                return true;
            }
        } else if (ps.pdi.page != null && (last_modified = ps.pdi.page.lastModified()) != ps.pdi.pageLastModified) {
            return true;
        }
        return false;
    }

    protected void deletePageState(File canonicalFile) {
        this.pages.remove(canonicalFile.getPath());
    }

    protected String getBasePath(String className) {
        return this.outputDir + File.separatorChar + className;
    }

    public synchronized void setSaveClasses(boolean b) {
        this.saveClasses = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _saveClasses(Map classBytes) throws IOException {
        for (String name : classBytes.keySet()) {
            String file = this.getBasePath(name) + ".class";
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write((byte[])classBytes.get(name));
            }
        }
    }

    public void saveClasses(final Map classBytes) throws IOException {
        block4: {
            if (System.getSecurityManager() == null) {
                this._saveClasses(classBytes);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            NeoTranslator.this._saveClasses(classBytes);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (!(e.getException() instanceof IOException)) break block4;
                    throw (IOException)e.getException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveClasses(Map classBytes, File saveFile) throws IOException {
        Iterator i = classBytes.keySet().iterator();
        try (FileOutputStream out = new FileOutputStream(saveFile);){
            while (i.hasNext()) {
                String name = (String)i.next();
                out.write((byte[])classBytes.get(name));
            }
        }
    }

    private static int getCharAsChars(char c, char[] ca) {
        char tmp = c;
        int len = 0;
        while (tmp > '\u0000') {
            tmp = (char)(tmp >> 4);
            ++len;
        }
        for (int i = 0; i < len; ++i) {
            ca[i] = hexDigits[c >> (len - 1 - i) * 4 & 0xF];
        }
        return len;
    }

    public void analyzePage(File canonicalPageFile) throws IOException {
        NeoTranslationContext tc = new NeoTranslationContext(this.cftags, this.application, canonicalPageFile, "dummy");
        ASTstart startNode = this.parsePage(tc);
        CFMLCodeAnalyzer analyzer = (CFMLCodeAnalyzer)this.application.getAttribute("CodeAnalyzer");
        analyzer.analyze(startNode, canonicalPageFile.getAbsolutePath());
    }

    public long getLastModifiedTime(String canonicalPagePath) {
        PageState psObj = this.pages.get(canonicalPagePath);
        if (psObj == null) {
            return 0L;
        }
        PageState ps = psObj;
        return ps.canonicalFile.lastModified();
    }

    public long getLastCompiledTime(String canonicalPagePath) {
        PageState psObj = this.pages.get(canonicalPagePath);
        if (psObj == null) {
            return 0L;
        }
        PageState ps = psObj;
        return ps.pdi.pageLastModified;
    }

    public static JRunTagLibraryInfo getCftaglibInfo() {
        return cftaglibInfo;
    }

    private void fireCompilationEvent(File file) {
        List<CompilationEventListener> listeners = EventListeners.getCompilationEventListeners();
        if (listeners != null) {
            for (CompilationEventListener listener : listeners) {
                try {
                    listener.afterCompilation(file);
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception exception) {
                }
            }
        }
    }

    static {
        if (executorService == null) {
            executorService = NeoTranslator.initializeExecutorService();
        }
        oc = null;
        try {
            oc = Class.forName("coldfusion.runtime.OEMUtils");
        }
        catch (Exception ex) {
            oc = null;
        }
        verbose = false;
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    class CfTagsElement {
        File tagFile;
        String uri;

        CfTagsElement(File f, String s) {
            this.tagFile = f;
            this.uri = s;
        }
    }

    static class PageState {
        PageDependencyInfo pdi;
        final File canonicalFile;
        final String className;

        PageState(String pageCanonicalPath) {
            this.canonicalFile = VFSFileFactory.getFileObject(pageCanonicalPath);
            this.className = NeoTranslator.getClassName(this.canonicalFile);
        }
    }
}

