/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ParseException;
import coldfusion.compiler.Token;
import coldfusion.util.RB;
import java.util.Objects;

public class ScriptParseExceptions {
    private static ScriptParseExceptions cfiException = new ScriptParseExceptions();

    private ScriptParseExceptions() {
    }

    public static void throwRequiredAttributeException(String tag, String attribute) throws RequiredAttributeException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new RequiredAttributeException(tag, attribute);
    }

    public static void throwMissingKeywordException(String tag, String attribute) throws MissingKeywordException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new MissingKeywordException(tag, attribute);
    }

    public static void throwInvalidObjectTypeWithNewOperatorException(String objectType) throws MissingKeywordException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new InvalidObjectTypeWithNewOperatorException(objectType);
    }

    public static void throwNullObjectTypeWithNewOperatorException() throws NullObjectTypeWithNewOperatorException {
        throw cfiException.new NullObjectTypeWithNewOperatorException();
    }

    public static void throwDisallowedTypeDeclarationException(String tag) throws DisallowedTypeDeclarationException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new DisallowedTypeDeclarationException(tag);
    }

    public static void throwTypedArrayEmptyTypeException(String tag) throws TypedArrayEmptyTypeException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new TypedArrayEmptyTypeException(tag);
    }

    public static void throwTypedArrayInvalidTypeException(Object type) throws TypedArrayInvalidTypeException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new TypedArrayInvalidTypeException(type);
    }

    public static void throwInvalidArrayInitializerException() throws InvalidArrayInitializerException {
        throw cfiException.new InvalidArrayInitializerException();
    }

    public static void throwArrayInitializerEmptyTypeException() throws TypedArrayEmptyTypeException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new TypedArrayEmptyTypeException(RB.getString(ScriptParseExceptions.class, "ASTArrayInitializer.emptyType"));
    }

    public static void throwSemicolonMissingException() throws SemicolonMissingException {
        throw cfiException.new SemicolonMissingException();
    }

    public static void throwInvalidPropertyException() throws InvalidPropertyException {
        throw cfiException.new InvalidPropertyException();
    }

    public static void throwReservedKeywordUsageException(Token errorToken) throws ReservedKeywordUsageException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new ReservedKeywordUsageException(errorToken);
    }

    public static void throwNullNotAllowedAsVariableNameException(Token errorToken) throws NullNotAllowedAsVariableNameException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new NullNotAllowedAsVariableNameException(errorToken);
    }

    public static void ReservedKeywordAsVariableNameException(Token errorToken) throws ReservedKeywordAsVariableNameException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new ReservedKeywordAsVariableNameException(errorToken);
    }

    public static void InvalidDeStructuringSyntaxException(String type) throws ReservedKeywordAsVariableNameException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new InvalidDeStructuringSyntaxException(type);
    }

    public static void RestOperatorException(String type) throws ReservedKeywordAsVariableNameException {
        ScriptParseExceptions scriptParseExceptions = cfiException;
        Objects.requireNonNull(scriptParseExceptions);
        throw scriptParseExceptions.new RestOperatorException(type);
    }

    public class RequiredAttributeException
    extends ParseException
    implements ScriptExceptionType {
        public String attribute;
        public String tag;

        RequiredAttributeException(String tag, String attribute) {
            this.tag = tag.toUpperCase();
            this.attribute = attribute;
        }
    }

    public class MissingKeywordException
    extends ParseException
    implements ScriptExceptionType {
        public String keyword;
        public String tag;

        MissingKeywordException(String tag, String keyword) {
            this.tag = tag.toUpperCase();
            this.keyword = keyword;
        }
    }

    public class InvalidObjectTypeWithNewOperatorException
    extends ParseException
    implements ScriptExceptionType {
        public String objectType;

        InvalidObjectTypeWithNewOperatorException(String objectType) {
            this.objectType = objectType;
        }
    }

    public class NullObjectTypeWithNewOperatorException
    extends ParseException
    implements ScriptExceptionType {
        NullObjectTypeWithNewOperatorException() {
        }
    }

    public class DisallowedTypeDeclarationException
    extends ParseException
    implements ScriptExceptionType {
        public String tag;

        DisallowedTypeDeclarationException(String tag) {
            this.tag = tag.toUpperCase();
        }
    }

    public class TypedArrayEmptyTypeException
    extends ParseException
    implements ScriptExceptionType {
        public String tag;

        TypedArrayEmptyTypeException(String tag) {
            this.tag = tag.toUpperCase();
        }
    }

    public class TypedArrayInvalidTypeException
    extends ParseException
    implements ScriptExceptionType {
        public Object type;

        TypedArrayInvalidTypeException(Object type) {
            this.type = type;
        }
    }

    public class InvalidArrayInitializerException
    extends ParseException
    implements ScriptExceptionType {
        InvalidArrayInitializerException() {
        }
    }

    public class SemicolonMissingException
    extends ParseException
    implements ScriptExceptionType {
    }

    public class InvalidPropertyException
    extends ParseException
    implements ScriptExceptionType {
    }

    public class ReservedKeywordUsageException
    extends ParseException
    implements ScriptExceptionType {
        public String name;

        public ReservedKeywordUsageException(Token errorToken) {
            super(errorToken);
            this.name = errorToken.image;
        }
    }

    public class NullNotAllowedAsVariableNameException
    extends ParseException
    implements ScriptExceptionType {
        public NullNotAllowedAsVariableNameException(Token errorToken) {
            super(errorToken);
        }
    }

    public class ReservedKeywordAsVariableNameException
    extends ParseException
    implements ScriptExceptionType {
        public String keyword;

        public ReservedKeywordAsVariableNameException(Token errorToken) {
            super(errorToken);
            this.keyword = errorToken.image;
        }
    }

    public class InvalidDeStructuringSyntaxException
    extends ParseException
    implements ScriptExceptionType {
        public String type;

        public InvalidDeStructuringSyntaxException(String type) {
            this.type = type;
        }
    }

    public class RestOperatorException
    extends ParseException
    implements ScriptExceptionType {
        public String type;

        public RestOperatorException(String type) {
            this.type = type;
        }
    }

    public static class AccessModifierException
    extends ParseException {
        AccessModifierException(Token t) {
            super(t);
        }
    }

    public static interface ScriptExceptionType {
    }
}

