/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.CharStream;
import java.io.IOException;

public class StringCharStream
implements CharStream {
    String sourceString;
    int lastPosition;
    int beginTokenPos;
    int currentPosition;

    public StringCharStream(String src) {
        this.sourceString = src;
        this.currentPosition = 0;
        this.lastPosition = src.length() - 1;
    }

    @Override
    public char readChar() throws IOException {
        if (this.currentPosition > this.lastPosition) {
            throw new IOException("eof");
        }
        char result = this.sourceString.charAt(this.currentPosition);
        ++this.currentPosition;
        return result;
    }

    @Override
    public int getEndColumn() {
        return this.currentPosition;
    }

    @Override
    public int getEndLine() {
        return 1;
    }

    @Override
    public int getBeginColumn() {
        return this.beginTokenPos + 1;
    }

    @Override
    public int getBeginLine() {
        return 1;
    }

    @Override
    public void backup(int amount) {
        this.currentPosition -= amount;
    }

    @Override
    public char BeginToken() throws IOException {
        this.beginTokenPos = this.currentPosition;
        char result = this.readChar();
        return result;
    }

    @Override
    public String GetImage() {
        return this.sourceString.substring(this.beginTokenPos, this.currentPosition);
    }

    @Override
    public char[] GetSuffix(int len) {
        char[] result = new char[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.sourceString.charAt(this.currentPosition - (len - i));
        }
        return result;
    }
}

