/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTcfproperty;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.AccessModifier;
import coldfusion.compiler.CFMLParserBase;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.FunctionAssembler;
import coldfusion.compiler.NeoTranslationContext;
import coldfusion.compiler.Node;
import coldfusion.compiler.OperationNotSupportedException;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.RecursiveDefinitionException;
import coldfusion.compiler.StaticFieldReference;
import coldfusion.compiler.StmtAssembler;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.ImplementationUtil;
import coldfusion.runtime.Variable;
import coldfusion.tools.Compiler;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;

final class TemplateAssembler
extends StmtAssembler {
    private static final Method runPage = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "runPage", new Class[0]);
    private static final Method registerUDFs = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "registerUDFs", new Class[0]);
    private static final Method registerUDF = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "registerUDF", new Class[]{StringClass, UDFMethodClass});
    private static final Method bindPageVariables = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "bindPageVariables", new Class[]{VariableScopeClass, LocalScopeClass});
    private static final Method bindPageVariable = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "bindPageVariable", new Class[]{StringClass, VariableScopeClass, LocalScopeClass});
    private static final Method bindFinalPageVariable = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "bindFinalPageVariable", new Class[]{StringClass, VariableScopeClass, LocalScopeClass});
    private static final Method clearStaticScope = TemplateAssembler.getDeclaredMethod(StaticScopeClass, "clear", new Class[0]);
    private static final Method createImplicitVariable = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "createImplicitVariable", new Class[]{StringClass, VariableScopeClass});
    private static final Field hasPseudoConstructor = TemplateAssembler.getInstanceField(CfJspPageClass, "hasPseudoConstructor");
    private static final Method getImplicitMethods = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "_getImplicitMethods", new Class[0]);
    private static final Method setImplicitMethods = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "_setImplicitMethods", new Class[]{MapClass});
    private static final Method runStaticBlock = TemplateAssembler.getDeclaredMethod(CfComponentClass, "runStaticBlock", new Class[0]);
    private static final Method getStaticScope = TemplateAssembler.getDeclaredMethod(CfComponentClass, "getStaticScope", new Class[0]);
    private static final Method registerStaticUDFs = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "registerStaticUDFs", new Class[0]);
    private static final Method createImplicitVariableInStaticScope = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "createImplicitVariable", new Class[]{StringClass, StaticScopeClass, booleanClass});
    private static final Method linkStaticScope = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "linkStaticScope", new Class[]{UDFMethodClass, StaticScopeClass});
    private static final Method registerUDFInScope = TemplateAssembler.getDeclaredMethod(CfJspPageClass, "registerUDFinScope", new Class[]{StringClass, UDFMethodClass, LocalScopeClass});
    private static final Method reAssemble = TemplateAssembler.getDeclaredMethod(CfComponentClass, "reAssemble", new Class[0]);
    private static final Method getPropertyDefault = TemplateAssembler.getDeclaredMethod(CfComponentClass, "getPropertyDefault", new Class[]{StringClass});
    private static final Set cfArrayMethods = new HashSet();

    TemplateAssembler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map assemble(ASTstart start, NeoTranslationContext tc) throws IOException {
        Object object = compileLock;
        synchronized (object) {
            HashMap resultMap = new HashMap();
            this.tc = tc;
            String fileName = tc.getPageFile().getName();
            String fileExt = fileName.length() > 3 ? fileName.substring(fileName.length() - 3) : "";
            boolean isCFC = fileExt.equalsIgnoreCase("cfc");
            String className = tc.getClassName();
            long sourceModTime = tc.lastModified;
            String pagePath = Compiler.removeAndGetBuildPathIfAdminPage(tc.getPagePath());
            this.startClass(className, tc.getBaseClass(), new Class[0], pagePath);
            if (start.parser.supportStatic()) {
                this.declareStaticVars(isCFC);
            }
            this.declareVars();
            this.setConstructorFlagField(start);
            this.declareStatics();
            this.setSourceModified(sourceModTime);
            if (!start.parser.isInterface()) {
                boolean declareStatic;
                boolean bl = declareStatic = isCFC && start.parser.supportStatic();
                if (declareStatic) {
                    this.declareStaticBlock(start);
                }
                Object label = this.assemblePage(start, declareStatic);
                this.addLineNumber(label, 1);
            }
            HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
            this.assembleFunctions(classes, isCFC);
            this.dumpStartMetadata(start);
            classes.put(className, this.getBytes());
            return classes;
        }
    }

    private void declareStaticBlock(ASTstart start) {
        this.implementMethod(runStaticBlock, new String[0], false, false);
        this.getstatic(this.findField("isStaticInitialized"));
        this.getstatic(this.findField("withinStaticBlock"));
        Object ior = this.ior();
        Object ifEq = this.ifeq(null);
        this.aconst(null);
        this.mreturn(runStaticBlock.getReturnType());
        this.setTarget(ifEq, this.label());
        this.aconst(true);
        this.putstatic(this.findField("withinStaticBlock"));
        this.getstatic(this.findField(this.getStaticScopeVarName()));
        this.invoke(clearStaticScope);
        this.pageVar = this.findLocal("this");
        this.outVar = this.createLocal(JspWriterClass, "out");
        this.valueVar = this.createLocal(ObjectClass, "value");
        this.parentVar = this.createLocal(TagClass, "parent");
        Object label = this.load(this.pageVar);
        this.getfield(pageContext);
        this.invoke(getOut);
        this.store(this.outVar);
        this.load(this.pageVar);
        this.getfield(pageParent);
        this.store(this.parentVar);
        this.declareImports();
        this.pageVar = this.findLocal("this");
        this.load(this.pageVar);
        this.invoke(registerStaticUDFs);
        this.createStaticVariables(this.tc.getStaticVariables());
        this.tc.setStaticProcessing(true);
        this.block(start.children);
        this.tc.setStaticProcessing(false);
        Object staticFlag = this.findField("isStaticInitialized");
        this.aconst(true);
        this.putstatic(staticFlag);
        this.aconst(false);
        this.putstatic(this.findField("withinStaticBlock"));
        this.aconst(null);
        this.mreturn(runStaticBlock.getReturnType());
    }

    private void declareStatics() {
        Map statics = this.tc.getStaticObjects();
        if (!statics.isEmpty()) {
            String oldMethod = this.setMethod("<clinit>");
            Iterator i = statics.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                Class type = (Class)statics.get(key);
                Object field = this.createField(type, key, 24);
                this.newinstance(type);
                this.invokespecial(type.getName(), "<init>");
                this.putstatic(field);
            }
        }
    }

    private void declareStaticVars(boolean isCFC) {
        if (!isCFC) {
            return;
        }
        String oldMethod = this.setMethod("<clinit>");
        Object staticField = this.createField(StaticScopeClass, this.getStaticScopeVarName(), 10);
        this.newinstance(StaticScopeClass);
        this.invokespecial(StaticScopeClass.getName(), "<init>");
        this.putstatic(staticField);
        Object initFlag = this.createField(booleanClass, "isStaticInitialized", 10);
        this.aconst(false);
        this.putstatic(initFlag);
        Object withinStatic = this.createField(booleanClass, "withinStaticBlock", 10);
        this.aconst(false);
        this.putstatic(withinStatic);
    }

    private void declareVars() {
        Map variables = this.tc.getVariables();
        Map finalvariables = this.tc.getFinalVariables();
        Map implicitVars = this.tc.getImplicitVariables();
        Map<String, Integer> staticVars = this.tc.getStaticVariables();
        this.declareVars(variables, finalvariables, implicitVars, staticVars);
    }

    private void declareVars(Map variables, Map finalVariables, Map implicitVariables, Map staticVars) {
        if (variables != null && variables.size() > 0 || implicitVariables != null && implicitVariables.size() > 0 || finalVariables != null && finalVariables.size() > 0) {
            this.implementMethod(bindPageVariables, new String[]{"varscope", "locscope"});
            this.pageVar = this.findLocal("this");
            Object varscopeVar = this.findLocal("varscope");
            Object locscopeVar = this.findLocal("locscope");
            this.load(this.pageVar);
            this.load(varscopeVar);
            this.load(locscopeVar);
            this.invokespecial(bindPageVariables);
            this.createVariables(variables, varscopeVar, locscopeVar, false, staticVars);
            this.createFinalVariables(finalVariables, varscopeVar, locscopeVar, staticVars);
            this.createVariables(implicitVariables, varscopeVar, locscopeVar, true, staticVars);
            this.vreturn();
        }
    }

    private void createFinalVariables(Map variables, Object varscopeVar, Object locscopeVar, Map staticVars) {
        if (variables == null) {
            return;
        }
        for (String name : variables.keySet()) {
            if (staticVars.containsKey(name.toUpperCase())) continue;
            Object varField = this.createField(VariableClass, name, 2);
            this.load(this.pageVar);
            this.load(this.pageVar);
            this.aconst(name);
            this.load(varscopeVar);
            this.load(locscopeVar);
            this.invoke(bindFinalPageVariable);
            this.putfield(varField);
        }
    }

    private void createVariables(Map variables, Object varscopeVar, Object locscopeVar, boolean isImplicit, Map staticVars) {
        if (variables == null) {
            return;
        }
        for (String name : variables.keySet()) {
            if (staticVars.containsKey(name.toUpperCase())) continue;
            Object varField = null;
            varField = this.createField(VariableClass, name, 2);
            this.load(this.pageVar);
            this.load(this.pageVar);
            this.aconst(name);
            this.load(varscopeVar);
            if (!isImplicit) {
                this.load(locscopeVar);
                this.invoke(bindPageVariable);
            } else {
                this.invoke(createImplicitVariable);
            }
            this.putfield(varField);
        }
    }

    private void createStaticVariables(Map<String, Integer> staticVars) {
        if (staticVars == null) {
            return;
        }
        for (String name : staticVars.keySet()) {
            int val = staticVars.get(name);
            boolean isImplicit = Variable.isStaticImplicit(val);
            boolean isFinal = Variable.isStaticFinal(val);
            int modifier = AccessModifier.getModifier(val);
            Object varField = null;
            varField = this.createField(VariableClass, name, 10);
            if (isImplicit) {
                this.load(this.pageVar);
                this.aconst(name);
                this.getstatic(this.findField(this.getStaticScopeVarName()));
                this.aconst(Variable.isStaticImplicit(staticVars.get(name)));
                this.invoke(createImplicitVariableInStaticScope);
                this.putstatic(varField);
                continue;
            }
            this.load(this.pageVar);
            this.aconst(name);
            this.getstatic(this.findField(this.getStaticScopeVarName()));
            this.aconst(isFinal);
            this.aconst(modifier);
            this.invoke(bindStaticVariable);
            this.putstatic(varField);
        }
    }

    private Object assemblePage(ASTstart start, boolean declareStatic) {
        this.implementMethod(runPage, new String[0]);
        if (declareStatic) {
            this.getstatic(this.findField("withinStaticBlock"));
            Object ifEq = this.ifeq(null);
            this.aconst(null);
            this.mreturn(runPage.getReturnType());
            this.setTarget(ifEq, this.label());
        }
        this.pageVar = this.findLocal("this");
        this.outVar = this.createLocal(JspWriterClass, "out");
        this.valueVar = this.createLocal(ObjectClass, "value");
        this.parentVar = this.createLocal(TagClass, "parent");
        Object label = this.load(this.pageVar);
        this.getfield(pageContext);
        this.invoke(getOut);
        this.store(this.outVar);
        this.load(this.pageVar);
        this.getfield(pageParent);
        this.store(this.parentVar);
        if (this.tc.getPageEncoding() != null) {
            label = this.load(this.pageVar);
            this.getfield(pageContext);
            this.aconst(this.tc.getPageEncoding());
            this.invokeVoid(setPageEncoding);
        }
        this.declareImports();
        try {
            this.block(start.children);
        }
        catch (ParseException pex) {
            if (pex._getPageFile() == null) {
                pex._setPageFile(this.tc.getPageFile());
            }
            throw pex;
        }
        this.aconst(null);
        this.mreturn(runPage.getReturnType());
        return label;
    }

    private void setConstructorFlagField(ASTstart start) {
        String path = this.tc.getPageFile().getName();
        if (path.toLowerCase().endsWith(".cfc")) {
            boolean hasRunnableCode = false;
            Node[] children = start.children;
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    Node child = children[i];
                    if (child.id == 0 || child.id == 24 || child.id == 18 || child.id == 43334) continue;
                    hasRunnableCode = true;
                    break;
                }
            }
            if (!hasRunnableCode) {
                this.setMethod("<init>");
                this.loadInstruction((Instruction)InstructionFactory.THIS);
                this.zconst(hasRunnableCode);
                this.putfield(hasPseudoConstructor);
            }
        }
    }

    @Override
    Object assembleStatement(Node node) {
        switch (node.id) {
            case 18: 
            case 24: 
            case 43334: {
                return this.label();
            }
        }
        return super.assembleStatement(node);
    }

    void assembleFunctions(Map classes, boolean iscfc) throws IOException {
        Hashtable UDFAndClosureTable = new Hashtable();
        UDFAndClosureTable.putAll(this.tc.getUdfTable());
        UDFAndClosureTable.putAll(this.tc.getClosureTable());
        Enumeration UDFs = UDFAndClosureTable.elements();
        if (UDFs.hasMoreElements()) {
            this.implementMethod(registerUDFs, new String[0]);
            if (this.pageVar == null) {
                this.pageVar = this.findLocal("this");
            }
            this.registersMethods(classes, UDFs, false);
            this.vreturn();
            if (this.tc.staticSupport()) {
                this.implementMethod(registerStaticUDFs, new String[0]);
                if (this.pageVar == null) {
                    this.pageVar = this.findLocal("this");
                }
                this.registersMethods(classes, UDFAndClosureTable.elements(), true);
                this.vreturn();
            }
        }
        if (iscfc && this.tc.staticSupport()) {
            this.implementMethod(getStaticScope, new String[0]);
            this.getstatic(this.findField(this.getStaticScopeVarName()));
            this.mreturn(getStaticScope.getReturnType());
            this.implementMethod(reAssemble, new String[0]);
            this.aconst(false);
            this.putstatic(this.findField("withinStaticBlock"));
            this.aconst(null);
            this.mreturn(reAssemble.getReturnType());
        }
    }

    private void registersMethods(Map classes, Enumeration UDFs, boolean staticContext) throws IOException {
        while (UDFs.hasMoreElements()) {
            Object udfField;
            ASTfunctionDefinition nextFunction = (ASTfunctionDefinition)UDFs.nextElement();
            if (nextFunction.isStatic() != staticContext) continue;
            FunctionAssembler assembler = new FunctionAssembler(this.tc, nextFunction);
            assembler.assemble(classes, nextFunction.parser.isInterface());
            if (nextFunction.isAnonymousClosure()) continue;
            if (nextFunction.isClosure()) {
                this.load(this.pageVar);
                udfField = this.createField(ClosureClass, nextFunction.getUserName(), 1);
                this.newinstance(assembler.getClassName());
                this.invokespecial(assembler.getClassName(), "<init>");
                this.putfield(udfField);
            } else {
                udfField = this.createField(UDFMethodClass, nextFunction.getUserName(), 26);
                String oldMethod = this.setMethod("<clinit>");
                this.newinstance(assembler.getClassName());
                this.invokespecial(assembler.getClassName(), "<init>");
                this.putstatic(udfField);
                this.setMethod(oldMethod);
            }
            String udfName = nextFunction.getUserName().toUpperCase();
            this.load(this.pageVar);
            this.aconst(udfName);
            if (nextFunction.isClosure()) {
                this.load(this.pageVar);
                this.getfield(udfField);
            } else {
                this.getstatic(udfField);
            }
            if (nextFunction.isStatic()) {
                this.getstatic(this.findField(this.getStaticScopeVarName()));
                this.invokeVoid(registerUDFInScope);
                continue;
            }
            this.invokeVoid(registerUDF);
            Object o = this.findField(this.getStaticScopeVarName());
            if (o == null) continue;
            this.load(this.pageVar);
            if (nextFunction.isClosure()) {
                this.load(this.pageVar);
                this.getfield(udfField);
            } else {
                this.getstatic(udfField);
            }
            this.getstatic(o);
            this.invokeVoid(linkStaticScope);
        }
    }

    private void dumpStartMetadata(ASTstart start) {
        Object metaDataField = this.createField(ObjectClass, "metaData", 25);
        this.implementMethod(getMetaData, new String[0]);
        this.getstatic(metaDataField);
        this.areturn();
        String oldMethod = this.setMethod("<clinit>");
        this.newinstance(AttributeCollectionClass);
        ArrayList attrData = this.beginAttrMetadata(start.attrList);
        this.sanitizeAttrDataForImplementations(attrData);
        String path = this.tc.getPageFile().getName();
        if (path.toLowerCase().endsWith(".cfc")) {
            String name = path.substring(0, path.length() - 4);
            attrData.add("Name");
            attrData.add(name);
            this.checkForRecursiveDefinition(start, name);
            this.addImplicitMethods();
            this.setMethod("<clinit>");
        }
        this.dumpFunctionListMetadata(attrData);
        this.dumpPropertyListMetadata(attrData);
        this.newarray(ObjectClass, attrData.toArray());
        this.invokespecial(newAttributeCollection);
        this.putstatic(metaDataField);
        this.setMethod(oldMethod);
        this.attrGetter(start.attrMap, "Extends");
        this.attrGetter(start.attrMap, "Output");
        this.attrGetter(start.attrMap, "Implements");
        this.dumpDefaultExpressions();
    }

    private void sanitizeAttrDataForImplementations(ArrayList attrData) {
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        for (int i = 0; i < attrData.size(); i += 2) {
            if (!attrData.get(i).equals("implements") && !attrData.get(i).equals("extends")) continue;
            Map<String, List<String>> implementations = ImplementationUtil.extractOtherImplementations(attrData.get(i + 1).toString(), true);
            List<String> cfcImpls = implementations.get("cfc");
            String cfcImplementation = String.join((CharSequence)",", (Iterable<? extends CharSequence>)implementations.get("cfc"));
            String otherImplementation = String.join((CharSequence)",", implementations.entrySet().stream().filter(e -> !((String)e.getKey()).equals("cfc")).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList()));
            if (cfcImplementation.isEmpty() && cfcImpls.isEmpty()) {
                if (otherImplementation.isEmpty()) {
                    attrData.remove(i + 1);
                    attrData.remove(i);
                    i -= 2;
                    continue;
                }
                attrData.set(i, "other" + attrData.get(i));
                attrData.set(i + 1, otherImplementation);
                continue;
            }
            attrData.set(i + 1, cfcImplementation);
            if (otherImplementation.isEmpty()) continue;
            map.put((CallSite)((Object)("other" + attrData.get(i))), otherImplementation);
        }
        for (String key : map.keySet()) {
            attrData.add(key);
            attrData.add(map.get(key));
        }
    }

    private void addImplicitMethods() {
        Object implicitField = this.createField(MapClass, "_implicitMethods", 10);
        this.implementMethod(setImplicitMethods, new String[]{"implicitMethods"});
        Object methodsVar = this.findLocal("implicitMethods");
        this.load(methodsVar);
        this.putstatic(implicitField);
        this.vreturn();
        this.implementMethod(getImplicitMethods, new String[0]);
        this.getstatic(implicitField);
        this.areturn();
    }

    private void checkForRecursiveDefinition(ASTstart start, String name) {
        String extendedCFCName;
        ASTliteral extendLiteral = (ASTliteral)start.attrMap.get("Extends");
        if (extendLiteral != null && name.equalsIgnoreCase(extendedCFCName = (String)extendLiteral.tokens.get(0))) {
            throw new RecursiveDefinitionException(name);
        }
    }

    private void dumpFunctionListMetadata(ArrayList attrData) {
        Hashtable udfTable = this.tc.getUdfTable();
        Enumeration i = udfTable.elements();
        if (i.hasMoreElements()) {
            attrData.add("Functions");
            functionData = new ArrayList<StaticFieldReference>();
            while (i.hasMoreElements()) {
                ASTfunctionDefinition function = (ASTfunctionDefinition)i.nextElement();
                String className = this.tc.getClassName() + "$func" + function.getCodeGenName();
                StaticFieldReference ref = new StaticFieldReference(className, "metaData");
                ref.setType(ObjectClass);
                ref.setStartToken(function.getStartToken());
                functionData.add(ref);
            }
            attrData.add(functionData.toArray());
        } else {
            attrData.add("Functions");
            functionData = new ArrayList();
            attrData.add(functionData.toArray());
        }
        Hashtable closureTable = this.tc.getClosureTable();
        Enumeration closureEnum = closureTable.elements();
        if (closureEnum.hasMoreElements()) {
            ArrayList<StaticFieldReference> closureData = new ArrayList<StaticFieldReference>();
            while (closureEnum.hasMoreElements()) {
                ASTfunctionDefinition closure = (ASTfunctionDefinition)closureEnum.nextElement();
                if (closure.isAnonymousClosure()) continue;
                String className = this.tc.getClassName() + "$func" + closure.getCodeGenName();
                StaticFieldReference ref = new StaticFieldReference(className, "metaData");
                ref.setType(ObjectClass);
                ref.setStartToken(closure.getStartToken());
                closureData.add(ref);
            }
            if (closureData.size() > 0) {
                attrData.add("Closures");
                attrData.add(closureData.toArray());
            }
        }
    }

    private void dumpPropertyListMetadata(ArrayList attrData) {
        Map propertyTable = this.tc.getPropertyTable();
        Iterator i = propertyTable.values().iterator();
        if (i.hasNext()) {
            attrData.add("Properties");
            ArrayList<AttributeCollection> propertyList = new ArrayList<AttributeCollection>();
            while (i.hasNext()) {
                ASTcfproperty property = (ASTcfproperty)i.next();
                propertyList.add(this.propertyMetadata(property));
            }
            attrData.add(propertyList.toArray());
        } else {
            attrData.add("Properties");
            ArrayList propertyList = new ArrayList();
            attrData.add(propertyList.toArray());
        }
    }

    private void dumpDefaultExpressions() {
        Iterator propertyiterator = this.tc.getPropertyTable().values().iterator();
        boolean hasDynamicDefault = false;
        while (propertyiterator.hasNext()) {
            if (!((ASTcfproperty)propertyiterator.next()).hasDynamicDefaultExpr()) continue;
            hasDynamicDefault = true;
            break;
        }
        if (!hasDynamicDefault) {
            return;
        }
        this.implementMethod(getPropertyDefault, new String[]{"name"});
        Object lookupTableField = this.createField(FastHashtableClass, "_cf_propertyMap$internal", 26);
        Object label = this.getstatic(lookupTableField);
        Object name = this.findLocal("name");
        this.load(name);
        this.invoke(caseValue);
        Object sw = this.tableswitch();
        ASTcfproperty dummyProp = new ASTcfproperty(24);
        AtomicInteger j = new AtomicInteger(0);
        HashMap propMap = new HashMap();
        this.tc.getPropertyTable().entrySet().forEach(entry -> {
            ASTcfproperty property = (ASTcfproperty)((Map.Entry)entry).getValue();
            if (property.hasDynamicDefaultExpr()) {
                int caseVal = j.getAndIncrement();
                dummyProp.addCaseLabel(this.label(), caseVal);
                propMap.put((String)((Map.Entry)entry).getKey(), caseVal);
                ExprNode valueNode = property.getAttrNode("default");
                Node stmt = property.getNamedAttribute("DEFAULT_EXPRESSION_STMT");
                if (stmt != null) {
                    this.assembleStatement(stmt);
                }
                this.assembleExpr(valueNode);
                this.areturn();
            }
        });
        Object end = this.label();
        this.patchCases(dummyProp, sw, end);
        String oldMethod = this.setMethod("<clinit>");
        this.newinstance(SwitchTableClass);
        this.invokespecial(newSwitchTable);
        propMap.entrySet().forEach(e -> {
            this.aconst(e.getKey());
            this.aconst(e.getValue());
            this.invoke(addStringCase);
        });
        this.putstatic(lookupTableField);
        this.setMethod(oldMethod);
        this.aconst(null);
        this.mreturn(getPropertyDefault.getReturnType());
    }

    private AttributeCollection propertyMetadata(ASTcfproperty cfproperty) {
        ArrayList propertyData = this.beginAttrMetadata(cfproperty.attrList, cfproperty);
        if (propertyData.size() % 2 != 0) {
            throw new PropertyExpressionException();
        }
        return new AttributeCollection(propertyData.toArray());
    }

    @Override
    Object get(ASTsimpleVariableReference var) {
        if (var.referenceNeedsSymTabSupport(this)) {
            if (var.isStatic() || var.isStaticAccessor()) {
                Object label = this.load(this.pageVar);
                this.resolveStatic(var, null);
                if (var.isLeafReference) {
                    this.callAutoscalarizeVar(var);
                } else {
                    this.callAutoscalarizeVarNonLeafRef(var);
                }
                return label;
            }
            return super.get(var);
        }
        if (var.isLeafReference) {
            Object varField = this.findField(var.getCodegenVariableName());
            Object label = this.load(this.pageVar);
            if (!this.resolveStatic(var, varField)) {
                this.load(this.pageVar);
                this.getfield(varField);
            }
            this.callAutoscalarizeVar(var);
            return label;
        }
        if (this.isIncrDecrOperand(var) != -1) {
            throw new OperationNotSupportedException(var.getStartToken());
        }
        Object varField = this.findField(var.getCodegenVariableName());
        Object label = this.load(this.pageVar);
        if (!this.resolveStatic(var, varField)) {
            this.load(this.pageVar);
            this.getfield(varField);
        }
        this.callAutoscalarizeVarNonLeafRef(var);
        return label;
    }

    private boolean resolveStatic(ASTsimpleVariableReference var, Object varField) {
        if (var.isStaticAccessor()) {
            this.resolveStaticAccessorVariable(var);
        } else if (var.isStatic()) {
            this.load(this.pageVar);
            this.getstatic(this.findField(this.getStaticScopeVarName()));
            if (varField != null) {
                this.getstatic(varField);
            } else {
                this.aconst(var.getCodegenVariableName());
            }
            if (var.getFunctionDef() != null && var.isLval()) {
                this.aconst(var.getAccessModifier());
                this.invoke(_declareStaticVariable);
            } else {
                this.aconst(null);
                this.invoke(_resolveStaticVariable);
            }
        } else {
            return false;
        }
        return true;
    }

    private void callAutoscalarizeVarNonLeafRef(ASTsimpleVariableReference var) {
        if (var.isSafePreHook()) {
            this.zconst(true);
            this.invoke(getVarSafe);
        } else {
            this.invoke(getVar);
        }
    }

    private void callAutoscalarizeVar(ASTsimpleVariableReference var) {
        int incrDecrOp = this.isIncrDecrOperand(var);
        if (this.isIncrDecrOperand(var) != -1) {
            this.iconst(incrDecrOp);
            this.invoke(getScalarVarIncrDecr);
        } else {
            this.invoke(this.isSafeOperator ? _getScalarVar : getScalarVar);
        }
    }

    @Override
    Method simpleref(ASTsimpleVariableReference ref, Method stringMethod, Method varMethod) {
        if (ref.referenceNeedsSymTabSupport(this)) {
            if (ref.isStaticAccessor()) {
                this.resolveStaticAccessorVariable(ref);
                return varMethod;
            }
            if (ref.isStatic()) {
                if (!ASTsimpleVariableReference.isBuiltinScopeName(ref.getCodegenVariableName())) {
                    this.load(this.pageVar);
                    this.getstatic(this.findField(this.getStaticScopeVarName()));
                    this.aconst(ref.getCodegenVariableName());
                    if (ref.getFunctionDef() != null && ref.isLval()) {
                        this.aconst(ref.getAccessModifier());
                        this.invoke(_declareStaticVariable);
                    } else {
                        this.aconst(null);
                        this.invoke(_resolveStaticVariable);
                    }
                    return varMethod;
                }
            }
            return super.simpleref(ref, stringMethod, varMethod);
        }
        String fieldName = ref.getCodegenVariableName();
        Object field = this.findField(fieldName);
        if (ref.isStaticAccessor()) {
            this.resolveStaticAccessorVariable(ref);
        } else if (ref.isStatic()) {
            this.getstatic(field);
        } else {
            this.load(this.pageVar);
            this.getfield(field);
        }
        return varMethod;
    }

    private Object resolveStaticAccessorVariable(ASTsimpleVariableReference ref) {
        Object label = this.load(this.pageVar);
        this.aconst(ref.getAccessorReference());
        this.aconst(ref.getCodegenVariableName());
        this.aconst(null);
        this.invoke(_resolveStaticAccessorVariable);
        return label;
    }

    @Override
    Object assignVar(ASTsimpleVariableReference var, ExprNode rval) {
        boolean isStatic = var.isStatic();
        if (this.tc.staticSupport() && var.getCodegenVariableName().equalsIgnoreCase("static")) {
            throw new CFMLParserBase.StaticKeywordAssignmentException(var.getStartToken());
        }
        if (var.referenceNeedsSymTabSupport(this)) {
            return super.assignVar(var, rval);
        }
        Object varField = this.findField(var.getCodegenVariableName());
        Object label = null;
        if (!isStatic) {
            label = this.load(this.pageVar);
            this.getfield(varField);
        } else {
            label = var.isStaticAccessor() ? this.resolveStaticAccessorVariable(var) : this.getstatic(varField);
        }
        if (this.isCFArrayMethodCall(rval)) {
            this.cast(rval, CFArrayClass);
            this.invokeVoid(setArrayVar);
        } else {
            Method methodToInvoke = this.generateSetVarCode(rval);
            this.invokeVoid(methodToInvoke);
        }
        return label;
    }

    private boolean isCFArrayMethodCall(ExprNode rval) {
        Node node;
        Node[] nodes;
        if (rval instanceof ASToperator && (nodes = ((ASToperator)rval).children) != null && nodes.length > 0 && (node = nodes[0]) instanceof ASTruntimeCall) {
            ASTruntimeCall astRuntimeCall = (ASTruntimeCall)node;
            ASTfuncparams funcParam = astRuntimeCall.arguments;
            String functionName = funcParam.getFunctionName();
            if (functionName != null && cfArrayMethods.contains(functionName = functionName.toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    static {
        cfArrayMethods.add("arraynew");
        cfArrayMethods.add("listtoarray");
        cfArrayMethods.add("structfindkey");
        cfArrayMethods.add("structfindvalue");
        cfArrayMethods.add("structkeyarray");
        cfArrayMethods.add("structsort");
    }

    public static class PropertyExpressionException
    extends ParseException {
    }
}

