/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.bytecode.JavaAssembler;
import coldfusion.compiler.ASTDestructring;
import coldfusion.compiler.ASTcfswitch;
import coldfusion.compiler.ASTcftry;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.Node;
import coldfusion.compiler.TreeTransformer;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import java.lang.reflect.Method;

final class TemplateOptimizer
implements TreeTransformer {
    static final Method compareD2O = JavaAssembler.getStaticMethod(CfJspPage.class, "_compare", new Class[]{Double.TYPE, Object.class});
    static final Method compareO2D = JavaAssembler.getStaticMethod(CfJspPage.class, "_compare", new Class[]{Object.class, Double.TYPE});
    static final Method compareS2O = JavaAssembler.getStaticMethod(CfJspPage.class, "_compare", new Class[]{String.class, Object.class});
    static final Method compareO2S = JavaAssembler.getStaticMethod(CfJspPage.class, "_compare", new Class[]{Object.class, String.class});
    static final int literalLimit = 16383;

    TemplateOptimizer() {
    }

    @Override
    public Node preTransform(Node n) {
        return n;
    }

    @Override
    public Node transform(Node n) {
        switch (n.id) {
            case 202: {
                n = this.flatten((ExprNode)n);
            }
            case 200: 
            case 201: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 224: 
            case 225: 
            case 226: 
            case 237: 
            case 238: 
            case 10001: {
                n = this.fold((ExprNode)n);
                break;
            }
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 235: 
            case 236: 
            case 239: 
            case 240: {
                n = this.fold((ExprNode)n);
                if (n.id == 27 || n.id == 239 || n.id == 240) break;
                this.transformCompare((ASToperator)n);
                break;
            }
            case 10002: {
                ASTsimpleVariableReference varRef = (ASTsimpleVariableReference)n;
                n = this.variable(varRef);
                break;
            }
            case 0: {
                n = this.pcdata((ASTpcdata)n);
                break;
            }
            case 4: {
                n = this.cfscript(n);
                break;
            }
            case 12: {
                n = this.cftry((ASTcftry)n);
                break;
            }
            case 17: {
                n = this.cfswitch((ASTcfswitch)n);
            }
            case 2: {
                if (!(n instanceof ASTDestructring)) break;
                ((ASTDestructring)n).optimize();
            }
        }
        return n;
    }

    private void transformCompare(ASToperator op) {
        ASTruntimeCall lhs;
        int childindex;
        if (op.subexpr((int)0).id == 27 && !(((ASTliteral)op.subexpr((int)0)).tokens.elementAt(0) instanceof ExprNode)) {
            childindex = 0;
        } else if (op.subexpr((int)1).id == 27 && !(((ASTliteral)op.subexpr((int)1)).tokens.elementAt(0) instanceof ExprNode)) {
            childindex = 1;
        } else {
            return;
        }
        ASTliteral child = (ASTliteral)op.subexpr(childindex);
        if (child.getType() == String.class) {
            String s = (String)child.tokens.get(0);
            try {
                double d = Cast._double(s);
                child.tokens.set(0, new Double(d));
                child.setType(Double.TYPE);
                lhs = new ASTruntimeCall(op.jjtGetParent(), childindex == 0 ? compareD2O : compareO2D, op.children);
            }
            catch (Exception ex) {
                lhs = new ASTruntimeCall(op.jjtGetParent(), childindex == 0 ? compareS2O : compareO2S, op.children);
            }
        } else {
            lhs = new ASTruntimeCall((Node)op, childindex == 0 ? compareD2O : compareO2D, op.children);
        }
        op.jjtAddChild(lhs, 0);
        op.jjtAddChild(new ASTliteral(new Double(0.0), op), 1);
    }

    private Node fold(ExprNode n) {
        int count = n.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            if (n.jjtGetChild((int)i).id == 27) continue;
            return n;
        }
        Class type = n.getType();
        if (type != null && type != Long.TYPE && (type.isPrimitive() || type == String.class)) {
            try {
                Object value = EvaluateEngine.evaluateNode(n);
                if (value instanceof String && ((String)value).length() > 16383) {
                    return n;
                }
                ASTliteral literal = new ASTliteral(value, n.jjtGetParent());
                literal.setStartToken(n.getStartToken());
                try {
                    if (n.getEndToken() != null) {
                        literal.setEndToken(n.getEndToken());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n.isSpreadOperationType()) {
                    literal.setSpreadOperation(true);
                }
                return literal;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private ExprNode variable(ASTsimpleVariableReference var) {
        var.declareVariable(var.getCodegenVariableName(), var.isFinalVariable());
        return var;
    }

    private ExprNode flatten(ExprNode node) {
        int count = 0;
        for (int i = 0; i < node.children.length; ++i) {
            if (node.children[i].id == node.id) {
                count += node.children[i].children.length;
                continue;
            }
            ++count;
        }
        Node[] children = node.children;
        node.children = null;
        for (int i = children.length - 1; i >= 0; --i) {
            if (children[i].id == node.id) {
                for (int j = children[i].children.length - 1; j >= 0; --j) {
                    Node child = children[i].children[j];
                    node.jjtAddChild(child, --count);
                    child.jjtSetParent(node);
                }
                continue;
            }
            Node child = children[i];
            node.jjtAddChild(child, --count);
            child.jjtSetParent(node);
        }
        return node;
    }

    Node pcdata(ASTpcdata pcdata) {
        int wsSetting = pcdata.getWhitespaceManagementSetting();
        if (pcdata.checkForSilentTag(wsSetting) == 2) {
            return null;
        }
        return pcdata;
    }

    Node cftry(ASTcftry cftry) {
        if (cftry.isEmptyTry()) {
            return null;
        }
        return cftry;
    }

    Node cfswitch(ASTcfswitch cfswitch) {
        if (cfswitch.children == null) {
            return null;
        }
        return cfswitch;
    }

    Node cfscript(Node cfscript) {
        if (cfscript.jjtGetParent() instanceof ASTcftry) {
            ASTcftry tryNode = (ASTcftry)cfscript.jjtGetParent();
            if (tryNode.finallyStmt != null) {
                return cfscript;
            }
        }
        if (cfscript.jjtGetNumChildren() == 0) {
            return null;
        }
        return cfscript;
    }
}

