/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ParseException;

public class TokenMgrError
extends ParseException {
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    public int errorCode;
    public int lexState;
    public int errorLine;
    public int errorColumn;
    public String errorAfter;
    public char curChar;
    public boolean EOFSeen;

    public TokenMgrError(String message, int reason) {
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, int curChar, int reason) {
        this.EOFSeen = EOFSeen;
        this.lexState = lexState;
        this.errorLine = errorLine;
        this.errorColumn = errorColumn;
        this.errorAfter = errorAfter;
        this.curChar = (char)curChar;
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        this.EOFSeen = EOFSeen;
        this.lexState = lexState;
        this.errorLine = errorLine;
        this.errorColumn = errorColumn;
        this.errorAfter = errorAfter;
        this.curChar = curChar;
        this.errorCode = reason;
    }

    public String getErrorText() {
        switch (this.curChar) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case ' ': {
                return "&nbsp";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return String.valueOf(this.curChar);
    }

    @Override
    public int getLine() {
        return this.errorLine;
    }

    @Override
    public int getColumn() {
        return this.errorColumn;
    }

    public int getLexstate() {
        return this.lexState;
    }

    public static String addEscapes(String s) {
        StringBuffer result = new StringBuffer(s.length() + 4);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isISOControl(c) || c > '\u007f') {
                result.append(Integer.toHexString(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

