/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler;

import coldfusion.compiler.ASTArrayDestructuring;
import coldfusion.compiler.ASTDestructring;
import coldfusion.compiler.ASTObjectDestructuring;
import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.ExprVisitor;
import coldfusion.compiler.NamedAttributeNode;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.SliceMetadataNode;
import coldfusion.compiler.TemplateOptimizer;
import coldfusion.compiler.TreeTransformer;
import coldfusion.compiler.cfml40TreeConstants;
import coldfusion.server.ServiceFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Treewalker
implements cfml40TreeConstants {
    public static Node postorder(Node n, TreeTransformer analyzer) {
        int i;
        if (n == null) {
            return null;
        }
        n = analyzer.preTransform(n);
        int j = 0;
        for (i = 0; n.children != null && i < n.children.length; ++i) {
            Node newNode = Treewalker.postorder(n.children[i], analyzer);
            if (newNode == null) continue;
            if (n.insertedNodeCount > 0) {
                i += n.insertedNodeCount;
                j += n.insertedNodeCount;
                n.insertedNodeCount = 0;
            }
            if (j < n.children.length && !n.children[j].insertedNode) {
                n.children[j] = newNode;
                if (i > j && analyzer instanceof TemplateOptimizer) {
                    n.children[j].insertedNode = false;
                }
            }
            ++j;
        }
        if (j < i) {
            if (j == 0) {
                n.children = null;
            } else {
                Node[] newChildren = new Node[j];
                System.arraycopy(n.children, 0, newChildren, 0, j);
                n.children = newChildren;
            }
        }
        if (n instanceof ExprNode && ((ExprNode)n).getExprInitializer() != null && analyzer instanceof ExprVisitor) {
            ((ExprNode)n).setExprInitializerNode(Treewalker.postorder(((ExprNode)n).getExprInitializer(), analyzer));
        }
        if (n instanceof ASTruntimeCall && ((ASTruntimeCall)n).getFuncName() != null && analyzer instanceof TemplateOptimizer) {
            Treewalker.postorder(((ASTruntimeCall)n).getFuncName(), analyzer);
        }
        if (analyzer instanceof ExprVisitor && n instanceof ASTDestructring) {
            List<Object> elements = new ArrayList();
            if (n instanceof ASTArrayDestructuring) {
                elements = ((ASTArrayDestructuring)n).getElements();
            } else if (n instanceof ASTObjectDestructuring) {
                elements = ((ASTObjectDestructuring)n).getElements();
            }
            for (int index = 0; index < elements.size(); ++index) {
                ASTDestructring.AssignmentElement element = (ASTDestructring.AssignmentElement)elements.get(index);
                Treewalker.postorder(element.value, analyzer);
                Treewalker.postorder(element.defaultValueInitializerStmt, analyzer);
                Treewalker.postorder(element.defaultValue, analyzer);
            }
        }
        if (n instanceof NamedAttributeNode) {
            Node nAttrNode = n;
            Enumeration attrNames = nAttrNode.getAttrNames();
            while (attrNames != null && attrNames.hasMoreElements()) {
                try {
                    Node newAttr;
                    String key = attrNames.nextElement().toString();
                    Node oldAttr = nAttrNode.getNamedAttribute(key);
                    if (analyzer instanceof ExprVisitor && key.equalsIgnoreCase("RVAL") && oldAttr instanceof ASTruntimeCall) {
                        ASTruntimeCall call = (ASTruntimeCall)oldAttr;
                        String queryName = "";
                        if (oldAttr.getStartToken().image.equalsIgnoreCase("queryexecute") && nAttrNode.getNamedAttribute("LVAL") != null) {
                            queryName = nAttrNode.getNamedAttribute("LVAL") instanceof ASTstructureReference || nAttrNode.getNamedAttribute("LVAL") instanceof ASTarrayReference ? nAttrNode.getNamedAttribute((String)"LVAL").getStartToken().image : ((ASTsimpleVariableReference)nAttrNode.getNamedAttribute("LVAL")).getVariableName();
                            int position = ((ASTruntimeCall)n.getNamedAttribute((String)"RVAL")).getParameters().children.length;
                            ((ASTruntimeCall)n.getNamedAttribute("RVAL")).getParameters().jjtAddChild(new ASTliteral(queryName), position);
                        }
                    }
                    if (oldAttr == null || (newAttr = Treewalker.postorder(oldAttr, analyzer)) != null && newAttr.equals(oldAttr)) continue;
                    nAttrNode.setNamedAttribute(key, newAttr);
                }
                catch (ServiceFactory.ModuleNotAvailableException mnae) {
                    throw mnae;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw ParseException.wrap(ex, n);
                }
            }
            if (nAttrNode instanceof SliceMetadataNode) {
                ExprNode startIndex = ((SliceMetadataNode)nAttrNode).getStartIndex();
                ExprNode endIndex = ((SliceMetadataNode)nAttrNode).getEndIndex();
                ExprNode step = ((SliceMetadataNode)nAttrNode).getStep();
                if (startIndex != null) {
                    if (analyzer instanceof TemplateOptimizer) {
                        Treewalker.postorder(startIndex, analyzer);
                    }
                    if (analyzer instanceof ExprVisitor) {
                        analyzer.transform(startIndex);
                        Treewalker.postorder(startIndex, analyzer);
                    }
                }
                if (endIndex != null) {
                    if (analyzer instanceof TemplateOptimizer) {
                        Treewalker.postorder(endIndex, analyzer);
                    }
                    if (analyzer instanceof ExprVisitor) {
                        analyzer.transform(endIndex);
                        Treewalker.postorder(endIndex, analyzer);
                    }
                }
                if (step != null) {
                    if (analyzer instanceof TemplateOptimizer) {
                        Treewalker.postorder(step, analyzer);
                    }
                    if (analyzer instanceof ExprVisitor) {
                        analyzer.transform(step);
                        Treewalker.postorder(step, analyzer);
                    }
                }
            }
        }
        return analyzer.transform(n);
    }
}

