/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler.validation;

import coldfusion.compiler.ASTcffunction;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.TagsAsFunctions;
import coldfusion.compiler.validation.CFMLValidationException;
import coldfusion.compiler.validation.FunctionValidationException;
import coldfusion.compiler.validation.FunctionValidator;
import coldfusion.compiler.validation.UnsupportedFeatureException;
import coldfusion.compiler.validation.ValidationResultCollector;
import coldfusion.runtime.Closure;
import coldfusion.tagext.validation.CFMLTagLibrary;
import coldfusion.tagext.validation.CFMLTagValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CFMLCodeValidator
extends JJTreeVisitor
implements ValidationResultCollector {
    protected CFMLTagValidator _tagValidator;
    protected FunctionValidator _funcValidator;
    protected String _tagName;
    protected String _funcName;
    protected TagNode _tagNode;
    protected static Set unsupportedTag;
    protected static Set unsupportedFunc;
    public static final String ARGUMENTS = "attributecollection";
    public static final String CFMODULE = "CFMODULE";
    private static final Class closure_clazz;
    private ValidationResultCollector _collector;

    public CFMLCodeValidator() {
        this._collector = this;
    }

    public CFMLCodeValidator(ValidationResultCollector collector) {
        this._collector = collector;
    }

    @Override
    public void visit(ASTstart root) {
        this.newPage();
        this._collector.reset();
    }

    @Override
    public void visit(TagNode tagNode) {
        if (this.newTag(tagNode)) {
            try {
                this._tagValidator.validateTagContext(tagNode, this._collector);
                if (!tagNode.containsArgumentsAttr() || tagNode.getTagName().equalsIgnoreCase("cfloop")) {
                    this._tagValidator.validateAttrConfiguration(tagNode, this._collector, false);
                    this._tagValidator.validateAttrConstraint(tagNode, this._collector);
                } else {
                    this._tagValidator.validateArgumentAttributeContraint(tagNode, this._collector);
                }
            }
            catch (ParseException pex) {
                throw tagNode.setStartLocation(pex);
            }
        }
    }

    @Override
    public void visit(ASTruntimeCall function) {
        String funcName = function.getFunctionName();
        if (unsupportedFunc.contains(funcName.toUpperCase())) {
            UnsupportedFeatureException error = new UnsupportedFeatureException("Function", funcName);
            error.setLineNumbers(function);
            this._collector.collectValidationResult(error);
        }
        if (!function.isVariadic() && function.isBuiltin()) {
            this._funcName = funcName;
            int argCount = function.getParameters().getParamCount();
            try {
                if (!TagsAsFunctions.isTagAsFunction(funcName) && !funcName.equalsIgnoreCase("isNull")) {
                    if (funcName != null && funcName.equalsIgnoreCase("arraynew") && argCount == 3) {
                        function.setFunctionName("__ArrayImpl");
                        return;
                    }
                    this._funcValidator = FunctionValidator.create(funcName);
                    this._funcValidator.checkFuncExists();
                    if (!function.isNew()) {
                        this._funcValidator.checkArgCount(argCount, function.isRuntimeEvaluate());
                    }
                }
            }
            catch (CFMLValidationException ex) {
                ex.setLineNumbers(function);
                this._collector.collectValidationResult(ex);
            }
        }
    }

    @Override
    public void visit(ASTfuncparams params) {
        ASTruntimeCall function = params.getFunction();
        if (function == null || !function.isBuiltin() || function.isVariadic() || function.isNew()) {
            return;
        }
        int paramCount = params.getParamCount();
        String funcName = params.getFunctionName().toLowerCase();
        if (funcName.equals("throw") || funcName.equals("writedump") || funcName.equals("writelog")) {
            throw new InBuiltFunctionInvalidParamterException(funcName);
        }
        for (int i = 0; i < paramCount; ++i) {
            String value;
            if (params.jjtGetChild(i) instanceof ASTtagAttribute) continue;
            if (params.jjtGetChild(i) instanceof ASTcffunction) {
                try {
                    this._funcValidator.checkArgument(paramCount, i + 1, closure_clazz);
                }
                catch (CFMLValidationException ex) {
                    ex.setLineNumbers(params);
                    this._collector.collectValidationResult(ex);
                }
                continue;
            }
            ExprNode simple = (ExprNode)params.jjtGetChild(i);
            try {
                value = EvaluateEngine._String(simple);
            }
            catch (Exception ex) {
                continue;
            }
            try {
                if (!funcName.equalsIgnoreCase(this._funcName) || this._funcValidator == null || params.getFunction().isNew() || TagsAsFunctions.isTagAsFunction(funcName) || funcName.equalsIgnoreCase("isNull")) continue;
                this._funcValidator.checkArgument(paramCount, i + 1, value);
                continue;
            }
            catch (CFMLValidationException ex) {
                ex.setLineNumbers(params);
                this._collector.collectValidationResult(ex);
            }
        }
    }

    private void newPage() {
        this._tagNode = null;
        this._tagName = null;
        this._funcValidator = null;
        this._funcName = null;
    }

    private boolean newTag(TagNode tagNode) {
        String tagName = tagNode.getTagName();
        if (tagName == null) {
            return false;
        }
        if (unsupportedTag.contains(tagName.toUpperCase())) {
            UnsupportedFeatureException error = new UnsupportedFeatureException("Tag", tagName);
            error.setLineNumbers(tagNode);
            this._collector.collectValidationResult(error);
            return false;
        }
        this._tagValidator = CFMLTagLibrary.lookup(tagName);
        if (this._tagValidator == null) {
            return false;
        }
        this._tagName = tagName;
        this._tagNode = tagNode;
        return true;
    }

    @Override
    public void collectValidationResult(CFMLValidationException error) {
        throw error;
    }

    @Override
    public void reset() {
    }

    @Override
    public Collection getValidationResult() {
        return new ArrayList();
    }

    static {
        closure_clazz = Closure.class;
        unsupportedTag = new HashSet(8);
        unsupportedTag.add("CFAUTHENTICATE");
        unsupportedTag.add("CFIMPERSONATE");
        unsupportedTag.add("CFINTERNALDEBUG");
        unsupportedTag.add("CFNEWINTERNALADMINSECURITY");
        unsupportedTag.add("CFNEWINTERNALREGISTRY");
        unsupportedTag.add("CFADMIN_REGISTRY_SET");
        unsupportedTag.add("CFADMIN_REGISTRY_DELETE");
        unsupportedFunc = new HashSet(19);
        unsupportedFunc.add("CF_SETDATASOURCEUSERNAME");
        unsupportedFunc.add("CF_SETDATASOURCEPASSWORD");
        unsupportedFunc.add("CF_ISCOLDFUSIONDATASOURCE");
        unsupportedFunc.add("CF_GETDATASOURCEUSERNAME");
        unsupportedFunc.add("CFUSION_VERIFYMAIL");
        unsupportedFunc.add("CFUSION_GETODBCINI");
        unsupportedFunc.add("CFUSION_SETODBCINI");
        unsupportedFunc.add("CFUSION_GETODBCDSN");
        unsupportedFunc.add("CFUSION_SETTINGS_REFRESH");
        unsupportedFunc.add("CFUSION_DBCONNECTIONS_FLUSH");
    }

    public class InBuiltFunctionInvalidParamterException
    extends FunctionValidationException {
        public InBuiltFunctionInvalidParamterException(String function) {
            this.functionName = function.toUpperCase();
        }
    }
}

