/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler.validation;

import coldfusion.log.CFLogs;
import coldfusion.server.CFService;
import coldfusion.server.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CfPathValidator {
    private static final String PATH_FILTER_FILE = CFService.getLibPath() + File.separator + "pathfilter.txt";
    private static String DEFAULT_ALLOWED_PATHS = "";
    private static List<Function<String, Status>> filters = new ArrayList<Function<String, Status>>();
    private static String pathFilterInputs = "";

    private static String getDefaultAllowedPaths() {
        if (DEFAULT_ALLOWED_PATHS.isEmpty()) {
            String webinf = ServiceFactory.getRuntimeService().getWEBINF();
            String cfide = ServiceFactory.getRuntimeService().getCFIDE();
            String cfideLowercase = cfide.replace("CFIDE", "cfide");
            String cfideUppercase = cfide.replace("cfide", "CFIDE");
            DEFAULT_ALLOWED_PATHS = Paths.get(cfideUppercase, new String[0]).normalize() + File.separator + "**;" + Paths.get(webinf, new String[0]).normalize() + File.separator + "**;" + Paths.get(cfideLowercase, new String[0]).normalize() + File.separator + "**;";
        }
        return DEFAULT_ALLOWED_PATHS;
    }

    public static boolean validatePath(String filePath, boolean logOnFailure) {
        Status status;
        if (pathFilterInputs.isEmpty()) {
            pathFilterInputs = CfPathValidator.loadPathFilter() + ";";
        }
        if (filters.isEmpty()) {
            CfPathValidator.createFilters(pathFilterInputs);
        }
        if ((status = CfPathValidator.checkInput(filePath)) == Status.REJECTED && logOnFailure) {
            CFLogs.SERVER_LOG.debug("File is not allowed in pathfilter" + filePath);
        }
        return status == Status.ALLOWED;
    }

    private static boolean createFilters(String filterString) {
        String[] filterArray;
        filters.clear();
        for (String filter : filterArray = filterString.split(";")) {
            if ((filter = filter.trim()).isEmpty()) continue;
            boolean isBlacklist = filter.startsWith("!");
            String filterPath = isBlacklist ? filter.substring(1) : filter;
            String linuxPath = filterPath.replaceAll("\\\\", "\\/");
            String windowsPath = filterPath.replaceAll("\\/", "\\\\");
            if (isBlacklist) {
                filters.add(path -> CfPathValidator.matchesFilter(path, linuxPath) ? Status.REJECTED : Status.UNDECIDED);
                filters.add(path -> CfPathValidator.matchesFilter(path, windowsPath) ? Status.REJECTED : Status.UNDECIDED);
                continue;
            }
            filters.add(path -> CfPathValidator.matchesFilter(path, linuxPath) ? Status.ALLOWED : Status.UNDECIDED);
            filters.add(path -> CfPathValidator.matchesFilter(path, windowsPath) ? Status.ALLOWED : Status.UNDECIDED);
        }
        return true;
    }

    public static boolean matchesFilter(String path, String filterPath) {
        Path normalizedPath = Paths.get(path, new String[0]).normalize();
        String regex = filterPath.replace("\\", "\\\\").replace(".", "\\.");
        String placeholder = "__DOUBLE_STAR__";
        String tempFilter = regex.replace("**", placeholder);
        tempFilter = tempFilter.replace("*", "[^/]+");
        regex = tempFilter.replace(placeholder, ".*");
        return normalizedPath.toString().matches("^" + regex + "$");
    }

    private static Status checkInput(String filePath) {
        Optional<Status> statusOfFilter = filters.stream().map(packageName -> (Status)((Object)((Object)packageName.apply(filePath)))).filter(packageName -> packageName != Status.UNDECIDED).findFirst();
        return statusOfFilter.orElse(Status.REJECTED);
    }

    private static String loadPathFilter() {
        File file = new File(PATH_FILTER_FILE);
        String pathsFromFile = "";
        if (!file.exists() || file.isDirectory()) {
            return CfPathValidator.getDefaultAllowedPaths();
        }
        try {
            pathsFromFile = Files.readAllLines(file.toPath()).stream().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).collect(Collectors.joining(";"));
            return CfPathValidator.getDefaultAllowedPaths() + pathsFromFile;
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error("Error reading path filter file: " + e.getMessage());
            return "";
        }
    }

    public static enum Status {
        UNDECIDED,
        ALLOWED,
        REJECTED;

    }
}

