/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.compiler.validation;

import coldfusion.compiler.MethodArgumentMismatchException;
import coldfusion.compiler.validation.CFFuncParamInfo;
import coldfusion.compiler.validation.FunctionArgMismatchException;
import coldfusion.compiler.validation.FunctionArgMismatchExceptionVariadic;
import coldfusion.compiler.validation.FunctionNotFoundException;
import coldfusion.compiler.validation.IllegalFuncArgumentException;
import coldfusion.compiler.validation.IllegalFuncArgumentTypeException;
import coldfusion.compiler.validation.OptionalArgMismatchException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Closure;
import coldfusion.runtime.UDFMethod;
import coldfusion.util.FastHashtable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FunctionValidator {
    private CFFuncParamInfo paramInfo;
    private FastHashtable metaInfo;
    private String funcName;
    private static final Class closure_clazz = Closure.class;
    private static final Map functionTable = new HashMap();

    public static FunctionValidator create(String funcName) {
        return (FunctionValidator)functionTable.get(funcName.toUpperCase());
    }

    private FunctionValidator() {
    }

    public void checkFuncExists() {
        if (this.paramInfo == null) {
            throw new FunctionNotFoundException(this.funcName);
        }
    }

    public void checkArgCount(int argCount, boolean isVariadic) {
        int newArgCount;
        if (this.funcName != null && this.funcName.equalsIgnoreCase("RunAsync") && argCount > 0 && this.metaInfo.get(this.funcName + (newArgCount = argCount + 1)) != null) {
            return;
        }
        if (this.metaInfo.get(this.funcName + argCount) == null) {
            if (isVariadic) {
                throw new FunctionArgMismatchExceptionVariadic(this.funcName);
            }
            if (!this.paramInfo.isOverLoaded()) {
                throw new FunctionArgMismatchException(this.funcName, this.paramInfo.getMaxParamCount());
            }
            throw new OptionalArgMismatchException(this.funcName, this.paramInfo.getMinParamCount(), this.paramInfo.getMaxParamCount());
        }
    }

    public void checkArgument(int argCount, int argIndex, Object argValue) {
        if (this.funcName != null && this.funcName.equalsIgnoreCase("RunAsync") && argCount >= 3) {
            throw new MethodArgumentMismatchException(this.funcName, 2, argCount);
        }
        Class[] paramTypes = (Class[])this.metaInfo.get(this.funcName + argCount);
        if (paramTypes == null) {
            return;
        }
        Class reqType = paramTypes[argIndex - 1];
        if (reqType == Object.class || reqType == String.class || argValue.getClass().isAssignableFrom(reqType)) {
            return;
        }
        if (reqType == UDFMethod.class) {
            return;
        }
        String coldFusionType = "";
        if (reqType == List.class) {
            coldFusionType = "[Array]";
        } else if (reqType == Map.class) {
            coldFusionType = "[Struct]";
        }
        try {
            Cast._cast(argValue, reqType);
        }
        catch (Exception ex) {
            if (coldFusionType.isEmpty()) {
                throw new IllegalFuncArgumentException(this.funcName, argValue.toString(), argIndex, reqType);
            }
            throw new IllegalFuncArgumentTypeException(this.funcName, argValue.toString(), argIndex, coldFusionType);
        }
    }

    static {
        try {
            Method[] methods = CFPage.class.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String methodName = methods[i].getName().toUpperCase();
                int paramCount = methods[i].getParameterTypes().length;
                FunctionValidator validator = (FunctionValidator)functionTable.get(methodName);
                if (validator == null) {
                    validator = new FunctionValidator();
                    validator.funcName = methodName;
                    validator.metaInfo = new FastHashtable();
                    functionTable.put(methodName, validator);
                }
                if (validator.paramInfo == null) {
                    validator.paramInfo = new CFFuncParamInfo(paramCount);
                } else {
                    validator.paramInfo.registerParamCount(paramCount);
                    validator.paramInfo.setOverLoaded(true);
                }
                validator.metaInfo.put(methodName + paramCount, (Object)methods[i].getParameterTypes());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

