/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CFThreadPoolExecutor
extends ThreadPoolExecutor {
    private CFThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    private CFThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public static ThreadPoolExecutor get(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        CFTaskQueue<Runnable> queue = new CFTaskQueue<Runnable>();
        CFThreadPoolExecutor executor = new CFThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, threadFactory);
        queue.executor = executor;
        executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        });
        return executor;
    }

    private static class CFTaskQueue<Runnable>
    extends LinkedBlockingQueue<Runnable> {
        public ThreadPoolExecutor executor;

        private CFTaskQueue() {
        }

        @Override
        public boolean offer(Runnable e) {
            int currentPoolSize = this.executor.getPoolSize();
            int maximumPoolSize = this.executor.getMaximumPoolSize();
            int activeThreads = this.executor.getActiveCount();
            if (currentPoolSize < maximumPoolSize && activeThreads == currentPoolSize) {
                return false;
            }
            return super.offer(e);
        }
    }
}

