/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway;

import coldfusion.CfmServlet;
import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.cfc.DummyHttpServletResponse;
import coldfusion.eventgateway.EventContext;
import coldfusion.filter.ApplicationFilter;
import coldfusion.filter.ClientScopePersistenceFilter;
import coldfusion.filter.DatasourceFilter;
import coldfusion.filter.EventComponentFilter;
import coldfusion.filter.EventRequestMonitorFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.GlobalsFilter;
import coldfusion.filter.MonitoringFilter;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.runtime.RequestLifecycleListener;
import coldfusion.xml.rpc.CFCServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import java.io.ByteArrayOutputStream;

public class EventProxy {
    public void invokeComponent(EventContext eventContext) throws Throwable {
        this.invokeComponent(eventContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeComponent(EventContext eventContext, boolean eventGatewayCall) throws Throwable {
        if (eventGatewayCall) {
            RequestMonitorEventProcessor.setRequestFunctionName(eventContext.cfcMethod);
        }
        FusionContext fusionContext = EventProxy.getFusionContext(eventContext);
        FusionContext oldFusionContext = FusionContext.setCurrent(fusionContext);
        fusionContext.setEventContext(eventContext);
        FusionFilter filterChain = this.getComponentFilterChain(eventContext);
        try {
            filterChain.invoke(fusionContext);
        }
        finally {
            FusionContext.setCurrent(oldFusionContext);
            RequestLifecycleListener.onRequestEnd(3, null);
        }
    }

    private FusionFilter getComponentFilterChain(EventContext eventContext) {
        FusionFilter filter = new EventComponentFilter(eventContext);
        filter = new ApplicationFilter(filter);
        if (EventRequestMonitorFilter.isFilterEnabled()) {
            filter = new EventRequestMonitorFilter(filter, eventContext);
        }
        filter = new MonitoringFilter(filter, "EVENT GATEWAY REQUEST");
        filter = new ClientScopePersistenceFilter(filter);
        boolean needsFormScope = false;
        filter = new GlobalsFilter(filter, false);
        filter = new DatasourceFilter(filter);
        return filter;
    }

    private static FusionContext getFusionContext(EventContext eventContext) {
        FusionContext fusionContext = FusionContext.getCurrent();
        DummyHttpServletRequest req = null;
        DummyHttpServletResponse resp = null;
        if (fusionContext == null) {
            HttpServlet servlet;
            fusionContext = new FusionContext();
            fusionContext.setUseMappings(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (req == null) {
                req = new DummyHttpServletRequest(eventContext.cfcPath);
            }
            if (baos != null || resp == null) {
                resp = new DummyHttpServletResponse(baos);
            }
            if ((servlet = CFCServlet.getCFCServlet()) == null) {
                servlet = CfmServlet.getCfmServlet();
            }
            fusionContext.setServletObjects((Servlet)servlet, (ServletRequest)req, (ServletResponse)resp);
            fusionContext.setPagePath(eventContext.cfcPath);
        }
        return fusionContext;
    }
}

