/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.EventRequestHandler;
import coldfusion.eventgateway.Logger;
import coldfusion.server.EventGatewayService;
import coldfusion.util.IOUtils;
import coldfusion.util.RB;
import coldfusion.util.SimpleThreadPool;

public class EventRequestDispatcher {
    private static SimpleThreadPool stp = null;
    private static Logger logger = null;
    private static EventRequestHandler handler = null;
    private static EventGatewayService service = null;
    private static int maxQueueSize = -1;

    public void init(EventGatewayService ep, int threadpoolsize, int maxqueuesize) {
        service = ep;
        logger = ep.getLogger();
        handler = ep.getEventRequestHandler();
        maxQueueSize = maxqueuesize;
        stp = new SimpleThreadPool(threadpoolsize, maxqueuesize);
        logger.info(RB.getString((Object)this, "EventService.InitThreadPool", (Object)new Integer(threadpoolsize).toString()));
    }

    public void stop() {
        if (stp != null) {
            stp.shutdown();
        }
    }

    public boolean addEvent(CFEvent msg) {
        if (msg == null) {
            return false;
        }
        try {
            stp.assign(new Task(msg));
            service.incrementEventsIn(msg.getGatewayID());
            return true;
        }
        catch (SimpleThreadPool.QueueSizeExceeded e) {
            logger.error(RB.getString((Object)this, "EventService.AddEvent", (Object)msg.getGatewayID(), (Object)e.getLocalizedMessage()));
            return false;
        }
    }

    public int getQueueSize() {
        return stp.getQueueSize();
    }

    public int getMaxQueueSize() {
        return maxQueueSize;
    }

    private class Task
    implements Runnable {
        private CFEvent msg = null;

        public Task(CFEvent msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            if (this.msg == null) {
                return;
            }
            try {
                boolean ok = handler.processRequest(this.msg);
                if (!ok) {
                    logger.warn(RB.getString((Object)this, "EventService.NotExecuted", (Object)this.msg.getGatewayID()));
                }
            }
            catch (Throwable t) {
                logger.error(RB.getString((Object)this, "EventService.InvokeError", (Object)this.msg.getGatewayID(), (Object)(t.getLocalizedMessage() + IOUtils.lineSeparator + this.msg.toString())), t);
            }
        }
    }
}

