/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.EventContext;
import coldfusion.eventgateway.EventProxy;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.runtime.Cast;
import coldfusion.server.EventGatewayService;
import coldfusion.util.FastHashtable;
import coldfusion.util.Utils;
import java.io.File;
import java.util.Map;

public class EventRequestHandler {
    private static FastHashtable cfcRegistry = new FastHashtable();
    private static EventGatewayService eventService = null;
    private static String default_cfcentrypoint = "onIncomingMessage";

    public void init(EventGatewayService ep) {
        eventService = ep;
        eventService.getLogger().info("Initializing EventRequestHandler");
    }

    public synchronized void setCFCPaths(String id, String[] paths) {
        cfcRegistry.put(id, (Object)paths);
    }

    public synchronized String[] getCFCPaths(String id) {
        return (String[])cfcRegistry.get(id);
    }

    public synchronized void removeCFCPaths(String id) {
        cfcRegistry.remove(id);
    }

    public synchronized boolean isRegisteredGW(String id) {
        return cfcRegistry.containsKey(id);
    }

    public String getDefaultCFCPath(String id) {
        String[] paths = this.getCFCPaths(id);
        if (paths != null && paths.length > 0) {
            return paths[0];
        }
        return null;
    }

    public boolean processRequest(CFEvent msg) throws Throwable {
        boolean ret = false;
        if (this.isRegisteredGW(msg.getGatewayID())) {
            RequestMonitorEventProcessor.onRequestStart();
            try {
                ret = this.invokeCFC(msg.getGatewayID(), msg);
            }
            catch (Throwable t) {
                RequestMonitorEventProcessor.onError(t);
                throw t;
            }
            finally {
                RequestMonitorEventProcessor.onRequestEnd();
            }
        }
        return ret;
    }

    private boolean invokeCFC(String id, CFEvent msg) throws Throwable {
        if (msg == null) {
            return false;
        }
        String gwID = msg.getGatewayID();
        String cfcPath = msg.getCfcPath();
        cfcPath = cfcPath == null ? this.getDefaultCFCPath(id) : Utils.getCanonicalPath(new File(cfcPath));
        String originatorID = msg.getOriginatorID();
        if (originatorID == null) {
            originatorID = "originatorID";
        }
        String gwType = msg.getGatewayType();
        String cfcEntryPoint = msg.getCfcMethod();
        if (cfcEntryPoint == null) {
            cfcEntryPoint = default_cfcentrypoint;
        }
        Integer timeout = msg.getCfcTimeOut();
        StringBuffer sessionid = new StringBuffer();
        sessionid.append(gwType).append("_").append(gwID).append("_").append(originatorID);
        EventProxy proxy = new EventProxy();
        EventContext eventContext = new EventContext();
        eventContext.data = msg;
        eventContext.cfcPath = cfcPath;
        eventContext.sessionId = sessionid.toString();
        eventContext.gwType = gwType;
        eventContext.cfcMethod = cfcEntryPoint;
        eventContext.originatorID = originatorID;
        eventContext.gwID = gwID;
        eventContext.cfcTimeout = timeout;
        proxy.invokeComponent(eventContext);
        Map retValue = Cast._Map(eventContext.returnValue);
        if (retValue != null && retValue.size() > 0) {
            CFEvent retMsg = new CFEvent(gwID);
            retMsg.setData(retValue);
            retMsg.setOriginatorID(originatorID);
            retMsg.setGatewayType(gwType);
            eventService.getGateway(gwID).outgoingMessage(retMsg);
            eventService.incrementEventsOut(gwID);
        }
        return true;
    }
}

