/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.featurerouter;

import coldfusion.util.DynamicSemaphore;
import java.util.HashMap;

public class EFRSemaphore
extends DynamicSemaphore {
    HashMap requestMap = new HashMap();

    public EFRSemaphore(int i) {
        super(i);
    }

    public EFRSemaphore(int i, boolean b) {
        super(i, b);
    }

    @Override
    public void acquire() {
        if (!this.needToAcquireLock()) {
            return;
        }
        try {
            super.acquire();
        }
        catch (InterruptedException ie) {
            return;
        }
        this.onLockAcquired();
    }

    @Override
    public void acquire(int limit) throws InterruptedException {
        if (!this.needToAcquireLock()) {
            return;
        }
        super.acquire(limit);
        this.onLockAcquired();
    }

    protected boolean needToAcquireLock() {
        String threadName = Thread.currentThread().getName();
        return !this.requestMap.containsKey(threadName);
    }

    protected void onLockAcquired() {
        String threadName = Thread.currentThread().getName();
        this.requestMap.put(threadName, threadName);
    }

    protected void onLockReleased(String threadName) {
        this.requestMap.remove(threadName);
    }

    @Override
    public void release() {
        String threadName = Thread.currentThread().getName();
        if (!this.requestMap.containsKey(threadName)) {
            return;
        }
        this.onLockReleased(threadName);
        super.release();
    }

    @Override
    public void release(int permits) {
        String threadName = Thread.currentThread().getName();
        if (!this.requestMap.containsKey(threadName)) {
            return;
        }
        this.onLockReleased(Thread.currentThread().getName());
        super.release(permits);
    }
}

