/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.featurerouter.edition;

import coldfusion.archivedeploy.ArchiveDeployServiceImpl;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.EFRContext;
import coldfusion.featurerouter.FeatureNotAvailableException;
import coldfusion.featurerouter.RequestEndListener;
import coldfusion.featurerouter.edition.AbstractServerEdition;
import coldfusion.featurerouter.handler.FeatureRouterHandler;
import coldfusion.featurerouter.handler.standard.GenericStandardRouterHandler;
import coldfusion.featurerouter.handler.standard.StandardCFThreadHandler;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.server.ArchiveDeployService;
import coldfusion.server.MonitoringService;
import coldfusion.server.ServiceFactory;
import coldfusion.thread.CFThreadHandler;
import coldfusion.util.DynamicSemaphore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StandardServerEdition
extends AbstractServerEdition {
    private DynamicSemaphore efrSemaphore = null;
    private static HashMap featureConfigMap = new HashMap();
    public static final int requestCountLimit = 1;
    public static final Integer max_cfthreads_per_request = new Integer(ServiceFactory.getRuntimeService().getCFThreadPoolSize());
    public static final String handler_key = "handler";
    public static final String max_cfThreads_key = "max_cf_threads";
    public static final int ASYNC_EXECUTOR_POOL_THREAD_LIMIT = 10;
    public static final int CLOUD_SERVICES_EXECUTOR_POOL_THREAD_LIMIT = 10;
    public static final int GRAPHL_CLIENT_EXECUTOR_POOL_THREAD_LIMIT = 10;
    private static final int DEFAULT_CORE_POOL_SIZE = 5;
    private static final int DEFAULT_MAX_POOL_SIZE = 10;
    private static final int DEFAULT_CORE_POOL_SIZE_CLOUD_SERVICES = 5;
    private static final int DEFAULT_MAX_POOL_SIZE_CLOUD_SERVICES = 10;
    private static final int DEFAULT_CORE_POOL_SIZE_GRAPHQL_CLIENT = 5;
    private static final int DEFAULT_MAX_POOL_SIZE_GRAPHQL_CLIENT = 10;
    public static final GenericStandardRouterHandler genericHandler = new GenericStandardRouterHandler();
    private ArrayList requestEndListeners = new ArrayList();
    private static final CFThreadHandler cfThreadHandler = new StandardCFThreadHandler();

    public StandardServerEdition(String editionName) {
        super(editionName);
        this.efrSemaphore = new DynamicSemaphore(1);
    }

    public boolean featureRequiresEnterpriseLock(int featureCode) {
        return !StandardServerEdition.isGatewayFeature(featureCode);
    }

    @Override
    public void allowFeature(int featureCode, String tagName, Map params) throws FeatureNotAvailableException {
        if (!this.isFeatureAllowed(featureCode)) {
            throw new FeatureNotAvailableException(featureCode);
        }
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException(tagName);
        }
        if (this.featureRequiresEnterpriseLock(featureCode)) {
            this.acquireEnterpriseFeatureLock();
        }
        this.callRouterHandler(featureCode, params);
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException(tagName);
        }
    }

    private void callRouterHandler(int featureCode, Map params) {
        Integer code = new Integer(featureCode);
        Object obj = featureConfigMap.get(code);
        if (obj == null) {
            genericHandler.handleRouterRequest(featureCode, null, params);
            return;
        }
        Map configMap = (Map)obj;
        FeatureRouterHandler handler = (FeatureRouterHandler)configMap.get(handler_key);
        handler.handleRouterRequest(featureCode, configMap, params);
    }

    @Override
    public void onRequestEnd(Map params) {
        EFRContext ctx = EFRContext.getThreadLocal();
        if (ctx != null) {
            ctx.onRequestThreadEnd();
        }
        for (RequestEndListener listener : this.requestEndListeners) {
            listener.onRequestEnd(params);
        }
    }

    @Override
    public boolean isFeatureAllowed(int featureCode) {
        return featureCode != EFRConstants.multi_server_monitoring && featureCode != EFRConstants.server_monitoring_and_api && featureCode != EFRConstants.support_64_bit_solaris && featureCode != EFRConstants.request_limit_management && featureCode != EFRConstants.os_vertualization_support && featureCode != EFRConstants.fips_140_strong_cryptography && featureCode != EFRConstants.web_multi_instance_manager && featureCode != EFRConstants.web_cluster_manager && featureCode != EFRConstants.j2ee_package_deploy && featureCode != EFRConstants.multi_server_instances && featureCode != EFRConstants.instance_clustering && featureCode != EFRConstants.enterprise_data_drivers && featureCode != EFRConstants.full_j2ee_server_included && featureCode != EFRConstants.enterprise_server_security && featureCode != EFRConstants.orm_search && featureCode != EFRConstants.websocket_cluster && featureCode != EFRConstants.scheduler_new_features && featureCode != EFRConstants.solr_enhancements && featureCode != EFRConstants.pdf_digital_signatures && featureCode != EFRConstants.restricted_ddx && featureCode != EFRConstants.multi_host_support && featureCode != EFRConstants.security_analyzer && featureCode != EFRConstants.cache_new_engines;
    }

    public void addRequestEndListener(RequestEndListener listener) {
        this.requestEndListeners.add(listener);
    }

    @Override
    public int getMaxSimultaneousCFThreads() {
        return max_cfthreads_per_request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireEnterpriseFeatureLock() {
        block9: {
            boolean needToAcquireLock = true;
            EFRContext ctx = EFRContext.getThreadLocal();
            if (ctx == null) {
                ctx = new EFRContext();
                EFRContext.setThreadLocal(ctx);
            } else if (ctx.isEnterpriseLockTaken()) {
                needToAcquireLock = false;
            }
            try {
                if (!needToAcquireLock) break block9;
                EFRContext eFRContext = ctx;
                synchronized (eFRContext) {
                    if (ctx.isEnterpriseLockTaken()) {
                        return;
                    }
                    this.efrSemaphore.acquire();
                    ctx.setEnterpriseLockTaken(true);
                }
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    @Override
    public void releaseEnterpriseFeatureLock() {
        this.efrSemaphore.release();
    }

    @Override
    public void onCFThreadEnd() {
        EFRContext ctx = EFRContext.getThreadLocal();
        if (ctx != null) {
            ctx.onCFThreadEnd();
        }
    }

    @Override
    public void onCFThreadCreated() {
        EFRContext ctx = EFRContext.getThreadLocal();
        if (ctx == null) {
            ctx = new EFRContext();
            EFRContext.setThreadLocal(ctx);
        }
        ctx.onCFThreadCreated();
    }

    @Override
    public void onCFThreadStarted() {
        EFRContext ctx = EFRContext.getThreadLocal();
        if (ctx != null) {
            ctx.onCFThreadStarted();
        }
    }

    @Override
    public MonitoringService createMonitoringService(File config) {
        MonitoringService standardMonitoringService = ServiceFactory.getStandardMonitoringService();
        return standardMonitoringService;
    }

    @Override
    public ArchiveDeployService createArchiveDeployService(File config, String rootDir) {
        return new ArchiveDeployServiceImpl(config, rootDir);
    }

    @Override
    public CFThreadHandler getCFThreadHandler() {
        return cfThreadHandler;
    }

    @Override
    public int getPoolSizeLimitForAsync() {
        return 10;
    }

    @Override
    public int getDefaultCorePoolSize() {
        return 5;
    }

    @Override
    public int getDefaultMaxPoolSize() {
        return 10;
    }

    @Override
    public int getDefaultCloudServicesCorePoolSize() {
        return 5;
    }

    @Override
    public int getDefaultCloudServicesMaxPoolSize() {
        return 10;
    }

    @Override
    public int getPoolSizeLimitForCloudServices() {
        return 10;
    }

    @Override
    public int getPoolSizeLimitForGraphQLClient() {
        return 10;
    }

    @Override
    public int getDefaultGraphQLClientCorePoolSize() {
        return 5;
    }

    @Override
    public int getDefaultGraphQLClientMaxPoolSize() {
        return 10;
    }
}

