/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.server.ServiceFactory;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CFFiddleFilter
extends FusionFilter {
    private ServletContext servletContext;
    private SandboxLevel cffiddleSandboxLevel;
    volatile transient Vector<Map<String, String>> defaultSandboxSettings;
    private ThreadLocal<Boolean> sandboxAdded = new ThreadLocal();
    private static final String cf_root_dir = System.getProperty("coldfusion.rootDir");
    private static final String cf_temp_dir = System.getProperty("coldfusion.temp.dir");
    private static final String fiddleContextRoot = System.getProperty("coldfusion.fiddle.contextroot", "cffiddle");

    public CFFiddleFilter(FusionFilter next, Servlet servlet) {
        super(next);
        this.servletContext = servlet.getServletConfig().getServletContext();
        String sandboxLevelString = this.servletContext.getInitParameter("cffiddle.sandbox");
        try {
            if (sandboxLevelString != null) {
                this.cffiddleSandboxLevel = SandboxLevel.valueOf(sandboxLevelString);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void invoke(FusionContext context) throws Throwable {
        block10: {
            boolean debug;
            block8: {
                block9: {
                    this.sandboxAdded.set(false);
                    String debugCall = context.getRequest().getParameter("__debugcall");
                    debug = false;
                    if (debugCall != null) {
                        debug = Boolean.parseBoolean(debugCall);
                    }
                    String sandboxDir = null;
                    if (debug) {
                        System.out.println("CFFiddle filter invoked with sandbox level: " + this.cffiddleSandboxLevel);
                    }
                    if (this.cffiddleSandboxLevel == null) break block8;
                    String fiddlecall = context.getRequest().getParameter("__fiddlecall");
                    if (!Boolean.parseBoolean(fiddlecall)) break block9;
                    String sandbox = context.getRequest().getParameter("__sandbox");
                    String app = context.getRequest().getParameter("__appid");
                    if (sandbox != null && app != null) {
                        String rootDir = this.servletContext.getRealPath("/");
                        sandboxDir = this.cffiddleSandboxLevel.equals((Object)SandboxLevel.application) ? rootDir + fiddleContextRoot + "/" + sandbox + "/" + app : rootDir + fiddleContextRoot + "/" + sandbox;
                        this.addSandbox(sandboxDir, debug);
                        this.sandboxAdded.set(true);
                        if (debug) {
                            System.out.println("CFFiddle filter sandbox added: " + sandboxDir);
                        }
                        break block10;
                    } else {
                        if (debug) {
                            System.out.println("CFFiddle filter sandbox or app is null");
                        }
                        return;
                    }
                }
                if (debug) {
                    System.out.println("CFFiddle filter is not enabled in request");
                }
                break block10;
            }
            if (debug) {
                System.out.println("CFFiddle filter, looks like sandbox level is null");
            }
        }
        this.next.invoke(context);
    }

    private Map getLatestWebApp(boolean debug) {
        Map contexts = ServiceFactory.getSecurityService().getContexts();
        if (debug) {
            System.out.println("CFFiddle filter got contexts size: " + contexts.size());
        }
        Object webAppObject = contexts.get("/");
        if (debug) {
            System.out.println("CFFiddle filter got webAppObject:");
        }
        if (webAppObject instanceof Map) {
            if (debug) {
                System.out.println("webappobject size: " + ((Map)webAppObject).size());
            }
            if (((Map)webAppObject).size() > 2000) {
                ((Map)webAppObject).clear();
                if (debug) {
                    System.out.println("webappobject cleared, new size: " + ((Map)webAppObject).size());
                }
            }
            return (Map)webAppObject;
        }
        return null;
    }

    private void addSandbox(String dir, boolean debug) {
        Map latestWebApp = this.getLatestWebApp(debug);
        if (latestWebApp == null) {
            if (debug) {
                System.out.println("CFFiddle filter webapp is null");
            }
            return;
        }
        if (latestWebApp.get(dir) != null) {
            if (debug) {
                System.out.println("CFFiddle filter sandbox already exists for dir: " + dir);
            }
            return;
        }
        Vector<Map<String, String>> sandbox = this.getFirstCopyOfSandbox(this.getDefaultSandboxSettings());
        sandbox.add(this.getFilePermissions(dir));
        sandbox.add(this.getFilePermissionsRecurs(dir));
        String tempDir = cf_temp_dir + "/tmpCache";
        String scriptsDir = cf_root_dir + "/wwwroot/cf_scripts/scripts/ajax/messages";
        String antiSamy = cf_root_dir + "/lib/antisamy-basic.xml";
        sandbox.add(this.getFilePermissions(tempDir));
        sandbox.add(this.getFilePermissionsRecurs(tempDir));
        sandbox.add(this.getReadFilePermissions(scriptsDir));
        sandbox.add(this.getReadFilePermissionsRecurs(scriptsDir));
        sandbox.add(this.getReadFilePermissions(antiSamy));
        latestWebApp.put(dir, sandbox);
        if (debug) {
            StringBuilder sb = new StringBuilder();
            sb.append("Sandbox-");
            sb.append("dir: " + dir);
            sb.append("sandbox:{");
            for (Map<String, String> perm : sandbox) {
                sb.append("[");
                sb.append(perm.get("class")).append(",");
                sb.append(perm.get("target")).append(",");
                sb.append(perm.get("action")).append(",");
                sb.append("]");
            }
            sb.append("}");
            System.out.println(sb.toString());
        }
    }

    private void removeSandbox(String dir, boolean debug) {
        Map latestWebApp = this.getLatestWebApp(debug);
        if (latestWebApp != null && dir != null) {
            latestWebApp.remove(dir);
        }
        if (debug) {
            System.out.println("CFFiddle filter sandbox removed");
        }
    }

    private Vector<Map<String, String>> getDefaultSandboxSettings() {
        return this.defaultSandboxSettings == null ? (this.defaultSandboxSettings = this.createDefaultSandboxSettings()) : this.defaultSandboxSettings;
    }

    private Vector<Map<String, String>> getFirstCopyOfSandbox(Vector<Map<String, String>> vector) {
        Vector<Map<String, String>> copyofVector = new Vector<Map<String, String>>(vector.size());
        for (Map<String, String> map : vector) {
            copyofVector.add(map);
        }
        return copyofVector;
    }

    private Vector<Map<String, String>> createDefaultSandboxSettings() {
        Vector<Map<String, String>> permissions = new Vector<Map<String, String>>();
        HashMap<String, String> serializablePermission = new HashMap<String, String>();
        serializablePermission.put("class", "java.io.SerializablePermission");
        serializablePermission.put("target", "*");
        serializablePermission.put("action", "");
        permissions.add(serializablePermission);
        HashMap<String, String> propertyPermission = new HashMap<String, String>();
        propertyPermission.put("class", "java.util.PropertyPermission");
        propertyPermission.put("target", "*");
        propertyPermission.put("action", "read,write");
        permissions.add(propertyPermission);
        HashMap<String, String> netPermission = new HashMap<String, String>();
        netPermission.put("class", "java.net.NetPermission");
        netPermission.put("target", "*");
        netPermission.put("action", "");
        permissions.add(netPermission);
        HashMap<String, String> sqlPermission = new HashMap<String, String>();
        sqlPermission.put("class", "java.sql.SQLPermission");
        sqlPermission.put("target", "*");
        sqlPermission.put("action", "");
        permissions.add(sqlPermission);
        HashMap<String, String> securityPermission = new HashMap<String, String>();
        securityPermission.put("class", "java.security.SecurityPermission");
        securityPermission.put("target", "*");
        securityPermission.put("action", "");
        permissions.add(securityPermission);
        HashMap<String, String> socketPermission = new HashMap<String, String>();
        socketPermission.put("class", "java.net.SocketPermission");
        socketPermission.put("target", "*");
        socketPermission.put("action", "connect,resolve");
        permissions.add(socketPermission);
        HashMap<String, String> functionPermission = new HashMap<String, String>();
        functionPermission.put("class", "coldfusion.runtime.FunctionPermission");
        functionPermission.put("target", "*-createobject(java)");
        functionPermission.put("action", "");
        permissions.add(functionPermission);
        for (String permission : this.getAllRuntimePermissions()) {
            HashMap<String, String> runtimePermission = new HashMap<String, String>();
            runtimePermission.put("class", "java.lang.RuntimePermission");
            runtimePermission.put("target", permission);
            runtimePermission.put("action", "");
            permissions.add(runtimePermission);
        }
        HashMap<String, String> reflectPermission = new HashMap<String, String>();
        reflectPermission.put("class", "java.lang.reflect.ReflectPermission");
        reflectPermission.put("target", "*");
        reflectPermission.put("action", "");
        permissions.add(reflectPermission);
        HashMap<String, String> genericTagPermission = new HashMap<String, String>();
        genericTagPermission.put("class", "coldfusion.tagext.GenericTagPermission");
        genericTagPermission.put("target", "*");
        genericTagPermission.put("action", "");
        permissions.add(genericTagPermission);
        HashMap<String, String> modulePermission = new HashMap<String, String>();
        modulePermission.put("class", "coldfusion.tagext.lang.ModulePermission");
        modulePermission.put("target", "*");
        modulePermission.put("action", "");
        permissions.add(modulePermission);
        return permissions;
    }

    private Map<String, String> getFilePermissions(String dir) {
        Map<String, String> filePermission = this.getDefaultFilePermissions();
        filePermission.put("target", dir);
        return filePermission;
    }

    private Map<String, String> getFilePermissionsRecurs(String dir) {
        Map<String, String> filePermissionRecurs = this.getDefaultFilePermissions();
        filePermissionRecurs.put("target", dir + "/-");
        return filePermissionRecurs;
    }

    private Map<String, String> getDefaultFilePermissions() {
        HashMap<String, String> filePermission = new HashMap<String, String>();
        filePermission.put("class", "java.io.FilePermission");
        filePermission.put("action", "read,write,delete");
        return filePermission;
    }

    private Map<String, String> getReadFilePermissions(String dir) {
        Map<String, String> filePermission = this.getDefaultReadFilePermissions();
        filePermission.put("target", dir);
        return filePermission;
    }

    private Map<String, String> getReadFilePermissionsRecurs(String dir) {
        Map<String, String> filePermissionRecurs = this.getDefaultReadFilePermissions();
        filePermissionRecurs.put("target", dir + "/-");
        return filePermissionRecurs;
    }

    private Map<String, String> getDefaultReadFilePermissions() {
        HashMap<String, String> filePermission = new HashMap<String, String>();
        filePermission.put("class", "java.io.FilePermission");
        filePermission.put("action", "read");
        return filePermission;
    }

    private Vector<String> getAllRuntimePermissions() {
        Vector<String> runtimePermissions = new Vector<String>();
        runtimePermissions.add("getClassLoader");
        runtimePermissions.add("setContextClassLoader");
        runtimePermissions.add("enableContextClassLoaderOverride");
        runtimePermissions.add("createSecurityManager");
        runtimePermissions.add("getenv.*");
        runtimePermissions.add("shutdownHooks");
        runtimePermissions.add("modifyThread");
        runtimePermissions.add("stopThread");
        runtimePermissions.add("getProtectionDomain");
        runtimePermissions.add("readFileDescriptor");
        runtimePermissions.add("writeFileDescriptor");
        runtimePermissions.add("accessClassInPackage.*");
        runtimePermissions.add("defineClassInPackage.*");
        runtimePermissions.add("accessDeclaredMembers");
        runtimePermissions.add("queuePrintJob");
        runtimePermissions.add("setDefaultUncaughtExceptionHandler");
        runtimePermissions.add("preferences");
        return runtimePermissions;
    }

    static enum SandboxLevel {
        application,
        sandbox;

    }
}

