/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class ClickjackingProtectionFilter
implements Filter {
    private static String DENY_MODE = "DENY";
    private static String SAMEORIGIN_MODE = "SAMEORIGIN";
    private static String ALLOWFROM_MODE = "ALLOW";
    private String mode = "DENY";

    public void init(FilterConfig filterConfig) throws ServletException {
        String configMode = filterConfig.getInitParameter("mode");
        if (configMode != null) {
            if ((configMode = configMode.toUpperCase()).equals(DENY_MODE) || configMode.equals(SAMEORIGIN_MODE) || configMode.startsWith(ALLOWFROM_MODE)) {
                this.mode = configMode;
            } else {
                throw new ServletException("Unsupported mode value.");
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        res.addHeader("X-FRAME-OPTIONS", this.mode);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

