/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.server.ServiceFactory;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;

public class CspFilter
extends FusionFilter {
    public static final String CSP_HEADER = "Content-Security-Policy";

    public CspFilter(FusionFilter next) {
        super(next);
    }

    @Override
    public void invoke(FusionContext context) throws Throwable {
        boolean isCspAppScopeSetting;
        this.next.invoke(context);
        ApplicationSettings appSettings = FusionContext.getApplicationSettings();
        ApplicationScope appScope = (ApplicationScope)FusionContext.getApplicationScope();
        Map settingsMap = appScope != null ? appScope.getApplicationSettingsMap() : null;
        HttpServletResponse response = context.getResponse();
        boolean generateCspNonce = false;
        boolean bl = isCspAppScopeSetting = settingsMap != null && settingsMap.containsKey("ENABLECSPNONCEFORSCRIPT");
        if (appSettings != null) {
            generateCspNonce = appSettings.generateCspNonce();
        }
        if (!isCspAppScopeSetting) {
            generateCspNonce = ServiceFactory.getRuntimeService().isEnableCspNonceForScript();
        }
        if (generateCspNonce && response != null && response.getHeader(CSP_HEADER) == null) {
            String cspHeaderValue = "default-src 'self'; script-src 'nonce-" + context.getCSPNonce() + "'";
            context.getResponse().setHeader(CSP_HEADER, cspHeaderValue);
        }
    }
}

