/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.CfincludeFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.runtime.NeoPageContext;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;

public class DreamweaverDebugFilter
extends FusionFilter {
    static final String DREAMWEAVER_USER_AGENT = "dreamweaver";
    static final String ULTRADEV_USER_AGENT = "ultradev";

    public DreamweaverDebugFilter(FusionFilter next) {
        super(next);
    }

    @Override
    public void invoke(FusionContext context) throws Throwable {
        NeoPageContext pageContext = context.pageContext;
        HttpServletRequest request = context.getRequest();
        long startTime = 0L;
        DebuggingService ds = ServiceFactory.getDebuggingService();
        if (ds == null) {
            return;
        }
        boolean show = ds.isValidIP(request.getRemoteAddr());
        if (show) {
            ds.reset(1);
            startTime = System.currentTimeMillis();
            HttpServletResponse response = context.getResponse();
            response.setHeader("Pragma", "No-Cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Cache-Control", "no-store");
            response.setHeader("Cache-Control", "must-revalidate");
            response.setDateHeader("Expires", 0L);
        }
        this.next.invoke(context);
        if (show) {
            String xmlTemplatePath;
            File xmlTemplateFile;
            ds.getDebugger().executionTime(startTime, System.currentTimeMillis());
            if (request.getAttribute("coldfusion.ExceptionFilter.biscuit") == null && (xmlTemplateFile = new File(context.getRealPath(xmlTemplatePath = ds.getXMLTemplate()))).isFile()) {
                new CfincludeFilter().include(xmlTemplateFile.getPath(), context);
            }
        }
    }

    public static boolean isDreamweaver(ServletRequest request) {
        boolean isDW = false;
        if (request != null && request instanceof HttpServletRequest) {
            String dreamweaver = ((HttpServletRequest)request).getHeader("User-Agent");
            isDW = dreamweaver != null && (dreamweaver == null || dreamweaver.toLowerCase().indexOf(DREAMWEAVER_USER_AGENT) != -1 || dreamweaver.toLowerCase().indexOf(ULTRADEV_USER_AGENT) != -1);
        }
        return isDW;
    }
}

