/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.compiler.ParseException;
import coldfusion.filter.CfincludeFilter;
import coldfusion.filter.FormValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.log.CFLogs;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.AbortMessageException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CFRestHTTPException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfErrorWrapper;
import coldfusion.runtime.CustomException;
import coldfusion.runtime.ExceptionInformation;
import coldfusion.runtime.ExceptionScope;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoJspWriter;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.StringFunc;
import coldfusion.runtime.TemplateNotFoundException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.server.DebuggingService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.BOMReader;
import coldfusion.util.Utils;
import coldfusion.xml.rpc.CFCInvocationException;
import coldfusion.xml.rpc.CFCServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;

public final class ExceptionFilter
extends FusionFilter {
    private static final String MISSING_TEMPLATE = "missing";
    private static final String SITE_TEMPLATE = "site";
    public static final String BISCUIT = "coldfusion.ExceptionFilter.biscuit";
    private static final String SECURE_MISSING_TEMPLATE_PATH = "/cfide/administrator/templates/missing_template_eror.cfm";
    private static final String SECURE_SITE_WIDE_TEMPLATE_PATH = "/cfide/administrator/templates/secure_profile_error.cfm";

    public ExceptionFilter(FusionFilter next) {
        super(next);
    }

    @Override
    public void invoke(FusionContext context) throws Throwable {
        JspWriter out = context.pageContext.getOut();
        try {
            this.next.invoke(context);
        }
        catch (Throwable ex) {
            try {
                if (out instanceof CFOutput) {
                    ((CFOutput)out).cfoutput(true);
                }
                if (ServerlessUtil.isLambdaEnv()) {
                    ex.printStackTrace();
                }
                if (!this.handleException(context, (Writer)out, NeoException.unwrap(ex), true)) {
                    throw ex;
                }
            }
            catch (TemplateNotFoundException notFound) {
                throw notFound;
            }
            catch (Exception exPrime) {
                System.err.println("Exception thrown by error-handling template:");
                exPrime.printStackTrace(System.err);
                throw ex;
            }
        }
    }

    private boolean handleException(FusionContext context, Writer out, Throwable ex, boolean setErrorStatus) throws IOException {
        boolean enableStatusCodes;
        block44: {
            DebuggingService ds;
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            Map error_settings = ServiceFactory.getRuntimeService().getErrors();
            enableStatusCodes = true;
            if (error_settings.containsKey("EnableHTTPStatus")) {
                enableStatusCodes = Cast._boolean(error_settings.get("EnableHTTPStatus"));
            }
            DebuggingService debuggingService = ServiceFactory.getDebuggingService();
            boolean robustEnabled = false;
            if (debuggingService != null) {
                robustEnabled = debuggingService.isRobustEnabled();
            }
            if (ServerlessUtil.isLambdaEnv()) {
                robustEnabled = true;
            }
            if (ex instanceof AbortException) {
                return true;
            }
            if (ex instanceof RequestTimedOutException) {
                ServiceFactory.getMetricsService().updateMetric("errorCount", 1);
            }
            if (request.getAttribute(BISCUIT) != null) {
                return false;
            }
            request.setAttribute(BISCUIT, (Object)"exception handler already invoked");
            if (!(ex instanceof TemplateNotFoundException)) {
                String url = null;
                if (context != null && context.request != null) {
                    url = context.request.getRequestURL().toString();
                }
                RequestMonitorEventProcessor.onError(ex, url);
            }
            if ((ds = ServiceFactory.getDebuggingService()) != null && ds.check(8) && ds.getDebugger() != null) {
                ds.getDebugger().exception(ex);
            }
            if (ex instanceof FormValidationException) {
                if (this.runValidationHandler((NeoJspWriter)((Object)out), context, (FormValidationException)ex)) {
                    return true;
                }
            } else {
                if (ex instanceof TemplateNotFoundException) {
                    try {
                        if (this.runMissingTemplateHandler(context, ex)) {
                            if (enableStatusCodes) {
                                response.setStatus(404);
                            }
                            this.logErrorTofile(context, ex);
                            return true;
                        }
                        break block44;
                    }
                    catch (AbortException exx) {
                        return true;
                    }
                }
                if (ex instanceof CFRestHTTPException) {
                    boolean exceptionHandled = false;
                    Throwable cause = ((CFRestHTTPException)ex).getCause();
                    context.getRequest().removeAttribute(BISCUIT);
                    if (cause instanceof CFCInvocationException) {
                        CFCInvocationException exception = (CFCInvocationException)cause;
                        Throwable baseCause = exception.getCause();
                        if (baseCause instanceof CustomException) {
                            CustomException customException = (CustomException)baseCause;
                            exceptionHandled = this.handleRestException(enableStatusCodes, robustEnabled, context, customException);
                        } else {
                            exceptionHandled = this.handleException(context, out, cause, true);
                        }
                    } else {
                        exceptionHandled = this.handleException(context, out, cause, true);
                    }
                    context.pageContext.flushOutput();
                    return exceptionHandled;
                }
                if (!(ex instanceof AbortException)) {
                    try {
                        if (this.runExceptionHandler(context, ex, request, out)) {
                            return true;
                        }
                    }
                    catch (AbortMessageException abortEx) {
                        ex = abortEx;
                    }
                    catch (AbortException abortEx) {
                        return true;
                    }
                    catch (Throwable ex1) {
                        try {
                            if (this.runRequestHandler(context, (NeoJspWriter)((Object)out), ex1)) {
                                if (enableStatusCodes) {
                                    context.getResponse().setStatus(500);
                                }
                                return true;
                            }
                        }
                        catch (AbortException exe) {
                            return true;
                        }
                    }
                    if (!response.isCommitted()) {
                        response.setHeader("server-error", "true");
                    }
                    try {
                        if (this.runSiteWideHandler(context, ex, request, out)) {
                            this.logErrorTofile(context, ex);
                            return true;
                        }
                        if (this.runRequestHandler(context, (NeoJspWriter)((Object)out), ex)) {
                            if (enableStatusCodes) {
                                context.getResponse().setStatus(500);
                            }
                            return true;
                        }
                    }
                    catch (AbortException exl) {
                        return true;
                    }
                }
            }
        }
        this.logErrorTofile(context, ex);
        if (enableStatusCodes) {
            if (ex instanceof TemplateNotFoundException) {
                context.getResponse().setStatus(404);
                RequestMonitorEventProcessor.onError(ex);
            } else if (setErrorStatus) {
                if (context.getServlet() instanceof CFCServlet && ex instanceof TemplateProxy.InvalidMethodNameException) {
                    context.getResponse().setStatus(404);
                } else {
                    context.getResponse().setStatus(500);
                }
            }
        }
        return this.runBuiltInHandler(context, ex);
    }

    private void handleSecureProfileLogging(FusionContext context, Throwable ex, String type) {
        if (ServiceFactory.getSecurityService().isSecureProfile()) {
            Map errors = ServiceFactory.getRuntimeService().getErrors();
            if (type.equals(MISSING_TEMPLATE)) {
                String handle;
                Object missingObj = errors.get("missing_template");
                if (missingObj != null && missingObj instanceof String && (handle = (String)missingObj).toLowerCase().endsWith(SECURE_MISSING_TEMPLATE_PATH)) {
                    this.logErrorTofile(context, ex);
                }
            } else {
                String handle;
                Object missingObj = errors.get("site_wide");
                if (missingObj != null && missingObj instanceof String && (handle = (String)missingObj).toLowerCase().endsWith(SECURE_SITE_WIDE_TEMPLATE_PATH)) {
                    this.logErrorTofile(context, ex);
                }
            }
        }
    }

    private void logErrorTofile(FusionContext context, Throwable ex) {
        Object scope = context.hiddenScope.get("application");
        if (scope != null && scope instanceof ApplicationScope) {
            ApplicationScope appScope = (ApplicationScope)scope;
            String appName = appScope.getName();
            CFLogs.APPLICATION_LOG.error(new ApplicationExceptionWrapper(ex, context.getPagePath()));
        } else {
            CFLogs.APPLICATION_LOG.error(new ApplicationExceptionWrapper(ex, context.getPagePath()));
        }
    }

    private boolean handleRestException(boolean enableStatusCodes, boolean robustEnabled, FusionContext context, CustomException customException) throws IOException {
        if (enableStatusCodes) {
            int status = 500;
            String errorCode = customException.getErrorCode();
            if (null != errorCode && errorCode.trim().length() > 0) {
                try {
                    status = Cast._int(errorCode);
                }
                catch (Cast.NumberConversionException e) {
                    throw new CFPage.InvalidHTTPStatusException((Object)errorCode);
                }
            }
            context.getResponse().setStatus(status);
        }
        return this.handleException(context, (Writer)context.pageContext.getOut(), customException, false);
    }

    /*
     * Exception decompiling
     */
    private boolean runMissingTemplateHandler(FusionContext context, Throwable ex) throws TemplateNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runSiteWideHandler(FusionContext context, Throwable ex, HttpServletRequest request, Writer out) {
        Object page;
        Object temp;
        Map errors;
        RuntimeService rtm = ServiceFactory.getRuntimeService();
        if (rtm != null && (errors = rtm.getErrors()).containsKey("site_wide") && (temp = errors.get("site_wide")) instanceof String && ((String)(page = (String)temp)).trim().length() > 0) {
            if (!((String)page).startsWith("/")) {
                page = "/" + (String)page;
            }
            boolean setUseMappings = context.setUseMappings(true);
            try {
                ExceptionScope exInfo = new ExceptionScope(new CfErrorWrapper(ex, "", request, ((NeoJspWriter)((Object)out)).getString()));
                context.pageContext.setAttribute("error", exInfo);
                context.pageContext.setAttribute("cferror", exInfo);
                ((NeoJspWriter)((Object)out)).clear();
                new CfincludeFilter().include(context.getRealPath((String)page), context);
                boolean bl = true;
                return bl;
            }
            catch (AbortException ex0) {
                throw ex0;
            }
            catch (Throwable ex1) {
                CFLogs.APPLICATION_LOG.error("Error thrown by site-wide exception handler:");
                CFLogs.APPLICATION_LOG.error(new ApplicationExceptionWrapper(ex1, context.getRealPath((String)page)));
            }
            finally {
                context.setUseMappings(setUseMappings);
            }
        }
        return false;
    }

    private boolean runExceptionHandler(FusionContext context, Throwable ex, HttpServletRequest request, Writer out) throws Throwable {
        if (context.exceptionHandlers != null) {
            int count = context.exceptionHandlers.size();
            for (int i = 0; i < count; ++i) {
                FusionContext.ExceptionHandler handler = (FusionContext.ExceptionHandler)context.exceptionHandlers.elementAt(i);
                if (!handler.type.isAssignableFrom(ex.getClass())) continue;
                ExceptionScope exInfo = new ExceptionScope(new CfErrorWrapper(ex, handler.mailto, request, ((NeoJspWriter)((Object)out)).getString()));
                context.pageContext.setAttribute("error", exInfo);
                context.pageContext.setAttribute("cferror", exInfo);
                ((NeoJspWriter)((Object)out)).clear();
                new CfincludeFilter().include(handler.template, context);
                return true;
            }
        }
        return false;
    }

    private boolean runBuiltInHandler(FusionContext context, Throwable ex) throws IOException {
        context.pageContext.flushOutput();
        String path = this.findCustomHandler(context, ex);
        if (path == null) {
            path = this.findJavaHandler(context, ex);
        }
        if (path != null) {
            ExceptionScope exInfo = new ExceptionScope(ex);
            context.pageContext.setAttribute("error", exInfo);
            context.pageContext.setAttribute("cferror", exInfo);
            try {
                new CfincludeFilter().include(context.getRealPath(path), context);
                return true;
            }
            catch (Throwable ex1) {
                CFLogs.APPLICATION_LOG.error("Exception thrown by error-handling template:");
                CFLogs.APPLICATION_LOG.error(new ApplicationExceptionWrapper(ex1, context.getRealPath(path)));
                return false;
            }
        }
        return false;
    }

    private boolean runRequestHandler(FusionContext context, NeoJspWriter out, Throwable ex) {
        if (context.requestExceptionHandler != null) {
            StringPair[] replaceStrings = new StringPair[12];
            CfErrorWrapper error = new CfErrorWrapper(ex, context.requestExceptionHandler.mailto, context.getRequest(), out.getString());
            replaceStrings[0] = new StringPair("#ERROR.GENERATEDCONTENT#", error.getGeneratedContent());
            replaceStrings[1] = new StringPair("#ERROR.DIAGNOSTICS#", error.getDiagnostics());
            replaceStrings[2] = new StringPair("#ERROR.MAILTO#", error.getMailto());
            replaceStrings[3] = new StringPair("#ERROR.DATETIME#", error.getDateTime().toString());
            replaceStrings[4] = new StringPair("#ERROR.BROWSER#", error.getBrowser());
            replaceStrings[5] = new StringPair("#ERROR.REMOTEADDRESS#", error.getRemoteAddress());
            replaceStrings[6] = new StringPair("#ERROR.HTTPREFERER#", error.getHTTPReferer());
            replaceStrings[7] = new StringPair("#ERROR.QUERYSTRING#", error.getQueryString());
            replaceStrings[8] = new StringPair("#ERROR.TEMPLATE#", error.getTemplate());
            ExceptionScope rootCause = new ExceptionScope(error.getRootCause());
            replaceStrings[9] = new StringPair("#ERROR.ROOTCAUSE.TYPE#", rootCause.get("type").toString());
            replaceStrings[10] = new StringPair("#ERROR.ROOTCAUSE.MESSAGE#", rootCause.get("message").toString());
            replaceStrings[11] = new StringPair("#ERROR.ROOTCAUSE.DETAIL#", rootCause.get("detail").toString());
            return this.runSimpleHandler(out, context, context.requestExceptionHandler, replaceStrings);
        }
        return false;
    }

    private boolean runSimpleHandler(NeoJspWriter out, FusionContext context, FusionContext.ExceptionHandler handler, StringPair[] strings) {
        HttpServletRequest request = context.getRequest();
        if (handler != null) {
            out.clear();
            try {
                File templateFile = new File(handler.template);
                if (!templateFile.exists() || !templateFile.isFile()) {
                    String path = Utils.getServletPath(request);
                    String canonicalRealPath = context.pageContext.getServletContext().getRealPath(path);
                    int separatorPos = canonicalRealPath.lastIndexOf(File.separatorChar);
                    String dir = "";
                    if (separatorPos != -1) {
                        dir = canonicalRealPath.substring(0, separatorPos + 1);
                    }
                    templateFile = new File(dir, handler.template);
                }
                FileInputStream fileInStream = null;
                byte[] buf = null;
                String encodingType = null;
                try {
                    fileInStream = new FileInputStream(templateFile);
                    int len = (int)templateFile.length();
                    buf = new byte[len];
                    fileInStream.read(buf, 0, len);
                    fileInStream.close();
                    fileInStream = new FileInputStream(templateFile);
                    BOMReader bomReader = new BOMReader(new BufferedInputStream(fileInStream));
                    encodingType = bomReader.getEncoding();
                    fileInStream.close();
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    if (fileInStream != null) {
                        try {
                            fileInStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                String content = encodingType != null ? new String(buf, encodingType) : new String(buf);
                for (int i = 0; i < strings.length; ++i) {
                    content = StringFunc.ReplaceNoCase(content, strings[i].searchStr, strings[i].replaceStr, "ALL");
                }
                out.write(content);
                return true;
            }
            catch (FileNotFoundException exception) {
                exception.printStackTrace(System.out);
                CFLogs.SERVER_LOG.error("Error Handler not found: " + context.requestExceptionHandler.template + " Could not be found");
                return false;
            }
            catch (IOException writeException) {
                return false;
            }
        }
        return false;
    }

    private boolean runValidationHandler(NeoJspWriter out, FusionContext context, FormValidationException ex) {
        if (context.validationExceptionHandler != null) {
            StringPair[] replaceStrings = new StringPair[]{new StringPair("#ERROR.VALIDATIONHEADER#", "Form entries incomplete or invalid."), new StringPair("#ERROR.INVALIDFIELDS#", "<UL>" + ex.errors + "</UL>"), new StringPair("#ERROR.VALIDATIONFOOTER#", "Please go <a href=\"javascript:history.back()\">back</a> and correct the problem.")};
            return this.runSimpleHandler(out, context, context.validationExceptionHandler, replaceStrings);
        }
        return false;
    }

    private String findCustomHandler(FusionContext context, Throwable ex) {
        if (!(ex instanceof CustomException)) {
            return null;
        }
        CustomException customEx = (CustomException)ex;
        String typeName = customEx.getType();
        while (true) {
            String handler;
            String path;
            if (this.fileExists(context, path = (handler = "/WEB-INF/exception/" + typeName.replace('.', '/')) + ".cfm")) {
                return path;
            }
            int dot = typeName.lastIndexOf(46);
            if (dot == -1) break;
            typeName = typeName.substring(0, dot);
        }
        return null;
    }

    private boolean fileExists(FusionContext context, String path) {
        return new File(context.getRealPath(path)).isFile();
    }

    private String findJavaHandler(FusionContext context, Throwable ex) {
        Class<?> type = ex.getClass();
        Class<Throwable> throwableClass = Throwable.class;
        do {
            String handler;
            String path;
            if (!this.fileExists(context, path = (handler = "/WEB-INF/exception/" + type.getName().replace('.', '/')) + ".cfm")) continue;
            return path;
        } while (throwableClass.isAssignableFrom(type = type.getSuperclass()));
        return null;
    }

    public void doCatch(Throwable t) throws Throwable {
    }

    public static class ApplicationExceptionWrapper
    extends ApplicationException {
        public String pagePath;
        public String lineNumber = "";
        private Throwable rootEx;

        public ApplicationExceptionWrapper(Throwable rootEx, String pagePath) {
            int linenum;
            this.rootEx = rootEx;
            this.pagePath = pagePath;
            if (rootEx instanceof ParseException) {
                linenum = ((ParseException)rootEx).getLine();
            } else {
                ExceptionInformation info = new ExceptionInformation(rootEx);
                linenum = info.getLine();
            }
            if (linenum > 0) {
                this.lineNumber = ", line: " + Integer.toString(linenum);
            }
        }

        public String getRootMessage() {
            if (this.rootEx instanceof NeoException) {
                return this.rootEx.getMessage() + ((NeoException)this.rootEx).getDetail();
            }
            return this.rootEx.getMessage();
        }

        @Override
        public void printStackTrace() {
            this.rootEx.printStackTrace();
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            this.rootEx.printStackTrace(s);
        }

        @Override
        public void printStackTrace(PrintStream s) {
            this.rootEx.printStackTrace(s);
        }
    }

    private static class StringPair {
        public String searchStr;
        public String replaceStr;

        public StringPair(String search, String replace) {
            this.searchStr = search;
            this.replaceStr = replace;
        }
    }
}

