/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.UrlScope;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.server.ServiceFactory;
import coldfusion.wddx.WddxDeserializer;
import coldfusion.wddx.WddxSerializer;
import coldfusion.xml.XmlNodeList;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.InputSource;

public class FilterUtils {
    public static final String ARGUMENT_COLLECTION_FLAG = "coldfusion.argumentcollection.allowscopes";
    public static final List<String> disabledScopesForArgumentCollection = new ArrayList<String>(Arrays.asList("ARGUMENTCOLLECTION", "FILE", "CLIENT", "COOKIE", "CGI", "SERVER", "APPLICATION", "SESSION", "REQUEST", "CFHTTP", "HTTP", "CFFILE", "LOCAL", "THIS", "THISTAG", "THREAD", "CFTHREAD", "VARIABLES"));

    public static Map GetArgumentCollection(FusionContext context) throws Throwable {
        String cfcName;
        UrlScope us;
        HttpServletRequest request = context.request;
        String attr = (String)context.pageContext.findAttribute("url.argumentCollection");
        if (attr == null) {
            attr = (String)context.pageContext.findAttribute("form.argumentCollection");
        }
        Struct argumentCollection = attr == null ? new Struct() : ((attr = attr.trim()).charAt(0) == '{' ? (Struct)JSONUtils.deserializeJSON(attr) : (Struct)FilterUtils.WDDXDeserialize(attr));
        if (!Boolean.getBoolean(ARGUMENT_COLLECTION_FLAG)) {
            Enumeration keys = argumentCollection.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                if (!disabledScopesForArgumentCollection.contains(key.toUpperCase())) continue;
                throw new InvalidArgumentCollectionException(key, disabledScopesForArgumentCollection.toString(), ARGUMENT_COLLECTION_FLAG);
            }
        }
        if ((us = (UrlScope)context.hiddenScope.get("URL")) != null) {
            Iterator attrs = us.keys();
            while (attrs.hasNext()) {
                String attrName = (String)attrs.next();
                if (attrName.equalsIgnoreCase("method") || attrName.equalsIgnoreCase("argumentCollection") || attrName.equalsIgnoreCase("returnFormat")) continue;
                argumentCollection.put(attrName, us.get(attrName));
            }
        }
        if (context.getRequest().getMethod().equalsIgnoreCase("post")) {
            Iterator fields = context.formScope.keys();
            while (fields.hasNext()) {
                String fieldName = (String)fields.next();
                if (fieldName.equalsIgnoreCase("method") || fieldName.equalsIgnoreCase("argumentCollection") || fieldName.equalsIgnoreCase("fieldNames") || fieldName.equalsIgnoreCase("returnFormat")) continue;
                argumentCollection.put(fieldName, context.formScope.get(fieldName));
            }
            Object obj = context.hiddenScope.get("URL");
            if (obj instanceof UrlScope) {
                UrlScope url = (UrlScope)obj;
                Iterator urlfields = url.keys();
                while (urlfields.hasNext()) {
                    String fieldName = (String)urlfields.next();
                    if (fieldName.equalsIgnoreCase("method") || fieldName.equalsIgnoreCase("argumentCollection") || fieldName.equalsIgnoreCase("fieldNames") || fieldName.equalsIgnoreCase("returnFormat")) continue;
                    argumentCollection.put(fieldName, url.get(fieldName));
                }
            }
        }
        if ((cfcName = (String)request.getAttribute("cfcName")) != null) {
            argumentCollection.put("name", (Object)cfcName);
        }
        return argumentCollection;
    }

    public static String WDDXSerialize(Object obj) throws Throwable {
        WddxSerializer ws = new WddxSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ws.serialize(obj, out);
        return out.toString("UTF8");
    }

    public static Object WDDXDeserialize(String str) throws Throwable {
        WddxDeserializer deserializer = new WddxDeserializer();
        InputSource source = new InputSource(new StringReader(str));
        return deserializer.deserialize(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void printReturnValue(Object returnValue, NeoPageContext pageContext, FusionContext context, TemplateProxy tp, String method, Map methodMetadata) throws Throwable {
        if (returnValue == null) return;
        PrintWriter out = context.response.getWriter();
        String returnFormat = (String)pageContext.findAttribute("url.returnFormat");
        if (returnFormat == null) {
            returnFormat = (String)pageContext.findAttribute("form.returnFormat");
        }
        returnFormat = returnFormat != null ? ServiceFactory.getSecurityService().crossSiteProtectString(returnFormat) : (methodMetadata != null ? (String)methodMetadata.get("returnFormat") : null);
        String string = returnFormat = returnFormat == null ? null : returnFormat.trim();
        if (returnFormat == null || returnFormat != null && returnFormat.equalsIgnoreCase("wddx")) {
            if (returnValue instanceof XmlNodeList) {
                pageContext.getResponse().setContentType("text/xml");
                out.print(returnValue.toString());
                return;
            } else {
                out.print(FilterUtils.WDDXSerialize(returnValue));
            }
            return;
        } else if (returnFormat.equalsIgnoreCase("plain")) {
            if (!(returnValue instanceof String) && !(returnValue instanceof Number) && !(returnValue instanceof Boolean) && !(returnValue instanceof CFBoolean) && !(returnValue instanceof Date) && !(returnValue instanceof XmlNodeList)) throw new InvalidPlainReturnFormatTypeException();
            out.print(returnValue);
            return;
        } else {
            Object sjObj;
            if (!returnFormat.equalsIgnoreCase("json")) throw new InvalidReturnFormatException(returnFormat);
            String queryFormat = (String)pageContext.findAttribute("url.queryFormat");
            if (queryFormat == null) {
                queryFormat = (String)pageContext.findAttribute("form.queryFormat");
            }
            String serializeQueryByColumns = null;
            if (queryFormat != null) {
                if ((queryFormat = queryFormat.trim()).equalsIgnoreCase("column")) {
                    serializeQueryByColumns = "column";
                } else if (queryFormat.equalsIgnoreCase("row")) {
                    serializeQueryByColumns = "row";
                } else {
                    if (!queryFormat.equalsIgnoreCase("struct")) throw new InvalidQueryFormatException(queryFormat);
                    serializeQueryByColumns = "struct";
                }
            }
            if (serializeQueryByColumns == null) {
                ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
                serializeQueryByColumns = appScope == null ? "row" : appScope.getApplicationSettings().getSerializeQueryFormat();
            }
            String json = null;
            Object v1 = sjObj = methodMetadata != null ? methodMetadata.get("secureJSON") : null;
            if (sjObj != null) {
                boolean isSecureJSON = Cast._boolean(sjObj);
                json = JSONUtils.serializeJSON(returnValue, serializeQueryByColumns, isSecureJSON);
            } else {
                json = JSONUtils.isJSON(returnValue) ? FilterUtils.checkForDouble(returnValue) : JSONUtils.serializeJSON(returnValue, serializeQueryByColumns);
            }
            out.print(json);
        }
    }

    private static String checkForDouble(Object returnValue) {
        boolean isNumber = returnValue instanceof Double;
        if (isNumber && System.getProperty("json.numberasdouble", "false").equalsIgnoreCase("true")) {
            return returnValue.toString();
        }
        return Cast._String(returnValue);
    }

    public static class InvalidArgumentCollectionException
    extends NeoException {
        public String disabledScope;
        public String allScopes;
        public String jvmFlag;

        public InvalidArgumentCollectionException(String disabledScope, String allScopes, String jvmFlag) {
            this.disabledScope = disabledScope;
            this.allScopes = allScopes;
            this.jvmFlag = jvmFlag;
        }
    }

    public static class InvalidPlainReturnFormatTypeException
    extends NeoException {
    }

    public static class InvalidQueryFormatException
    extends NeoException {
        public String queryFormat;

        public InvalidQueryFormatException(String queryFormat) {
            this.queryFormat = CFPage.EncodeForHTML(queryFormat);
        }
    }

    public static class InvalidReturnFormatException
    extends NeoException {
        public String returnFormat;

        public InvalidReturnFormatException(String returnFormat) {
            this.returnFormat = CFPage.EncodeForHTML(returnFormat);
        }
    }
}

