/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class HTTPMethodFilter
implements Filter {
    public static final String ALLOWED_HTTP_METHODS_CONFIG_PARAM = "allowedHTTPMethods";
    public static final String ALLOWED_HTTP_METHODS_DELIMITER = ",";
    public static final String WILDCARD = "*";
    private Set<String> allowedHTTPMethods = null;
    private boolean allowAllMethods = false;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String httpMethod = ((HttpServletRequest)request).getMethod().toUpperCase();
        if (this.allowAllMethods || this.allowedHTTPMethods.contains(httpMethod)) {
            filterChain.doFilter(request, response);
        } else {
            ((HttpServletResponse)response).sendError(405);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String allowedMethodsParam = config.getInitParameter(ALLOWED_HTTP_METHODS_CONFIG_PARAM);
        HashSet<String> httpMethodsSet = new HashSet<String>();
        if (allowedMethodsParam != null && (allowedMethodsParam = allowedMethodsParam.trim()).length() > 0) {
            String[] httpMethods;
            if (allowedMethodsParam.contains(WILDCARD)) {
                this.allowAllMethods = true;
                return;
            }
            allowedMethodsParam = allowedMethodsParam.toUpperCase();
            for (String httpMethod : httpMethods = allowedMethodsParam.split(ALLOWED_HTTP_METHODS_DELIMITER)) {
                if ((httpMethod = httpMethod.trim()).length() <= 0) continue;
                httpMethodsSet.add(httpMethod);
            }
        }
        this.allowedHTTPMethods = httpMethodsSet;
    }
}

