/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.runtime.FastArray;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;

public class NoCacheFilter
extends FusionFilter {
    private static final String NO_CACHE_FLAG = "_cf_nocache";
    private static final String TRUE = "true";

    public NoCacheFilter(FusionFilter next) {
        super(next);
    }

    @Override
    public void invoke(FusionContext context) throws Throwable {
        Map urlScope = (Map)context.hiddenScope.get("URL");
        Map formScope = (Map)context.hiddenScope.get("FORM");
        String noCache = (String)urlScope.get(NO_CACHE_FLAG);
        if (noCache == null && formScope != null) {
            Object nocache_field = formScope.get(NO_CACHE_FLAG);
            if (nocache_field instanceof FastArray) {
                FastArray fieldarr = (FastArray)nocache_field;
                noCache = (String)fieldarr.get(0);
            } else {
                noCache = (String)nocache_field;
            }
        }
        if (noCache != null && noCache.equalsIgnoreCase(TRUE)) {
            HttpServletResponse res = context.getResponse();
            res.setHeader("Expires", "0");
            res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            res.setHeader("Pragma", "public");
        }
        this.next.invoke(context);
    }
}

