/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.bootstrap.AppServerUtils;
import coldfusion.compiler.ParseException;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.AppEventInvoker;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.Scope;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.TemplateNotFoundException;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.util.Utils;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;

public final class PathFilter
extends FusionFilter {
    private ServletContext servletContext;
    private String calledPage = null;

    public PathFilter(FusionFilter next, Servlet servlet) {
        super(next);
        this.servletContext = servlet.getServletConfig().getServletContext();
    }

    public PathFilter(FusionFilter next, String calledPath) {
        super(next);
        this.calledPage = calledPath;
    }

    @Override
    public void invoke(FusionContext context) throws Throwable {
        String calledPage = Utils.getServletPath(context.request);
        calledPage = Utils.canonicalizeURI(calledPage);
        int appServerType = AppServerUtils.getAppServerType();
        if (appServerType != 0 && appServerType != 1 && appServerType != 2 && appServerType != 7 && calledPage.regionMatches(true, 0, "/WEB-INF/", 0, 9)) {
            throw new TemplateNotFoundException(calledPage);
        }
        Object calledRealPath = null;
        calledRealPath = null != this.servletContext ? this.servletContext.getRealPath(calledPage) : this.calledPage;
        if (calledRealPath == null) {
            String rootDir = this.servletContext.getRealPath("/");
            calledRealPath = !calledPage.startsWith("/") ? "/" + calledPage : calledPage;
            calledRealPath = rootDir + (String)calledRealPath;
            if ((calledRealPath = Utils.getCanonicalPath((String)calledRealPath)) == null) {
                throw new TemplateNotFoundException(calledPage);
            }
        }
        FusionContext oldContext = FusionContext.setCurrent(context);
        try {
            context.setPagePath((String)calledRealPath);
            Class pageClass = TemplateClassLoader.findClassFromCache((String)calledRealPath);
            if (pageClass != null) {
                this.resolveApplicationScope(context, (String)calledRealPath, (TemplateClassLoader)pageClass.getClassLoader());
            } else {
                this.resolveApplicationScope(context, (String)calledRealPath, null);
                pageClass = TemplateClassLoader.findClass(context.getServletContext(), (String)calledRealPath);
                if (pageClass == null) {
                    pageClass = this.getCFCClassForAjaxProxy(calledPage, context);
                    if (pageClass == null) {
                        context.setMissingTemplate(true);
                    } else {
                        calledRealPath = context.getPagePath();
                    }
                }
            }
            this.next.invoke(context);
            if (context.isMissingTemplate()) {
                throw new TemplateNotFoundException(calledPage);
            }
        }
        catch (ParseException pex) {
            try {
                DebuggingService debuggingService = ServiceFactory.getDebuggingService();
                if (debuggingService != null && debuggingService.getDebugger() != null) {
                    if (debuggingService.check(1)) {
                        Object sPath = calledRealPath;
                        debuggingService.getDebugger().template((String)sPath, System.currentTimeMillis(), System.currentTimeMillis());
                    }
                }
            }
            catch (ServiceFactory.ServiceNotAvailableException serviceNotAvailableException) {
                // empty catch block
            }
            throw pex;
        }
        finally {
            FusionContext.setCurrent(oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveApplicationScope(FusionContext context, String templatePath, TemplateClassLoader cls) throws Throwable {
        block12: {
            context = FusionContext.getCurrent();
            File appPathFile = TemplateClassLoader.findApplicationFile(cls, null);
            String applicationPath = null;
            if (appPathFile != null) {
                context.setApplicationPath(appPathFile.getParent());
                context.setApplicationFile(appPathFile);
                applicationPath = appPathFile.getPath();
            }
            if (applicationPath != null && applicationPath.endsWith(".cfc")) {
                AppEventInvoker appProxy = null;
                boolean oldMapping = context.setUseMappings(true);
                try {
                    appProxy = new AppEventInvoker(applicationPath);
                    AppHelper helper = new AppHelper(context.pageContext, appProxy, appProxy.getThisScope(), context);
                    context.setAppHelper(helper);
                    helper.validateMappings();
                    Scope appScope = helper.connectApplication();
                    if (appScope instanceof ApplicationScope) {
                        ApplicationScope app = (ApplicationScope)appScope;
                        app.setEventInvoker(appProxy);
                    }
                    helper.applyAppSettings((ApplicationScope)appScope);
                }
                catch (AbortException abex) {
                    if (context.getApplicationEventEnableStatus() && appProxy != null) {
                        appProxy.onAbort(new Object[]{context.getRequest().getServletPath()}, context);
                    }
                    throw abex;
                }
                catch (Throwable t) {
                    if (appProxy != null && appProxy.isMethodPresent("OnError")) {
                        appProxy.onError(new Object[]{t, ""}, context);
                        break block12;
                    }
                    if (t instanceof NeoException) {
                        throw (NeoException)t;
                    }
                    throw new ApplicationTemplateResolutionException(t, templatePath);
                }
                finally {
                    context.setUseMappings(oldMapping);
                }
            }
        }
    }

    private Class getCFCClassForAjaxProxy(String calledPage, FusionContext context) throws IOException {
        String appName_url = AjaxUtils.decryptAppName();
        if (appName_url != null && calledPage.endsWith(".cfc")) {
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName_url);
            if (appScope != null) {
                FusionContext.SymTab_setApplicationScope(appScope);
                context.setApplicationName(appScope.getName());
            }
            boolean oldUseMappings = context.setUseMappings(true);
            String calledRealPath = context.getRealPath(calledPage);
            context.setUseMappings(oldUseMappings);
            context.setPagePath(calledRealPath);
            return TemplateClassLoader.findClass(context.getServletContext(), calledRealPath);
        }
        return null;
    }

    public static class ApplicationTemplateResolutionException
    extends ApplicationException {
        public String templateName;

        ApplicationTemplateResolutionException(Throwable t, String templateName) {
            super(t);
            this.templateName = templateName;
        }
    }
}

