/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Vector;
import javax.security.auth.Subject;

public class SecurityFilter
extends FusionFilter {
    private String templatePath;
    private static final HashSet emptySet = new HashSet();

    public SecurityFilter(FusionFilter next) {
        super(next);
    }

    @Override
    public void invoke(final FusionContext context) throws Throwable {
        HttpServletRequest request = (HttpServletRequest)context.pageContext.getRequest();
        try {
            if (request.getUserPrincipal() != null) {
                Subject subject = this.getSubject(request);
                String requestURL = request.getRequestURL().toString();
                AccessControlContext userContext = this.getAccessControlContext(subject, requestURL);
                Subject.doAsPrivileged(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            SecurityFilter.this.next.invoke(context);
                            return null;
                        }
                        catch (Error ex) {
                            throw ex;
                        }
                        catch (Throwable ex) {
                            throw (Exception)ex;
                        }
                    }
                }, userContext);
            } else {
                this.next.invoke(context);
            }
        }
        catch (SecurityException ex) {
            throw new AuthorizationException(ex);
        }
    }

    private AccessControlContext getAccessControlContext(Subject subject, String requestURL) throws Throwable {
        CodeSource cs = new CodeSource(new URL(requestURL), (Certificate[])null);
        PermissionCollection collection = Policy.getPolicy().getPermissions(cs);
        ProtectionDomain[] pds = new ProtectionDomain[]{new ProtectionDomain(cs, collection, null, subject.getPrincipals().toArray(new Principal[subject.getPrincipals().size()]))};
        return new AccessControlContext(pds);
    }

    private Subject getSubject(HttpServletRequest request) {
        Vector roles;
        Principal p = request.getUserPrincipal();
        if (p == null) {
            return null;
        }
        SecurityService ss = ServiceFactory.getSecurityService();
        String context_path = request.getContextPath();
        if (context_path.length() == 0) {
            context_path = "/";
        }
        if ((roles = null) != null) {
            HashSet<RolePrincipal> set = new HashSet<RolePrincipal>();
            int count = roles.size();
            for (int i = 0; i < count; ++i) {
                String role = (String)roles.elementAt(i);
                if (!request.isUserInRole(role)) continue;
                RolePrincipal rp = new RolePrincipal(role);
                set.add(rp);
            }
            return new Subject(true, set, emptySet, emptySet);
        }
        return null;
    }

    public static class AuthorizationException
    extends coldfusion.runtime.SecurityException {
        AuthorizationException(SecurityException ex) {
            super(ex.getMessage());
        }
    }

    private static class RolePrincipal
    implements Principal {
        String name;

        RolePrincipal(String n) {
            this.name = n;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

