/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.UDFMethod;
import coldfusion.util.RB;
import java.io.File;

public class ServerCFCFilter
extends FusionFilter {
    private static final String TIMEOUT = "timeout";
    private String cfcPath;

    public ServerCFCFilter(String cfcPath) {
        super(null);
        this.cfcPath = cfcPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(FusionContext fusionContext) throws Throwable {
        FusionContext oldContext = FusionContext.setCurrent(fusionContext);
        boolean useMap = true;
        TemplateProxy template = null;
        try {
            useMap = fusionContext.setUseMappings(true);
            String methodName = "OnServerStart";
            template = this.getOnSSTemplate(fusionContext, template);
            if (template.page != null && template.page.getPagePath() != null) {
                fusionContext.pageContext.getRequest().setAttribute("jakarta.servlet.include.servlet_path", (Object)template.page.getPagePath());
            }
            UDFMethod method = template.resolveMethod(methodName, false);
            long timeout = this.getTimeout(method);
            this.runOnSS(template, methodName, fusionContext, timeout);
        }
        finally {
            fusionContext.setUseMappings(useMap);
            FusionContext.setCurrent(oldContext);
            if (template != null) {
                template.release();
                template = null;
            }
        }
    }

    private void runOnSS(TemplateProxy template, String methodName, FusionContext fusionContext, long timeout) throws Throwable {
        OnSSLaunchThread onSSThread = new OnSSLaunchThread(template, methodName, fusionContext);
        onSSThread.start();
        onSSThread.join(timeout);
        if (onSSThread.isAlive()) {
            onSSThread.interrupt();
            throw new Exception(RB.getString((Object)this, "ServerCFCFilter.stop", timeout / 1000L));
        }
        if (onSSThread.getThrowable() != null) {
            throw onSSThread.getThrowable();
        }
    }

    private long getTimeout(UDFMethod method) throws Exception {
        long timeout = 0L;
        AttributeCollection metadata = (AttributeCollection)method.getMetadata();
        String to = (String)metadata.get(TIMEOUT);
        if (to != null) {
            try {
                timeout = 1000L * Long.parseLong(to);
            }
            catch (NumberFormatException e) {
                throw new Exception(RB.getString((Object)this, "ServerCFCFilter.timeout", (Object)to));
            }
        }
        return timeout;
    }

    private TemplateProxy getOnSSTemplate(FusionContext fusionContext, TemplateProxy template) throws Throwable {
        if (this.cfcPath.endsWith(".cfc")) {
            File cfc = new File(this.cfcPath);
            if (!cfc.exists()) {
                throw new Exception(RB.getString((Object)this, "ServerCFCFilter.onserverstart", (Object)this.cfcPath));
            }
            template = TemplateProxyFactory.resolveFile(fusionContext.pageContext, cfc);
        } else {
            template = TemplateProxyFactory.resolveName(this.cfcPath, fusionContext.pageContext);
        }
        template.page = template.setupScopesForInvoke(template.page.pageContext, fusionContext);
        return template;
    }

    private static class OnSSLaunchThread
    extends Thread {
        private TemplateProxy template;
        private String methodName;
        private FusionContext fusionContext;
        private Throwable throwable;

        OnSSLaunchThread(TemplateProxy template, String methodName, FusionContext fusionContext) {
            this.template = template;
            this.methodName = methodName;
            this.fusionContext = fusionContext;
        }

        @Override
        public void run() {
            try {
                FusionContext.setCurrent(this.fusionContext);
                Object[] args = new Object[]{};
                this.template.invoke(this.methodName, args, null, this.template.page, this.fusionContext);
            }
            catch (Throwable throwable) {
                this.throwable = throwable;
            }
        }

        Throwable getThrowable() {
            return this.throwable;
        }
    }
}

