/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.filter;

import coldfusion.runtime.CFPage;
import coldfusion.runtime.locale.CFLocale;
import coldfusion.runtime.locale.CFLocaleBase;
import coldfusion.tagext.validation.CFIntegerValidator;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.tagext.validation.InvalidSimpleTypeException;
import coldfusion.util.DateUtils;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class StringValidator {
    static Pattern numericNoisePattern;

    public static boolean validateDate(String dateString) {
        if (dateString.length() == 0) {
            return true;
        }
        return DateUtils.isDate(dateString);
    }

    public static boolean validateDate(String dateString, CFLocale cfLocale) {
        if (dateString.length() == 0) {
            return true;
        }
        if (CFLocaleBase.isNumberOnly(dateString)) {
            return false;
        }
        return cfLocale.IsDate(dateString);
    }

    public static boolean validateFloat(String floatString) {
        if (floatString.length() == 0) {
            return true;
        }
        try {
            floatString = StringValidator.stripNumericNoise(floatString, false);
        }
        catch (Exception ex) {
            return false;
        }
        return CFPage.IsNumeric(floatString);
    }

    public static boolean validateRange(String numberString, Double min, Double max) {
        double value;
        if (numberString.length() == 0) {
            return true;
        }
        try {
            value = Double.parseDouble(numberString);
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        if (min != null && max != null) {
            if (value >= min && value <= max) {
                return true;
            }
        } else if (min != null) {
            if (value >= min) {
                return true;
            }
        } else if (max != null) {
            if (value <= max) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean validateTime(String timeString) {
        return StringValidator.validateDate(timeString);
    }

    public static String stripNumericNoise(String input, boolean integer) {
        if (!CFNumberValidator.checkValidNumericNoise(input, integer)) {
            if (integer) {
                throw new CFIntegerValidator.IntegerParseException(input);
            }
            throw new InvalidSimpleTypeException("numeric");
        }
        return Util.substitute((PatternMatcher)new Perl5Matcher(), (Pattern)numericNoisePattern, (Substitution)new Perl5Substitution("", 0), (String)input, (int)-1);
    }

    static {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            numericNoisePattern = compiler.compile("[$\u00a3\u00a5\u0080,~+]", 32768);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
        }
    }
}

