/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.graph.ChartAttributeMapper;
import coldfusion.graph.GraphCommon;
import coldfusion.graph.GraphDataPoint;
import coldfusion.graph.IChartConstants;
import coldfusion.graph.IChartSeries;
import coldfusion.graph.InteractiveChart;
import coldfusion.graph.StyleApplicator;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.NeoException;
import coldfusion.util.RuntimeWrapper;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;

public class ChartSeries
implements IChartSeries,
IChartConstants {
    private List<String> chartDataItemList;
    private List<Object> chartDataValueList;
    private List<Object> chartDataZValueList;
    private List<Double> chartOutlierList;
    private List<Object> chartDataBoxvalue;
    private Object key;
    private Map<String, Object> itemValueMap = new HashMap<String, Object>();
    private List colorList;
    private String seriesColor;
    private String label;
    private ResultSet query;
    private String itemColumn;
    private String valueColumn;
    private String type;
    private String originalSeriesType;
    private boolean show3D;
    private String zColumn;
    private double alpha = -1.0;
    private String aspect;
    private Map<String, Object> animate;
    private Map<String, String> background;
    private Object bevel;
    private Map<String, String> border;
    private Map<String, Object> marker;
    private Map<String, Object> hoverMarker;
    private Map<String, Object> tooltip;
    private Object shadow;
    private Object data;
    private String scales;
    private String markerStyle;
    private String dataLabelStyle;
    private Map dataFormat;
    private List<Map> rules;
    private static HashMap<String, String> markerStyles = new HashMap(14);
    private static HashMap<String, String> dataLabelStyles;
    private Logger logger = CFLogs.APPLICATION_LOG;

    private boolean isValidMarkerStyle(String style) {
        return markerStyles.containsKey(style.toLowerCase());
    }

    public ChartSeries() {
        this.chartDataValueList = new ArrayList<Object>();
        this.chartDataItemList = new ArrayList<String>();
        this.chartDataZValueList = new ArrayList<Object>();
        this.chartOutlierList = new ArrayList<Double>();
        this.chartDataBoxvalue = new ArrayList<Object>();
    }

    public String getChartType() {
        return this.type;
    }

    public Object getKey() {
        return this.key;
    }

    public void setShow3D(boolean show3d) {
        this.show3D = show3d;
    }

    private String getZColumn() {
        return this.zColumn;
    }

    @Override
    public void setQuery(ResultSet query) {
        this.query = query;
    }

    public ResultSet getQuery() {
        return this.query;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setAspect(String aspect) {
        this.aspect = aspect;
    }

    public void setAnimate(Map<String, Object> animate) {
        this.animate = animate;
    }

    public void setBackground(Map<String, String> background) {
        this.background = background;
    }

    public void setBevel(Object bevel) {
        this.bevel = bevel;
    }

    public void setBorder(Map<String, String> border) {
        this.border = border;
    }

    public void setMarker(Map<String, Object> marker) {
        this.marker = marker;
    }

    public void setHovermarker(Map<String, Object> hoverMarker) {
        this.hoverMarker = hoverMarker;
    }

    public void setTooltip(Map<String, Object> tooltip) {
        this.tooltip = tooltip;
    }

    public void setShadow(Object shadow) {
        this.shadow = shadow;
    }

    public void setDataFormat(Map dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setRules(List<Map> rules) {
        this.rules = rules;
    }

    @Override
    public void addDataPoint(GraphDataPoint dataPoint) {
        if (this.chartDataItemList == null) {
            this.chartDataItemList = new ArrayList<String>();
        }
        if (this.chartDataValueList == null) {
            this.chartDataValueList = new ArrayList<Object>();
        }
        if (this.chartDataZValueList == null) {
            this.chartDataZValueList = new ArrayList<Object>();
        }
        this.chartDataItemList.add(dataPoint.getItem());
        this.chartDataValueList.add(ChartSeries.convertToNumber(dataPoint.getValue()));
        this.chartDataZValueList.add(ChartSeries.convertToNumber(dataPoint.getZValue()));
    }

    public void processSeriesData(InteractiveChart interactiveChart) {
        if (this.query == null && interactiveChart.getQuery() != null) {
            this.query = interactiveChart.getQuery();
        }
        if (this.itemColumn == null && interactiveChart.getItemColumn() != null) {
            this.itemColumn = interactiveChart.getItemColumn();
        }
        this.processQueryData();
        this.processData(interactiveChart.type);
    }

    private void processData(String outerchartType) {
        if (this.data != null) {
            if (!this.isBoxplotChart(outerchartType) && !this.isBoxplotChart(this.type)) {
                if (this.data instanceof List) {
                    int lastPointDimension = -1;
                    for (List dataPoint : (List)this.data) {
                        int pointDimension = dataPoint.size();
                        if (lastPointDimension != -1 && pointDimension != lastPointDimension) {
                            throw new DataPointException((List)this.data);
                        }
                        if (pointDimension == 1) {
                            this.addValue(ChartSeries.convertToNumber(dataPoint.get(0)));
                        } else if (pointDimension > 1) {
                            this.addItem(dataPoint.get(0));
                            this.addValue(ChartSeries.convertToNumber(dataPoint.get(1)));
                        }
                        if (pointDimension >= 3) {
                            this.addZValue(ChartSeries.convertToNumber(dataPoint.get(2)));
                        }
                        lastPointDimension = pointDimension;
                    }
                }
            } else {
                Object lastPointDimension = this.data;
                if (lastPointDimension instanceof List) {
                    List rawData = (List)lastPointDimension;
                    if (!this.validateBoxplotArray(rawData)) {
                        throw new InvalidDataException("data");
                    }
                    this.processBoxplotData(rawData);
                } else if (this.data instanceof Map) {
                    Map data = (Map)this.data;
                    this.validateDataKeys(data);
                    this.key = data.getOrDefault("key", null);
                    if (data.containsKey("data")) {
                        List rawData = (List)data.get("data");
                        if (!this.validateBoxplotArray(rawData)) {
                            throw new InvalidDataException("data");
                        }
                        this.processBoxplotData(rawData);
                    } else {
                        this.chartDataBoxvalue = (List)data.get("dataBox");
                        this.chartOutlierList = data.getOrDefault("dataOutlier", new ArrayList());
                        if (!this.validateBoxplotArray(this.chartDataBoxvalue)) {
                            throw new InvalidDataException("dataBox");
                        }
                        if (!this.validateBoxplotArray(this.chartOutlierList)) {
                            throw new InvalidDataException("dataOutlier");
                        }
                        if (!this.chartOutlierList.isEmpty()) {
                            this.chartOutlierList = this.processListValues(this.chartOutlierList);
                        }
                    }
                }
            }
        }
    }

    private List processDataOutlier(int seriesNum) {
        ArrayList processedOutliers = new ArrayList();
        for (Double outlier : this.chartOutlierList) {
            ArrayList<Number> dataOutlierValue = new ArrayList<Number>();
            dataOutlierValue.add(seriesNum);
            dataOutlierValue.add(outlier);
            processedOutliers.add(dataOutlierValue);
        }
        return processedOutliers;
    }

    private boolean validateBoxplotArray(List array) {
        return array.stream().allMatch(value -> CfJspPage.internalIsNumeric(value));
    }

    private void validateInvalidColumn(List array) {
        if (array.stream().allMatch(value -> value == null)) {
            throw new InvalidValueColumnException();
        }
    }

    private void validateDataKeys(Map data) {
        if (!(data.containsKey("dataBox") ^ data.containsKey("data"))) {
            throw new DataRequiredException("Either data or dataBox");
        }
        if (data.containsKey("data") && !data.containsKey("key")) {
            throw new DataRequiredException("key");
        }
        if (data.containsKey("dataBox") && ((List)data.get("dataBox")).size() != 5) {
            throw new DataBoxLengthException();
        }
    }

    private void addZValue(Object zValue) {
        this.chartDataZValueList.add(zValue);
    }

    private void addItem(Object o) {
        this.chartDataItemList.add(o == null ? "null" : String.valueOf(o));
    }

    private void addValue(Object value) {
        this.chartDataValueList.add(value);
    }

    private void addOutlier(Double dataOutlierValue) {
        this.chartOutlierList.add(dataOutlierValue);
    }

    private void processBoxplotData(List rawData) {
        double q3;
        double q1;
        int size = rawData.size();
        List<Object> data = new ArrayList();
        if (size == 0) {
            throw new EmptyDataArrayException();
        }
        data = this.processListValues(rawData);
        if (size == 1) {
            double val = (Double)data.get(0);
            this.chartDataBoxvalue = List.of(Double.valueOf(val), Double.valueOf(val), Double.valueOf(val), Double.valueOf(val), Double.valueOf(val));
            return;
        }
        Collections.sort(data);
        double median = this.calculateMedian(data, 0, size);
        int subArrSize = size / 2;
        if (size % 2 != 0) {
            q1 = this.calculateMedian(data, 0, subArrSize);
            q3 = this.calculateMedian(data, subArrSize + 1, subArrSize);
        } else {
            q1 = this.calculateMedian(data, 0, subArrSize);
            q3 = this.calculateMedian(data, subArrSize, subArrSize);
        }
        double iqr = q3 - q1;
        double lowerFence = q1 - 1.5 * iqr;
        double upperFence = q3 + 1.5 * iqr;
        int i = 0;
        while ((Double)data.get(i) < lowerFence) {
            this.addOutlier((Double)data.get(i));
            ++i;
        }
        double min = (Double)data.get(i);
        i = size - 1;
        while ((Double)data.get(i) > upperFence) {
            this.addOutlier((Double)data.get(i));
            --i;
        }
        double max = (Double)data.get(i);
        this.chartDataBoxvalue = List.of(Double.valueOf(min), Double.valueOf(q1), Double.valueOf(median), Double.valueOf(q3), Double.valueOf(max));
    }

    private double calculateMedian(List<Double> data, int startidx, int size) {
        if (size % 2 != 0) {
            return data.get(startidx + size / 2);
        }
        return (data.get(startidx + size / 2 - 1) + data.get(startidx + size / 2)) / 2.0;
    }

    private void processQueryData() {
        ResultSet query = this.getQuery();
        if (query != null && (this.getItemColumn() != null || this.getValueColumn() != null || this.getZColumn() != null)) {
            try {
                int itemColumnIndex = -1;
                int valueColumnIndex = -1;
                int zColumnIndex = -1;
                if (this.getItemColumn() != null) {
                    itemColumnIndex = query.findColumn(this.getItemColumn());
                }
                if (this.getValueColumn() != null) {
                    valueColumnIndex = query.findColumn(this.getValueColumn());
                }
                if (this.getZColumn() != null) {
                    zColumnIndex = query.findColumn(this.getZColumn());
                }
                while (query.next()) {
                    if (query.isFirst() && itemColumnIndex != -1 && (valueColumnIndex != -1 || zColumnIndex != -1)) {
                        this.chartDataItemList.clear();
                        this.chartDataValueList.clear();
                        this.chartDataZValueList.clear();
                    }
                    if (itemColumnIndex != -1) {
                        String item = query.getString(itemColumnIndex);
                        this.addItem(ChartSeries.convertToNumber(item));
                    }
                    if (zColumnIndex != -1) {
                        String z = query.getString(zColumnIndex);
                        this.addZValue(ChartSeries.convertToNumber(z));
                    }
                    if (valueColumnIndex == -1) continue;
                    String value = query.getString(valueColumnIndex);
                    this.addValue(ChartSeries.convertToNumber(value));
                }
            }
            catch (Exception sqle) {
                throw new RuntimeWrapper(sqle);
            }
        }
    }

    private boolean isZValueChart(Map<String, Object> graph) {
        return this.isInstanceOfChart(graph, "bubble") || this.isInstanceOfChart(graph, "gauge");
    }

    @Override
    public void setItemColumn(String itemColumn) {
        this.itemColumn = itemColumn;
    }

    @Override
    public void setZColumn(String zColumn) {
        this.zColumn = zColumn;
    }

    public String getItemColumn() {
        return this.itemColumn;
    }

    public List<Object> getZcolumnList() {
        return ListUtils.unmodifiableList(this.chartDataZValueList);
    }

    @Override
    public void setValueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    @Override
    public void setChartType(String type) {
        this.originalSeriesType = type;
        if (!InteractiveChart.isValidChartType(type = type.toLowerCase())) {
            throw new GraphCommon.InvalidChartTypeException(type);
        }
        this.type = InteractiveChart.handleOldChartTypes(type);
    }

    private void setSeriesItemValueMap() {
        int size = this.chartDataItemList.size() < this.chartDataValueList.size() ? this.chartDataItemList.size() : this.chartDataValueList.size();
        for (int i = 0; i < size; ++i) {
            this.itemValueMap.put(this.chartDataItemList.get(i), this.chartDataValueList.get(i));
        }
    }

    private List<Object> constructChartValues(List<String> fullItemList) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String item : fullItemList) {
            values.add(this.itemValueMap.getOrDefault(item, 0));
        }
        return values;
    }

    Map<String, Object> mergeSeries(int seriesNum, Map<String, Object> graph, int size, String outerChartType, String originalChartType, List<String> fullItemList, boolean isThemeDefined) {
        List<Object> values = this.getValueList();
        ArrayList<Map<String, Object>> seriesList = (ArrayList<Map<String, Object>>)graph.get("series");
        Map<String, Object> series = null;
        List<Object> outliers = this.getOutlierList();
        List<Object> databoxVal = this.getDataBoxList();
        ArrayList<List<Object>> databoxList = null;
        ArrayList outlierList = null;
        int seriesNumTemp = 0;
        if (seriesList != null && !seriesList.isEmpty()) {
            Map seriesListMap = (Map)seriesList.get(0);
            if (seriesListMap.containsKey("dataBox")) {
                databoxList = seriesListMap.getOrDefault("dataBox", new ArrayList());
            }
            if (seriesListMap.containsKey("dataOutlier")) {
                outlierList = seriesListMap.getOrDefault("dataOutlier", new ArrayList());
            }
        }
        this.setSeriesItemValueMap();
        if (this.isBoxplotChart(originalChartType) || this.isBoxplotChart(outerChartType)) {
            seriesNumTemp = seriesNum;
            seriesNum = 0;
            if (this.valueColumn != null && values != null && databoxVal.isEmpty()) {
                this.validateInvalidColumn(this.chartDataValueList);
                if (!this.validateBoxplotArray(this.chartDataValueList)) {
                    throw new InvalidDataException("data");
                }
                this.processBoxplotData(this.chartDataValueList);
                outliers = this.getOutlierList();
                databoxVal = this.getDataBoxList();
            }
        }
        if (this.isRequiredChartType(graph) && size == 1) {
            if (seriesList == null) {
                seriesList = new ArrayList(values.size());
            }
            graph.put("series", seriesList);
            List<String> itemList = this.getItemList();
            for (int i = 0; i < values.size(); ++i) {
                try {
                    series = (Map)seriesList.get(i);
                }
                catch (IndexOutOfBoundsException ioe) {
                    series = new HashMap();
                    seriesList.add(series);
                }
                this.setChartType(series, outerChartType);
                if (!isThemeDefined) {
                    StyleApplicator.applyStyle(i, graph, series, outerChartType);
                }
                ArrayList<Object> valueVector = new ArrayList<Object>(1);
                valueVector.add(ChartSeries.convertToNumber(values.get(i)));
                series.put("values", valueVector);
                try {
                    this.setSeriesLabel(series, Cast._String(itemList.get(i)));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                List<Object> zColumnList = this.getZcolumnList();
                if (zColumnList != null) {
                    try {
                        if (zColumnList.get(i) != null) {
                            if (this.isInstanceOfChart(graph, "gauge")) {
                                series.put("size", zColumnList.get(i));
                            } else if (this.isVennChart(graph)) {
                                ArrayList<Object> joinVector = new ArrayList<Object>(1);
                                joinVector.add(zColumnList.get(i));
                                series.put("join", joinVector);
                            }
                        }
                    }
                    catch (Throwable joinVector) {
                        // empty catch block
                    }
                }
                this.setSeriesColor(series, true, false, i, true);
                this.mergeDirectChartingEngineAttributes(series);
                this.handleMarkerStyle(series);
                this.handleDataLabelStyle(series);
            }
        } else {
            block55: {
                if (seriesList == null) {
                    seriesList = new ArrayList<Map<String, Object>>(size);
                    graph.put("series", seriesList);
                }
                if (this.colorList != null) {
                    Map<String, Object> plot = InteractiveChart.retrieveMapFragment(graph, "plot", true);
                    ArrayList rules = (ArrayList)plot.get("rules");
                    if (rules == null) {
                        rules = new ArrayList(this.colorList.size());
                        plot.put("rules", rules);
                    }
                    for (int i = 0; i < this.colorList.size(); ++i) {
                        HashMap<String, Object> rule = new HashMap<String, Object>();
                        String color = (String)this.colorList.get(i);
                        rule.put("rule", "%i==" + i);
                        rule.put("background-color", color);
                        rule.put("background-color-2", color);
                        rule.put("line-color", color);
                        rules.add(rule);
                    }
                }
                try {
                    series = (HashMap<String, Object>)seriesList.get(seriesNum);
                }
                catch (IndexOutOfBoundsException ioe) {
                    if (!this.isInstanceOfChart(graph, "boxplot") && !this.isInstanceOfChart(graph, "hboxplot") || seriesList.size() == 0) {
                        series = new HashMap<String, Object>();
                        seriesList.add(series);
                    }
                    if (!this.isInstanceOfChart(graph, "boxplot") && !this.isInstanceOfChart(graph, "hboxplot")) break block55;
                    series = (Map)seriesList.get(0);
                }
            }
            this.setChartType(series, outerChartType);
            if (!isThemeDefined) {
                StyleApplicator.applyStyle(seriesNum, graph, series, outerChartType);
            }
            if (this.isInstanceOfChart(graph, "scatter")) {
                pointsList = this.constructScatterChartValues();
                series.put("values", pointsList);
            } else if (this.isInstanceOfChart(graph, "bubble")) {
                pointsList = this.constructBubbleChartValues();
                series.put("values", pointsList);
            } else if (this.isInstanceOfChart(graph, "boxplot") || this.isInstanceOfChart(graph, "hboxplot")) {
                if (seriesList != null && databoxList == null) {
                    databoxList = new ArrayList<List<Object>>();
                }
                databoxList.add(databoxVal);
                series.put("dataBox", databoxList);
                if (outliers.size() > 0) {
                    if (seriesList != null && outlierList == null) {
                        outlierList = new ArrayList();
                    }
                    outlierList.addAll(this.processDataOutlier(seriesNumTemp));
                    series.put("dataOutlier", outlierList);
                }
                if (this.key == null) {
                    this.key = seriesNumTemp;
                }
            } else {
                List<Object> valuesList = this.constructChartValues(fullItemList);
                series.put("values", valuesList);
            }
            if (this.isBulletChart(graph) && this.getZcolumnList() != null && this.getZcolumnList().size() > 0) {
                series.put("goals", this.getZcolumnList());
            }
            if (this.isVennChart(graph) && this.getZcolumnList() != null && this.getZcolumnList().size() > 0) {
                series.put("join", this.getZcolumnList());
            }
            if (this.isFBarChart(graph, this.originalSeriesType != null ? this.originalSeriesType : originalChartType) && this.getZcolumnList() != null && this.getZcolumnList().size() > 0) {
                series.put("offset-values", this.getZcolumnList());
            }
            this.setSeriesLabel(series, this.label);
            this.setSeriesColor(series, this.isPieChart(graph), this.isInstanceOfChart(graph, "line"), seriesNum, false);
            if (this.isCurveChart(graph, this.originalSeriesType != null ? this.originalSeriesType : originalChartType)) {
                series.put("aspect", "spline");
            } else if (this.isStepChart(graph, this.originalSeriesType != null ? this.originalSeriesType : originalChartType)) {
                series.put("aspect", "stepped");
            }
            if (this.isConeChart(graph, this.originalSeriesType != null ? this.originalSeriesType : originalChartType)) {
                series.put("aspect", "cone");
                if (series.get("alpha") == null) {
                    series.put("alpha", "0.75");
                }
            } else if (this.isCylinderChart(graph, this.originalSeriesType != null ? this.originalSeriesType : originalChartType)) {
                series.put("aspect", "cylinder");
                if (series.get("alpha") == null) {
                    series.put("alpha", "0.75");
                }
            } else if (this.isPyramidChart(graph, this.originalSeriesType != null ? this.originalSeriesType : originalChartType)) {
                series.put("aspect", "pyramid");
                if (series.get("alpha") == null) {
                    series.put("alpha", "0.75");
                }
            }
            if (this.isHistogramChart(graph, this.originalSeriesType != null ? this.originalSeriesType : originalChartType)) {
                series.put("aspect", "histogram");
            }
            this.mergeDirectChartingEngineAttributes(series);
            this.handleMarkerStyle(series);
            this.handleDataLabelStyle(series);
        }
        return series;
    }

    boolean isRequiredChartType(Map graph) {
        return (this.isPieChart(graph) || this.isRingChart(graph)) && (this.getItemColumn() != null || this.chartDataValueList != null && this.chartDataValueList.size() > 0 || this.data != null) || this.isInstanceOfChart(graph, "gauge") || this.isVennChart(graph) || this.isFunnelChart(graph);
    }

    List<Object> getValueList() {
        return ListUtils.unmodifiableList(this.chartDataValueList);
    }

    List<Object> getOutlierList() {
        return ListUtils.unmodifiableList(this.chartOutlierList);
    }

    List<Object> getDataBoxList() {
        return ListUtils.unmodifiableList(this.chartDataBoxvalue);
    }

    private void handleDataLabelStyle(Map<String, Object> series) {
        if (this.dataLabelStyle == null) {
            if (InteractiveChart.retrieveMapFragment(series, "value-box", false) == null) {
                return;
            }
            this.dataLabelStyle = "none";
        }
        Map<String, Object> seriesValueBox = InteractiveChart.retrieveMapFragment(series, "value-box");
        if ("value".equalsIgnoreCase(this.dataLabelStyle)) {
            seriesValueBox.put("text", "%v");
        } else if ("columnlabel".equalsIgnoreCase(this.dataLabelStyle)) {
            if ("pie".equalsIgnoreCase(this.type)) {
                seriesValueBox.put("text", "%t");
            } else {
                seriesValueBox.put("text", "%k");
            }
        } else if ("pattern".equalsIgnoreCase(this.dataLabelStyle)) {
            if ("pie".equalsIgnoreCase(this.type)) {
                seriesValueBox.put("text", "%v , %t");
            } else {
                seriesValueBox.put("text", "%v , %k");
            }
        } else if ("none".equalsIgnoreCase(this.dataLabelStyle)) {
            seriesValueBox.put("text", "");
        } else if ("rowlabel".equalsIgnoreCase(this.dataLabelStyle)) {
            seriesValueBox.put("text", this.label != null ? this.label : "");
        } else {
            seriesValueBox.put("text", this.dataLabelStyle);
        }
        seriesValueBox.put("offset-y", -10);
    }

    private void handleMarkerStyle(Map<String, Object> series) {
        if (this.markerStyle == null) {
            return;
        }
        Map<String, Object> marker = InteractiveChart.retrieveMapFragment(series, "marker");
        if ("none".equalsIgnoreCase(this.markerStyle)) {
            marker.remove("type");
        } else {
            marker.put("type", this.markerStyle);
        }
    }

    private void mergeDirectChartingEngineAttributes(Map<String, Object> series) {
        if (this.alpha != -1.0) {
            series.put("alpha", this.alpha);
        }
        if (this.aspect != null) {
            series.put("aspect", this.aspect);
        }
        if (this.animate != null) {
            series.put("animation", ChartAttributeMapper.getAnimation(this.animate));
        }
        InteractiveChart.handleDoubleLevelMappedAttributes(series, this.background, "background");
        if (this.bevel instanceof Map) {
            series.put("bevel", true);
            InteractiveChart.handleDoubleLevelMappedAttributes(series, (Map)this.bevel, "bevel");
        } else if (this.bevel != null) {
            try {
                boolean bev = Cast._boolean(this.bevel);
                series.put("bevel", bev);
            }
            catch (Exception bev) {
                // empty catch block
            }
        }
        InteractiveChart.handleDoubleLevelMappedAttributes(series, this.border, "border");
        if (this.marker != null) {
            series.put("marker", this.marker);
        }
        if (this.hoverMarker != null) {
            InteractiveChart.handleSingleLevelMappedAttributes(series, this.hoverMarker, "hovermarker");
        }
        if (this.tooltip != null) {
            series.put("tooltip", this.tooltip);
        }
        if (this.shadow instanceof Map) {
            series.put("shadow", true);
            InteractiveChart.handleDoubleLevelMappedAttributes(series, (Map)this.shadow, "shadow");
        } else if (this.shadow != null) {
            try {
                boolean shdw = Cast._boolean(this.shadow);
                series.put("shadow", shdw);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.scales != null) {
            InteractiveChart.handleScales(series, this.scales, true);
        }
        if (this.dataFormat != null && this.dataFormat instanceof Map) {
            for (Object key : this.dataFormat.keySet()) {
                series.put((String)key, this.dataFormat.get(key));
            }
        }
        if (this.rules != null) {
            series.put("rules", this.rules);
        }
    }

    private List constructScatterChartValues() {
        int itemsSize;
        List<Object> values = this.getValueList();
        List<String> items = this.getItemList();
        int valuesSize = values.size();
        int size = valuesSize < (itemsSize = items.size()) ? valuesSize : itemsSize;
        ArrayList pointsList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            ArrayList<Object> point2D = new ArrayList<Object>(2);
            point2D.add(ChartSeries.convertToNumber(items.get(i)));
            point2D.add(ChartSeries.convertToNumber(values.get(i)));
            pointsList.add(point2D);
        }
        return pointsList;
    }

    List<String> getItemList() {
        return ListUtils.unmodifiableList(this.chartDataItemList);
    }

    private List constructBubbleChartValues() {
        int itemsSize;
        List<Object> values = this.getValueList();
        List<String> items = this.getItemList();
        List<Object> zColumnList = this.getZcolumnList();
        int valuesSize = values.size();
        int size = valuesSize < (itemsSize = items.size()) ? valuesSize : itemsSize;
        ArrayList pointsList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            ArrayList<Object> point2D = new ArrayList<Object>(2);
            point2D.add(ChartSeries.convertToNumber(items.get(i)));
            point2D.add(ChartSeries.convertToNumber(values.get(i)));
            if (zColumnList != null) {
                try {
                    if (zColumnList.get(i) != null) {
                        point2D.add(ChartSeries.convertToNumber(zColumnList.get(i)));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            pointsList.add(point2D);
        }
        return pointsList;
    }

    private void setChartType(Map<String, Object> series, String outerChartType) {
        if ("pie".equalsIgnoreCase(outerChartType) || "nestedpie".equalsIgnoreCase(outerChartType) || "pie3d".equalsIgnoreCase(outerChartType) || "radar".equalsIgnoreCase(outerChartType) || "ring".equalsIgnoreCase(outerChartType) || "ring3d".equalsIgnoreCase(outerChartType) || this.isBoxplotChart(outerChartType)) {
            return;
        }
        String chartSeriesType = null;
        if (this.type != null) {
            chartSeriesType = this.type;
        } else if (outerChartType != null) {
            chartSeriesType = outerChartType;
        }
        if (chartSeriesType != null) {
            InteractiveChart.handleShow3D(series, this.show3D, chartSeriesType);
        }
    }

    private void setSeriesLabel(Map<String, Object> series, String type) {
        if (type != null) {
            series.put("text", type);
        }
    }

    private void setSeriesColor(Map<String, Object> series, boolean pie, boolean line, int index, boolean singleSeries) {
        String color = null;
        if (pie && singleSeries) {
            try {
                if (this.colorList == null) {
                    return;
                }
                color = (String)this.colorList.get(index);
                if (color != null && !color.startsWith("#")) {
                    color = ChartSeries.toHexColor(color);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            color = this.seriesColor;
            if (color != null && !color.startsWith("#")) {
                color = ChartSeries.toHexColor(color);
            }
        }
        if (color != null) {
            series.put("line-color", color);
            series.put("background-color", color);
            series.put("background-color-2", color);
            if (!pie) {
                Map<String, Object> marker = InteractiveChart.retrieveMapFragment(series, "marker");
                marker.put("background-color", color);
                marker.put("background-color-2", color);
                if (this.isBulletChart(series)) {
                    Map<String, Object> goal = InteractiveChart.retrieveMapFragment(series, "goal");
                    goal.put("background-color", color);
                    goal.put("background-color-2", color);
                }
            }
        }
        if (line) {
            if (color != null) {
                series.put("border-color", color);
            } else {
                Object lineColor = series.get("line-color");
                if (lineColor != null) {
                    series.put("border-color", lineColor);
                }
            }
        }
    }

    static String toHexColor(String aColor) {
        String color = aColor;
        try {
            color = GraphCommon.getHexColor(aColor);
        }
        catch (GraphCommon.UnsupportedColorException unsupportedColorException) {
            // empty catch block
        }
        return color;
    }

    private List<Double> processListValues(List data) {
        ArrayList<Double> processedList = new ArrayList<Double>();
        for (Object value : data) {
            Object val = ChartSeries.convertToNumber(value);
            if (val instanceof Long) {
                processedList.add(((Long)val).doubleValue());
                continue;
            }
            processedList.add((Double)val);
        }
        return processedList;
    }

    private static Object convertToNumber(Object value) {
        try {
            return ChartSeries._convertToNumber(value);
        }
        catch (Exception exception) {
            return value;
        }
    }

    static Object _convertToNumber(Object value) {
        double convertedValue = 0.0;
        if (value instanceof String) {
            String strValue = (String)value;
            try {
                convertedValue = Double.parseDouble(strValue);
            }
            catch (Throwable t) {
                return strValue;
            }
        } else if (value instanceof Number) {
            convertedValue = ((Number)value).doubleValue();
        } else {
            return value;
        }
        long iConvertedValue = (long)convertedValue;
        if ((double)iConvertedValue == convertedValue && convertedValue > -9.223372036854776E18 && convertedValue < 9.223372036854776E18) {
            return iConvertedValue;
        }
        return convertedValue;
    }

    private boolean isInstanceOfChart(Map<String, Object> chartJsonMap, String type) {
        String chartType = this.type;
        if (chartType == null) {
            chartType = (String)chartJsonMap.get("type");
        }
        return type.equalsIgnoreCase(chartType) || (type + "3d").equalsIgnoreCase(chartType);
    }

    private boolean isPieChart(Map<String, Object> graph) {
        String chartType = this.type;
        if (chartType == null) {
            chartType = (String)graph.get("type");
        }
        return "pie".equalsIgnoreCase(chartType) || "pie3d".equalsIgnoreCase(chartType) || "nestedpie".equalsIgnoreCase(chartType);
    }

    private boolean isRingChart(Map<String, Object> graph) {
        String chartType = this.type;
        if (chartType == null) {
            chartType = (String)graph.get("type");
        }
        return "ring".equalsIgnoreCase(chartType) || "ring3d".equalsIgnoreCase(chartType);
    }

    private boolean isCurveChart(Map<String, Object> graph, String chartType) {
        return "curve".equalsIgnoreCase(chartType) || "curve3d".equalsIgnoreCase(chartType) || "curvedarea".equalsIgnoreCase(chartType) || "curvedarea3d".equalsIgnoreCase(chartType);
    }

    private boolean isStepChart(Map<String, Object> graph, String chartType) {
        return "step".equalsIgnoreCase(chartType) || "step3d".equalsIgnoreCase(chartType) || "steppedarea".equalsIgnoreCase(chartType) || "steppedarea3d".equalsIgnoreCase(chartType);
    }

    private boolean isConeChart(Map<String, Object> graph, String chartType) {
        return "cone".equalsIgnoreCase(chartType);
    }

    private boolean isCylinderChart(Map<String, Object> graph, String chartType) {
        return "cylinder".equalsIgnoreCase(chartType);
    }

    private boolean isHistogramChart(Map<String, Object> graph, String chartType) {
        return "histogram".equalsIgnoreCase(chartType) || "hhistogram".equalsIgnoreCase(chartType) || "hist".equalsIgnoreCase(chartType) || "hhist".equalsIgnoreCase(chartType);
    }

    private boolean isPyramidChart(Map<String, Object> graph, String chartType) {
        return "pyramid".equalsIgnoreCase(chartType);
    }

    private boolean isFBarChart(Map<String, Object> graph, String chartType) {
        return "fbar".equalsIgnoreCase(chartType) || "fbar3d".equalsIgnoreCase(chartType) || "hfbar".equalsIgnoreCase(chartType) || "hfbar3d".equalsIgnoreCase(chartType);
    }

    private boolean isBulletChart(Map<String, Object> graph) {
        String chartType = this.type;
        if (chartType == null) {
            chartType = (String)graph.get("type");
        }
        return "vbullet".equalsIgnoreCase(chartType) || "hbullet".equalsIgnoreCase(chartType) || "bullet".equalsIgnoreCase(chartType);
    }

    private boolean isVennChart(Map<String, Object> graph) {
        String chartType = this.type;
        if (chartType == null) {
            chartType = (String)graph.get("type");
        }
        return "venn".equalsIgnoreCase(chartType);
    }

    private boolean isFunnelChart(Map<String, Object> graph) {
        String chartType = this.type;
        if (chartType == null) {
            chartType = (String)graph.get("type");
        }
        return "vfunnel".equalsIgnoreCase(chartType) || "hfunnel".equalsIgnoreCase(chartType) || "funnel".equalsIgnoreCase(chartType);
    }

    private boolean isBoxplotChart(Object type) {
        if (type == null) {
            return false;
        }
        return "boxplot".equalsIgnoreCase((String)type) || "hboxplot".equalsIgnoreCase((String)type);
    }

    @Override
    public void setForeColor(String seriesColor) {
        this.seriesColor = seriesColor;
    }

    @Override
    public void setColorList(String colorList) {
        this.colorList = ListFunc.ListToArray(colorList, ",");
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setScales(String scales) {
        this.scales = scales;
    }

    @Override
    public void setPaintStyle(String paintStyle) {
    }

    @Override
    public void setMarkerStyle(String markerStyle) {
        String mStyle = markerStyle.toLowerCase();
        if (!this.isValidMarkerStyle(mStyle)) {
            throw new GraphCommon.InvalidMarkerStyleException(markerStyle);
        }
        this.markerStyle = markerStyles.get(mStyle);
    }

    @Override
    public void setDataLabelStyle(String dataLabelStyle) {
        String dataStyle = dataLabelStyle.toLowerCase();
        String mappedDataStyle = dataLabelStyles.get(dataStyle);
        this.dataLabelStyle = mappedDataStyle != null ? mappedDataStyle : dataLabelStyle;
    }

    static {
        markerStyles.put("rectangle", "rectangle");
        markerStyles.put("triangle", "triangle");
        markerStyles.put("diamond", "diamond");
        markerStyles.put("circle", "circle");
        markerStyles.put("square", "square");
        markerStyles.put("plus", "plus");
        markerStyles.put("letterx", "circle");
        markerStyles.put("cross", "cross");
        markerStyles.put("mcross", "cross");
        markerStyles.put("snow", "circle");
        markerStyles.put("rcross", "cross");
        markerStyles.put("none", "none");
        dataLabelStyles = new HashMap(6);
        dataLabelStyles.put("none", "none");
        dataLabelStyles.put("value", "value");
        dataLabelStyles.put("rowlabel", "rowlabel");
        dataLabelStyles.put("columnlabel", "columnlabel");
        dataLabelStyles.put("pattern", "pattern");
    }

    public static class DataPointException
    extends NeoException {
        public String data = "";

        DataPointException(List dataPoints) {
            try {
                this.data = JSONUtils.serializeJSON(dataPoints);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class InvalidDataException
    extends ApplicationException {
        public String listName;

        public InvalidDataException(String listName) {
            this.listName = listName;
        }
    }

    public static class InvalidValueColumnException
    extends ApplicationException {
    }

    public static class DataRequiredException
    extends NeoException {
        public String attr;

        public DataRequiredException(String attr) {
            this.attr = attr;
        }
    }

    public static class DataBoxLengthException
    extends NeoException {
    }

    public static class EmptyDataArrayException
    extends NeoException {
    }
}

