/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.graph.GraphCommon;
import coldfusion.graph.GraphDataPoint;
import coldfusion.graph.GraphException;
import coldfusion.util.RuntimeWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class GraphDataSeries
extends GraphCommon {
    private ArrayList _dataPoints = null;
    private ArrayList _columnNames = null;
    private HashMap _dpMap = null;
    private long _curEmptyItemID = 0L;
    protected static final String EMPTY_ITEM_PREFIX = "MACR_EMPTY_ITEM_PREFIX_";
    private String _seriesLabel;
    private ResultSet _query;
    private String _valueColumn;
    private String _itemColumn;
    private List _colorList;
    private boolean _dataProcessed = false;

    public GraphDataSeries() {
        this._dataPoints = new ArrayList();
        this._columnNames = new ArrayList();
        this._dpMap = new HashMap();
    }

    public GraphDataSeries(String chartType) throws GraphException {
        this.setChartType(chartType);
        this._dataPoints = new ArrayList();
        this._columnNames = new ArrayList();
        this._dpMap = new HashMap();
    }

    public void addDataPoint(GraphDataPoint dataPoint) {
        if (dataPoint.getItem().equals("")) {
            String tmpItem = EMPTY_ITEM_PREFIX + this._curEmptyItemID++;
            dataPoint.setItem(tmpItem);
        }
        this._dataPoints.add(dataPoint);
    }

    public Iterator getDataPoints() {
        return this._dataPoints.iterator();
    }

    public Collection getColumnNames() {
        return this._columnNames;
    }

    public GraphDataPoint getDataPoint(String item) {
        return (GraphDataPoint)this._dpMap.get(item);
    }

    public int getNumDataPoints() {
        return this._dataPoints.size();
    }

    public void setQuery(ResultSet query) {
        this._query = query;
    }

    public ResultSet getQuery() {
        return this._query;
    }

    public void setItemColumn(String itemColumn) {
        this._itemColumn = itemColumn;
    }

    public String getItemColumn() {
        return this._itemColumn;
    }

    public void setValueColumn(String valueColumn) {
        this._valueColumn = valueColumn;
    }

    public String getValueColumn() {
        return this._valueColumn;
    }

    public void setSeriesLabel(String seriesLabel) {
        this._seriesLabel = seriesLabel;
    }

    public void setLabel(String label) {
        this._seriesLabel = label;
    }

    public String getSeriesLabel() {
        return this._seriesLabel;
    }

    public void setColorList(String colorList) {
        this._colorList = this.stringToList(colorList, ",");
    }

    List getColorList() {
        return this._colorList;
    }

    String getColorFromList(int index) {
        int idx = index % this._colorList.size();
        return GraphDataSeries.getHexColor((String)this._colorList.get(idx));
    }

    private List stringToList(String str, String token) {
        Vector<String> l = new Vector<String>();
        StringTokenizer st = new StringTokenizer(str, token, false);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken().trim());
        }
        return l;
    }

    public void processData() {
        if (!this._dataProcessed) {
            ResultSet query = this.getQuery();
            if (query != null) {
                try {
                    int itemColumn = query.findColumn(this.getItemColumn());
                    int valueColumn = query.findColumn(this.getValueColumn());
                    while (query.next()) {
                        String item = query.getString(itemColumn);
                        String value = query.getString(valueColumn);
                        GraphDataPoint dp = new GraphDataPoint(item, value);
                        this.addDataPoint(dp);
                    }
                }
                catch (SQLException sqle) {
                    throw new RuntimeWrapper(sqle);
                }
            }
            Iterator it = this.getDataPoints();
            while (it.hasNext()) {
                GraphDataPoint dp = (GraphDataPoint)it.next();
                String itemName = dp.getItem();
                this._columnNames.add(itemName);
                this._dpMap.put(itemName, dp);
            }
            this._dataProcessed = true;
        }
    }

    public String getWebChartsStyleXml(int seriesIndex) {
        this.processData();
        StringBuffer xmlBuf = new StringBuffer();
        if (this.getChartType().equals("AREA CHART")) {
            xmlBuf.append("<element index='" + seriesIndex + "'>");
            if (this.getShapeStyle() != null) {
                xmlBuf.append("<shapeStyle>" + this.getShapeStyle() + "</>");
            }
            if (this.getPaintStyle() != null) {
                xmlBuf.append("<paintStyle>" + this.getPaintStyle() + "</>");
            }
            if (this.getPlaceStyle() != null) {
                xmlBuf.append("<placeStyle>" + this.getPlaceStyle() + "</>");
            }
            if (this.getForeColor() != null) {
                xmlBuf.append("<foreColor>" + this.getForeColor() + "</>");
            }
            if (this.getMarkerStyle() != null) {
                xmlBuf.append("<markerStyle>" + this.getMarkerStyle() + "</>");
            }
            xmlBuf.append("</>");
        } else if (this.getChartType().equals("PIE CHART") && this.getColorList() != null) {
            for (int i = 0; i < this.getNumDataPoints(); ++i) {
                xmlBuf.append("<element index='" + i + "'>");
                xmlBuf.append("<foreColor>" + this.getColorFromList(i) + "</>");
                xmlBuf.append("</>");
            }
        }
        return xmlBuf.toString();
    }
}

