/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.graph.ChartAttributeMapper;
import coldfusion.graph.ChartSeries;
import coldfusion.graph.Graph;
import coldfusion.graph.GraphCommon;
import coldfusion.graph.GraphException;
import coldfusion.graph.IChart;
import coldfusion.graph.IChartConstants;
import coldfusion.graph.InteractiveChartSet;
import coldfusion.graph.JSONManipulator;
import coldfusion.graph.StyleFileResolver;
import coldfusion.graph.XMLToJSON;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ListFunc;
import coldfusion.server.LicenseService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RuntimeWrapper;
import java.io.FileNotFoundException;
import java.net.URL;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public class InteractiveChart
implements IChart,
IChartConstants {
    private Logger logger = CFLogs.APPLICATION_LOG;
    private String id;
    private String style;
    List<ChartSeries> seriesValueList = new ArrayList<ChartSeries>();
    private String height;
    private String width;
    private String url;
    private String title;
    private ResultSet query;
    private String itemColumn;
    private List<String> itemList;
    protected String type;
    private String originalType;
    private String xAxisTitle;
    private String yAxisTitle;
    private byte show3D = (byte)-1;
    private byte showLegend = (byte)-1;
    private byte adjustLayout = 1;
    private byte showMarkers = (byte)-1;
    private byte showScaleMarkers = (byte)-1;
    private byte showBorder = (byte)-1;
    private byte fontBold = (byte)-1;
    private byte fontItalic = (byte)-1;
    private byte showXGridlines = (byte)-1;
    private byte showYGridlines = (byte)-1;
    private String backgroundColor;
    private Map<String, Integer> aspect3d;
    private Map<String, Integer> scaleR;
    private double alpha = -1.0;
    private Map<String, Object> legend;
    private Map<String, Object> plot;
    private Map<String, Object> plotarea;
    private Map<String, Object> preview;
    private Map<String, Object> xaxis;
    private Map<String, Object> yaxis;
    private Map<String, Object> xaxis2;
    private Map<String, Object> yaxis2;
    private Map<String, Object> tooltip;
    private Map<String, Object> zoom;
    private Map<String, Object> refresh;
    private List<Map<String, Object>> labels;
    private Map<String, String> background;
    private Map<String, String> border;
    private Map<String, String> fill;
    private Map titleMap;
    private Object bevel;
    private Map<String, Object> crosshair;
    private List<Map<String, Object>> arrows;
    private List<Object> xaxisvalues;
    private List<Object> yaxisvalues;
    private String dataBackgroundColor;
    private int markerSize = -1;
    private String pieSliceStyle;
    private String placeStyle;
    private String tipBackgroundColor;
    private double scaleFrom = -1.0;
    private double scaleTo = -1.0;
    private String font;
    private int fontSize = -1;
    private String foreGroundColor;
    private int numGridLines = -1;
    private String scales;
    private String format;
    private boolean serverSideChart = false;
    private Map<String, Object> options;
    private String x;
    private String y;
    private String urlData;
    private Map markers;
    private static HashMap<String, String> chartTypes = new HashMap(30);
    public static HashMap<String, String> clientFormats;
    public static HashMap<String, String> serverFormats;
    private String labelFormat;
    private static final Locale locale;
    private static final NumberFormat currencyFormatter;
    private static final DecimalFormatSymbols currencySymbols;
    private static final List<String> _validLabelFormats;
    private static final String CURRENCY_SYMBOL;
    private static final String DECIMAL_SEPARATOR_VALUE;
    private static final String THOUSAND_SEPARATOR_VALUE;
    private static final String FORMATTED_CURRENCY_VALUE;
    private static final boolean IS_CURRENCY_SYMBOL_PREFIX;
    private static final List<String> hmixedChartList;

    public static String getChartType(String chartType) {
        return chartTypes.get(chartType);
    }

    public String getChartType(Map<String, Object> graph) {
        String chartType = this.type;
        if (chartType == null) {
            chartType = (String)graph.get("type");
        }
        return chartType;
    }

    public static boolean isValidChartType(String type) {
        return chartTypes.containsKey(type.toLowerCase());
    }

    public void addChartSeries(ChartSeries chartSeries) {
        if (this.show3D == 1) {
            chartSeries.setShow3D(true);
        }
        this.seriesValueList.add(chartSeries);
    }

    public void setQuery(ResultSet query) {
        this.query = query;
    }

    public ResultSet getQuery() {
        return this.query;
    }

    @Override
    public void setStyle(String styleTemplate) {
        this.style = styleTemplate;
    }

    public void setXPosition(String x) {
        InteractiveChartSet.validateAttrValue("x", x);
        this.x = x;
    }

    public void setYPosition(String y) {
        InteractiveChartSet.validateAttrValue("y", y);
        this.y = y;
    }

    public void setUpWatermark(Map<String, Object> graph) {
        try {
            LicenseService lic = ServiceFactory.getLicenseService();
            if (lic.isDeveloper()) {
                URL safeURL = this.getClass().getClassLoader().getResource("watermark.png");
                String watermarkImgPath = safeURL.getFile();
                graph.put("background-image", watermarkImgPath);
                graph.put("background-fit", "xy");
                graph.put("background-transparent", false);
                graph.put("background-position", "0% 0%");
                graph.put("background-repeat", "false");
            }
        }
        catch (ServiceFactory.ServiceNotAvailableException serviceNotAvailableException) {
            // empty catch block
        }
    }

    public Map<String, Object> mergeJSON(Map jsonConfig, boolean isThemeDefined) throws FileNotFoundException {
        List grpahsetList = (List)jsonConfig.get("graphset");
        String derivedStyle = this.style;
        String derivedType = this.type;
        boolean scaleXSize = false;
        if (!this.isServerSideChart()) {
            String mappedType;
            if (this.type == null && derivedStyle == null && !isThemeDefined && (mappedType = InteractiveChart.getChartType(derivedStyle = this.deriveChartType(null, true))) != null) {
                derivedStyle = mappedType;
            }
        } else if (derivedStyle == null && !isThemeDefined) {
            derivedStyle = "default";
        }
        if (derivedType == null) {
            derivedType = this.deriveChartType(null, true);
        }
        StyleFileResolver styleResolver = new StyleFileResolver(derivedType, derivedStyle, isThemeDefined);
        Object style = styleResolver.readStyle();
        Object styleJSON = null;
        styleJSON = style != null && style instanceof Document ? JSONManipulator.deserializeJSON(new StyleFileResolver(this.type, null, isThemeDefined).readStyle()) : JSONManipulator.deserializeJSON(style);
        Map jsonMap = (Map)styleJSON;
        List graphset = (List)jsonMap.get("graphset");
        Map graph = (Map)graphset.get(0);
        grpahsetList.add(graph);
        if (style != null && style instanceof Document) {
            try {
                XMLToJSON xmlToJSON = new XMLToJSON((Document)style, graph);
                graph = xmlToJSON.convert();
                if (this.show3D == -1) {
                    this.setIs3D(xmlToJSON.isShow3D());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.handleTitle(graph);
        InteractiveChart.handleShow3D(graph, this.show3D == 1, this.type != null ? this.type : (String)graph.get("type"));
        this.handleShowLegend(graph);
        this.mergeDirectChartingEngineAttributes(graph);
        if (graph.get("plot") != null) {
            Map plot = (Map)graph.get("plot");
            Object slice = plot.get("slice");
            if (slice != null && !(slice instanceof Number)) {
                InteractiveChartSet.validateAttrValue("slice", (String)slice);
            }
            if (((Map)graph.get("plot")).get("animation") != null) {
                this.handlePlotAnimation(graph);
            }
        }
        InteractiveChart.handleColor(graph, this.backgroundColor, "background-color");
        if (this.dataBackgroundColor != null) {
            InteractiveChart.handleColor(InteractiveChart.retrieveMapFragment(graph, "plotarea"), this.dataBackgroundColor, "background-color");
        }
        if (this.tipBackgroundColor != null) {
            InteractiveChart.handleColor(InteractiveChart.retrieveMapFragment(graph, "tooltip"), this.tipBackgroundColor, "background-color");
        }
        this.handleURL(graph);
        this.handleMarker(graph);
        this.handleShowBorder(graph);
        this.handlePieSliceStyle(graph);
        this.handlePlaceStyle(graph);
        InteractiveChart.handleFont(graph, this.font, "font-family");
        if (this.fontSize != -1) {
            InteractiveChart.handleFont(graph, this.fontSize, "font-size");
        }
        if (this.fontBold != -1) {
            InteractiveChart.handleFont(graph, this.fontBold != 0, "bold");
        }
        if (this.fontItalic != -1) {
            InteractiveChart.handleFont(graph, this.fontItalic != 0, "italic");
        }
        InteractiveChart.handleForegroundColor(graph, this.foreGroundColor, "color");
        int seriesSize = this.seriesValueList.size();
        for (int i = 0; i < seriesSize; ++i) {
            this.merge(graph, this.seriesValueList.get(i), i, seriesSize, isThemeDefined);
        }
        if (this.labelFormat != null) {
            this.handleLabelFormat(graph);
        }
        this.deriveChartType(graph, false);
        if (((String)graph.get("type")).equalsIgnoreCase("boxplot") || ((String)graph.get("type")).equalsIgnoreCase("hboxplot")) {
            this.handleScaleX(graph, seriesSize);
        }
        graph.putIfAbsent("type", this.show3D == 1 ? "bar3d" : "bar");
        if (this.getItemColumn() != null) {
            this.processItemQueryData();
        }
        this.mergeAxisValues(graph);
        if ("piano".equalsIgnoreCase(this.getChartType(graph))) {
            this.constructAxisForPianoChart(graph, this.seriesValueList);
        }
        if (this.isServerSideChart()) {
            this.setUpWatermark(graph);
        }
        this.removeEmptySeries((ArrayList)graph.get("series"));
        return graph;
    }

    private void handleLabelFormat(Map<String, Object> graph) {
        if (this.labelFormat.equalsIgnoreCase("currency")) {
            this.handleCurrencyLabelFormat(graph);
        }
    }

    private void handleCurrencyLabelFormat(Map<String, Object> graph) {
        Map scaley = (Map)graph.get("scale-y");
        Map plot = (Map)graph.get("plot");
        Map value_box = (Map)plot.get("value-box");
        String currencyFormat = null;
        currencyFormat = IS_CURRENCY_SYMBOL_PREFIX ? CURRENCY_SYMBOL + "%v" : "%v" + CURRENCY_SYMBOL;
        this.formatCurrencyData(scaley, "format", currencyFormat);
        if (this.pieSliceStyle != null) {
            this.formatCurrencyData(value_box, "text", currencyFormat);
        }
        this.formatCurrencyData(plot, "tooltip-text", currencyFormat);
    }

    private void handlePercentLabelFormat(Map<String, Object> graph) {
        Map scaley = (Map)graph.get("scale-y");
        Map plot = (Map)graph.get("plot");
        Map value_box = (Map)plot.get("value-box");
        Optional<ArrayList> optionalSeriesList = Optional.ofNullable((ArrayList)graph.get("series"));
        optionalSeriesList.ifPresent(seriesList -> seriesList.stream().filter(series -> series.containsKey("values")).forEach(series -> {
            List valueList = (List)series.get("values");
            List newValueList = valueList.stream().filter(item -> item != null && item instanceof Number).map(item -> ((Number)item).doubleValue() * 100.0).collect(Collectors.toList());
            series.put("values", newValueList);
        }));
        this.formatPercentData(scaley, "format");
        if (this.pieSliceStyle != null) {
            this.formatPercentData(value_box, "text");
        }
        this.formatPercentData(plot, "tooltip-text");
    }

    private void formatPercentData(Map<String, Object> map, String format) {
        map.put(format, "%v%");
        map.putIfAbsent("thousands-separator", THOUSAND_SEPARATOR_VALUE);
    }

    private void formatCurrencyData(Map<String, Object> map, String format, String currency) {
        map.put(format, currency);
        map.put("negation", "currency");
        map.putIfAbsent("decimals", "2");
        map.putIfAbsent("decimals-separator", DECIMAL_SEPARATOR_VALUE);
        map.putIfAbsent("thousands-separator", THOUSAND_SEPARATOR_VALUE);
    }

    private void removeEmptySeries(ArrayList<Map<String, Object>> seriesList) {
        if (seriesList != null) {
            Iterator<Map<String, Object>> seriesIterator = seriesList.iterator();
            while (seriesIterator.hasNext()) {
                Map<String, Object> series = seriesIterator.next();
                if (series.get("text") != null || series.get("values") != null || series.get("dataBox") != null || series.get("dataOutlier") != null) continue;
                seriesIterator.remove();
            }
        }
    }

    private void handleURL(Map<String, Object> graph) {
        if (this.url == null) {
            return;
        }
        this.url = this.url.replaceAll("(?i)\\$VALUE\\$", "%v");
        this.url = this.url.replaceAll("(?i)\\$ITEMLABEL\\$", "%k");
        this.url = this.url.replaceAll("(?i)\\$SERIESLABEL\\$", "%t");
        Map<String, Object> plot = InteractiveChart.retrieveMapFragment(graph, "plot");
        plot.put("url", this.url);
        plot.put("target", "_self");
    }

    private void constructAxisForPianoChart(Map<String, Object> graph, List<ChartSeries> seriesValueList) {
        int seriesSize = seriesValueList.size();
        ArrayList<String> axisValues = new ArrayList<String>();
        for (int i = 0; i < seriesSize; ++i) {
            ChartSeries series = seriesValueList.get(i);
            axisValues.add(series.getLabel());
        }
        Map<String, Object> scaley = InteractiveChart.retrieveMapFragment(graph, "scale-y");
        scaley.put("values", axisValues);
    }

    private void handleTitle(Map<String, Object> graph) {
        if (this.title != null && this.title.length() != 0) {
            HashMap<String, String> title = (HashMap<String, String>)graph.get("title");
            if (title == null) {
                title = new HashMap<String, String>();
                graph.put("title", title);
            }
            title.put("text", this.title);
        } else if (this.titleMap != null) {
            graph.put("title", this.titleMap);
        } else {
            Object titleText;
            Map title = (Map)graph.get("title");
            if (title != null && ((titleText = title.get("text")) == null || titleText.toString().length() == 0)) {
                graph.remove("title");
            }
        }
    }

    private void mergeDirectChartingEngineAttributes(Map<String, Object> graph) {
        List valueList;
        if (this.legend != null && this.showLegend != 0) {
            graph.put("legend", this.legend);
        }
        if (this.aspect3d != null) {
            InteractiveChart.handleSingleLevelMappedAttributes(graph, this.aspect3d, "aspect3d");
        }
        if (this.alpha != -1.0) {
            graph.put("alpha", this.alpha);
        }
        if (this.scaleR != null) {
            graph.put("scaleR", this.scaleR);
        }
        if (this.plot != null) {
            graph.put("plot", this.plot);
        }
        if (this.options != null) {
            graph.put("options", this.options);
        }
        if (this.plotarea != null) {
            graph.put("plotarea", this.plotarea);
        }
        if (this.preview != null) {
            graph.put("preview", this.preview);
        }
        if (this.xaxis != null) {
            valueList = (List)this.xaxis.get("values");
            this.xaxis.put("values", this.convertToNumberForList(valueList));
            InteractiveChart.handleSingleLevelMappedAttributes(graph, this.xaxis, "xaxis");
        }
        if (this.yaxis != null) {
            valueList = (List)this.yaxis.get("values");
            this.yaxis.put("values", this.convertToNumberForList(valueList));
            InteractiveChart.handleSingleLevelMappedAttributes(graph, this.yaxis, "yaxis");
        }
        if (this.xaxis2 != null) {
            valueList = (List)this.xaxis2.get("values");
            this.xaxis2.put("values", this.convertToNumberForList(valueList));
            InteractiveChart.handleSingleLevelMappedAttributes(graph, this.xaxis2, "xaxis2");
            this.autoCalculateScalesY(graph);
        }
        if (this.yaxis2 != null) {
            valueList = (List)this.yaxis2.get("values");
            this.yaxis2.put("values", this.convertToNumberForList(valueList));
            InteractiveChart.handleSingleLevelMappedAttributes(graph, this.yaxis2, "yaxis2");
            this.autoCalculateScalesX(graph);
        }
        if (this.tooltip != null) {
            graph.put("tooltip", this.tooltip);
        }
        if (this.zoom != null) {
            graph.put("zoom", this.zoom);
        }
        if (this.refresh != null) {
            graph.put("refresh", this.refresh);
        }
        if (this.labels != null) {
            graph.put("labels", this.labels);
        }
        InteractiveChart.handleDoubleLevelMappedAttributes(graph, this.background, "background");
        InteractiveChart.handleDoubleLevelMappedAttributes(graph, this.border, "border");
        InteractiveChart.handleDoubleLevelMappedAttributes(graph, this.fill, "fill");
        if (this.bevel instanceof Map) {
            graph.put("bevel", true);
            InteractiveChart.handleDoubleLevelMappedAttributes(graph, (Map)this.bevel, "bevel");
        } else if (this.bevel != null) {
            try {
                boolean bev = Cast._boolean(this.bevel);
                graph.put("bevel", bev);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.crosshair != null) {
            InteractiveChart.handleSingleLevelMappedAttributes(graph, this.crosshair, "crosshair");
        }
        if (this.arrows != null) {
            graph.put("arrows", this.arrows);
        }
        if (this.scales != null) {
            InteractiveChart.handleScales(graph, this.scales, false);
        }
        if (this.x != null) {
            graph.put("x", this.x);
        }
        if (this.y != null) {
            graph.put("y", this.y);
        }
        if (this.height != null) {
            graph.put("height", this.height);
        }
        if (this.width != null) {
            graph.put("width", this.width);
        }
        if (this.urlData != null) {
            graph.put("urlData", this.urlData);
        }
    }

    private List convertToNumberForList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> convertedList = new ArrayList<Object>();
        for (Object aItem : list) {
            try {
                convertedList.add(ChartSeries._convertToNumber(aItem));
            }
            catch (Exception ex) {
                return list;
            }
        }
        return convertedList;
    }

    static void handleScales(Map<String, Object> graph, String scales, boolean series) {
        Array scalesList = ListFunc.ListToArray(scales, ",");
        if (scalesList.size() != 2) {
            throw new ScalesValueException(scales);
        }
        String axis1 = ((String)scalesList.get(0)).toLowerCase().trim();
        String axis2 = ((String)scalesList.get(1)).toLowerCase().trim();
        String scale1 = InteractiveChart.resolveAxis(axis1);
        String scale2 = InteractiveChart.resolveAxis(axis2);
        Map<String, Object> scalesParent = null;
        scalesParent = series ? graph : InteractiveChart.retrieveMapFragment(graph, "plot");
        scalesParent.put("scales", scale1 + "," + scale2);
    }

    private void autoCalculateScalesY(Map<String, Object> graph) {
        if (this.scales != null) {
            Map<String, Object> plot = InteractiveChart.retrieveMapFragment(graph, "plot");
            if (this.yaxis != null || this.yaxisvalues != null) {
                plot.put("scales", "scale-x-2,scale-y");
            } else if (this.yaxis2 != null) {
                plot.put("scales", "scale-x-2,scale-y-2");
            }
        }
    }

    private void autoCalculateScalesX(Map<String, Object> graph) {
        if (this.scales != null) {
            Map<String, Object> plot = InteractiveChart.retrieveMapFragment(graph, "plot");
            if (this.xaxis != null || this.xaxisvalues != null) {
                plot.put("scales", "scale-x,scale-y-2");
            } else if (this.xaxis2 != null) {
                plot.put("scales", "scale-x-2,scale-y-2");
            }
        }
    }

    private static String resolveAxis(String axis) {
        if (axis.equalsIgnoreCase("x") || axis.endsWith("xaxis")) {
            return "scale-x";
        }
        if (axis.equalsIgnoreCase("y") || axis.endsWith("yaxis")) {
            return "scale-y";
        }
        if (axis.endsWith("x-2") || axis.endsWith("x2") || axis.endsWith("xaxis2")) {
            return "scale-x-2";
        }
        if (axis.endsWith("y-2") || axis.endsWith("y2") || axis.endsWith("yaxis2")) {
            return "scale-y-2";
        }
        return axis;
    }

    static void handleSingleLevelMappedAttributes(Map<String, Object> graph, Object attributeValue, String attributeName) {
        if (attributeValue == null) {
            return;
        }
        String mappedName = ChartAttributeMapper.getChartEngineAttributeName(new String[]{attributeName});
        if (mappedName != null) {
            graph.put(mappedName, attributeValue);
        } else {
            graph.put(attributeName, attributeValue);
        }
    }

    static void handleDoubleLevelMappedAttributes(Map<String, Object> graph, Map attributeMap, String attributeName) {
        if (attributeMap == null) {
            return;
        }
        for (String key : attributeMap.keySet()) {
            String value;
            String mappedName = ChartAttributeMapper.getChartEngineAttributeName(new String[]{attributeName, key});
            if (mappedName == null || (value = Cast._String(attributeMap.get(key))) == null) continue;
            if (key.indexOf("color") != -1 && value != null && !value.startsWith("#")) {
                value = ChartSeries.toHexColor(value);
            }
            graph.put(mappedName, value);
        }
    }

    static void handleFont(Map<String, Object> graph, Object attributeValue, String attributeName) {
        if (attributeValue == null) {
            return;
        }
        Map<String, Object> title = InteractiveChart.retrieveMapFragment(graph, "title", false);
        Map<String, Object> tooltip = InteractiveChart.retrieveMapFragment(graph, "tooltip");
        Map<String, Object> scalex = InteractiveChart.retrieveMapFragment(graph, "scale-x");
        Map<String, Object> scaleXItem = InteractiveChart.retrieveMapFragment(scalex, "item");
        Map<String, Object> scaleXLabel = InteractiveChart.retrieveMapFragment(scalex, "label");
        Map<String, Object> scaley = InteractiveChart.retrieveMapFragment(graph, "scale-y");
        Map<String, Object> scaleYItem = InteractiveChart.retrieveMapFragment(scaley, "item");
        Map<String, Object> scaleYLabel = InteractiveChart.retrieveMapFragment(scaley, "label");
        Map<String, Object> legend = InteractiveChart.retrieveMapFragment(graph, "legend", false);
        Map<String, Object> legendItem = legend == null ? null : InteractiveChart.retrieveMapFragment(legend, "item", false);
        Map<String, Object> plot = InteractiveChart.retrieveMapFragment(graph, "plot");
        Map<String, Object> valueBox = InteractiveChart.retrieveMapFragment(plot, "value-box", false);
        boolean valueBoxExists = false;
        if (valueBox != null) {
            valueBoxExists = true;
        } else {
            valueBox = InteractiveChart.retrieveMapFragment(plot, "value-box", true);
        }
        if (title != null) {
            title.put(attributeName, attributeValue);
        }
        tooltip.put(attributeName, attributeValue);
        scalex.put(attributeName, attributeValue);
        scaleXItem.put(attributeName, attributeValue);
        scaleXLabel.put(attributeName, attributeValue);
        scaley.put(attributeName, attributeValue);
        scaleYItem.put(attributeName, attributeValue);
        scaleYLabel.put(attributeName, attributeValue);
        if (legendItem != null) {
            legendItem.put(attributeName, attributeValue);
        }
        valueBox.put(attributeName, attributeValue);
        if (!valueBoxExists) {
            valueBox.put("text", "");
        }
    }

    static void handleForegroundColor(Map<String, Object> graph, String attributeValue, String attributeName) {
        if (attributeValue == null) {
            return;
        }
        if (!attributeValue.startsWith("#")) {
            attributeValue = ChartSeries.toHexColor(attributeValue);
        }
        InteractiveChart.handleFont(graph, attributeValue, attributeName);
        InteractiveChart.handlePlotAreaOutline(graph, attributeValue);
    }

    static void handleXMLForegroundColor(Map<String, Object> graph, String attributeValue, String attributeName) {
        if (attributeValue == null) {
            return;
        }
        if (!attributeValue.startsWith("#")) {
            attributeValue = ChartSeries.toHexColor(attributeValue);
        }
        Map<String, Object> title = InteractiveChart.retrieveMapFragment(graph, "title");
        Map<String, Object> legend = InteractiveChart.retrieveMapFragment(graph, "legend");
        Map<String, Object> legendItem = InteractiveChart.retrieveMapFragment(legend, "item");
        Map<String, Object> plot = InteractiveChart.retrieveMapFragment(graph, "plot");
        Map<String, Object> valueBox = InteractiveChart.retrieveMapFragment(plot, "value-box", false);
        boolean valueBoxExists = false;
        if (valueBox != null) {
            valueBoxExists = true;
        } else {
            valueBox = InteractiveChart.retrieveMapFragment(plot, "value-box", true);
        }
        title.put(attributeName, attributeValue);
        legendItem.put(attributeName, attributeValue);
        valueBox.put(attributeName, attributeValue);
        if (!valueBoxExists) {
            valueBox.put("text", "");
        }
        InteractiveChart.handleOutline(InteractiveChart.retrieveMapFragment(graph, "plot"), attributeValue);
    }

    static void handlePlotAreaOutline(Map<String, Object> graph, String color) {
        if (color == null) {
            return;
        }
        Map<String, Object> plotarea = InteractiveChart.retrieveMapFragment(graph, "plotarea");
        plotarea.put("border-width", "1");
        InteractiveChart.handleColor(plotarea, color, "border-color");
        if (graph.containsKey("scale-x")) {
            Map<String, Object> scaleX = InteractiveChart.retrieveMapFragment(graph, "scale-x");
            scaleX.put("line-width", "1");
            InteractiveChart.handleColor(scaleX, color, "line-color");
            Map<String, Object> scaleXTick = InteractiveChart.retrieveMapFragment(scaleX, "tick");
            scaleXTick.put("line-width", "1");
            InteractiveChart.handleColor(scaleXTick, color, "line-color");
            Map<String, Object> scaleXItem = InteractiveChart.retrieveMapFragment(scaleX, "item");
            Map<String, Object> scaleXLabel = InteractiveChart.retrieveMapFragment(scaleX, "label");
            scaleX.put("color", color);
            scaleXItem.put("color", color);
            scaleXLabel.put("color", color);
        }
        if (graph.containsKey("scale-y")) {
            Map<String, Object> scaleY = InteractiveChart.retrieveMapFragment(graph, "scale-y");
            scaleY.put("line-width", "1");
            InteractiveChart.handleColor(scaleY, color, "line-color");
            Map<String, Object> scaleYTick = InteractiveChart.retrieveMapFragment(scaleY, "tick");
            scaleYTick.put("line-width", "1");
            InteractiveChart.handleColor(scaleYTick, color, "line-color");
            Map<String, Object> scaleYItem = InteractiveChart.retrieveMapFragment(scaleY, "item");
            Map<String, Object> scaleYLabel = InteractiveChart.retrieveMapFragment(scaleY, "label");
            scaleY.put("color", color);
            scaleYItem.put("color", color);
            scaleYLabel.put("color", color);
        }
    }

    static void handleOutline(Map<String, Object> graph, String color) {
        if (color == null) {
            return;
        }
        graph.put("border-width", 1);
        InteractiveChart.handleColor(graph, color, "border-color");
    }

    static void handleColor(Map<String, Object> graph, String color, String attributeName) {
        if (color == null) {
            return;
        }
        if (!color.startsWith("#")) {
            color = ChartSeries.toHexColor(color);
        }
        graph.put(attributeName, color);
    }

    private void handleMarker(Map<String, Object> graph) {
        this.handlePlotMarker(graph);
        if (this.markers == null || this.showScaleMarkers == 0) {
            return;
        }
        if (this.markers.get("xaxis") != null) {
            InteractiveChart.retrieveMapFragment(graph, InteractiveChart.resolveAxis("xaxis")).put("markers", this.markers.get("xaxis"));
        }
        if (this.markers.get("xaxis2") != null) {
            InteractiveChart.retrieveMapFragment(graph, InteractiveChart.resolveAxis("xaxis2")).put("markers", this.markers.get("xaxis2"));
        }
        if (this.markers.get("yaxis") != null) {
            InteractiveChart.retrieveMapFragment(graph, InteractiveChart.resolveAxis("yaxis")).put("markers", this.markers.get("yaxis"));
        }
        if (this.markers.get("yaxis2") != null) {
            InteractiveChart.retrieveMapFragment(graph, InteractiveChart.resolveAxis("yaxis2")).put("markers", this.markers.get("yaxis2"));
        }
        if (this.markers.get("scaleR") != null) {
            InteractiveChart.retrieveMapFragment(graph, "scaleR").put("markers", this.markers.get("scaleR"));
        }
    }

    private void handlePlotMarker(Map<String, Object> graph) {
        Map<String, Object> plot = InteractiveChart.retrieveMapFragment(graph, "plot");
        Map marker = InteractiveChart.retrieveMapFragment(plot, "marker");
        if (this.markers != null && this.markers.get("plot") != null) {
            marker = (Map)this.markers.get("plot");
        }
        if (this.showMarkers == 0) {
            marker.put((String)"type", (Object)"none");
        }
        if (this.markerSize != -1) {
            marker.put("size", this.markerSize);
        }
        plot.put("marker", marker);
    }

    private void handleShowBorder(Map<String, Object> graph) {
        if (this.showBorder == -1) {
            return;
        }
        if (this.showBorder == 1) {
            graph.put("border-width", 2);
        } else if (this.showBorder == 0) {
            graph.remove("border-width");
        }
    }

    private void handlePieSliceStyle(Map<String, Object> graph) {
        if (this.pieSliceStyle == null) {
            return;
        }
        if (this.pieSliceStyle.equalsIgnoreCase("sliced")) {
            Map<String, Object> plot = InteractiveChart.retrieveMapFragment(graph, "plot");
            plot.put("offset", 5);
        }
    }

    private void handlePlaceStyle(Map<String, Object> graph) {
        if (this.placeStyle == null) {
            return;
        }
        if (this.placeStyle.equalsIgnoreCase("stacked")) {
            graph.put("stacked", true);
        } else if (this.placeStyle.equalsIgnoreCase("percent")) {
            graph.put("stacked", true);
            graph.put("stack-type", "100%");
        }
    }

    private void handleShowLegend(Map<String, Object> graph) {
        HashMap<String, Boolean> legend;
        if (this.showLegend == 1) {
            legend = graph.get("legend");
            if (legend == null) {
                legend = new HashMap<String, Boolean>(1);
                graph.put("legend", legend);
            }
            ((Map)legend).put("visible", "true");
        } else if (this.showLegend == 0) {
            graph.remove("legend");
        }
        legend = (Map)graph.get("legend");
        if (legend != null) {
            try {
                if (legend.containsKey("visible") && !Cast._boolean(legend.get("visible"))) {
                    graph.remove("legend");
                } else {
                    legend.put("adjust-layout", this.adjustLayout == 1);
                }
            }
            catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException expressionException) {
                // empty catch block
            }
        }
    }

    private void handlePlotAnimation(Map<String, Object> graph) {
        Map plot = (Map)graph.get("plot");
        Map animation = (Map)plot.get("animation");
        plot.put("animation", ChartAttributeMapper.getAnimation(animation));
        graph.put("plot", plot);
    }

    private void handleScaleX(Map<String, Object> graph, int seriesSize) {
        if (graph.containsKey("scale-x") && ((Map)graph.get("scale-x")).containsKey("values") && ((List)((Map)graph.get("scale-x")).get("values")).isEmpty()) {
            ArrayList<Object> scaleXVal = new ArrayList<Object>();
            for (int i = 0; i < seriesSize; ++i) {
                scaleXVal.add(this.seriesValueList.get(i).getKey());
            }
            this.setxaxisvalues(scaleXVal);
        }
    }

    private String deriveChartType(Map<String, Object> graph, boolean determineTypeQuickly) {
        int seriesSize = this.seriesValueList.size();
        if (seriesSize == 1 && this.type == null) {
            String seriesType = this.seriesValueList.get(0).getChartType();
            if (determineTypeQuickly) {
                return seriesType;
            }
            if (seriesType != null) {
                graph.put("type", seriesType);
            }
            InteractiveChart.handleShow3D(graph, this.show3D == 1, this.type != null ? this.type : (String)graph.get("type"));
        }
        HashMap<String, String> types = new HashMap<String, String>(4);
        for (int i = 0; i < seriesSize; ++i) {
            ChartSeries chartSeries = this.seriesValueList.get(i);
            String type = chartSeries.getChartType();
            types.put(type, type);
        }
        String aType = null;
        if (types.size() == 1 && (aType = types.keySet().toArray(new String[0])[0]) != null) {
            if (determineTypeQuickly) {
                return aType;
            }
            graph.put("type", aType);
            InteractiveChart.handleShow3D(graph, this.show3D == 1, this.type != null ? this.type : (String)graph.get("type"));
        }
        if (types.size() == 1 && types.containsKey(null)) {
            if (determineTypeQuickly) {
                return "bar";
            }
            graph.put("type", "bar");
            InteractiveChart.handleShow3D(graph, this.show3D == 1, this.type != null ? this.type : (String)graph.get("type"));
        } else if (types.size() > 1) {
            if (determineTypeQuickly) {
                for (String type : types.keySet()) {
                    if (type == null) continue;
                    return type;
                }
            }
            if (hmixedChartList.contains(this.type) && types.containsKey(null)) {
                types.remove(null);
            }
            if (types.keySet().stream().allMatch(hmixedChartList::contains)) {
                graph.put("type", "hmixed");
            } else {
                graph.put("type", "mixed");
            }
        }
        types = null;
        return null;
    }

    static void handleShow3D(Map<String, Object> map, boolean show3D, String type) {
        if (type == null) {
            return;
        }
        String cType = chartTypes.get(type);
        if (cType != null) {
            String chart3dType;
            if (show3D && (chart3dType = chartTypes.get(cType + "3d")) != null) {
                map.put("type", chart3dType);
                return;
            }
            map.put("type", cType);
            return;
        }
        map.put("type", type);
    }

    public void merge(Map<String, Object> graph, ChartSeries chartSeries, int seriesNum, int size, boolean isThemeDefined) {
        chartSeries.mergeSeries(seriesNum, graph, size, (String)graph.get("type"), this.originalType, this.getFullItemList(), isThemeDefined);
    }

    private List<String> getFullItemList() {
        ArrayList<String> itemsFullList = new ArrayList<String>();
        for (int i = 0; i < this.seriesValueList.size(); ++i) {
            List<String> items = this.seriesValueList.get(i).getItemList();
            if (items == null) continue;
            for (String item : items) {
                if (itemsFullList.contains(item)) continue;
                itemsFullList.add(item);
            }
        }
        return itemsFullList;
    }

    public void mergeAxisValues(Map<String, Object> graph) {
        Map<String, Object> guide;
        Map<String, Object> scaley;
        Object valueList;
        Map<String, Object> scalex;
        boolean axisSet = false;
        if (this.getItemColumn() != null && this.getQuery() != null && !this.isPieChartFamily((String)graph.get("type"))) {
            Map<String, Object> scale = this.calculateRelevantAxis(graph);
            scale.put("values", this.convertToNumberForList(this.getItemList()));
            axisSet = true;
        }
        if (this.xaxisvalues != null) {
            scalex = InteractiveChart.retrieveMapFragment(graph, "scale-x");
            scalex.put("values", this.convertToNumberForList(this.xaxisvalues));
            axisSet = true;
        }
        if (this.xaxis != null && (valueList = this.xaxis.get("values")) != null) {
            axisSet = true;
        }
        if (!axisSet) {
            String chartType = (String)graph.get("type");
            List<String> scaleItems = null;
            if (this.isPieChartFamily(chartType)) {
                int seriesSize = this.seriesValueList.size();
                if (seriesSize == 1) {
                    ChartSeries aSeries = this.seriesValueList.get(0);
                    String label = aSeries.getLabel();
                    if (label != null) {
                        scaleItems = Arrays.asList(label);
                    }
                } else if (this.itemList != null && this.itemList.size() > 0) {
                    scaleItems = this.itemList;
                } else {
                    for (int i = 0; i < this.seriesValueList.size() && ((scaleItems = this.seriesValueList.get(i).getItemList()) == null || scaleItems.size() <= 0); ++i) {
                    }
                }
                Map<String, Object> scale = InteractiveChart.retrieveMapFragment(graph, "scale");
                scale.put("values", this.convertToNumberForList(scaleItems));
            } else {
                Map<String, Object> scale = this.calculateRelevantAxis(graph);
                scale.put("values", this.convertToNumberForList(this.getFullItemList()));
            }
        }
        if (this.yaxisvalues != null) {
            scaley = InteractiveChart.retrieveMapFragment(graph, "scale-y");
            scaley.put("values", this.convertToNumberForList(this.yaxisvalues));
        }
        if (this.xAxisTitle != null) {
            scalex = InteractiveChart.retrieveMapFragment(graph, "scale-x");
            HashMap<String, String> scaleXlabel = (HashMap<String, String>)scalex.get("label");
            if (scaleXlabel == null) {
                scaleXlabel = new HashMap<String, String>();
                scalex.put("label", scaleXlabel);
            }
            scaleXlabel.put("text", this.xAxisTitle);
        }
        if (this.yAxisTitle != null) {
            scaley = InteractiveChart.retrieveMapFragment(graph, "scale-y");
            HashMap<String, String> scaleYlabel = (HashMap<String, String>)scaley.get("label");
            if (scaleYlabel == null) {
                scaleYlabel = new HashMap<String, String>();
                scaley.put("label", scaleYlabel);
            }
            scaleYlabel.put("text", this.yAxisTitle);
        }
        if (this.showXGridlines != -1) {
            scalex = InteractiveChart.retrieveMapFragment(graph, "scale-x");
            guide = InteractiveChart.retrieveMapFragment(scalex, "guide");
            if (this.showXGridlines == 1) {
                guide.put("visible", true);
                guide.put("line-width", 1);
            } else if (this.showXGridlines == 0) {
                guide.put("visible", false);
            }
        }
        if (this.showYGridlines != -1) {
            scaley = InteractiveChart.retrieveMapFragment(graph, "scale-y");
            guide = InteractiveChart.retrieveMapFragment(scaley, "guide");
            if (this.showYGridlines == 1) {
                guide.put("line-width", 1);
            } else if (this.showYGridlines == 0) {
                guide.put("visible", false);
            }
        }
        if (this.numGridLines != -1) {
            Map<String, Object> scaleY = InteractiveChart.retrieveMapFragment(graph, "scale-y");
            guide = InteractiveChart.retrieveMapFragment(scaleY, "guide");
            scaleY.put("max-labels", this.numGridLines);
            guide.put("line-width", 1);
        }
        if (this.scaleFrom != -1.0) {
            scaley = InteractiveChart.retrieveMapFragment(graph, "scale-y");
            scaley.put("min-value", this.scaleFrom);
        }
        if (this.scaleTo != -1.0) {
            scaley = InteractiveChart.retrieveMapFragment(graph, "scale-y");
            scaley.put("max-value", this.scaleTo);
        }
    }

    private Map<String, Object> calculateRelevantAxis(Map<String, Object> graph) {
        String chartType = (String)graph.get("type");
        Map<String, Object> scale = InteractiveChart.retrieveMapFragment(graph, "scale-x");
        if ("radar".equalsIgnoreCase(chartType)) {
            scale = InteractiveChart.retrieveMapFragment(graph, "scale-k");
        } else if (this.isPieChartFamily(chartType)) {
            scale = InteractiveChart.retrieveMapFragment(graph, "scale");
        } else if (("vfunnel".equalsIgnoreCase(chartType) || "hfunnel".equalsIgnoreCase(chartType) || "funnel".equalsIgnoreCase(chartType)) && this.seriesValueList.size() == 1) {
            scale = InteractiveChart.retrieveMapFragment(graph, "scale-y");
        }
        return scale;
    }

    static Map<String, Object> retrieveNestedMapFragment(Map<String, Object> graph, String elementTree) {
        HashMap map = null;
        String[] elements = elementTree.split(":");
        for (int i = 0; i < elements.length; ++i) {
            map = (HashMap)graph.get(elements[i]);
            if (map == null) {
                map = new HashMap();
                graph.put(elements[i], map);
            }
            graph = map;
        }
        return map;
    }

    static Map<String, Object> retrieveMapFragment(Map<String, Object> graph, String element) {
        return InteractiveChart.retrieveMapFragment(graph, element, true);
    }

    static Map<String, Object> retrieveMapFragment(Map<String, Object> graph, String element, boolean create) {
        HashMap map = (HashMap)graph.get(element);
        if (map == null && create) {
            map = new HashMap();
            graph.put(element, map);
        }
        return map;
    }

    public void processItemQueryData() {
        this.itemList = new ArrayList<String>();
        ResultSet query = this.getQuery();
        if (query != null) {
            try {
                int itemColumn = query.findColumn(this.getItemColumn());
                while (query.next()) {
                    String item = query.getString(itemColumn);
                    this.addItem(item);
                }
            }
            catch (Exception sqle) {
                throw new RuntimeWrapper(sqle);
            }
            query = null;
        }
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleMap(Map titleMap) {
        this.titleMap = titleMap;
    }

    public void setItemColumn(String itemColumn) {
        this.itemColumn = itemColumn;
    }

    public String getItemColumn() {
        return this.itemColumn;
    }

    public List<String> getItemList() {
        return this.itemList;
    }

    public void addItem(String item) {
        this.itemList.add(item);
    }

    public void setType(String type) {
        this.originalType = type;
        if (!InteractiveChart.isValidChartType(type = type.toLowerCase())) {
            throw new GraphCommon.InvalidChartTypeException(type);
        }
        this.type = InteractiveChart.handleOldChartTypes(type);
    }

    public static String handleOldChartTypes(String type) {
        switch (type) {
            case "curve": 
            case "step": {
                return "line";
            }
            case "cylinder": 
            case "cone": 
            case "pyramid": 
            case "fbar3d": {
                return "bar3d";
            }
            case "column": {
                return "horizontalbar";
            }
            case "histogram": 
            case "hist": 
            case "fbar": {
                return "bar";
            }
            case "hfbar": 
            case "hhistogram": 
            case "hhist": {
                return "hbar";
            }
            case "hfbar3d": {
                return "hbar3d";
            }
            case "curvedarea": 
            case "steppedarea": {
                return "area";
            }
            case "curvedarea3d": 
            case "steppedarea3d": {
                return "area3d";
            }
        }
        return type;
    }

    @Override
    public void setXAxisTitle(String title) {
        this.xAxisTitle = title;
    }

    @Override
    public void setYAxisTitle(String title) {
        this.yAxisTitle = title;
    }

    @Override
    public void setIs3D(boolean show3d) {
        this.show3D = show3d ? (byte)1 : 0;
    }

    @Override
    public void setHasLegend(boolean showLegend) {
        this.showLegend = showLegend ? (byte)1 : 0;
    }

    public void setAdjustLayout(boolean adjustLayout) {
        this.adjustLayout = adjustLayout ? (byte)1 : 0;
    }

    @Override
    public void setOuterColor(String color) {
        this.backgroundColor = color;
    }

    public void setLegend(Map<String, Object> legend) {
        this.legend = legend;
    }

    @Override
    public void setGraphHeight(String graphHeight) {
        InteractiveChartSet.validateAttrValue("chartheight", graphHeight);
        InteractiveChartSet.validateDimensionFormat(this.isServerSideChart(), graphHeight);
        this.height = graphHeight;
    }

    @Override
    public void setGraphWidth(String graphWidth) {
        InteractiveChartSet.validateAttrValue("chartwidth", graphWidth);
        InteractiveChartSet.validateDimensionFormat(this.isServerSideChart(), graphWidth);
        this.width = graphWidth;
    }

    public void setHeight(String height) {
        InteractiveChartSet.validateAttrValue("height", height);
        InteractiveChartSet.validateDimensionFormat(this.isServerSideChart(), height);
        this.height = height;
    }

    public void setWidth(String width) {
        InteractiveChartSet.validateAttrValue("width", width);
        InteractiveChartSet.validateDimensionFormat(this.isServerSideChart(), width);
        this.width = width;
    }

    public void setAspect3d(Map<String, Integer> aspect3d) {
        this.aspect3d = aspect3d;
    }

    public void setScaleR(Map<String, Integer> scaleR) {
        this.scaleR = scaleR;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setPlot(Map<String, Object> plot) {
        this.plot = plot;
    }

    public void setPlotarea(Map<String, Object> plotarea) {
        this.plotarea = plotarea;
    }

    public void setPreview(Map<String, Object> preview) {
        this.preview = preview;
    }

    public void setXaxis(Map<String, Object> xaxis) {
        this.xaxis = xaxis;
    }

    public void setYaxis(Map<String, Object> yaxis) {
        this.yaxis = yaxis;
    }

    public void setTooltip(Map<String, Object> tooltip) {
        this.tooltip = tooltip;
    }

    public void setZoom(Map<String, Object> zoom) {
        this.zoom = zoom;
    }

    public void setLabels(List<Map<String, Object>> labels) {
        this.labels = labels;
    }

    public void setBackground(Map<String, String> background) {
        this.background = background;
    }

    public void setFill(Map<String, String> fill) {
        this.fill = fill;
    }

    public void setBorder(Map<String, String> border) {
        this.border = border;
    }

    public void setBevel(Object bevel) {
        this.bevel = bevel;
    }

    public void setCrosshair(Map<String, Object> crosshair) {
        this.crosshair = crosshair;
    }

    public void setArrows(List<Map<String, Object>> arrows) {
        this.arrows = arrows;
    }

    public void setxaxisvalues(List<Object> xaxisvalues) {
        this.xaxisvalues = xaxisvalues;
    }

    public void setyaxisvalues(List<Object> yaxisvalues) {
        this.yaxisvalues = yaxisvalues;
    }

    @Override
    public void setInnerColor(String color) {
        this.dataBackgroundColor = color;
    }

    @Override
    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder ? (byte)1 : 0;
    }

    public void setMarkers(Map markers) {
        this.markers = markers;
    }

    @Override
    public void setShowMarkers(boolean showMarkers) {
        this.showMarkers = showMarkers ? (byte)1 : 0;
    }

    @Override
    public void setShowScaleMarkers(boolean showScaleMarkers) {
        this.showScaleMarkers = (byte)(showScaleMarkers ? 1 : 0);
    }

    @Override
    public void setMarkerSize(int markerSize) {
        this.markerSize = markerSize;
    }

    @Override
    public void setPieSliceStyle(String style) {
        if (!Graph.isValidPieSliceStyle(style)) {
            throw new Graph.InvalidGraphPieSliceStyleException(style);
        }
        this.pieSliceStyle = style.toLowerCase();
    }

    @Override
    public void setPlaceStyle(String placeStyle) throws GraphException {
        if (!Graph.isValidPlaceStyle(placeStyle.toLowerCase())) {
            throw new GraphCommon.InvalidPlaceStyleException(placeStyle);
        }
        this.placeStyle = placeStyle.toLowerCase();
    }

    @Override
    public void setShowXGridlines(boolean showXGridlines) {
        this.showXGridlines = showXGridlines ? (byte)1 : 0;
    }

    @Override
    public void setShowYGridlines(boolean showYGridlines) {
        this.showYGridlines = showYGridlines ? (byte)1 : 0;
    }

    @Override
    public void setTipBackgroundColor(String color) {
        this.tipBackgroundColor = color;
    }

    public void setXaxis2(Map<String, Object> xaxis2) {
        this.xaxis2 = xaxis2;
    }

    public void setYaxis2(Map<String, Object> yaxis2) {
        this.yaxis2 = yaxis2;
    }

    public void setScales(String scales) {
        this.scales = scales;
    }

    @Override
    public void setScaleFrom(double scaleFrom) {
        this.scaleFrom = scaleFrom;
    }

    @Override
    public void setScaleTo(double scaleTo) {
        this.scaleTo = scaleTo;
    }

    @Override
    public void setFont(String font) {
        this.font = font;
    }

    @Override
    public void setFontSize(int fontSize) throws GraphException {
        if (fontSize < 0) {
            throw new Graph.InvalidChartingArgValueException("fontSize", fontSize + " which is negative", "positive");
        }
        this.fontSize = fontSize;
    }

    @Override
    public void setFontBold(boolean isFontBold) {
        this.fontBold = isFontBold ? (byte)1 : 0;
    }

    @Override
    public void setFontItalic(boolean isFontItalic) {
        this.fontItalic = isFontItalic ? (byte)1 : 0;
    }

    @Override
    public void setForegroundNGridColor(String foregroundColor) {
        this.foreGroundColor = foregroundColor;
    }

    @Override
    public void setNumGridelines(int gridlines) {
        this.numGridLines = gridlines;
    }

    @Override
    public String getFont() {
        return null;
    }

    @Override
    public void setForegroundColor(String f) {
    }

    @Override
    public void setLabelFormat(String s) {
        if (!this.isValidLabelFormat(s)) {
            throw new InvalidChartLabelFormatException(s);
        }
        this.labelFormat = s;
    }

    public boolean isValidLabelFormat(String labelFormat) {
        return _validLabelFormats.contains(labelFormat.toLowerCase());
    }

    @Override
    public void setTipStyle(String f) {
    }

    @Override
    public void setUrl(String url) {
        if (url != null && url.trim().length() > 0) {
            this.url = url;
        }
    }

    @Override
    public void setXAxisType(String s) {
    }

    @Override
    public void setXOffset(double x) {
    }

    @Override
    public void setYAxisType(String s) {
    }

    @Override
    public void setYOffset(double y) {
    }

    @Override
    public String getImageFormat() {
        return this.format;
    }

    @Override
    public String getGraphHeight() {
        return this.height;
    }

    @Override
    public String getGraphWidth() {
        return this.width;
    }

    @Override
    public void setImageFormat(String format) throws GraphException {
        if (!this.isValidFormat(format, this.isServerSideChart())) {
            if (this.isServerSideChart()) {
                throw new InvalidServerImageFormatException(format);
            }
            throw new InvalidClientImageFormatException(format);
        }
        this.format = this.isServerSideChart() ? serverFormats.get(format.toLowerCase()) : clientFormats.get(format.toLowerCase());
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public boolean isValidFormat(String format, boolean isServerSide) {
        if (this.isServerSideChart()) {
            return serverFormats.containsKey(format.toLowerCase());
        }
        return clientFormats.containsKey(format.toLowerCase());
    }

    @Override
    public void setLabelMask(String labelMask) throws GraphException {
    }

    @Override
    public void setRotated(boolean isRotated) {
    }

    @Override
    public void setSortColumnNames(boolean flag) {
    }

    public void setRefresh(Map<String, Object> refresh) {
        if (refresh == null) {
            return;
        }
        this.refresh = refresh;
        Object type = this.refresh.get("type");
        if ("full".equalsIgnoreCase((String)type)) {
            if (this.refresh.get("url") != null) {
                this.urlData = (String)this.refresh.get("url");
            }
            this.refresh.remove("url");
        }
    }

    public void setServerSideChart(boolean serverSide) {
        this.serverSideChart = serverSide;
    }

    public boolean isServerSideChart() {
        return this.serverSideChart;
    }

    public boolean isPieChart() {
        String chartType = this.type;
        return "pie".equalsIgnoreCase(chartType) || "pie3d".equalsIgnoreCase(chartType) || "nestedpie".equalsIgnoreCase(chartType);
    }

    public boolean isPieChartFamily(String chartType) {
        return "pie".equalsIgnoreCase(chartType) || "pie3d".equalsIgnoreCase(chartType) || "ring".equalsIgnoreCase(chartType) || "ring3d".equalsIgnoreCase(chartType);
    }

    static {
        chartTypes.put("pie3d", "pie3d");
        chartTypes.put("area3d", "area3d");
        chartTypes.put("bar3d", "bar3d");
        chartTypes.put("horizontalbar3d", "hbar3d");
        chartTypes.put("hbar3d", "hbar3d");
        chartTypes.put("hfunnel3d", "hfunnel3d");
        chartTypes.put("vfunnel3d", "vfunnel3d");
        chartTypes.put("line3d", "line3d");
        chartTypes.put("ring3d", "ring3d");
        chartTypes.put("curvedarea3d", "area3d");
        chartTypes.put("steppedarea3d", "area3d");
        chartTypes.put("fbar3d", "bar3d");
        chartTypes.put("hfbar3d", "hbar3d");
        chartTypes.put("area", "area");
        chartTypes.put("bar", "bar");
        chartTypes.put("bubble", "bubble");
        chartTypes.put("gauge", "gauge");
        chartTypes.put("horizontalbar", "hbar");
        chartTypes.put("column", "hbar");
        chartTypes.put("hbar", "hbar");
        chartTypes.put("hbullet", "hbullet");
        chartTypes.put("line", "line");
        chartTypes.put("nestedpie", "nestedpie");
        chartTypes.put("pie", "pie");
        chartTypes.put("radar", "radar");
        chartTypes.put("scatter", "scatter");
        chartTypes.put("vbullet", "vbullet");
        chartTypes.put("bullet", "vbullet");
        chartTypes.put("stock", "stock");
        chartTypes.put("venn", "venn");
        chartTypes.put("hfunnel", "hfunnel");
        chartTypes.put("vfunnel", "vfunnel");
        chartTypes.put("funnel", "vfunnel");
        chartTypes.put("piano", "piano");
        chartTypes.put("curve", "line");
        chartTypes.put("step", "line");
        chartTypes.put("cylinder", "bar3d");
        chartTypes.put("cone", "bar3d");
        chartTypes.put("pyramid", "bar3d");
        chartTypes.put("histogram", "bar");
        chartTypes.put("hhistogram", "hbar");
        chartTypes.put("hist", "bar");
        chartTypes.put("hhist", "hbar");
        chartTypes.put("fbar", "bar");
        chartTypes.put("hfbar", "hbar");
        chartTypes.put("ring", "ring");
        chartTypes.put("varea", "varea");
        chartTypes.put("curvedarea", "area");
        chartTypes.put("steppedarea", "area");
        chartTypes.put("boxplot", "boxplot");
        chartTypes.put("hboxplot", "hboxplot");
        clientFormats = new HashMap(2);
        clientFormats.put("html", "html");
        clientFormats.put("flash", "flash");
        serverFormats = new HashMap(2);
        serverFormats.put("jpg", "jpg");
        serverFormats.put("png", "png");
        locale = Locale.getDefault();
        currencyFormatter = NumberFormat.getCurrencyInstance(locale);
        currencySymbols = ((DecimalFormat)currencyFormatter).getDecimalFormatSymbols();
        _validLabelFormats = Arrays.asList("number", "currency", "percent", "date");
        CURRENCY_SYMBOL = currencySymbols.getCurrencySymbol();
        DECIMAL_SEPARATOR_VALUE = Character.toString(currencySymbols.getDecimalSeparator());
        THOUSAND_SEPARATOR_VALUE = Character.toString(currencySymbols.getGroupingSeparator());
        FORMATTED_CURRENCY_VALUE = currencyFormatter.format(1L);
        IS_CURRENCY_SYMBOL_PREFIX = FORMATTED_CURRENCY_VALUE.startsWith(CURRENCY_SYMBOL);
        hmixedChartList = Arrays.asList("varea", "hbar", "hbullet");
    }

    public static class ScalesValueException
    extends ApplicationException {
        public String scales;

        ScalesValueException(String scales) {
            this.scales = scales;
        }
    }

    public class InvalidChartLabelFormatException
    extends GraphException {
        private String _labelFormat;

        public InvalidChartLabelFormatException(String labelFormat) {
            this._labelFormat = labelFormat;
        }

        public String getLabelFormat() {
            return this._labelFormat;
        }
    }

    public static class InvalidServerImageFormatException
    extends GraphException {
        private String format;

        public InvalidServerImageFormatException(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class InvalidClientImageFormatException
    extends GraphException {
        private String format;

        public InvalidClientImageFormatException(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

