/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.filter.FusionContext;
import coldfusion.graph.GraphException;
import coldfusion.graph.IChartConstants;
import coldfusion.graph.IChartSet;
import coldfusion.graph.InteractiveChart;
import coldfusion.graph.JSONManipulator;
import coldfusion.graph.StyleFileResolver;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Scope;
import coldfusion.server.DocumentService;
import coldfusion.server.GraphingService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.form.JavascriptHelper;
import coldfusion.util.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;

public class InteractiveChartSet
implements IChartSet,
IChartConstants {
    private Logger logger = CFLogs.APPLICATION_LOG;
    List<InteractiveChart> graphsetList = new ArrayList<InteractiveChart>();
    private String layout;
    public static final String ZC_HTML5_JS = "/chart/cfchart-html.js";
    public static final String CFCHART_JS = "/chart/cfchart.js";
    public static final String ZC_LICENSE_JS = "/chart/license.js";
    public static final String ZC_LITE_JS = "/chart/cfchart-lite.js";
    public static final String ZC_SWF_PATH = "chart/cfchart.swf";
    public static final String ZC_SERVER_JS = "/chart/cfchart-server.js";
    private final String DEFAULT_THEME = "classic";
    private boolean serverSideChart;
    private String format;
    private int serialID;
    private String id;
    public static final String MODULESDIR_PATH = "chart/modules/";
    private String dataurl;
    private static final String ZC_DEFAULTS = "{ \"root\" : {   \"gui\" : { \"context-menu\" : { \"visible\" : true },\"behaviors\" : [ {\"id\" : \"BugReport\", \"enabled\" : \"none\" }, {\"id\" : \"DownloadPDF\", \"enabled\" : \"none\" }, {\"id\" : \"Print\", \"enabled\" : \"none\" } ] } } }";
    public static final String ZC_SWF;
    public static final String MODULESDIR;
    private static String absPathScript;
    public static final String PLUGINS_PREFIX = "zingchart-rhino-";
    public static final String PLUGINS_SUFFIX = ".min.js";
    private String renderer = "auto";
    List<Map<String, Object>> graphset = new ArrayList<Map<String, Object>>();
    private static Map<String, String> _modulesMapper;
    private String plugins = "";
    private Set<String> pluginsSet = new HashSet<String>();
    private String theme;
    public boolean isThemeDefined = false;
    private String themeContent;
    private final String layoutPattern = "^\\d+x\\d+$";
    private static final char TAB = '\t';
    private static final String CHART_DIV_ID = "cfchart";
    private static final String JSONCONFIG = "jsonConfig";
    private String width = "320";
    private String height = "240";
    public static HashMap<String, String> renderers;
    public static HashMap<String, String> clientFormats;
    public static HashMap<String, String> serverFormats;

    public InteractiveChartSet(int serialID) {
        this.serialID = serialID;
    }

    @Override
    public String getImageFormat() {
        return this.format;
    }

    @Override
    public String getGraphHeight() {
        return this.height;
    }

    @Override
    public String getGraphWidth() {
        return this.width;
    }

    @Override
    public void setImageFormat(String format) {
        if (!this.isValidFormat(format, this.isServerSideChart())) {
            if (this.isServerSideChart()) {
                throw new InteractiveChart.InvalidServerImageFormatException(format);
            }
            throw new InteractiveChart.InvalidClientImageFormatException(format);
        }
        this.format = this.isServerSideChart() ? serverFormats.get(format.toLowerCase()) : clientFormats.get(format.toLowerCase());
    }

    @Override
    public void setHeight(String height) {
        InteractiveChartSet.validateAttrValue("height", height);
        InteractiveChartSet.validateDimensionFormat(this.isServerSideChart(), height);
        this.height = height;
    }

    @Override
    public void setWidth(String width) {
        InteractiveChartSet.validateAttrValue("width", width);
        InteractiveChartSet.validateDimensionFormat(this.isServerSideChart(), width);
        this.width = width;
    }

    public boolean isValidFormat(String format, boolean isServerSide) {
        if (this.isServerSideChart()) {
            return serverFormats.containsKey(format.toLowerCase());
        }
        return clientFormats.containsKey(format.toLowerCase());
    }

    @Override
    public void setRenderer(String renderer) {
        this.renderer = renderer;
    }

    @Override
    public void setServerSideChart(boolean serverSide) {
        this.serverSideChart = serverSide;
    }

    @Override
    public void setTheme(String theme) {
        this.theme = theme;
    }

    public boolean isServerSideChart() {
        return this.serverSideChart;
    }

    public void addChart(InteractiveChart chart) {
        this.graphsetList.add(chart);
    }

    @Override
    public void setLayout(String layout) {
        this.validateLayout(layout);
        this.layout = layout;
    }

    public void setDataUrl(String dataurl) {
        this.dataurl = dataurl;
    }

    public void setId(String id) {
        this.id = id;
    }

    private String emitChartID() {
        if (this.id != null) {
            return this.id;
        }
        Object chartid = CHART_DIV_ID;
        chartid = (String)chartid + this.serialID;
        return chartid;
    }

    private String emitJSONVar() {
        String id = JSONCONFIG + this.serialID;
        return id;
    }

    public void serverChartHeadWriter() {
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(FusionContext.getCurrent().pageContext, false);
        htmlAssembler.importJS(ZC_SERVER_JS, null, false, false);
        htmlAssembler.writeHead(FusionContext.getCurrent().pageContext.getOut());
    }

    public String chartRenderer() throws FileNotFoundException {
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(FusionContext.getCurrent().pageContext, false);
        htmlAssembler.importJS("/smp/swfobject.js");
        htmlAssembler.importJS("/jquery/jquery.js");
        htmlAssembler.importJS(ZC_LITE_JS, null, false, false);
        htmlAssembler.importJS(ZC_HTML5_JS, null, false, false);
        htmlAssembler.importJS(CFCHART_JS, null, false, false);
        htmlAssembler.importJS(ZC_LICENSE_JS, null, false, false);
        htmlAssembler.writeHead(FusionContext.getCurrent().pageContext.getOut());
        StringBuilder sb = new StringBuilder(500);
        sb.append("<script type=\"text/javascript\">");
        sb.append(IOUtils.lineSeparator);
        sb.append("var ");
        sb.append(this.emitJSONVar());
        sb.append(" = '");
        sb.append(this.mergeChartJSON());
        sb.append("';");
        sb.append(IOUtils.lineSeparator);
        sb.append("var themeVar_");
        sb.append(this.emitChartID());
        sb.append("= '");
        sb.append(this.themeContent);
        sb.append("';");
        sb.append(IOUtils.lineSeparator);
        sb.append("jQuery(document).ready(function(){");
        sb.append(IOUtils.lineSeparator);
        sb.append('\t');
        sb.append("ColdFusion.Chart.getChartHandle().MODULESDIR=\"");
        sb.append(MODULESDIR);
        sb.append("\";");
        sb.append(IOUtils.lineSeparator);
        sb.append("ColdFusion.Chart.getChartHandle().render({");
        sb.append("data : ");
        sb.append(this.emitJSONVar());
        sb.append(",");
        sb.append("liburl : '");
        sb.append(this.resolveZCSwfPath());
        sb.append("',");
        sb.append("width : ");
        sb.append("'100%'");
        sb.append(",");
        sb.append("height : ");
        sb.append("'100%'");
        sb.append(",");
        if (this.dataurl != null) {
            sb.append("dataurl").append(" : '");
            sb.append(this.dataurl);
            sb.append("',");
        }
        sb.append("preservecontainer : ");
        sb.append(true);
        sb.append(",");
        sb.append("output : '");
        sb.append(this.format.equalsIgnoreCase("flash") ? "flash" : (this.format.equalsIgnoreCase("html") ? this.renderer.toLowerCase() : ""));
        sb.append("',");
        sb.append("'safe-render' : ");
        sb.append(true);
        sb.append(",");
        sb.append("'safe-render-timeout' : ");
        sb.append(1000);
        sb.append(",");
        sb.append("'safe-render-persist' : ");
        sb.append(false);
        sb.append(",");
        sb.append("'hideprogresslogo' : ");
        sb.append(true);
        sb.append(",");
        sb.append("'defaults' : '");
        sb.append(ZC_DEFAULTS);
        sb.append("',");
        sb.append("container : '");
        sb.append(this.emitChartID());
        sb.append("',");
        if (this.isThemeDefined) {
            sb.append("defaults : ");
            sb.append("themeVar_");
            sb.append(this.emitChartID());
        } else {
            sb.append("theme : '");
            sb.append("classic");
            sb.append("'");
        }
        sb.append("});");
        sb.append(IOUtils.lineSeparator);
        sb.append("});");
        sb.append(IOUtils.lineSeparator);
        sb.append("</script>");
        sb.append(IOUtils.lineSeparator);
        sb.append("<div id=\"");
        sb.append(this.emitChartID());
        sb.append("\" style=\"width:");
        sb.append(this.width);
        sb.append("; height:");
        sb.append(this.height);
        sb.append("\"></div>");
        sb.append(IOUtils.lineSeparator);
        return sb.toString();
    }

    private String resolveZCSwfPath() {
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(FusionContext.getCurrent().pageContext, false);
        Object importPath = htmlAssembler.getImportPath();
        if (importPath == null) {
            return ZC_SWF;
        }
        if (!((String)importPath).endsWith("/")) {
            importPath = (String)importPath + "/";
        }
        return (String)importPath + ZC_SWF_PATH;
    }

    private void validateTheme(String theme) throws FileNotFoundException {
        this.themeContent = new StyleFileResolver(theme).readTheme();
        this.isThemeDefined = true;
    }

    private void validateLayout(String layout) {
        if (layout.equals("horizontal") || layout.equals("vertical")) {
            return;
        }
        Pattern compiledLayoutPattern = Pattern.compile("^\\d+x\\d+$");
        if (compiledLayoutPattern.matcher(layout).matches()) {
            return;
        }
        throw new InvalidLayoutException();
    }

    public static void validateDimensionFormat(boolean isServerChart, String dimension) {
        if (!isServerChart) {
            return;
        }
        if ((dimension = dimension.trim()).charAt(dimension.length() - 1) == '%') {
            throw new InvalidServerHeightWidthException(dimension);
        }
    }

    public static void validateAttrValue(String attr, String attrVal) {
        boolean isPercent = false;
        if ((attrVal = attrVal.trim()).isEmpty()) {
            throw new InvalidValueException(attr);
        }
        if (attrVal.charAt(attrVal.length() - 1) == '%') {
            isPercent = true;
            attrVal = attrVal.substring(0, attrVal.length() - 1);
        }
        try {
            double attrParsedVal = Double.parseDouble(attrVal);
            if (isPercent && attrParsedVal > 100.0) {
                throw new InvalidValueException(attr);
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException(attr);
        }
    }

    public String mergeChartJSON() throws FileNotFoundException {
        HashMap<String, Object> jsonconfig = new HashMap<String, Object>();
        if (this.layout != null) {
            jsonconfig.put("layout", this.layout);
        }
        jsonconfig.put("graphset", this.graphset);
        int graphSize = this.graphsetList.size();
        if (this.theme != null) {
            this.validateTheme(this.theme);
        }
        for (int i = 0; i < graphSize; ++i) {
            this.merge(jsonconfig, this.graphsetList.get(i), i);
        }
        if (this.isServerSideChart()) {
            this.handlePlugins((List)jsonconfig.get("graphset"));
        }
        String mergedStyle = JSONManipulator.serializeJSON(jsonconfig);
        return mergedStyle;
    }

    private void handlePlugins(List<Map> graphset) {
        for (Map graph : graphset) {
            String type;
            if (graph.get("type") == null || !_modulesMapper.containsKey(type = ((String)graph.get("type")).toLowerCase())) continue;
            this.pluginsSet.add(_modulesMapper.get(type));
        }
    }

    private void addPlugins(Set<String> plugins) {
        String fullPluginPrefix = absPathScript + File.separator + PLUGINS_PREFIX;
        StringJoiner stringJoiner = new StringJoiner(",", fullPluginPrefix, PLUGINS_SUFFIX);
        for (String plugin : plugins) {
            stringJoiner.add(plugin);
        }
        this.plugins = stringJoiner.toString();
    }

    public void merge(Map jsonConfig, InteractiveChart chart, int chartNum) throws FileNotFoundException {
        chart.mergeJSON(jsonConfig, this.isThemeDefined);
    }

    public Object serverChartRenderer(boolean isBase64, String _name, boolean _retIS, NeoPageContext pageContext, HttpServletRequest request, Tag parent, FusionContext fContext) throws IOException {
        GraphingService.GraphURLFormat format;
        GraphingService graphService = null;
        DocumentService documentService = null;
        String graphStyle = null;
        String url = null;
        String graphContent = null;
        graphService = ServiceFactory.getNewGraphingService(true);
        documentService = ServiceFactory.getDocumentService();
        boolean isInstanceOfDocumentTag = false;
        GraphingService.GraphURLFormat graphURLFormat = format = isBase64 || this.isPresentationTagParent(parent) ? GraphingService.GraphURLFormat.BASE64 : null;
        if (documentService != null) {
            boolean bl = isInstanceOfDocumentTag = this.findDocumentParentTag(documentService, parent) != null;
            if (format == null && isInstanceOfDocumentTag) {
                format = GraphingService.GraphURLFormat.FILE;
            }
        }
        graphContent = this.mergeChartJSON();
        if (!isInstanceOfDocumentTag) {
            this.serverChartHeadWriter();
        }
        if (!this.pluginsSet.isEmpty()) {
            absPathScript = fContext.getRealPath(MODULESDIR);
            this.addPlugins(this.pluginsSet);
        }
        if (_name == null) {
            String imageTag = graphService.generateGraph(this.getImageFormat(), this.getGraphHeight(), this.getGraphWidth(), request.getContextPath(), url, graphStyle, graphContent, format, this.plugins, this.isThemeDefined ? this.themeContent : null);
            Scope scope = (Scope)pageContext.SymTab_findBuiltinScope("CGI");
            if (scope != null) {
                String userAgent = (String)scope.get("HTTP_USER_AGENT");
                if (userAgent != null && userAgent.indexOf("MSIE") != -1 && format.equals("flash")) {
                    return "<NOSCRIPT>\n" + imageTag + "\n</NOSCRIPT>\n" + JavascriptHelper.wrapActiveContent(imageTag, null);
                }
                return imageTag;
            }
        } else {
            byte[] graphData = graphService.generateBytes(this.getImageFormat(), this.getGraphHeight(), this.getGraphWidth(), url, graphStyle, graphContent, this.plugins, this.isThemeDefined ? this.themeContent : null);
            Object graphDataOut = !_retIS ? graphData : (Object)new ByteArrayInputStream(graphData);
            pageContext.setAttribute(_name, graphDataOut);
            return "";
        }
        return null;
    }

    private final Tag findDocumentParentTag(DocumentService documentService, Tag parentTag) {
        while (parentTag != null) {
            if (documentService.isInstanceOfDocumentTag(parentTag)) {
                return parentTag;
            }
            parentTag = parentTag.getParent();
        }
        return null;
    }

    protected boolean isPresentationTagParent(Object parent) {
        try {
            if (ServiceFactory.getPresentationService() == null) {
                return false;
            }
            while (parent != null) {
                if (ServiceFactory.getPresentationService().isInstanceOfPresentationTag(parent)) {
                    return true;
                }
                parent = ((GenericTag)((Object)parent)).getParent();
            }
        }
        catch (ServiceFactory.ModuleNotAvailableException | ServiceFactory.ModuleNotInstalledException e) {
            return false;
        }
        return false;
    }

    static {
        _modulesMapper = new HashMap<String, String>(2);
        Object scriptSrc = null;
        try {
            scriptSrc = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getCFFormScriptSrc();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (scriptSrc == null || ((String)scriptSrc).trim().length() == 0) {
            scriptSrc = "/cf_scripts/scripts/";
        }
        if (!((String)scriptSrc).endsWith("/")) {
            scriptSrc = (String)scriptSrc + "/";
        }
        ZC_SWF = (String)scriptSrc + ZC_SWF_PATH;
        MODULESDIR = (String)scriptSrc + MODULESDIR_PATH;
        _modulesMapper.put("boxplot", "boxplot");
        _modulesMapper.put("hboxplot", "boxplot");
        renderers = new HashMap(4);
        renderers.put("svg", "svg");
        renderers.put("canvas", "canvas");
        renderers.put("vml", "vml");
        renderers.put("auto", "auto");
        renderers.put("flash", "flash");
        clientFormats = new HashMap(2);
        clientFormats.put("html", "html");
        clientFormats.put("flash", "flash");
        serverFormats = new HashMap(2);
        serverFormats.put("jpg", "jpg");
        serverFormats.put("png", "png");
        serverFormats.put("svg", "svg");
    }

    public class InvalidLayoutException
    extends GraphException {
    }

    public static class InvalidServerHeightWidthException
    extends GraphException {
        private String str;

        public InvalidServerHeightWidthException(String str) {
            this.str = str;
        }

        public String getStr() {
            return this.str;
        }
    }

    public static class InvalidValueException
    extends GraphException {
        public String attr;

        public InvalidValueException(String attr) {
            this.attr = attr;
        }
    }
}

