/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructBean;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class JSONManipulator {
    public static final char OPEN_OBJECT = '{';
    public static final char CLOSE_OBJECT = '}';
    public static final char OPEN_ARRAY = '[';
    public static final char CLOSE_ARRAY = ']';
    public static final char ELEMENT_SEP = ',';
    public static final char KEYVAL_SEP = ':';
    public static final char OPEN_STRING = '\"';
    public static final char CLOSE_STRING = '\"';
    public static final char ESCAPE = '\\';
    public static final String NULL = "null";
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static Object deserializeJSON(Object jsonObj) {
        Object o;
        String json;
        try {
            json = Cast._String(jsonObj).trim();
        }
        catch (Exception ex) {
            throw new JSONParseInvalidTypeException();
        }
        ParserState state = new ParserState(json, true);
        try {
            o = JSONManipulator.parseJSON(state);
        }
        catch (JSONParseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new JSONParseException(state, t);
        }
        return o;
    }

    public static boolean isJSON(Object o) {
        boolean isValid;
        String s;
        try {
            s = Cast._String(o).trim();
        }
        catch (Exception ex) {
            return false;
        }
        if (s.length() == 0) {
            return false;
        }
        ParserState state = new ParserState(s, false);
        try {
            JSONManipulator.parseJSON(state);
            isValid = true;
        }
        catch (JSONParseException jsonEx) {
            isValid = false;
        }
        catch (Throwable t) {
            throw new JSONParseException(state, t);
        }
        return isValid;
    }

    public static String serializeJSON(Object o) {
        StringBuffer json = new StringBuffer();
        JSONManipulator.serializeJSON(o, json);
        return json.toString();
    }

    private static void serializeJSON(Object o, StringBuffer json) {
        if (o == null) {
            json.append(NULL);
        } else if (o instanceof Number) {
            json.append(o.toString());
        } else if (o instanceof String) {
            String s = (String)o;
            json.append('\"').append(JSONManipulator.escape((String)o)).append('\"');
        } else if (o.getClass().isArray()) {
            JSONManipulator.serializeArrayToJSON(o, json);
        } else if (o instanceof Map) {
            JSONManipulator.serializeJSON((Map)o, json);
        } else if (o instanceof List) {
            JSONManipulator.serializeJSON((List)o, json);
        } else {
            json.append(o.toString());
        }
    }

    public static void serializeJSON(List list, StringBuffer json) {
        int listSize = list.size();
        json.append('[');
        for (int i = 0; i < listSize; ++i) {
            Object value = list.get(i);
            if (i != 0) {
                json.append(',');
            }
            JSONManipulator.serializeJSON(value, json);
        }
        json.append(']');
    }

    private static void serializeJSON(Map map, StringBuffer json) {
        json.append('{');
        boolean first = true;
        for (Map.Entry entry : map.entrySet()) {
            block4: {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                if (!first) {
                    json.append(',');
                }
                json.append('\"').append(JSONManipulator.escape(key)).append('\"').append(':');
                try {
                    JSONManipulator.serializeJSON(value, json);
                }
                catch (Exception e) {
                    if (!(map instanceof StructBean)) break block4;
                    throw new JSONSerializeComplexJavaException(e);
                }
            }
            first = false;
        }
        json.append('}');
    }

    private static void serializeArrayToJSON(Object o, StringBuffer json) {
        Class<?> componentClass = o.getClass().getComponentType();
        if (componentClass.isPrimitive()) {
            if (componentClass == Character.TYPE) {
                JSONManipulator.serializeJSON(new String((char[])o), json);
            } else {
                if (componentClass == Byte.TYPE) {
                    throw new JSONSerializeBinaryException();
                }
                json.append('[');
                for (int i = 0; i < Array.getLength(o); ++i) {
                    Object value = Array.get(o, i);
                    if (i != 0) {
                        json.append(',');
                    }
                    json.append(value);
                }
                json.append(']');
            }
        } else {
            Object[] oArr = (Object[])o;
            json.append('[');
            for (int i = 0; i < oArr.length; ++i) {
                if (i != 0) {
                    json.append(',');
                }
                JSONManipulator.serializeJSON(oArr[i], json);
            }
            json.append(']');
        }
    }

    private static Object parseJSON(ParserState state) {
        Object cfml = JSONManipulator.parseObject(state);
        if (!state.isComplete()) {
            throw new JSONParseException(state);
        }
        return cfml;
    }

    private static Object parseObject(ParserState state) {
        JSONManipulator.walkWhitespace(state);
        return switch (state.currentChar()) {
            case '{' -> JSONManipulator.parseStruct(state);
            case '[' -> JSONManipulator.parseArray(state);
            case '\"' -> JSONManipulator.parseString(state);
            case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> JSONManipulator.parseNumber(state, true);
            case '-' -> JSONManipulator.parseNumber(state, false);
            case 't' -> JSONManipulator.parseBoolean(state, true);
            case 'f' -> JSONManipulator.parseBoolean(state, false);
            case 'n' -> JSONManipulator.parseNull(state);
            default -> throw new JSONParseException(state);
        };
    }

    private static void walkWhitespace(ParserState state) {
        boolean isWhitespace = true;
        block3: while (!state.isComplete() && isWhitespace) {
            switch (state.currentChar()) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    state.incrementOffset();
                    continue block3;
                }
            }
            isWhitespace = false;
        }
    }

    private static Struct parseStruct(ParserState state) {
        Struct struct = null;
        if (state.construct) {
            struct = new Struct();
        }
        state.incrementOffset();
        boolean done = false;
        JSONManipulator.walkWhitespace(state);
        if (state.currentChar() == '}') {
            done = true;
        }
        block4: while (!done) {
            if (state.currentChar() != '\"') {
                throw new JSONParseInvalidCharException(state, '\"');
            }
            String key = JSONManipulator.parseString(state);
            JSONManipulator.walkWhitespace(state);
            if (state.currentChar() != ':') {
                throw new JSONParseInvalidCharException(state, ':');
            }
            state.incrementOffset();
            Object value = JSONManipulator.parseObject(state);
            if (state.construct) {
                struct.put(key, value);
            }
            JSONManipulator.walkWhitespace(state);
            switch (state.currentChar()) {
                case ',': {
                    state.incrementOffset();
                    JSONManipulator.walkWhitespace(state);
                    continue block4;
                }
                case '}': {
                    done = true;
                    continue block4;
                }
            }
            throw new JSONParseInvalidCharsException(state, ',', '}');
        }
        state.incrementOffset(false);
        return struct;
    }

    private static coldfusion.runtime.Array parseArray(ParserState state) {
        coldfusion.runtime.Array array = null;
        if (state.construct) {
            array = new coldfusion.runtime.Array();
        }
        state.incrementOffset();
        boolean done = false;
        JSONManipulator.walkWhitespace(state);
        if (state.currentChar() == ']') {
            done = true;
        }
        block4: while (!done) {
            Object value = JSONManipulator.parseObject(state);
            if (state.construct) {
                array.add(value);
            }
            JSONManipulator.walkWhitespace(state);
            switch (state.currentChar()) {
                case ',': {
                    state.incrementOffset();
                    JSONManipulator.walkWhitespace(state);
                    continue block4;
                }
                case ']': {
                    done = true;
                    continue block4;
                }
            }
            throw new JSONParseInvalidCharsException(state, ',', ']');
        }
        state.incrementOffset(false);
        return array;
    }

    private static String parseString(ParserState state) {
        state.incrementOffset();
        int stringStartIndex = state.offset;
        StringBuffer s = null;
        if (state.construct) {
            s = new StringBuffer();
        }
        while (state.currentChar() != '\"') {
            if (state.currentChar() == '\\') {
                if (state.construct) {
                    s.append(state.json, stringStartIndex, state.offset - stringStartIndex);
                }
                state.incrementOffset();
                switch (state.currentChar()) {
                    case '\'': {
                        if (!state.construct) break;
                        s.append('\'');
                        break;
                    }
                    case '\"': {
                        if (!state.construct) break;
                        s.append('\"');
                        break;
                    }
                    case '\\': {
                        if (!state.construct) break;
                        s.append('\\');
                        break;
                    }
                    case '/': {
                        if (!state.construct) break;
                        s.append('/');
                        break;
                    }
                    case 'b': {
                        if (!state.construct) break;
                        s.append('\b');
                        break;
                    }
                    case 'f': {
                        if (!state.construct) break;
                        s.append('\f');
                        break;
                    }
                    case 'n': {
                        if (!state.construct) break;
                        s.append('\n');
                        break;
                    }
                    case 'r': {
                        if (!state.construct) break;
                        s.append('\r');
                        break;
                    }
                    case 't': {
                        if (!state.construct) break;
                        s.append('\t');
                        break;
                    }
                    case 'u': {
                        char c;
                        state.incrementOffset();
                        try {
                            byte b1 = (byte)Integer.parseInt(new String(state.json, state.offset, 2), 16);
                            byte b2 = (byte)Integer.parseInt(new String(state.json, state.offset + 2, 2), 16);
                            ByteBuffer bb = state.getByteBuffer();
                            bb.put(b1).put(b2);
                            c = bb.getChar(0);
                        }
                        catch (Throwable t) {
                            throw new JSONParseInvalidUnicodeSequenceException(state, t);
                        }
                        if (state.construct) {
                            s.append(c);
                        }
                        state.incrementOffset(3);
                        break;
                    }
                    default: {
                        throw new JSONParseException(state);
                    }
                }
                stringStartIndex = state.offset + 1;
            }
            state.incrementOffset();
        }
        String str = null;
        if (state.construct) {
            int stringLength = state.offset - stringStartIndex;
            if (stringLength > 0) {
                s.append(state.json, stringStartIndex, stringLength);
            }
            str = s.toString();
        }
        state.incrementOffset(false);
        return str;
    }

    private static Number parseNumber(ParserState state, boolean foundNumber) {
        int numberStartIndex = state.offset;
        boolean isNumber = true;
        boolean foundE = false;
        boolean foundDecimal = false;
        state.incrementOffset(false);
        while (isNumber && !state.isComplete()) {
            switch (state.currentChar()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    foundNumber = true;
                    break;
                }
                case '.': {
                    if (foundDecimal || foundE) {
                        throw new JSONParseException(state);
                    }
                    foundDecimal = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (foundE || !foundNumber) {
                        throw new JSONParseException(state);
                    }
                    foundE = true;
                    if (state.nextChar() != '+' && state.nextChar() != '-') break;
                    state.incrementOffset();
                    break;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ']': 
                case '}': {
                    isNumber = false;
                    break;
                }
                default: {
                    throw new JSONParseException(state);
                }
            }
            if (!isNumber) continue;
            state.incrementOffset(false);
        }
        Double d = null;
        Integer i = null;
        if (state.construct) {
            String numberStr = new String(state.json, numberStartIndex, state.offset - numberStartIndex);
            if (!(foundDecimal || foundE || System.getProperty("json.numberasdouble", FALSE).equalsIgnoreCase(TRUE))) {
                try {
                    i = Integer.valueOf(numberStr);
                    return i;
                }
                catch (Exception e) {
                    try {
                        long l = Long.valueOf(numberStr);
                        return l;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            d = Double.valueOf(numberStr);
        }
        return d;
    }

    private static Boolean parseBoolean(ParserState state, boolean expected) {
        String compareTo = expected ? TRUE : FALSE;
        for (int i = 1; i < compareTo.length(); ++i) {
            state.incrementOffset();
            if (state.currentChar() == compareTo.charAt(i)) continue;
            throw new JSONParseException(state);
        }
        state.incrementOffset(false);
        Boolean b = expected ? Boolean.TRUE : Boolean.FALSE;
        return b;
    }

    private static String parseNull(ParserState state) {
        for (int i = 1; i < NULL.length(); ++i) {
            state.incrementOffset();
            if (state.currentChar() == NULL.charAt(i)) continue;
            throw new JSONParseException(state);
        }
        state.incrementOffset(false);
        return NULL;
    }

    private static String escape(String s) {
        int i;
        StringBuffer escaped = new StringBuffer();
        char[] chars = s.toCharArray();
        int unescapeIdx = 0;
        block11: for (i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\"': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('\"');
                    continue block11;
                }
                case '\'': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('\'');
                    continue block11;
                }
                case '\\': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('\\');
                    continue block11;
                }
                case '/': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('/');
                    continue block11;
                }
                case '\b': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('b');
                    continue block11;
                }
                case '\f': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('f');
                    continue block11;
                }
                case '\n': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('n');
                    continue block11;
                }
                case '\r': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('r');
                    continue block11;
                }
                case '\t': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('t');
                    continue block11;
                }
            }
        }
        if (unescapeIdx <= i) {
            escaped.append(chars, unescapeIdx, chars.length - unescapeIdx);
        }
        return escaped.toString();
    }

    public static class JSONParseInvalidTypeException
    extends JSONParseException {
    }

    private static class ParserState {
        char[] json;
        int offset = 0;
        boolean construct;
        ByteBuffer bb;

        ParserState(String s, boolean construct) {
            this.json = s.toCharArray();
            this.construct = construct;
        }

        public char currentChar() {
            if (this.offset >= this.json.length) {
                throw new JSONParseOverflowException();
            }
            return this.json[this.offset];
        }

        public char nextChar() {
            return this.json[this.offset + 1];
        }

        public boolean isComplete() {
            return this.offset >= this.json.length;
        }

        public void incrementOffset() {
            this.incrementOffset(1, true);
        }

        public void incrementOffset(int incr) {
            this.incrementOffset(incr, true);
        }

        public void incrementOffset(boolean throwOnOverflow) {
            this.incrementOffset(1, throwOnOverflow);
        }

        public void incrementOffset(int incr, boolean throwOnOverflow) {
            this.offset += incr;
            if (this.offset >= this.json.length && throwOnOverflow) {
                throw new JSONParseOverflowException();
            }
        }

        public ByteBuffer getByteBuffer() {
            if (this.bb == null) {
                this.bb = ByteBuffer.allocate(4);
            } else {
                this.bb.clear();
            }
            return this.bb;
        }
    }

    public static class JSONParseException
    extends ApplicationException {
        public String json;
        public int offset;
        public char character;

        protected JSONParseException() {
        }

        public JSONParseException(ParserState state) {
            this.json = new String(state.json);
            this.offset = state.offset + 1;
            this.character = state.currentChar();
        }

        public JSONParseException(ParserState state, Throwable e) {
            super(e);
            this.json = new String(state.json);
            this.offset = state.offset + 1;
            this.character = state.currentChar();
        }
    }

    public static class JSONSerializeComplexJavaException
    extends ApplicationException {
        public JSONSerializeComplexJavaException(Exception e) {
            super(e);
        }
    }

    public static class JSONSerializeBinaryException
    extends ApplicationException {
    }

    public static class JSONParseInvalidCharException
    extends JSONParseException {
        public char expected;

        public JSONParseInvalidCharException(ParserState state, char expected) {
            super(state);
            this.expected = expected;
        }
    }

    public static class JSONParseInvalidCharsException
    extends JSONParseException {
        public char expectedOne;
        public char expectedTwo;

        public JSONParseInvalidCharsException(ParserState state, char expectedOne, char expectedTwo) {
            super(state);
            this.expectedOne = expectedOne;
            this.expectedTwo = expectedTwo;
        }
    }

    public static class JSONParseInvalidUnicodeSequenceException
    extends JSONParseException {
        public JSONParseInvalidUnicodeSequenceException(ParserState state, Throwable e) {
            super(state, e);
        }
    }

    public static class JSONParseOverflowException
    extends JSONParseException {
    }
}

