/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.client;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.filter.FusionContext;
import coldfusion.graphql.client.AbstractGraphQLConfig;
import coldfusion.graphql.client.GraphQLServiceConfigMetadata;
import coldfusion.graphql.client.ServiceConfig;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.Array;
import coldfusion.runtime.DotResolver;
import coldfusion.runtime.Struct;
import coldfusion.server.CFService;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import coldfusion.util.StructUtil;
import coldfusion.util.Utils;
import coldfusion.xml.XmlFunctions;
import coldfusion.xml.XmlNodeArray;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlNodeMap;
import coldfusion.xml.XmlProcessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.xerces.dom.DeferredTextImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GraphQLConfigService
extends ServiceBase
implements Observer,
StructUtil {
    private static final String NEWLINE_CHAR = "\n";
    private static final String INTROSPECTION_HEADERS_XPATH = "/introspection/headers";
    private static final String SLASH = "/";
    public static final String TYPE = "type";
    ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private File graphQlClientConfigFile;
    private File serviceConfigFile;
    private ConfigMap configSetting;
    private XmlNodeList serviceConfig;
    private XmlNodeList services;
    private static final List emptyList = Arrays.asList(new Object[0]);
    private static final Map EMPTY_MAP = new Struct();
    private Map serviceConfigMap = new LinkedHashMap();
    public static final String GRAPHQL_SERVICE_CONFIG_FILE = "graphql_serviceconfig.pom";
    static final String SEPARATOR = System.getProperty("file.separator");
    static final String GQL = "gql";
    private static final String GRAPHQL_SERVICE_CONFIG_LIST_KEY = "GRAPHQLSERVICECONFIG";
    private static final String ALIAS_KEY = "ALIAS";
    static final String GQL_ROOT = CFService._path + SEPARATOR + "gql" + SEPARATOR;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    public static final String OLDSEEDVAL = "0yJ!@1&r%gG^?az=|J!@1r7@";
    private static final Set<String> fieldsToBeEncrypted = SetUtils.unmodifiableSet(new HashSet<String>(Arrays.asList("headers")));
    private String seed;
    Set<String> listNodes = new HashSet<String>(Arrays.asList("plugins", "dependencies"));

    public GraphQLConfigService(File graphQlClientConfigFile, File serviceConfigFile) {
        this.graphQlClientConfigFile = graphQlClientConfigFile;
        this.serviceConfigFile = serviceConfigFile;
    }

    public GraphQLConfigService(String graphQlClientConfigFile, String serviceConfigFile) {
        this.graphQlClientConfigFile = new File(graphQlClientConfigFile);
        this.serviceConfigFile = new File(serviceConfigFile);
    }

    public void addConfigData(Struct struct) {
        Struct structCopy = null;
        try {
            structCopy = (Struct)struct.duplicate();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to make a copy of Struct!");
        }
        AbstractGraphQLConfig cfGraphQLConfig = this.transformToGraphQLConfig(structCopy);
        String serviceName = cfGraphQLConfig.getClientName();
        this.encryptField(structCopy);
        if (this.configSetting.containsKey(serviceName)) {
            throw new ValidationException(serviceName + " alias already exists.");
        }
        this.configSetting.put(serviceName, (Object)structCopy);
        try {
            this.store(cfGraphQLConfig.getClientName(), structCopy, null);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    private void encryptField(Struct struct) {
        fieldsToBeEncrypted.forEach(fieldName -> {
            if (struct.containsKey(fieldName)) {
                struct.put(fieldName, (Object)this.encryptOnlyValues((Struct)struct.get(fieldName)));
            }
        });
    }

    private Struct encryptOnlyValues(Struct src) {
        src.forEach((key, value) -> src.put(key, (Object)PasswordUtils.encryptPassword((String)value, PasswordUtils.getInstance().getSeedValue())));
        return src;
    }

    private void decryptField(Struct struct, String seed) {
        fieldsToBeEncrypted.forEach(fieldName -> {
            if (struct.containsKey(fieldName)) {
                struct.put(fieldName, (Object)this.decryptOnlyValues((Struct)struct.get(fieldName), seed));
            }
        });
    }

    private Struct decryptOnlyValues(Struct src, String seed) {
        Struct headersStruct = new Struct();
        src.forEach((key, value) -> headersStruct.put(key, (Object)PasswordUtils.decryptPassword((String)value, seed)));
        return headersStruct;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        if (this.isFirstLoad()) {
            CentralConfigClientUtil.delayStore(this);
        }
    }

    public List<Struct> getAllConfigData() {
        Collection graphQLConfigs = this.configSetting.values();
        return graphQLConfigs.stream().filter(Objects::nonNull).map(map -> {
            Struct configData = new Struct();
            configData.putAll((Map)map);
            this.decryptField(configData, PasswordUtils.getInstance().getSeedValue());
            return configData;
        }).collect(Collectors.toList());
    }

    public void deleteConfigData(String alias) throws ServiceException {
        if (!this.configSetting.containsKey(alias)) {
            throw new ConfigDoesNotExistException(alias);
        }
        Object copy = this.configSetting.get(alias);
        this.configSetting.remove(alias);
        this.store(alias, null, copy);
    }

    public Struct getConfigData(String alias) {
        Map map = (Map)this.configSetting.get(alias);
        if (map == null) {
            throw new ConfigDoesNotExistException(alias);
        }
        Struct configData = new Struct();
        configData.putAll(map);
        this.decryptField(configData, PasswordUtils.getInstance().getSeedValue());
        return configData;
    }

    public AbstractGraphQLConfig getConfig(String alias) {
        if (Objects.nonNull(alias) && this.configSetting.containsKey(alias)) {
            return this.transformToGraphQLConfig(this.getConfigData(alias));
        }
        throw new ValidationException("Invalid GraphQL Config Alias (null/Not found)");
    }

    public void modifyConfigData(String oldAlias, Struct struct) throws ServiceException {
        if (Objects.isNull(oldAlias)) {
            throw new ValidationException("oldAlias is null.");
        }
        if (Objects.isNull(struct)) {
            throw new ValidationException("config struct is null");
        }
        if (!this.configSetting.containsKey(oldAlias)) {
            throw new ConfigDoesNotExistException(oldAlias);
        }
        if (struct.containsKey("alias")) {
            throw new ValidationException("Alias cannot be modified once created. Please create configuration with a new alias");
        }
        Struct oldStruct = this.getConfigData(oldAlias);
        Struct oldStructCopy = new Struct();
        oldStructCopy.putAll((Map)oldStruct);
        this.replaceOldValues(oldStruct, struct);
        AbstractGraphQLConfig graphQLConfig = this.transformToGraphQLConfig(oldStruct);
        graphQLConfig.setClientName(oldAlias);
        this.encryptField(oldStruct);
        this.configSetting.put(graphQLConfig.getClientName(), (Object)oldStruct.caseHandledKeySet().stream().collect(Collectors.toMap(key -> key, oldStruct::get)));
        this.store(graphQLConfig.getClientName(), oldStructCopy, struct);
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.graphQlClientConfigFile = Utils.getCanonicalFile(this.graphQlClientConfigFile);
            this.serviceConfigFile = Utils.getCanonicalFile(this.serviceConfigFile);
            this.configSetting = (ConfigMap)this.deserialize(this.graphQlClientConfigFile);
            this.readServiceConfigFile();
            XmlNodeList cfusionHome = (XmlNodeList)((Array)XmlProcessor.search(this.serviceConfig, "/project/properties/cfusion.home", null)).get(0);
            Node firstNode = cfusionHome.getFirstNode();
            if (!CFService._rootdir.equals(firstNode.getTextContent())) {
                firstNode.setTextContent(CFService._rootdir);
                this.writeServiceConfigFile(this.serviceConfigFile, this.serviceConfig.toString());
                this.readServiceConfigFile();
            }
            if (this.configSetting == null) {
                this.configSetting = new ConfigMap(this, "graphqlclientConfig");
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private void readServiceConfigFile() throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            this.readLock.lock();
            Files.readAllLines(Paths.get(this.serviceConfigFile.getAbsolutePath(), new String[0])).forEach(line -> {
                sb.append((String)line);
                sb.append(NEWLINE_CHAR);
            });
            this.serviceConfig = XmlProcessor.parse(sb.toString(), true);
            this.services = (XmlNodeList)((Array)XmlProcessor.search(this.serviceConfig, "/project/build/plugins/plugin/executions/execution/configuration/services", null)).get(0);
            this.serviceConfigMap.clear();
            this.convertToMap(this.services.getFirstNode(), this.serviceConfigMap);
            this.flattenServiceMap();
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void flattenServiceMap() {
        if (this.serviceConfigMap.get("services") instanceof String) {
            return;
        }
        this.serviceConfigMap = (Map)this.serviceConfigMap.get("services");
        Set serviceNames = this.serviceConfigMap.keySet();
        LinkedHashMap flattenedServiceMap = new LinkedHashMap();
        serviceNames.forEach(serviceName -> {
            LinkedHashMap<String, Object> flattenedServiceBody = new LinkedHashMap<String, Object>();
            Map serviceBody = (Map)this.serviceConfigMap.get(serviceName);
            Map compilationUnit = (Map)serviceBody.get("compilationUnit");
            Map compilerParams = (Map)compilationUnit.get("compilerParams");
            Map introspection = (Map)serviceBody.get("introspection");
            flattenedServiceBody.put("service_name", serviceName);
            flattenedServiceBody.put("root_package_name", (String)compilerParams.get("rootPackageName"));
            if (Objects.nonNull(introspection)) {
                flattenedServiceBody.put("service_url", introspection.getOrDefault("endpointUrl", null));
                Map headersMap = introspection.getOrDefault("headers", null);
                if (headersMap != null) {
                    Struct headers = new Struct();
                    Struct childMap = new Struct();
                    childMap.putAll(headersMap);
                    headers.put("headers", (Object)childMap);
                    this.decryptField(headers, PasswordUtils.getInstance().getSeedValue());
                    flattenedServiceBody.put("headers", headers.get("headers"));
                }
            } else {
                flattenedServiceBody.put("schema_path", ((String)serviceBody.get("schemaPath")).substring("${cfusion.home}/".length()));
            }
            flattenedServiceMap.put(serviceName, flattenedServiceBody);
        });
        this.serviceConfigMap = flattenedServiceMap;
    }

    public Map getServiceConfig(String name) {
        if (this.serviceConfigMap.containsKey(name)) {
            Struct struct = new Struct();
            struct.putAll((Map)this.serviceConfigMap.get(name));
            return struct;
        }
        return null;
    }

    public List<Struct> getAllServicesConfig() {
        return this.serviceConfigMap.values().stream().filter(Objects::nonNull).map(map -> {
            Struct struct = new Struct();
            struct.putAll((Map)map);
            return struct;
        }).collect(Collectors.toList());
    }

    public void updateServiceConfig(String oldServiceName, Struct updatedConfigStruct) throws ServiceException {
        try {
            this.deleteServiceConfig(oldServiceName);
            this.addServiceConfig(updatedConfigStruct);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error(e);
            throw new ServiceException(e);
        }
    }

    public void deleteServiceConfig(String name) throws ServiceException {
        if (!this.serviceConfigMap.containsKey(name)) {
            throw new ValidationException(RB.getString(GraphQLConfigService.class, "GraphQLConfigService.ServiceNameAbsentException"));
        }
        try {
            String configString = this.serviceConfig.toString();
            int serviceStartIndex = configString.indexOf("<" + name + ">");
            int serviceEndIndex = this.serviceConfig.toString().indexOf("</" + name + ">");
            String resultServiceConfig = configString.substring(0, serviceStartIndex) + configString.substring(serviceEndIndex + 3 + name.length(), configString.length());
            this.writeServiceConfigFile(this.serviceConfigFile, resultServiceConfig);
            this.readServiceConfigFile();
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error(e);
            throw new ServiceException(e);
        }
    }

    public void addServiceConfig(Struct struct) throws ServiceException {
        Object fileWriter = null;
        try {
            this.encryptField(struct);
            ServiceConfig serviceConfig = new ServiceConfig();
            this.filler.fillObject(serviceConfig, struct, GraphQLServiceConfigMetadata.getInstance().getConsumerMap());
            String serviceName = serviceConfig.getServiceName();
            if (this.serviceConfigMap.containsKey(serviceName)) {
                throw new ValidationException(RB.getString(GraphQLConfigService.class, "GraphQLConfigService.ServiceAlreadyExistsException", (Object)serviceName));
            }
            XmlNodeArray servicesChilrenArray = this.addChildToNode(this.services, serviceName);
            XmlNodeList newService = (XmlNodeList)servicesChilrenArray.get(servicesChilrenArray.size() - 1);
            XmlNodeArray newServiceChildrenArray = this.addChildToNode(newService, "compilationUnit");
            XmlNodeList compilationUnit = (XmlNodeList)newServiceChildrenArray.get(newServiceChildrenArray.size() - 1);
            XmlNodeArray compilationUnitChildrenArray = this.addChildToNode(compilationUnit, "name", serviceName);
            compilationUnitChildrenArray = this.addChildToNode(compilationUnit, "compilerParams");
            XmlNodeList compilerParams = (XmlNodeList)compilationUnitChildrenArray.get(compilationUnitChildrenArray.size() - 1);
            XmlNodeArray compilerParamsChildrenArray = this.addChildToNode(compilerParams, "rootPackageName", serviceConfig.getRootPackageName());
            if (serviceConfig.getCustomTypes() != null) {
                compilerParamsChildrenArray = this.addChildToNode(compilerParams, "customTypeMapping");
                XmlNodeList customTypeMapping = (XmlNodeList)compilerParamsChildrenArray.get(compilerParamsChildrenArray.size() - 1);
                serviceConfig.getCustomTypes().forEach(type -> this.addChildToNode(customTypeMapping, (String)type, "coldfusion.graphql.client.CustomScalar"));
            }
            if (serviceConfig.getServiceUrl() != null) {
                newServiceChildrenArray = this.addChildToNode(newService, "introspection");
                XmlNodeList introspection = (XmlNodeList)newServiceChildrenArray.get(newServiceChildrenArray.size() - 1);
                this.addChildToNode(introspection, "enabled", "true");
                this.addChildToNode(introspection, "endpointUrl", serviceConfig.getServiceUrl());
                XmlNodeArray introspectionchildrenArray = this.addChildToNode(introspection, "headers");
                XmlNodeList headers = (XmlNodeList)introspectionchildrenArray.get(introspectionchildrenArray.size() - 1);
                if (Objects.nonNull(serviceConfig.getHeaders())) {
                    serviceConfig.getHeaders().forEach((key, value) -> this.addChildToNode(headers, (String)key, (String)value));
                }
                this.addChildToNode(introspection, "connectTimeoutSeconds", "10");
                this.addChildToNode(introspection, "readTimeoutSeconds", "10");
                this.addChildToNode(introspection, "writeTimeoutSeconds", "10");
                this.addChildToNode(introspection, "useSelfSignedCertificat", "false");
                this.addChildToNode(introspection, "useGzip", "false");
            } else {
                String schemaPath = serviceConfig.getSchemaPath();
                if (schemaPath != null && !schemaPath.contains("${cfusion.home}/")) {
                    newServiceChildrenArray = this.addChildToNode(newService, "schemaPath", "${cfusion.home}/" + schemaPath);
                }
            }
            this.writeServiceConfigFile(this.serviceConfigFile, this.serviceConfig.toString());
            this.readServiceConfigFile();
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error(e);
            throw new ServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServiceConfigFile(File file, String content) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            this.writeLock.lock();
            fileWriter.write(content);
            fileWriter.flush();
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
        finally {
            this.closeFileWriter(fileWriter);
            this.writeLock.unlock();
        }
    }

    private void closeFileWriter(FileWriter fileWriter) {
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error(e);
            }
        }
    }

    private XmlNodeArray addChildToNode(XmlNodeList node, String childName) {
        return this.addChildToNode(node, childName, "");
    }

    private XmlNodeArray addChildToNode(XmlNodeList node, String childName, String text) {
        XmlNodeArray servicesChildrenArray = (XmlNodeArray)DotResolver.LhsResolve(new XmlNodeMap(node), new String[]{"XmlChildren"}, 0, false);
        XmlNodeList childNode = XmlFunctions.XmlElementNew(this.serviceConfig, childName);
        childNode.getFirstNode().setTextContent(text);
        servicesChildrenArray.add(childNode);
        return servicesChildrenArray;
    }

    private void convertToMap(Node node, Map map) {
        if (!node.hasChildNodes() && node.getTextContent().trim().length() > 0) {
            map.put(node.getNodeName(), node.getTextContent());
        } else {
            if (!node.hasChildNodes() && node.getTextContent().trim().length() == 0) {
                return;
            }
            NodeList children = node.getChildNodes();
            int numberOfChildren = children.getLength();
            if (this.listNodes.contains(node.getNodeName())) {
                ArrayList list = new ArrayList();
                for (int i = 0; i < numberOfChildren; ++i) {
                    Node child = children.item(i);
                    LinkedHashMap childMap = new LinkedHashMap();
                    this.convertToMap(child, childMap);
                    if (childMap.isEmpty()) continue;
                    list.add(childMap);
                }
                map.put(node.getNodeName(), list);
            } else if (numberOfChildren == 1 && node.getFirstChild() instanceof DeferredTextImpl) {
                map.put(node.getNodeName(), node.getFirstChild().getTextContent());
            } else {
                LinkedHashMap childrenMap = new LinkedHashMap();
                for (int i = 0; i < numberOfChildren; ++i) {
                    Node child = children.item(i);
                    this.convertToMap(child, childrenMap);
                }
                map.put(node.getNodeName(), childrenMap);
            }
        }
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("graphqlclientConfig.formats", "coldfusion.server.MapFormatter");
            this.rb.put("graphqlclientConfig.value", "");
        }
        return this.rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            String string = seedVal;
            synchronized (string) {
                this.reEncryptPasswords(oldSeed);
            }
        }
    }

    private void reEncryptPasswords(String oldSeed) {
        this.configSetting.forEach((k, v) -> {
            this.decryptField((Struct)v, oldSeed);
            this.encryptField((Struct)v);
        });
        this.store();
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.serialize(this.configSetting, this.graphQlClientConfigFile, true, key, value, oldValue);
    }

    @Override
    public void store() {
        this.serialize(this.configSetting, this.graphQlClientConfigFile);
    }

    public AbstractGraphQLConfig fromApplicationScope(String alias) {
        if (alias.trim().isEmpty()) {
            throw new ValidationException(RB.getString(GraphQLConfigService.class, "emptyServiceConfigAlias"));
        }
        Struct struct = null;
        ApplicationScope appScope = (ApplicationScope)FusionContext.getApplicationScope();
        if (appScope == null) {
            return null;
        }
        List graphQLServiceConfig = (List)appScope.getApplicationSettingsMap().get(GRAPHQL_SERVICE_CONFIG_LIST_KEY);
        struct = this.getStructFromList(graphQLServiceConfig, ALIAS_KEY, alias);
        if (struct != null) {
            return this.transformToGraphQLConfig(struct);
        }
        return null;
    }

    public AbstractGraphQLConfig transformToGraphQLConfig(Struct struct) {
        if (struct.isEmpty()) {
            throw new ValidationException(RB.getString(GraphQLConfigService.class, "GraphQLConfigService.emptyGraphQLClientConfigException"));
        }
        return ServiceFactory.getGraphQLClientService(true).getGraphQLClientConfig(struct);
    }

    public void replaceOldValues(Map oldMap, Map newMap) {
        for (Map.Entry entry : newMap.entrySet()) {
            String newKey = (String)entry.getKey();
            if (oldMap.containsKey(newKey)) {
                Object oldVal = oldMap.get(newKey);
                if (!(oldVal instanceof Map)) {
                    oldMap.replace(newKey, entry.getValue());
                    continue;
                }
                this.replaceOldValues((Map)oldVal, (Map)entry.getValue());
                continue;
            }
            oldMap.put(newKey, entry.getValue());
        }
    }

    public Map getServiceConfigMap() {
        return this.serviceConfigMap;
    }

    public void decryptHeadersAndRewriteServiceConfig(String path) throws IOException {
        StringBuilder sb = new StringBuilder();
        File tempFile = new File(path);
        Files.readAllLines(Paths.get(tempFile.getAbsolutePath(), new String[0])).forEach(line -> {
            sb.append((String)line);
            sb.append(NEWLINE_CHAR);
        });
        XmlNodeList tempServiceConfig = XmlProcessor.parse(sb.toString(), true);
        Set services = this.serviceConfigMap.keySet();
        services.forEach(service -> {
            Struct headers = new Struct();
            Array serviceHeaders = (Array)XmlProcessor.search(tempServiceConfig, "/project/build/plugins/plugin/executions/execution/configuration/services/" + service + INTROSPECTION_HEADERS_XPATH, null);
            if (Objects.nonNull(serviceHeaders) && !serviceHeaders.isEmpty()) {
                this.convertToMap(((XmlNodeList)serviceHeaders.get(0)).getFirstNode(), headers);
                Struct innerStruct = new Struct();
                if (!headers.isEmpty()) {
                    innerStruct.putAll((Map)headers.get("headers"));
                    headers.put("headers", (Object)innerStruct);
                    this.decryptField(headers, PasswordUtils.getInstance().getSeedValue());
                    String headerXPathPrefix = "/project/build/plugins/plugin/executions/execution/configuration/services/" + service + "/introspection/headers/";
                    ((Map)headers.get("headers")).forEach((headerKey, headerValue) -> {
                        Array searchResult = (Array)XmlProcessor.search(tempServiceConfig, headerXPathPrefix + headerKey, null);
                        if (!searchResult.isEmpty()) {
                            Node headerNode = ((XmlNodeList)searchResult.get(0)).getFirstNode();
                            headerNode.setTextContent((String)headerValue);
                        }
                    });
                }
            }
        });
        this.writeServiceConfigFile(tempFile, tempServiceConfig.toString());
    }

    public class ConfigDoesNotExistException
    extends ApplicationException {
        public String configAlias;

        public ConfigDoesNotExistException(String configAlias) {
            this.configAlias = configAlias;
        }
    }
}

