/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.jsp;

import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.compiler.AbstractParseException;
import coldfusion.compiler.NeoTranslator;
import coldfusion.filter.FusionContext;
import coldfusion.jsp.JSTTagInfo;
import coldfusion.jsp.NoSuchPropertyException;
import coldfusion.jsp.ValidatingTagInfo;
import coldfusion.runtime.TemplateException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.felix.FelixUtil;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Utils;
import coldfusion.util.WebEntityResolver;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagExtraInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JRunTagLibraryInfo
extends TagLibraryInfo {
    public static final String TAG_LIBRARY_INFO_KEY = "coldfusion.jsp.taglibinfo.";
    private static DocumentBuilder docBuilder;
    protected ServletContext application;
    File taglibDir;
    String taglibUri;
    boolean isCfmDir = false;
    File tld_uri;
    URL tld_location;
    private ClassLoader taglibClassLoader;
    private Map tag_infos = new CaseInsensitiveMap();
    static final Object taglib_lock;

    public static JRunTagLibraryInfo lookupTLI(ServletContext application, String uri, File pageFile) throws IOException {
        File tldFile = JRunTagLibraryInfo.resolveTagLibraryURI(application, uri, pageFile);
        return JRunTagLibraryInfo.lookupTLI(tldFile, application, uri);
    }

    public static JRunTagLibraryInfo lookupTLI(File tldFile, ServletContext application) throws IOException {
        return JRunTagLibraryInfo.lookupTLI(tldFile, application, null);
    }

    public static JRunTagLibraryInfo lookupTLI(File tldFile, ServletContext application, String uri) throws IOException {
        String key = TAG_LIBRARY_INFO_KEY.concat(Utils.getCanonicalPath(tldFile)).concat(uri);
        JRunTagLibraryInfo tli = (JRunTagLibraryInfo)((Object)application.getAttribute(key));
        if (tli == null) {
            tli = new JRunTagLibraryInfo(application, tldFile, uri);
            application.setAttribute(key, (Object)tli);
        }
        return tli;
    }

    public String getURI() {
        if (this.taglibUri == null) {
            return super.getURI();
        }
        return this.taglibUri;
    }

    public boolean isCfmDir() {
        return this.isCfmDir;
    }

    public TagInfo[] getTags() {
        if (this.tags == null || this.tags.length < this.tag_infos.size()) {
            this.tags = new TagInfo[this.tag_infos.size()];
            Iterator iter = this.tag_infos.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                String tagName = (String)iter.next();
                this.tags[i] = this.getTag(tagName);
                ++i;
            }
        }
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JRunTagLibraryInfo(ServletContext application, File tldFile, String uri) throws IOException {
        super("mock_prefix", Utils.getCanonicalPath(tldFile));
        this.application = application;
        this.tld_uri = tldFile;
        this.tld_location = this.resolveTagLibraryTLD(this.tld_uri, uri);
        if (this.tld_location != null) {
            try {
                Document tld;
                DocumentBuilder documentBuilder = docBuilder;
                synchronized (documentBuilder) {
                    docBuilder.setEntityResolver(new WebEntityResolver((Properties)this.application.getAttribute("coldfusion.dtdmappings")));
                    tld = docBuilder.parse(this.tld_location.openStream());
                }
                this.initialize(tld);
            }
            catch (Exception e) {
                throw new TldParseException(this.tld_location, e);
            }
        }
    }

    public TagInfo getTag(String tagName) {
        Object o = this.tag_infos.get(tagName);
        if (o instanceof Element) {
            TagInfo tagInfo = this.buildTagInfo((Element)o);
            this.tag_infos.put(tagName, tagInfo);
            return tagInfo;
        }
        if (o != null) {
            return (TagInfo)o;
        }
        File tagFile = new File(this.taglibDir, tagName + ".cfm");
        if (!tagFile.isFile()) {
            return null;
        }
        return this.registerTagInfo(tagName, tagFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getTagClass(TagInfo info) throws ClassNotFoundException {
        JRunTagLibraryInfo lib = (JRunTagLibraryInfo)info.getTagLibrary();
        if (ServerlessUtil.isLambdaEnv()) {
            lib.taglibClassLoader = BootstrapClassLoader.instance();
            if (!(Thread.currentThread().getContextClassLoader() instanceof BootstrapClassLoader)) {
                Thread.currentThread().setContextClassLoader((ClassLoader)BootstrapClassLoader.instance());
            }
        }
        JRunTagLibraryInfo jRunTagLibraryInfo = lib;
        synchronized (jRunTagLibraryInfo) {
            return lib.taglibClassLoader.loadClass(info.getTagClassName());
        }
    }

    private TagInfo registerTagInfo(String tagName, File tagFile) {
        String jstClassName = NeoTranslator.getClassName(tagFile);
        JSTTagInfo tagInfo = new JSTTagInfo(tagFile, tagName, jstClassName, "JSP", null, this, null, new TagAttributeInfo[0]);
        this.tag_infos.put(tagName, tagInfo);
        return tagInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File resolveTagLibraryURI(ServletContext application, String pageUri, File pageFile) {
        File tldFile;
        Object uri;
        Hashtable taglib_mappings = (Hashtable)application.getAttribute("coldfusion.web.xml.taglib");
        if (taglib_mappings == null) {
            Object object = taglib_lock;
            synchronized (object) {
                Document webxml = (Document)application.getAttribute("coldfusion.web.xml");
                if (webxml != null) {
                    taglib_mappings = JRunTagLibraryInfo.getTaglibFromWebXml(webxml);
                }
                application.setAttribute("coldfusion.web.xml.taglib", (Object)taglib_mappings);
            }
        }
        if (taglib_mappings != null && (uri = taglib_mappings.get(pageUri)) instanceof String) {
            pageUri = (String)uri;
        }
        if (pageUri.charAt(0) != '/') {
            tldFile = new File(pageFile.getParentFile(), pageUri);
        } else {
            FusionContext context = FusionContext.getCurrent();
            boolean use = true;
            if (pageUri.startsWith("/WEB-INF/")) {
                use = false;
            }
            boolean old = context.setUseMappings(use);
            try {
                tldFile = new File(context.getRealPath(pageUri));
            }
            finally {
                context.setUseMappings(old);
            }
        }
        return tldFile;
    }

    private URL resolveTagLibraryTLD(File tldFile, String uri) throws IOException {
        this.taglibClassLoader = Thread.currentThread().getContextClassLoader();
        if (tldFile.isDirectory()) {
            this.taglibDir = tldFile;
            this.taglibUri = uri;
            File f = new File(tldFile, "META-INF" + File.separator + "taglib.tld");
            if (f.isFile()) {
                return f.toURL();
            }
            f = new File(tldFile, "META-INF" + File.separator + "taglib.cftld");
            if (f.isFile()) {
                return f.toURL();
            }
            this.isCfmDir = true;
            return null;
        }
        if (tldFile.isFile()) {
            if (".".equals(tldFile.getName())) {
                return null;
            }
            try {
                JarFile jf = new JarFile(tldFile);
                if (jf.getEntry("META-INF/taglib.tld") != null) {
                    return new URL("jar:" + tldFile.toURL() + "!/META-INF/taglib.tld");
                }
                if (jf.getEntry("META-INF/taglib.cftld") != null) {
                    return new URL("jar:" + tldFile.toURL() + "!/META-INF/taglib.cftld");
                }
                throw new TldNotFoundException(uri, tldFile);
            }
            catch (IOException e) {
                return tldFile.toURL();
            }
        }
        throw new FileNotFoundException(tldFile.getPath());
    }

    private static Hashtable getTaglibFromWebXml(Document webxml) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        Element root = webxml.getDocumentElement();
        NodeList taglibs = root.getElementsByTagName("taglib");
        for (int i = 0; i < taglibs.getLength(); ++i) {
            Element taglib = (Element)taglibs.item(i);
            h.put(JRunTagLibraryInfo.getChildElementData(taglib, "taglib-uri"), JRunTagLibraryInfo.getChildElementData(taglib, "taglib-location"));
        }
        return h;
    }

    private void initialize(Document tld) {
        Element root = tld.getDocumentElement();
        this.info = JRunTagLibraryInfo.getChildElementData(root, "info");
        this.jspversion = JRunTagLibraryInfo.getChildElementData(root, "jspversion");
        this.shortname = JRunTagLibraryInfo.getChildElementData(root, "shortname");
        this.tlibversion = JRunTagLibraryInfo.getChildElementData(root, "tlibversion");
        this.urn = JRunTagLibraryInfo.getChildElementData(root, "uri");
        NodeList tag_list = root.getElementsByTagName("tag");
        for (int i = 0; i < tag_list.getLength(); ++i) {
            Element tag = (Element)tag_list.item(i);
            this.tag_infos.put(JRunTagLibraryInfo.getChildElementData(tag, "name"), tag);
        }
    }

    private TagInfo buildTagInfo(Element tag) throws AbstractParseException {
        String teiClass;
        String info;
        String body;
        String name = JRunTagLibraryInfo.getChildElementData(tag, "name");
        String clazz = JRunTagLibraryInfo.getChildElementData(tag, "tagclass");
        if (clazz == null) {
            clazz = JRunTagLibraryInfo.getChildElementData(tag, "tag-class");
        }
        if ((body = JRunTagLibraryInfo.getChildElementData(tag, "bodycontent")) == null) {
            body = JRunTagLibraryInfo.getChildElementData(tag, "body-content");
        }
        if ((info = JRunTagLibraryInfo.getChildElementData(tag, "info")) == null) {
            info = JRunTagLibraryInfo.getChildElementData(tag, "description");
        }
        if ((teiClass = JRunTagLibraryInfo.getChildElementData(tag, "teiclass")) == null) {
            teiClass = JRunTagLibraryInfo.getChildElementData(tag, "tei-class");
        }
        TagExtraInfo tei = null;
        if (teiClass != null) {
            try {
                tei = (TagExtraInfo)this.taglibClassLoader.loadClass(teiClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                throw new TEIClassNotFoundException(teiClass, name);
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
                throw new TEIInitException(ie, teiClass, name);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ie) {
                throw new TEIInitException(ie, teiClass, name);
            }
        }
        NodeList attrs = tag.getElementsByTagName("attribute");
        TagAttributeInfo[] tag_attrs = new TagAttributeInfo[attrs.getLength()];
        for (int i = 0; i < tag_attrs.length; ++i) {
            Element attr = (Element)attrs.item(i);
            String attributeName = JRunTagLibraryInfo.getChildElementData(attr, "name");
            String req = JRunTagLibraryInfo.getChildElementData(attr, "required");
            String rtexpr = JRunTagLibraryInfo.getChildElementData(attr, "rtexprvalue");
            String type = this.getPropertyType(clazz, attributeName, name);
            boolean required = "true".equals(req) || "yes".equals(req);
            boolean rtexprvalue = "true".equals(rtexpr) || "yes".equals(rtexpr);
            tag_attrs[i] = new TagAttributeInfo(attributeName, required, type, rtexprvalue);
        }
        body = "tagdependent".equalsIgnoreCase(body) ? "tagdependent" : ("empty".equalsIgnoreCase(body) ? "empty" : "JSP");
        return new ValidatingTagInfo(name, clazz, body, info, this, tei, tag_attrs);
    }

    private String getPropertyType(String className, String attributeName, String tagName) throws AbstractParseException {
        try {
            Class<?> tagClass = this.taglibClassLoader.loadClass(className);
            return JRunTagLibraryInfo.getPropertyDescriptor(tagClass, attributeName).getPropertyType().getName();
        }
        catch (ClassNotFoundException cnfe) {
            if (!ServiceFactory.isRuntimeServiceInitialized() || FelixUtil.installed((String)tagName, null)) {
                // empty if block
            }
            return "";
        }
        catch (IntrospectionException ie) {
            throw new TagAttributeIntrospectionException(ie, tagName, attributeName);
        }
        catch (NoSuchPropertyException nspe) {
            throw new NoSuchAttributeException(tagName, attributeName);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Class clazz, String property) throws IntrospectionException, NoSuchPropertyException {
        String propName;
        int i;
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        for (i = 0; i < pds.length && !(propName = pds[i].getName()).equalsIgnoreCase(property); ++i) {
        }
        if (i == pds.length) {
            throw new NoSuchPropertyException();
        }
        return pds[i];
    }

    private static String getChildElementData(Element root, String name) {
        NodeList nl = root.getElementsByTagName(name);
        if (nl.getLength() == 0) {
            return null;
        }
        Node text = nl.item(0).getFirstChild();
        return text == null ? null : text.getNodeValue();
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate XML parser: " + e);
        }
        taglib_lock = new Object();
    }

    public static class TldParseException
    extends TemplateException {
        public URL location;

        TldParseException(URL location, Exception rootCause) {
            super(rootCause);
            this.location = location;
        }
    }

    public static class TldNotFoundException
    extends TemplateException {
        public String uri;
        public File tldFile;

        TldNotFoundException(String uri, File tldFile) {
            this.uri = uri;
            this.tldFile = tldFile;
        }
    }

    public static class TEIClassNotFoundException
    extends AbstractParseException {
        public String teiClass;
        public String name;

        TEIClassNotFoundException(String teiClass, String name) {
            this.teiClass = teiClass;
            this.name = name;
        }
    }

    public static class TEIInitException
    extends AbstractParseException {
        public String teiClass;
        public String name;

        TEIInitException(Exception ex, String teiClass, String name) {
            super(ex);
            this.teiClass = teiClass;
            this.name = name;
        }
    }

    public static class TagAttributeIntrospectionException
    extends AbstractParseException {
        public String tagName;
        public String attributeName;

        TagAttributeIntrospectionException(Exception ex, String tagName, String attributeName) {
            super(ex);
            this.tagName = tagName;
            this.attributeName = attributeName;
        }
    }

    public static class NoSuchAttributeException
    extends AbstractParseException {
        public String tagName;
        public String attributeName;

        NoSuchAttributeException(String tagName, String attributeName) {
            this.tagName = tagName;
            this.attributeName = attributeName;
        }
    }
}

