/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.jsp;

import coldfusion.bootstrap.AppServerUtils;
import coldfusion.jsp.CompilationFailedException;
import coldfusion.server.SystemInfo;
import coldfusion.util.Utils;
import com.sun.tools.javac.Main;
import jakarta.servlet.ServletContext;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JavaCompiler {
    private String classpath;
    private String compiler_spec = "jikes -g -nowarn -d %d %f";
    private String outputDirectory;
    private boolean onWAS4 = false;
    private boolean saveJava;

    public JavaCompiler() {
        this.onWAS();
        this.setClasspath(this.getDefaultClasspath());
    }

    private void onWAS() {
        try {
            Class.forName("com.ibm.ws.classloader.ExtJarClassLoader", true, Thread.currentThread().getContextClassLoader());
            this.onWAS4 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCompilerSpec(String s) {
        this.compiler_spec = s;
    }

    public void setClasspath(String classpath) {
        this.classpath = this.cleanClasspath(classpath);
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setOutputDirectory(String path) {
        this.outputDirectory = path;
    }

    public void setSaveJava(String setting) {
        try {
            this.saveJava = Boolean.valueOf(setting);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void compileClass(List sourceFileList, boolean debug) throws CompilationFailedException, IOException {
        boolean status;
        int i;
        StringBuffer errors = new StringBuffer();
        String new_classpath = this.classpath + File.pathSeparatorChar + this.outputDirectory;
        boolean hasLongFilePath = false;
        if (SystemInfo.isWindows()) {
            for (i = 0; i < sourceFileList.size(); ++i) {
                String sourceFile = (String)sourceFileList.get(i);
                if (sourceFile.length() < 255) continue;
                hasLongFilePath = true;
                break;
            }
        }
        if (!(status = this.compiler_spec == null || hasLongFilePath || AppServerUtils.getAppServerType() == 2 ? this.inProcessCompile(sourceFileList, new_classpath, errors, debug) : this.outProcessCompile(sourceFileList, new_classpath, errors, debug))) {
            throw new CompilationFailedException(errors.toString());
        }
        if (!this.saveJava) {
            for (i = 0; i < sourceFileList.size(); ++i) {
                String file = (String)sourceFileList.get(i);
                new File(file).delete();
            }
        }
    }

    public Map compileClass(String sourceFile, String javaSource, boolean debug) throws CompilationFailedException, IOException {
        String classStem;
        int i;
        this.save(javaSource, sourceFile);
        StringBuffer errors = new StringBuffer();
        String new_classpath = this.classpath + File.pathSeparatorChar + this.outputDirectory;
        ArrayList<String> sourceList = new ArrayList<String>(1);
        sourceList.add(sourceFile);
        boolean status = this.compiler_spec == null ? this.inProcessCompile(sourceList, new_classpath, errors, debug) : this.outProcessCompile(sourceList, new_classpath, errors, debug);
        if (!status) {
            throw new CompilationFailedException(errors.toString());
        }
        if (!this.saveJava) {
            new File(sourceFile).delete();
        }
        if ((i = (classStem = sourceFile.substring(0, sourceFile.lastIndexOf(46))).lastIndexOf(47)) < classStem.lastIndexOf(92)) {
            i = classStem.lastIndexOf(92);
        }
        Object className = classStem.substring(i + 1);
        byte[] bytes = this.load(classStem + ".class");
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put((String)className, bytes);
        i = javaSource.indexOf("class");
        if (i != -1 && javaSource.indexOf("class", i + 1) != -1) {
            String[] list = new File(this.outputDirectory).list();
            className = (String)className + "$";
            for (i = 0; i < list.length; ++i) {
                if (!list[i].startsWith((String)className) || !list[i].endsWith(".class")) continue;
                String name = list[i].substring(0, list[i].length() - 6);
                map.put(name, this.load(new File(this.outputDirectory, list[i]).getAbsolutePath()));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String source, String filename) throws IOException {
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(filename));
        try (UnicodeEscapeWriter out = new UnicodeEscapeWriter(bout, this.saveJava);){
            out.write(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] load(String filename) throws IOException {
        try (DataInputStream in = new DataInputStream(new FileInputStream(filename));){
            byte[] data = new byte[in.available()];
            in.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    private String getDefaultClasspath() {
        StringBuffer classpath = new StringBuffer();
        for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)cl).getURLs();
            for (int i = 0; urls != null && i < urls.length; ++i) {
                File file = new File(urls[i].getFile());
                if (file.isFile()) {
                    try {
                        Attributes attributes;
                        if (!JavaCompiler.isJar(file)) continue;
                        classpath.append(urls[i].getPath());
                        classpath.append(File.pathSeparatorChar);
                        JarFile jar = new JarFile(file);
                        Manifest manifest = jar.getManifest();
                        if (manifest == null || (attributes = manifest.getMainAttributes()) == null) continue;
                        String s = attributes.getValue(Attributes.Name.CLASS_PATH);
                        String base = file.getParent();
                        if (s == null) continue;
                        StringTokenizer st = new StringTokenizer(s, " ");
                        while (st.hasMoreTokens()) {
                            String t = st.nextToken();
                            classpath.append(base).append(File.separatorChar).append(t);
                            classpath.append(File.pathSeparatorChar);
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (!file.isDirectory()) continue;
                classpath.append(urls[i].getPath());
                classpath.append(File.pathSeparatorChar);
            }
        }
        if (this.onWAS4) {
            String home = System.getProperty("server.root");
            classpath.append(home).append(File.separator).append("lib").append(File.separator).append("jsp.jar");
            classpath.append(File.pathSeparatorChar);
            classpath.append(home).append(File.separator).append("lib").append(File.separator).append("j2ee.jar");
            classpath.append(File.pathSeparatorChar);
        }
        if (System.getProperty("sun.boot.class.path") != null) {
            classpath.append(System.getProperty("sun.boot.class.path"));
            classpath.append(File.pathSeparatorChar);
        }
        classpath.append(System.getProperty("java.class.path"));
        return classpath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJar(File file) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            JarInputStream jis = new JarInputStream(fis);
            if (jis.getNextEntry() != null) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private String getExtDirs() {
        StringBuffer dirs = new StringBuffer();
        String d = System.getProperty("ws.ext.dirs");
        if (d != null) {
            dirs.append(File.pathSeparator);
            dirs.append(d);
        }
        return dirs.toString();
    }

    private boolean inProcessCompile(List sourceList, String classpath, StringBuffer errors, boolean debug) throws CompilationFailedException {
        ArrayList<String> argsList = new ArrayList<String>(30);
        if (debug) {
            argsList.add("-g");
        }
        argsList.add("-classpath");
        argsList.add(classpath);
        argsList.add("-nowarn");
        argsList.add("-source");
        argsList.add("1.8");
        argsList.add("-target");
        argsList.add("1.8");
        argsList.add("-d");
        argsList.add(this.outputDirectory);
        argsList.addAll(sourceList);
        String[] args = new String[argsList.size()];
        argsList.toArray(args);
        StringWriter strWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(strWriter);
        try {
            Object compiler = this.getJavac().newInstance();
            Main cfr_ignored_0 = (Main)compiler;
            int ret = Main.compile(args, pw);
            errors.append(strWriter.getBuffer().toString());
            return ret == 0;
        }
        catch (IllegalAccessException ie) {
            throw new UnknownCompiler(ie);
        }
        catch (InstantiationException ie) {
            throw new UnknownCompiler(ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnknownCompiler(cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new UnknownCompiler(ncdfe);
        }
        catch (IncompatibleClassChangeError icce) {
            try {
                Class<Main> c = Main.class;
                Main o = new Main();
                Method m = c.getMethod("compile", String[].class);
                m.invoke((Object)o, args, pw);
                errors.append(strWriter.getBuffer().toString());
                return true;
            }
            catch (Exception e) {
                throw new UnknownCompiler(e);
            }
        }
    }

    private Class getJavac() throws ClassNotFoundException {
        return Class.forName("com.sun.tools.javac.Main");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean outProcessCompile(List sourceList, String classpath, StringBuffer err, boolean debug) throws IOException, CompilationFailedException {
        Process p;
        Runtime runtime = Runtime.getRuntime();
        String[] command = this.parseCompileArgs(this.compiler_spec, sourceList, debug);
        String[] envs = new String[]{"CLASSPATH=" + classpath};
        try {
            p = runtime.exec(command, envs);
        }
        catch (IOException e) {
            try {
                this.getJavac();
                this.compiler_spec = null;
                return this.inProcessCompile(sourceList, classpath, err, debug);
            }
            catch (ClassNotFoundException ex) {
                throw e;
            }
        }
        boolean processDone = false;
        InputStream stdout = p.getInputStream();
        InputStream stderr = p.getErrorStream();
        while (stdout.available() == 0 && stderr.available() == 0 && !processDone) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                try {
                    p.exitValue();
                    processDone = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {}
            }
        }
        if (!JavaCompiler.isStreamEmpty(stdout, err) || !JavaCompiler.isStreamEmpty(stderr, err)) {
            try {
                p.waitFor();
                return false;
            }
            catch (InterruptedException e) {
                throw new CompilationFailedException(err.toString());
            }
        }
        return true;
    }

    private static boolean isStreamEmpty(InputStream in, StringBuffer err) throws IOException {
        BufferedReader errorIn = new BufferedReader(new InputStreamReader(in));
        if (in.available() == 0) {
            return true;
        }
        String line = errorIn.readLine();
        if (line == null) {
            return true;
        }
        err.append(line).append("\n");
        while ((line = errorIn.readLine()) != null) {
            err.append(line).append("\n");
        }
        return false;
    }

    private String[] parseCompileArgs(String spec, List sourceList, boolean debug) {
        String quote = "\"";
        if (File.separator.equals("/")) {
            quote = "";
        }
        char sep = File.pathSeparatorChar;
        Vector<Object> v = new Vector<Object>();
        StringTokenizer st = new StringTokenizer(spec, " ", false);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.startsWith("%")) {
                char c = tok.charAt(1);
                if (c == 'c' || c == 'C') {
                    String remain = tok.substring(2);
                    v.addElement(quote + this.classpath + remain + sep + this.outputDirectory + quote);
                    continue;
                }
                if (c == 'd' || c == 'D') {
                    v.addElement(quote + this.outputDirectory + quote);
                    continue;
                }
                if (c != 'f' && c != 'F') continue;
                v.addAll(sourceList);
                continue;
            }
            v.addElement(tok);
        }
        if (!v.contains("-g") && debug) {
            v.addElement("-g");
        }
        String[] s = new String[v.size()];
        v.toArray(s);
        return s;
    }

    private String cleanClasspath(String classPath) {
        if (classPath == null) {
            return null;
        }
        if (File.pathSeparatorChar == ':') {
            classPath = classPath.replace(';', ':');
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(classPath.trim(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            File f = new File(st.nextToken());
            if (!f.exists()) continue;
            sb.append(Utils.getCanonicalPath(f));
            if (!st.hasMoreTokens()) continue;
            sb.append(File.pathSeparator);
        }
        return sb.toString();
    }

    public static String createClasspath(ServletContext application) {
        FilenameFilter jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                try {
                    return JavaCompiler.isJar(new File(dir, name));
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
        StringBuffer classpath = new StringBuffer(application.getRealPath("/WEB-INF/classes"));
        try {
            File f = new File(application.getRealPath("/WEB-INF/lib"));
            String[] jars = f.list(jarFilter);
            JavaCompiler.appendClassPath(classpath, jars, f);
        }
        catch (Exception e) {
            return null;
        }
        return classpath.toString();
    }

    public static void appendClassPath(StringBuffer classpath, String[] jars, File f) {
        for (int i = 0; jars != null && i < jars.length; ++i) {
            classpath.append(File.pathSeparator);
            classpath.append(f.getAbsolutePath());
            classpath.append(File.separator);
            classpath.append(jars[i]);
        }
    }

    static class UnicodeEscapeWriter
    extends Writer {
        private OutputStream out;
        static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int level;
        boolean indent;
        boolean startLine;

        public UnicodeEscapeWriter(OutputStream out, boolean indent) {
            this.out = out;
            this.indent = indent;
        }

        private void indent() throws IOException {
            if (this.startLine) {
                this.startLine = false;
                for (int i = 0; i < this.level; ++i) {
                    this.out.write(9);
                }
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            block7: for (int i = off; i < len; ++i) {
                char c = cbuf[i];
                switch (c) {
                    case '\r': {
                        this.out.write(c);
                        this.startLine = false;
                        continue block7;
                    }
                    case '\n': {
                        this.out.write(c);
                        this.startLine = this.indent;
                        continue block7;
                    }
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        if (this.startLine) continue block7;
                        this.out.write(c);
                        continue block7;
                    }
                    case '(': 
                    case '[': 
                    case '{': {
                        this.indent();
                        ++this.level;
                        this.out.write(c);
                        continue block7;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        --this.level;
                        this.indent();
                        this.out.write(c);
                        continue block7;
                    }
                    default: {
                        this.indent();
                        if (c <= '\u001f' || c >= '\u007f') {
                            this.out.write(92);
                            this.out.write(117);
                            this.out.write(digits[c >>> 12 & 0xF]);
                            this.out.write(digits[c >>> 8 & 0xF]);
                            this.out.write(digits[c >>> 4 & 0xF]);
                            this.out.write(digits[c & 0xF]);
                            continue block7;
                        }
                        this.out.write(c);
                    }
                }
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class UnknownCompiler
    extends CompilationFailedException {
        public Throwable rootCause;

        UnknownCompiler(Throwable ex) {
            super(ex.getMessage());
            this.rootCause = ex;
        }
    }
}

