/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.jsp;

import coldfusion.jsp.AbstractIOException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import java.io.Writer;

public class JspWriterOutputStream
extends ServletOutputStream {
    private boolean closed;
    private Writer writer;
    private final String NULL_STRING = "null";
    private static final char[] NEWLINE = new char[]{'\r', '\n'};

    public JspWriterOutputStream(Writer writer) {
        this.writer = writer;
        this.closed = false;
    }

    void alreadyClosed() throws IOException {
        throw new ResponseClosedException();
    }

    public void flush() throws IOException {
        if (this.closed) {
            this.alreadyClosed();
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
        }
    }

    public void write(int c) throws IOException {
        if (this.closed) {
            this.alreadyClosed();
        }
        this.writer.write(c);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            this.alreadyClosed();
        }
        this.writer.write(new String(b, off, len));
    }

    public void print(String s) throws IOException {
        if (this.closed) {
            this.alreadyClosed();
        }
        this.writer.write(s != null ? s : "null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) throws IOException {
        if (this.closed) {
            this.alreadyClosed();
        }
        Writer writer = this.writer;
        synchronized (writer) {
            this.writer.write(s != null ? s : "null");
            this.writer.write(NEWLINE);
        }
    }

    public void println() throws IOException {
        this.println("");
    }

    public void println(char c) throws IOException {
        this.println(String.valueOf(c));
    }

    public void println(byte c) throws IOException {
        this.println(String.valueOf(c));
    }

    public void println(short c) throws IOException {
        this.println(String.valueOf(c));
    }

    public void println(int c) throws IOException {
        this.println(String.valueOf(c));
    }

    public void println(long c) throws IOException {
        this.println(String.valueOf(c));
    }

    public void println(float c) throws IOException {
        this.println(String.valueOf(c));
    }

    public void println(double c) throws IOException {
        this.println(String.valueOf(c));
    }

    public boolean isReady() {
        return false;
    }

    public void setWriteListener(WriteListener arg0) {
    }

    public static class ResponseClosedException
    extends AbstractIOException {
    }
}

