/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.jwt;

import coldfusion.jwt.JwtProvider;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.util.KeystoreUtils;
import coldfusion.util.RB;
import coldfusion.wddx.Base64Encoder;
import java.security.Key;
import java.security.KeyPair;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.DecryptionJwkSelector;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.VerificationJwkSelector;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.JoseException;

public class StandardJwtProvider
implements JwtProvider {
    public static final String EXP = "exp";
    public static final String NBF = "nbf";
    public static final String IAT = "iat";
    public static final String JTI = "id";
    public static final String ALGORITHM = "algorithm";
    public static final String ENCRYPTION = "encryption";
    public static final String PLAINTEXT = "plaintext";
    public static final String PLAINTEXT_MODE = "plaintext";
    public static final String RETURN_TYPE = "returnType";
    public static final String CLOCK_SKEW = "clockSkew";
    public static final String VALID = "valid";
    public static final String VALIDATION_FAILED_REASON = "validation_failed_reason";
    public static final String GENERATE_IAT = "generateIssuedAt";
    public static final String GENERATE_JTI = "generateJti";
    public static final String KEY = "key";
    public static final String KEY_ALGORITHM = "keyAlg";

    @Override
    public String createSignedJWT(Object payload, Object signOptions, Map config) {
        JsonWebSignature jws = new JsonWebSignature();
        if (payload instanceof Struct) {
            Struct payLoadData = (Struct)payload;
            if (config.get(GENERATE_IAT) != null && Cast._boolean(config.get(GENERATE_IAT))) {
                this.generateIat(payLoadData);
            }
            if (config.get(GENERATE_JTI) != null && Cast._boolean(config.get(GENERATE_JTI))) {
                this.generateJti(payLoadData);
            }
            String json = JSONUtils.serializeJSON(payLoadData);
            jws.setPayload(json);
        } else if (payload instanceof String) {
            jws.setPayload((String)payload);
        }
        Key signingKey = null;
        if (signOptions instanceof Key) {
            signingKey = (Key)signOptions;
        } else if (signOptions instanceof KeyPair) {
            keyPair = (KeyPair)signOptions;
            signingKey = keyPair.getPrivate();
        } else if (signOptions instanceof Struct) {
            keyPair = KeystoreUtils.getKeyPair((Map)signOptions);
            signingKey = keyPair.getPrivate();
        } else {
            throw new IncorrectDatatypeException("signOptions", "Key or KeyPair or Struct");
        }
        Object algorithm = config.get(ALGORITHM);
        if (algorithm == null) {
            throw new JwtMissingFieldException(ALGORITHM);
        }
        if (!(algorithm instanceof String)) {
            throw new IncorrectDatatypeException(ALGORITHM, "String");
        }
        String algo = (String)algorithm;
        jws.setAlgorithmHeaderValue(algo);
        jws.setKey(signingKey);
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            String exc = RB.getString(StandardJwtProvider.class, "StandardJwtProvider.UnableToCreateJwt");
            CFLogs.SECURITY_LOG.error(exc, e);
            throw new JWTException(exc, e);
        }
    }

    @Override
    public Struct verifySignedJwt(String token, Object signOptions, Map config) {
        String mode;
        int clockSkew;
        boolean plainTextMode = false;
        boolean jwkVerification = false;
        int n = clockSkew = config.containsKey(CLOCK_SKEW) ? (Integer)config.get(CLOCK_SKEW) : 0;
        if (config.containsKey(RETURN_TYPE) && (mode = (String)config.get(RETURN_TYPE)).equalsIgnoreCase("plaintext")) {
            plainTextMode = true;
        }
        Struct result = new Struct();
        Key verificationKey = null;
        if (signOptions instanceof Key) {
            verificationKey = (Key)signOptions;
        } else if (signOptions instanceof KeyPair) {
            verificationKey = ((KeyPair)signOptions).getPrivate();
        } else if (signOptions instanceof Struct) {
            KeyPair keyPair = KeystoreUtils.getKeyPair((Map)signOptions);
            verificationKey = keyPair.getPrivate();
        } else if (signOptions instanceof String) {
            jwkVerification = true;
        } else {
            throw new IncorrectDatatypeException("signOptions", "Key or KeyPair or Struct or String");
        }
        JsonWebSignature jws = new JsonWebSignature();
        try {
            jws.setCompactSerialization(token);
            if (jwkVerification) {
                JsonWebKeySet jsonWebKeySet = new JsonWebKeySet((String)signOptions);
                VerificationJwkSelector jwkSelector = new VerificationJwkSelector();
                JsonWebKey jwk = jwkSelector.select(jws, (Collection)jsonWebKeySet.getJsonWebKeys());
                verificationKey = jwk.getKey();
            }
            jws.setKey(verificationKey);
            String plaintext = jws.getPayload();
            if (!plainTextMode && JSONUtils.isJSON(plaintext)) {
                Struct response = (Struct)JSONUtils.deserializeJSON(plaintext);
                return this.validateResponse(response, clockSkew);
            }
            result.put("plaintext", (Object)plaintext);
        }
        catch (JoseException e) {
            String exc = RB.getString(StandardJwtProvider.class, "StandardJwtProvider.UnableToVerifyJwt");
            CFLogs.SECURITY_LOG.error(exc, e);
            throw new JWTException(exc, e);
        }
        return result;
    }

    @Override
    public String createEncryptedJwt(Object payload, Object encryptOptions, Map config) {
        JsonWebEncryption jwe = new JsonWebEncryption();
        if (payload instanceof Struct) {
            Struct payLoadData = (Struct)payload;
            if (config.get(GENERATE_IAT) != null && Cast._boolean(config.get(GENERATE_IAT))) {
                this.generateIat(payLoadData);
            }
            if (config.get(GENERATE_JTI) != null && Cast._boolean(config.get(GENERATE_JTI))) {
                this.generateJti(payLoadData);
            }
            String json = JSONUtils.serializeJSON(payLoadData);
            jwe.setPayload(json);
        } else if (payload instanceof String) {
            jwe.setPayload((String)payload);
        }
        Key encryptionKey = null;
        if (encryptOptions instanceof Key) {
            encryptionKey = (Key)encryptOptions;
        } else if (encryptOptions instanceof KeyPair) {
            KeyPair keyPair = (KeyPair)encryptOptions;
            encryptionKey = keyPair.getPublic();
        } else if (encryptOptions instanceof Struct) {
            Struct keyStruct = (Struct)encryptOptions;
            if (keyStruct.containsKey(KEY)) {
                byte[] secKeyBytes = Base64Encoder.decode((String)keyStruct.get(KEY));
                encryptionKey = new SecretKeySpec(secKeyBytes, (String)keyStruct.get(KEY_ALGORITHM));
            } else {
                KeyPair keyPair = KeystoreUtils.getKeyPair((Map)encryptOptions);
                encryptionKey = keyPair.getPublic();
            }
        } else {
            throw new IncorrectDatatypeException("encryptOptions", "Key or KeyPair or Struct");
        }
        jwe.setKey(encryptionKey);
        Object algorithm = config.get(ALGORITHM);
        if (algorithm == null) {
            throw new JwtMissingFieldException(ALGORITHM);
        }
        if (!(algorithm instanceof String)) {
            throw new IncorrectDatatypeException(ALGORITHM, "String");
        }
        jwe.setAlgorithmHeaderValue((String)algorithm);
        Object encryptionAlgorithm = config.get(ENCRYPTION);
        if (encryptionAlgorithm == null) {
            throw new JwtMissingFieldException(ENCRYPTION);
        }
        if (!(encryptionAlgorithm instanceof String)) {
            throw new IncorrectDatatypeException(ENCRYPTION, "String");
        }
        jwe.setEncryptionMethodHeaderParameter((String)encryptionAlgorithm);
        try {
            String token = jwe.getCompactSerialization();
            return token;
        }
        catch (JoseException e) {
            String exc = RB.getString(StandardJwtProvider.class, "StandardJwtProvider.UnableToEncryptJwt");
            CFLogs.SECURITY_LOG.error(exc, e);
            throw new JWTException(exc, e);
        }
    }

    @Override
    public Struct verifyEncryptedJwt(String token, Object decryptOptions, Map config) {
        String mode;
        int clockSkew;
        boolean plainTextMode = false;
        boolean jwkDecryption = false;
        int n = clockSkew = config.containsKey(CLOCK_SKEW) ? (Integer)config.get(CLOCK_SKEW) : 0;
        if (config.containsKey(RETURN_TYPE) && (mode = (String)config.get(RETURN_TYPE)).equalsIgnoreCase("plaintext")) {
            plainTextMode = true;
        }
        Struct result = new Struct();
        Key decryptionKey = null;
        if (decryptOptions instanceof Key) {
            decryptionKey = (Key)decryptOptions;
        } else if (decryptOptions instanceof KeyPair) {
            decryptionKey = ((KeyPair)decryptOptions).getPrivate();
        } else if (decryptOptions instanceof Struct) {
            Struct keyStruct = (Struct)decryptOptions;
            if (keyStruct.containsKey(KEY)) {
                byte[] secKeyBytes = Base64Encoder.decode((String)keyStruct.get(KEY));
                decryptionKey = new SecretKeySpec(secKeyBytes, (String)keyStruct.get(KEY_ALGORITHM));
            } else {
                KeyPair keyPair = KeystoreUtils.getKeyPair((Map)decryptOptions);
                decryptionKey = keyPair.getPrivate();
            }
        } else if (decryptOptions instanceof String) {
            jwkDecryption = true;
        } else {
            throw new IncorrectDatatypeException("encryptOptions", "Key or KeyPair or Struct or String");
        }
        JsonWebEncryption jwe = new JsonWebEncryption();
        try {
            jwe.setCompactSerialization(token);
            if (jwkDecryption) {
                JsonWebKeySet jsonWebKeySet = new JsonWebKeySet((String)decryptOptions);
                DecryptionJwkSelector jwkSelector = new DecryptionJwkSelector();
                JsonWebKey jwk = jwkSelector.select(jwe, (Collection)jsonWebKeySet.getJsonWebKeys());
                decryptionKey = jwk.getKey();
            }
            jwe.setKey(decryptionKey);
            String plaintext = jwe.getPlaintextString();
            if (!plainTextMode && JSONUtils.isJSON(plaintext)) {
                Struct response = (Struct)JSONUtils.deserializeJSON(plaintext);
                return this.validateResponse(response, clockSkew);
            }
            result.put("plaintext", (Object)plaintext);
        }
        catch (JoseException e) {
            String exc = RB.getString(StandardJwtProvider.class, "StandardJwtProvider.UnableToDecryptJwt");
            CFLogs.SECURITY_LOG.error(exc, e);
            throw new JWTException(exc, e);
        }
        return result;
    }

    private void generateIat(Struct input) {
        Date date = new Date();
        input.put(IAT, (Object)date.getTime());
    }

    private void generateJti(Struct input) {
        byte[] randomBytes = ByteUtil.randomBytes((int)16);
        String jti = Base64Url.encode((byte[])randomBytes);
        input.put(JTI, (Object)jti);
    }

    private Struct validateResponse(Struct responseStruct, int clockSkew) {
        boolean valid = true;
        String invalidReason = null;
        Calendar calendar = Calendar.getInstance();
        if (responseStruct.containsKey(EXP)) {
            Date expiryDate = Cast._Date(responseStruct.get(EXP));
            calendar.setTime(expiryDate);
            responseStruct.put(EXP, (Object)calendar.getTime());
            calendar.add(13, clockSkew);
            if (calendar.getTimeInMillis() < new Date().getTime()) {
                valid = false;
                invalidReason = RB.getString(StandardJwtProvider.class, "StandardJwtProvider.Expired");
            }
            responseStruct.put(EXP, (Object)new OleDateTime(calendar.getTimeInMillis()));
        }
        if (responseStruct.containsKey(NBF)) {
            Date notBeforeDate = Cast._Date(responseStruct.get(NBF));
            calendar.setTime(notBeforeDate);
            responseStruct.put(NBF, (Object)calendar.getTime());
            calendar.add(13, clockSkew);
            if (calendar.getTimeInMillis() > new Date().getTime()) {
                valid = false;
                invalidReason = RB.getString(StandardJwtProvider.class, "StandardJwtProvider.InvalidNbf");
            }
            responseStruct.put(NBF, (Object)new OleDateTime(calendar.getTimeInMillis()));
        }
        responseStruct.put(VALID, (Object)valid);
        if (invalidReason != null) {
            responseStruct.put(VALIDATION_FAILED_REASON, (Object)invalidReason);
        }
        return responseStruct;
    }

    public class IncorrectDatatypeException
    extends ApplicationException {
        public Object input;
        public String type;

        public IncorrectDatatypeException(Object input, String type) {
            this.input = input;
            this.type = type;
        }
    }

    public class JwtMissingFieldException
    extends ApplicationException {
        public String field;

        public JwtMissingFieldException(String field) {
            this.field = field;
        }
    }

    public class JWTException
    extends ApplicationException {
        public String message;

        public JWTException(String message, Throwable e) {
            super(e);
            this.message = message;
        }
    }
}

