/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.log;

import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public enum CFPatternLayout {
    INSTANCE;

    private static final String header;
    private static final String LOGLEVEL_NAME_MAP = "{WARN=Warning, DEBUG=Debug, ERROR=Error, TRACE=Trace, INFO=Information, FATAL=Fatal}";
    private static final String LOGLEVEL_EXCEPTION_FULL = "%ex{full}";
    private static final String LOGLEVEL_PRIORITY_CHAR_1 = "%p";
    private static final String LOGLEVEL_PRIORITY_CHAR_2 = "%-5p";
    private static final String LOGLEVEL_DETAILED_MESSAGE_OLD_CHAR = "%x";
    private static final String LOGLEVEL_DETAILED_MESSAGE_NEW_CHAR = "%z";

    public PatternLayout getPatternLayout(Configuration config, String pattern, boolean logExceptions, boolean isCommandLine) {
        PatternLayout.Builder patternLayoutBuilder = PatternLayout.newBuilder().withConfiguration(config).withPattern(this.getLog4j2Pattern(pattern, logExceptions)).withAlwaysWriteExceptions(logExceptions);
        if (logExceptions || isCommandLine) {
            patternLayoutBuilder.withHeader("");
        } else {
            patternLayoutBuilder.withHeader(header);
        }
        return patternLayoutBuilder.build();
    }

    private String getLog4j2Pattern(String pattern, boolean logExceptions) {
        if (pattern != null) {
            if (((String)pattern).contains(LOGLEVEL_PRIORITY_CHAR_1) && !((String)pattern).contains(LOGLEVEL_NAME_MAP)) {
                pattern = ((String)pattern).replace(LOGLEVEL_PRIORITY_CHAR_1, "%p{WARN=Warning, DEBUG=Debug, ERROR=Error, TRACE=Trace, INFO=Information, FATAL=Fatal}");
            }
            if (((String)pattern).contains(LOGLEVEL_PRIORITY_CHAR_2) && !((String)pattern).contains(LOGLEVEL_NAME_MAP)) {
                pattern = ((String)pattern).replace(LOGLEVEL_PRIORITY_CHAR_2, "%-5p{WARN=Warning, DEBUG=Debug, ERROR=Error, TRACE=Trace, INFO=Information, FATAL=Fatal}");
            }
            if (((String)pattern).contains(LOGLEVEL_DETAILED_MESSAGE_OLD_CHAR)) {
                pattern = ((String)pattern).replace(LOGLEVEL_DETAILED_MESSAGE_OLD_CHAR, LOGLEVEL_DETAILED_MESSAGE_NEW_CHAR);
            }
            if (logExceptions && !((String)pattern).contains(LOGLEVEL_EXCEPTION_FULL)) {
                pattern = (String)pattern + LOGLEVEL_EXCEPTION_FULL;
            }
        }
        return pattern;
    }

    static {
        header = "\"Severity\",\"ThreadID\",\"Date\",\"Time\",\"Application\",\"Message\"" + System.getProperty("line.separator");
    }
}

