/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.log;

import coldfusion.log.CFLogLevel;
import coldfusion.log.CFPatternLayout;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public enum CFRollingFileAppender {
    INSTANCE;


    public RollingFileAppender getRollingFileAppender(Configuration config, String loggerName, String fileName, boolean logExceptions, boolean isCommandLine, boolean append, String pattern, int maxFileSize, int maxFileBackup) {
        DefaultRolloverStrategy strategy = this.getDefaultRolloverStrategy(config, maxFileBackup);
        PatternLayout layout = this.getPatternLayout(config, pattern, logExceptions, isCommandLine);
        String fName = CFRollingFileAppender.extractFileNameWithoutExtension(fileName);
        RollingFileAppender.Builder appenderBuilder = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setConfiguration(config)).setName(loggerName)).setLayout((Layout)layout)).withFileName(fileName).withFilePattern(fName + ".%i.log").withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)(Integer.toString(maxFileSize) + "KB"))).withStrategy((RolloverStrategy)strategy).withCreateOnDemand(true).withAppend(append);
        if (logExceptions) {
            ThresholdFilter thresholdFilter = ThresholdFilter.createFilter((Level)CFLogLevel.toLog4J2Level("error"), (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY);
            appenderBuilder.setFilter((Filter)thresholdFilter);
        }
        return appenderBuilder.build();
    }

    private static String extractFileNameWithoutExtension(String fileName) {
        int dotIndex;
        if (fileName != null && fileName.endsWith(".log") && (dotIndex = fileName.lastIndexOf(46)) != -1) {
            return fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    private DefaultRolloverStrategy getDefaultRolloverStrategy(Configuration config, int maxFileBackup) {
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withMax(String.valueOf(maxFileBackup)).withMin("1").withFileIndex("min").withConfig(config).withCompressionLevelStr(String.valueOf(0)).build();
        return strategy;
    }

    private PatternLayout getPatternLayout(Configuration config, String pattern, boolean logExceptions, boolean isCommandLine) {
        return CFPatternLayout.INSTANCE.getPatternLayout(config, pattern, logExceptions, isCommandLine);
    }
}

