/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.log;

import coldfusion.log.CFLogLevel;
import coldfusion.serverless.ServerlessUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.config.Configurator;

public class Logger {
    private org.apache.logging.log4j.Logger wrappedLogger;
    private String loggerName;
    private static String FQN = "Logger";
    private boolean loggingEnabled = true;
    public static final String CF_APPLICATION_NAME_KEY = "cfAppName";
    private static Map<String, Logger> loggerCache = new ConcurrentHashMap<String, Logger>();

    private Logger(String categoryName) {
        this.wrappedLogger = LogManager.getLogger((String)categoryName);
        if (categoryName.startsWith("coldfusion.user.")) {
            ((org.apache.logging.log4j.core.Logger)this.wrappedLogger).setAdditive(false);
        }
        this.loggerName = this.getLoggerName();
    }

    private String getLoggerName() {
        if (this.wrappedLogger.getName() != null && this.wrappedLogger.getName().indexOf(".") > -1 && this.wrappedLogger.getName().startsWith("coldfusion")) {
            int index = this.wrappedLogger.getName().lastIndexOf(".");
            return this.wrappedLogger.getName().substring(index + 1);
        }
        return null;
    }

    public static Logger getLogger(String name) {
        Logger logger = loggerCache.get(name);
        if (logger == null) {
            logger = new Logger(name);
            loggerCache.putIfAbsent(name, logger);
        }
        return logger;
    }

    public static boolean isLogger(String name) {
        return loggerCache.containsKey(name);
    }

    public void setLevel(Level l) {
        Configurator.setLevel((String)this.wrappedLogger.getName(), (Level)l);
    }

    public void setPriority(String priority) {
        this.setLevel(CFLogLevel.toLog4J2Level(priority));
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public void error(Throwable th) {
        this.wrappedLogger.error(this.getLogName() + th.getMessage(), th);
    }

    public void error(Object msg, Throwable th) {
        this.wrappedLogger.error(this.getLogName() + msg, th);
    }

    public void error(Object msg) {
        this.wrappedLogger.error(this.getLogName() + msg);
    }

    public void debug(Throwable th) {
        if (this.loggingEnabled) {
            this.wrappedLogger.debug(this.getLogName() + th.getMessage(), th);
        }
    }

    public void debug(Object msg, Throwable th) {
        if (this.loggingEnabled) {
            this.wrappedLogger.debug(this.getLogName() + msg, th);
        }
    }

    public void debug(Object msg) {
        if (this.loggingEnabled) {
            this.wrappedLogger.debug(this.getLogName() + msg);
        }
    }

    public void info(Throwable th) {
        if (this.loggingEnabled) {
            this.wrappedLogger.info(this.getLogName() + th.getMessage(), th);
        }
    }

    public void info(Object msg, Throwable th) {
        if (this.loggingEnabled) {
            this.wrappedLogger.info(this.getLogName() + msg, th);
        }
    }

    public void info(Object msg) {
        if (this.loggingEnabled) {
            this.wrappedLogger.info(this.getLogName() + msg);
        }
    }

    public void warn(Throwable th) {
        if (this.loggingEnabled) {
            this.wrappedLogger.warn(this.getLogName() + th.getMessage(), th);
        }
    }

    public void warn(Object msg, Throwable th) {
        if (this.loggingEnabled) {
            this.wrappedLogger.warn(this.getLogName() + msg, th);
        }
    }

    public void warn(Object msg) {
        if (this.loggingEnabled) {
            this.wrappedLogger.warn(this.getLogName() + msg);
        }
    }

    public void fatal(Throwable th) {
        this.wrappedLogger.fatal(this.getLogName() + th.getMessage(), th);
    }

    public void fatal(Object msg, Throwable th) {
        this.wrappedLogger.fatal(this.getLogName() + msg, th);
    }

    public void fatal(Object msg) {
        this.wrappedLogger.fatal(this.getLogName() + msg);
    }

    public void trace(Throwable th) {
        if (this.loggingEnabled) {
            this.wrappedLogger.trace(this.getLogName() + th.getMessage(), th);
        }
    }

    public void trace(Object msg, Throwable th) {
        if (this.loggingEnabled) {
            this.wrappedLogger.trace(this.getLogName() + msg, th);
        }
    }

    public void trace(Object msg) {
        if (this.loggingEnabled) {
            this.wrappedLogger.trace(this.getLogName() + msg);
        }
    }

    public boolean isDebugEnabled() {
        return this.wrappedLogger.isDebugEnabled();
    }

    public void applog(String priority, String appName, String message) {
        this.applog(priority, appName, message, null);
    }

    public void applog(String priority, String appName, String message, Throwable th) {
        String msg = this.getLogName(appName) + message;
        ThreadContext.put((String)CF_APPLICATION_NAME_KEY, (String)appName);
        this.wrappedLogger.log(CFLogLevel.toLog4J2Level(priority), msg, th);
        ThreadContext.remove((String)CF_APPLICATION_NAME_KEY);
    }

    public org.apache.logging.log4j.Logger getWrappedLogger() {
        return this.wrappedLogger;
    }

    private String getLogName() {
        return this.getLogName(this.loggerName);
    }

    private String getLogName(String appName) {
        if (appName != null && ServerlessUtil.isLambdaEnv()) {
            return "[" + appName + "] - ";
        }
        return "";
    }
}

