/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.mail.core;

import coldfusion.mail.core.MailSessionException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ExpressionException;
import coldfusion.util.ExceptionUtils;

public class MailExceptions {

    public static class InvalidCharacterEncodingException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String encoding;

        public InvalidCharacterEncodingException(String e) {
            this.encoding = e;
        }
    }

    public static class InvalidIDNAVersionException
    extends ApplicationException {
    }

    public static class InvalidSignAttributesException
    extends ApplicationException {
    }

    public static class KeyStoreNotFoundException
    extends ApplicationException {
        public String filename;

        public KeyStoreNotFoundException(String filename) {
            this.filename = filename;
        }
    }

    public static class MailFileAttachException
    extends ApplicationException {
    }

    public static class MultipartException
    extends ApplicationException {
    }

    public static class MailBodyException
    extends ApplicationException {
        public MailBodyException(Throwable ex) {
            super(ex);
        }
    }

    public static class RecipientCertificateException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class MailEncryptionException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public MailEncryptionException(Throwable e) {
            super(e);
        }
    }

    public static class MailSignException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public MailSignException(Throwable e) {
            super(e);
        }
    }

    public static class UnrecoverablePrivateKeyException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public UnrecoverablePrivateKeyException(Throwable e) {
            super(e);
        }
    }

    public static class UnrecoverablePublicKeyException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String msg;

        public UnrecoverablePublicKeyException(Throwable e) {
            super(e);
        }

        public UnrecoverablePublicKeyException(String msg) {
            this.msg = msg;
        }
    }

    public static class UnsupportedAlgorithmException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String algo = "";

        public UnsupportedAlgorithmException(String algo) {
            this.algo = algo;
        }
    }

    public static class KeyNotFoundException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String keyalias;

        public KeyNotFoundException(String keyalias) {
            this.keyalias = keyalias;
        }
    }

    public static class InvalidKeystoreException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public InvalidKeystoreException(Throwable e) {
            super(e);
        }
    }

    public static class SpoolLockTimeoutException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidSpoolFileException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String filename;

        public InvalidSpoolFileException() {
            this.filename = "unknown";
        }

        public InvalidSpoolFileException(String file) {
            this.filename = file;
        }

        public void setFilename(String f) {
            this.filename = f;
        }
    }

    public static class ServerMissingException
    extends MailSessionException {
        private static final long serialVersionUID = 1L;

        public ServerMissingException() {
            super(new Exception());
        }
    }

    public static class PopTagException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public PopTagException(Throwable ex) {
            super(ExceptionUtils.getOriginalCause(ex));
        }
    }

    public static class EmptyAttributeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String attrName = null;

        public EmptyAttributeException(String attrName) {
            this.attrName = attrName;
        }
    }

    public static class ClosedConnectionException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String action;
        public String conName;

        public ClosedConnectionException(String action, String conName) {
            this.action = action;
            this.conName = conName;
        }
    }

    public static class InvalidConnectionException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String action;
        public String conName;

        public InvalidConnectionException(String action, String conName) {
            this.action = action;
            this.conName = conName;
        }
    }

    public static class InvalidStartRowException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public int startRow;
        public int numRows;

        public InvalidStartRowException(int startrow, int numrows) {
            this.startRow = startrow;
            this.numRows = numrows;
        }
    }

    public static class IMapTagException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String actionName;

        public IMapTagException(Throwable ex, String action) {
            super(ExceptionUtils.getOriginalCause(ex));
            this.actionName = action;
        }
    }
}

