/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.GenericSettings;
import coldfusion.monitor.MonitorSettings;
import coldfusion.monitor.Utils;
import coldfusion.monitor.alert.AlertConfig;
import coldfusion.monitor.alert.CustomAlertManager;
import coldfusion.monitor.beans.Cluster;
import coldfusion.monitor.beans.CodeProfilingRecord;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.scheduler.TaskScheduler;
import coldfusion.runtime.Struct;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.CFDataSourceProxy;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public enum Configuration {
    INSTANCE;

    private List<AlertConfig> alertConfig;
    private GenericSettings genSettings;
    private MonitorSettings mntrSettings;
    private boolean codeProfilerOn;
    private boolean isSettingLoaded;
    private boolean memoryProfilerOn;
    private Set<String> listToProfile;
    private String profileId;
    private String profilingLevel;
    private String instanceId;
    private String hostName;
    private String instanceName;
    private String displayName;
    private String instancePort;
    private String clusterId;
    private String serverIPAddress;
    private StringBuilder clusters;
    private String groupId;
    private String groupName;
    private Set<String> appList;
    private Set<String> applications;
    private Set<String> dbList;
    private Set<String> siteList;
    private CodeProfilingRecord codeProfilingRecord = null;
    private String connectorSecret;
    private String PMTDashboardUrl;
    private Cluster clusterObj;
    private Map<String, Struct> dataSources = null;
    private boolean esHealthy = true;
    private Map<String, List<Map<String, String>>> urlsToBeProfiled = null;
    private String uuid;
    private boolean httpsEnabled;
    private Logger logger = CFLogs.MONITOR_LOG;

    public CodeProfilingRecord getCodeProfilingRecord() {
        return this.codeProfilingRecord;
    }

    public String getConnectorSecret() {
        return this.connectorSecret;
    }

    public void setConnectorSecret(String connectorSecret) {
        this.connectorSecret = connectorSecret;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public void setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean isEsHealthy() {
        return this.esHealthy;
    }

    public void setEsHealthy(boolean esHealthy) {
        this.esHealthy = esHealthy;
    }

    public Cluster getClusterObj() {
        return this.clusterObj;
    }

    public void setClusterObj(Cluster clusterObj) {
        this.clusterObj = clusterObj;
    }

    private Configuration() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this.serverIPAddress = localHost.getHostAddress();
        }
        catch (UnknownHostException e) {
            this.logger.warn("Monitoring Service: Unable to determine the IP address of the server.", e);
            this.serverIPAddress = "";
        }
    }

    public boolean checkIfDBExists(String db) {
        if (this.dbList == null) {
            return false;
        }
        return this.dbList.contains(db + "_" + this.getConfigId()) && this.getDataSourcesMap().containsKey(db);
    }

    public boolean checkIfAppExists(String app) {
        if (this.appList == null) {
            return false;
        }
        return this.appList.contains(app + "_" + this.getConfigId());
    }

    public boolean checkIfSiteExists(String site) {
        if (this.siteList == null) {
            return false;
        }
        return this.siteList.contains(site + "_" + this.getConfigId());
    }

    public void updateAppList(String app, boolean isRest) {
        Struct str = new Struct();
        str.put("app_name", (Object)app);
        str.put("cluster_id", (Object)this.clusterId);
        str.put("instance_id", (Object)this.instanceId);
        str.put("group_id", (Object)this.groupId);
        str.put("rest", (Object)isRest);
        Struct appJson = new Struct();
        appJson.put("doc", (Object)str);
        appJson.put("doc_as_upsert", (Object)true);
        String jsonDocument = JSONConverter.toJson(appJson);
        int status = Client.get().indexDocument(jsonDocument, "applications", app + "_" + this.getConfigId());
        if (status == 200 || status == 201) {
            if (this.appList == null) {
                this.appList = new HashSet<String>();
                this.applications = new HashSet<String>();
            }
            this.appList.add(app + "_" + this.getConfigId());
            this.applications.add(app);
        } else {
            this.logger.error("Error updating application list with application name " + app + " status code " + status);
        }
    }

    private String modifyURL(String urlES) {
        return UrlEscapers.urlFragmentEscaper().escape(urlES);
    }

    public void updateDBList(String db) {
        Struct str = new Struct();
        str.put("db_name", (Object)db);
        str.put("cluster_id", (Object)this.clusterId);
        str.put("instance_id", (Object)this.instanceId);
        str.put("group_id", (Object)this.groupId);
        this.updateDataSourceDetails(str, db);
        int status = Client.get().indexDocument(JSONConverter.toJson(str), "databases", db + "_" + this.getConfigId());
        if (status == 200 || status == 201) {
            if (this.dbList == null) {
                this.dbList = new HashSet<String>();
            }
            this.dbList.add(db + "_" + this.getConfigId());
        } else {
            this.logger.error("Error updating db list with db " + db + " status code " + status);
        }
    }

    public void updateSiteList(String site, String siteType) {
        Struct str = new Struct();
        str.put("site_name", (Object)site);
        str.put("site_type", (Object)siteType);
        str.put("cluster_id", (Object)this.clusterId);
        str.put("instance_id", (Object)this.instanceId);
        str.put("group_id", (Object)this.groupId);
        String siteURL = "sites";
        int status = Client.get().indexDocument(JSONConverter.toJson(str), siteURL, site + "_" + this.getConfigId());
        if (status == 200 || status == 201) {
            if (this.siteList == null) {
                this.siteList = new HashSet<String>();
            }
            this.siteList.add(site + "_" + this.getConfigId());
        } else {
            this.logger.error("Error updating site list with site name " + site);
        }
    }

    public boolean isMonitoringEnabled() {
        return this.getMonitorSettings().isMonitoringEnabled() && this.isEsHealthy();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
        this.initializeSettings();
    }

    public boolean isMemoryProfilerOn() {
        return this.memoryProfilerOn;
    }

    public void setMemoryProfilerOn(boolean memoryProfilerOn) {
        this.memoryProfilerOn = memoryProfilerOn;
    }

    public Set<String> getListToProfile() {
        return this.listToProfile;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getprofilingLevel() {
        return this.profilingLevel;
    }

    public GenericSettings getGenericSettings() {
        return this.genSettings;
    }

    public MonitorSettings getMonitorSettings() {
        if (this.mntrSettings == null) {
            this.mntrSettings = new MonitorSettings();
        }
        return this.mntrSettings;
    }

    public boolean isCodeProfilerOn() {
        return this.codeProfilerOn;
    }

    public void startProfiling(String level, String profileId, long responseTimeThreshold) {
        this.codeProfilerOn = true;
        this.profileId = profileId;
        this.profilingLevel = level;
        this.codeProfilingRecord = new CodeProfilingRecord(profileId, level, System.currentTimeMillis(), 0L, this.instanceId, responseTimeThreshold);
    }

    public void stopProfiling() {
        this.codeProfilerOn = false;
        this.profileId = null;
        this.profilingLevel = null;
        this.codeProfilingRecord.setStopTime(System.currentTimeMillis());
        this.urlsToBeProfiled = null;
        try {
            Client.get().indexDocument(JSONConverter.toJson(this.codeProfilingRecord), "/profiling_history", 1);
        }
        catch (Throwable th) {
            this.logger.error("Exception while pushing profiling history in DataSource ");
            th.printStackTrace();
        }
    }

    public String getClusters() {
        return this.clusters.toString();
    }

    public void setClusters(String cluster) {
        if (this.clusters == null) {
            this.clusters = new StringBuilder();
            this.clusters.append(cluster);
        } else {
            this.clusters.append(",").append(cluster);
        }
    }

    public void initializeSettings() {
        String id = this.getConfigId();
        this.mntrSettings = this.getMonitorSettings(id);
        this.genSettings = this.getGenericSettings(id);
        this.alertConfig = this.getAlertSettings(id);
        CustomAlertManager.INSTANCE.load();
        if (this.mntrSettings != null) {
            this.isSettingLoaded = true;
        }
    }

    public void setHostName(String name) {
        if (name.isEmpty() || "$HOSTNAME$".equals(name)) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName().trim();
            }
            catch (UnknownHostException ex) {
                this.logger.warn("Exception while fetching Host Name ", ex);
            }
        } else {
            if ("$HOSTNAME$".equals(this.hostName)) {
                this.setInstanceId(name + ":" + this.instanceName + ":" + this.instancePort);
            }
            this.hostName = name;
            this.hostName = name.trim();
            this.logger.trace("Host Name " + name + " has been provided by User ");
        }
    }

    public void findGroupId() {
    }

    public String getConfigId() {
        if (this.clusterId != null) {
            return this.clusterId;
        }
        if (this.groupId != null) {
            return this.groupId;
        }
        return this.instanceId;
    }

    public List<AlertConfig> getAlertSettings(String id) {
        List<AlertConfig> alertSettings = null;
        String baseUrl = "/alert_settings/";
        String json = null;
        if (Client.get().documentExists(baseUrl, id)) {
            json = Client.get().getDocument(baseUrl, id);
            this.logger.debug("Alert Settings retireved from Data Source: " + id);
        } else {
            json = Client.get().getDocument(baseUrl, "default");
            this.logger.debug("Alert Settings retireved from Data Source: default");
        }
        alertSettings = JSONConverter.INSTANCE.toAlertSettings(json);
        return alertSettings;
    }

    public MonitorSettings getMonitorSettings(String id) {
        MonitorSettings mntrSettings = null;
        String baseUrl = "/monitor_settings/";
        String json = null;
        json = Client.get().documentExists(baseUrl, id) ? Client.get().getDocument(baseUrl, id) : Client.get().getDocument(baseUrl, "default");
        mntrSettings = JSONConverter.INSTANCE.toMonitorSettings(json);
        return mntrSettings;
    }

    public GenericSettings getGenericSettings(String id) {
        GenericSettings genSettings = null;
        String baseUrl = "/generic_settings/";
        if (Client.get().documentExists(baseUrl, id)) {
            String json = Client.get().getDocument(baseUrl, id);
            genSettings = JSONConverter.INSTANCE.toGenericObject(json);
        } else {
            String defaultJson = Client.get().getDocument(baseUrl, "default");
            genSettings = JSONConverter.INSTANCE.toGenericObject(defaultJson);
        }
        return genSettings;
    }

    public List<AlertConfig> getAlertConfig() {
        return this.alertConfig;
    }

    public boolean isSettingsLoaded() {
        return this.isSettingLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMonitorSettings(String id) {
        MonitorSettings monitorSettings = this.mntrSettings;
        synchronized (monitorSettings) {
            MonitorSettings oldMonitorSetting = this.mntrSettings;
            this.mntrSettings = this.getMonitorSettings(id);
            if (this.mntrSettings != null) {
                this.isSettingLoaded = true;
            }
            if (this.mntrSettings != null && oldMonitorSetting != null && oldMonitorSetting.getNonRequestTaskInterval() != this.mntrSettings.getNonRequestTaskInterval()) {
                TaskScheduler.INSTANCE.changeScheduleInterval(this.mntrSettings.getNonRequestTaskInterval());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGenericSettings(String id) {
        GenericSettings genericSettings = this.genSettings;
        synchronized (genericSettings) {
            this.genSettings = this.getGenericSettings(id);
            CustomAlertManager.INSTANCE.loadGeneralSettings();
        }
    }

    public void updateAlertSettings(String id, String settingType) {
        this.alertConfig = this.getAlertSettings(id);
        CustomAlertManager.INSTANCE.loadAlertConfigs(settingType);
    }

    public void reset() {
        this.genSettings = null;
        this.mntrSettings = null;
        this.alertConfig = null;
        this.PMTDashboardUrl = null;
        CustomAlertManager.INSTANCE.reset();
    }

    public void setListToProfile(String[] urlsOrApps) {
        if ("URL".equals(this.profilingLevel)) {
            this.storeInMemoryUrlProfilingList(urlsOrApps);
        } else if ("APPLICATION".equals(this.profilingLevel)) {
            this.listToProfile = Arrays.stream(urlsOrApps).collect(Collectors.toCollection(HashSet::new));
        }
    }

    private void storeInMemoryUrlProfilingList(String[] urlsOrApps) {
        for (int i = 0; i < urlsOrApps.length; ++i) {
            String urlWithQryParams = urlsOrApps[i];
            this.storeURLWithQryParameterMap(urlWithQryParams);
        }
    }

    public void storeURLWithQryParameterMap(String urlWithQryParams) {
        String[] tempArray = urlWithQryParams.split("\\?");
        String url = tempArray[0].trim();
        if (this.urlsToBeProfiled == null) {
            this.urlsToBeProfiled = new HashMap<String, List<Map<String, String>>>();
        }
        if (tempArray.length > 1) {
            List<Map<String, String>> listOfQueryParamMap = null;
            if (this.urlsToBeProfiled.containsKey(url)) {
                if (this.urlsToBeProfiled.get(url) != null) {
                    listOfQueryParamMap = this.urlsToBeProfiled.get(url);
                    this.updateURLMapWithQueryParamList(tempArray, url, listOfQueryParamMap);
                }
            } else {
                listOfQueryParamMap = new ArrayList<Map<String, String>>();
                this.updateURLMapWithQueryParamList(tempArray, url, listOfQueryParamMap);
            }
        } else {
            this.urlsToBeProfiled.put(url, null);
        }
    }

    private void updateURLMapWithQueryParamList(String[] tempArray, String url, List<Map<String, String>> listOfQueryParamMap) {
        Map<String, String> paramValueMap = this.convertQryParamsToMap(tempArray[1]);
        listOfQueryParamMap.add(paramValueMap);
        this.urlsToBeProfiled.put(url, listOfQueryParamMap);
    }

    public Map<String, String> convertQryParamsToMap(String qryParams) {
        HashMap<String, String> qryParamKeyValueMap = new HashMap<String, String>();
        String[] qryParamsArray = qryParams.split("&");
        for (int i = 0; i < qryParamsArray.length; ++i) {
            String temp = qryParamsArray[i];
            String[] keyValue = temp.split("=");
            qryParamKeyValueMap.put(keyValue[0], keyValue[1]);
        }
        return qryParamKeyValueMap;
    }

    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    public String getServerHostName() {
        return this.hostName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String contextRoot) {
        this.instanceName = contextRoot;
    }

    public String getInstancePort() {
        return this.instancePort;
    }

    public void setInstancePort(String j2eePort) {
        this.instancePort = j2eePort;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void updateClusterData(boolean isStandAlone) {
        if (isStandAlone) {
            this.persistClusterData("coldfusion.monitor.TomCatCluster");
            this.clusterId = this.findClusterIdForRemoteCFInstance();
        } else {
            this.instanceId = Utils.getInstanceId(this.hostName, this.instanceName, this.instancePort);
        }
        this.findAndSetGroupFilter();
        this.logger.debug("ClusterId: " + this.clusterId + " GroupId: " + this.groupId + " InstanceId: " + this.instanceId);
    }

    public void updateClusterIdForRemoteInstance(boolean isStandAlone) {
        if (isStandAlone) {
            this.persistClusterData("coldfusion.monitor.TomCatCluster");
            this.clusterId = this.findClusterIdForRemoteCFInstance();
        }
        this.logger.debug("ClusterId: " + this.clusterId + " GroupId: " + this.groupId + " InstanceId: " + this.instanceId);
    }

    private void findAndSetGroupFilter() {
        if (this.clusterId == null && Client.get().isInitialized()) {
            this.groupId = Client.get().findGroupId(this.instanceId);
        }
    }

    private String findClusterIdForRemoteCFInstance() {
        this.clusterId = this.findClusterIdUsingIP();
        this.clusterId = this.findClusterIdUsingHost();
        return this.clusterId;
    }

    private String findClusterIdUsingIP() {
        if (this.clusterId == null && Client.get().isInitialized()) {
            Cluster clstrObj = Client.get().findClusterId(this.serverIPAddress, this.instancePort);
            if (clstrObj != null && clstrObj.getInstances() != null) {
                for (Cluster.Instance inst : clstrObj.getInstances()) {
                    if (!this.instanceId.equals(inst.getInstanceId()) && !this.compareHostAndPort(inst, this.serverIPAddress)) continue;
                    this.clusterId = clstrObj.getClusterId();
                    if (this.instanceName.equals(inst.getName())) continue;
                    String oldInstanceName = this.instanceName;
                    this.instanceName = inst.getName();
                    Client.get().deleteDocument("instance-heartbeat", this.serverIPAddress + ":" + oldInstanceName + ":" + this.instancePort);
                    TaskScheduler.INSTANCE.updateStaticMetrics();
                }
            }
            if (this.clusterId != null) {
                INSTANCE.setInstanceId(this.serverIPAddress + ":" + this.instanceName + ":" + this.instancePort);
            }
        }
        return this.clusterId;
    }

    private boolean compareHostAndPort(Cluster.Instance inst, String host) {
        return inst.getHost().equals(host) && String.valueOf(inst.getPort()).equals(this.instancePort);
    }

    private String findClusterIdUsingHost() {
        if (this.clusterId == null && Client.get().isInitialized()) {
            Cluster clstrObj = Client.get().findClusterId(this.hostName, this.instancePort);
            if (clstrObj != null && clstrObj.getInstances() != null) {
                for (Cluster.Instance inst : clstrObj.getInstances()) {
                    if (!inst.isRemote() || !this.instanceId.equals(inst.getInstanceId()) && !this.compareHostAndPort(inst, this.hostName)) continue;
                    this.clusterId = clstrObj.getClusterId();
                    if (this.instanceName.equals(inst.getName())) continue;
                    Client.get().deleteDocument("instance-heartbeat", this.hostName + ":" + this.instanceName + ":" + this.instancePort);
                    this.instanceName = inst.getName();
                    TaskScheduler.INSTANCE.updateStaticMetrics();
                }
            }
            if (this.clusterId != null) {
                INSTANCE.setInstanceId(this.hostName + ":" + this.instanceName + ":" + this.instancePort);
            }
        }
        return this.clusterId;
    }

    private static String getApplicationServer() {
        if (System.getProperty("weblogic.Name") != null) {
            return "WebLogic";
        }
        try {
            Class<?> cl = Class.forName("com.ibm.websphere.runtime.ServerName");
            return "WebSphere";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String id) {
        this.instanceId = id;
    }

    public String getPMTDashboardUrl() {
        return this.PMTDashboardUrl;
    }

    public void setPMTDashboardUrl(String pMTDashboardUrl) {
        this.PMTDashboardUrl = pMTDashboardUrl;
    }

    public void persistClusterData(String clusterImpl) {
        try {
            Class<?> c = Class.forName(clusterImpl);
            Method method = c.getDeclaredMethod("updateClusterData", new Class[0]);
            Map inst = (Map)method.invoke(null, new Object[0]);
            this.instanceName = (String)inst.get("instanceName");
            this.instancePort = !this.isMonitoringEnabled() ? (String)inst.get("instancePort") : String.valueOf(ServiceFactory.getMonitoringService().getMonitoredPort());
            this.clusterId = (String)inst.get("clusterId");
            this.httpsEnabled = Boolean.valueOf((String)inst.get("https"));
            this.instanceId = Utils.getInstanceId(this.hostName, this.instanceName, this.instancePort);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public String findInstanceName() {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        String rootDir = runtimeService.getRootDir();
        String instanceName = Configuration.getRootDirName(rootDir);
        return instanceName;
    }

    private static String getRootDirName(String rootDir) {
        int index = rootDir.lastIndexOf(File.separator);
        String fileName = rootDir.substring(index + 1);
        return fileName;
    }

    public Set<String> getApplications() {
        return this.applications;
    }

    public void updateUniqueApplications(String appName) {
        this.applications.add(appName);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Map<String, Struct> getDataSourcesMap() {
        if (this.dataSources == null) {
            this.dataSources = new ConcurrentHashMap<String, Struct>();
        }
        return this.dataSources;
    }

    private void updateDataSourceDetails(Struct hostPortMap, String dbName) {
        try {
            this.dataSources = this.getDataSourcesMap();
            if (!this.dataSources.containsKey(dbName)) {
                this.updateHostPort(dbName);
            }
            if (this.dataSources.containsKey(dbName)) {
                Struct dbMap = this.dataSources.get(dbName);
                hostPortMap.put("host", dbMap.get("host"));
                hostPortMap.put("port", dbMap.get("port"));
                hostPortMap.put("vendor", dbMap.get("vendor"));
                hostPortMap.put("db_server_name", dbMap.get("db_server_name"));
            }
        }
        catch (Throwable th) {
            this.logger.error("Exception while getting datasource details for " + dbName, th);
        }
    }

    private void updateHostPort(String dbName) {
        try {
            Struct strt = new Struct();
            CFDataSource cfDataSource = null;
            if (ServiceFactory.getDataSourceService().getDatasource(dbName) instanceof CFDataSource) {
                cfDataSource = (CFDataSource)ServiceFactory.getDataSourceService().getDatasource(dbName);
                strt.put("host", (Object)cfDataSource.getDataSourceDef().getHost());
                strt.put("port", (Object)cfDataSource.getDataSourceDef().getPort());
                strt.put("vendor", (Object)cfDataSource.getDataSourceDef().getVendor());
                strt.put("db_server_name", (Object)cfDataSource.getDataSourceDef().getDatabase());
            } else if (ServiceFactory.getDataSourceService().getDatasource(dbName) instanceof CFDataSourceProxy) {
                URI uri;
                cfDataSource = ((CFDataSourceProxy)ServiceFactory.getDataSourceService().getDatasource(dbName)).getDatasource();
                String dbServerName = "";
                boolean namedInstance = false;
                String jdbcUrl = cfDataSource.getDataSourceDef().getUrl();
                jdbcUrl = jdbcUrl.startsWith("jdbc:macromedia") ? jdbcUrl.substring(16) : jdbcUrl.substring(5);
                if (jdbcUrl.contains("\\")) {
                    namedInstance = true;
                    uri = URI.create(jdbcUrl.split("\\\\")[0]);
                } else {
                    uri = URI.create(jdbcUrl.split(";")[0]);
                }
                Object host = "";
                Object port = "";
                host = namedInstance ? uri.getHost() + "\\" + jdbcUrl.split("\\\\")[1].split(";")[0] : uri.getHost();
                port = namedInstance ? null : Integer.valueOf(uri.getPort());
                if (namedInstance) {
                    String[] keyVal;
                    for (String key : keyVal = jdbcUrl.split("\\\\")[1].split(";")) {
                        if (!key.toLowerCase().startsWith("databasename")) continue;
                        dbServerName = key.split("=")[1];
                        break;
                    }
                } else {
                    if (jdbcUrl.split(";").length > 1) {
                        String[] keyVal;
                        for (String key : keyVal = jdbcUrl.split(";")[1].split(";")) {
                            if (key.toLowerCase().startsWith("databasename")) {
                                dbServerName = key.split("=")[1];
                                break;
                            }
                            if (!key.toLowerCase().startsWith("sid")) continue;
                            dbServerName = key.split("=")[1];
                            break;
                        }
                    }
                    if (dbServerName.isEmpty()) {
                        dbServerName = uri.getPath().substring(1);
                    }
                }
                strt.put("host", host);
                strt.put("port", port);
                strt.put("vendor", (Object)cfDataSource.getDataSourceDef().getVendor());
                strt.put("db_server_name", (Object)dbServerName);
            }
            this.dataSources.put(dbName, strt);
        }
        catch (Throwable th) {
            this.logger.error("Exception while fetching the host port of the DB in Configuration for db " + dbName, th);
        }
    }

    public void clearStaticList() {
        if (this.dbList != null && !this.dbList.isEmpty()) {
            this.dbList.clear();
        }
        if (this.siteList != null && !this.siteList.isEmpty()) {
            this.siteList.clear();
        }
        if (this.appList != null && !this.appList.isEmpty()) {
            this.appList.clear();
        }
    }

    public boolean validateUrlForProfiling(String url, Map reqQryParameters) {
        if (this.urlsToBeProfiled.containsKey(url)) {
            if (this.urlsToBeProfiled.get(url) == null) {
                return true;
            }
            List<Map<String, String>> paramKeyList = this.urlsToBeProfiled.get(url);
            boolean paramMatches = false;
            for (Map<String, String> storedQryParam : paramKeyList) {
                if (!this.matchesEachQueryParam(reqQryParameters, storedQryParam)) continue;
                paramMatches = true;
                break;
            }
            return paramMatches;
        }
        return false;
    }

    private boolean matchesEachQueryParam(Map reqQryParameters, Map<String, String> storedQryParam) {
        boolean profileUrl = true;
        for (Map.Entry<String, String> entryObj : storedQryParam.entrySet()) {
            String[] valueMap = (String[])reqQryParameters.get(entryObj.getKey());
            boolean keyExists = reqQryParameters.containsKey(entryObj.getKey());
            String storedParamValue = entryObj.getValue();
            if (keyExists && storedParamValue.equals(valueMap[0])) continue;
            profileUrl = false;
            break;
        }
        return profileUrl;
    }

    public void removeApplication(String applicationName) {
        this.appList.remove(applicationName + "_" + this.getConfigId());
    }

    public void removeSite(String siteName) {
        this.siteList.remove(siteName + "_" + this.getConfigId());
    }

    static final class Fields {
        static final String UNDER_SCORE = "_";
        static final String FORWARD_SLASH = "/";
        static final String DEFAULT_HOST_NAME = "$HOSTNAME$";

        Fields() {
        }
    }
}

