/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.Cluster;
import coldfusion.monitor.datastore.Client;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.server.ServiceFactory;
import com.adobe.coldfusion.entman.ClusterManager;
import com.adobe.coldfusion.entman.ProcessServer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TomCatCluster {
    private static Logger logger = CFLogs.MONITOR_LOG;

    public static Map<String, String> updateClusterData() {
        String hostName = Configuration.INSTANCE.getServerHostName();
        logger.debug("Host name being used while updating cluster data " + hostName);
        String instanceName = Configuration.INSTANCE.findInstanceName();
        String instancePort = null;
        String clusterId = null;
        boolean httpsEnabled = false;
        boolean clusterUpdated = false;
        HashMap<String, String> instanceData = new HashMap<String, String>();
        String configDir = ServiceFactory.getRuntimeService().getRootDir() + File.separator + ".." + File.separator + "config";
        ClusterManager cm = new ClusterManager();
        ProcessServer ps = new ProcessServer();
        cm.setConfigDir(configDir);
        ps.setConfigDir(configDir);
        instancePort = ps.getServerPort(instanceName);
        httpsEnabled = ps.isHttpsEnabled(instanceName);
        for (String cluster : cm.getClusters()) {
            if (clusterUpdated) break;
            logger.debug("Cluster name :" + cluster);
            Cluster cs = new Cluster();
            cs.setName(cluster);
            cs.setHost(hostName);
            ArrayList<Cluster.Instance> ls = new ArrayList<Cluster.Instance>();
            for (String server : cm.getServers(cluster)) {
                Cluster.Instance ins = new Cluster.Instance();
                ins.setName(server);
                if (ps.isServerRemote(server)) {
                    Map remoteInstance = ps.listRemoteServer(server);
                    ins.setIsRemote(true);
                    ins.setHost((String)remoteInstance.get("host"));
                    int remotePort = Integer.parseInt((String)remoteInstance.get("httpport"));
                    ins.setPort(remotePort);
                    String serverName = server.split("_")[0];
                    ins.setName(serverName);
                    ins.setInstanceId((String)remoteInstance.get("host") + ":" + serverName + ":" + remotePort);
                } else {
                    String port = ps.getServerPort(server);
                    if (port != null && port.length() > 0) {
                        ins.setPort(Integer.parseInt(port));
                        if (clusterId == null && server.equals(instanceName) && instancePort.equals(port)) {
                            clusterId = hostName + ":" + cluster;
                        }
                    }
                    ins.setHost(hostName);
                    ins.setIsRemote(false);
                    ins.setInstanceId(hostName + ":" + server + ":" + port);
                }
                ls.add(ins);
            }
            cs.setClusterId(hostName + ":" + cluster);
            cs.setInstances(ls);
            if (!Client.get().isInitialized() || clusterId == null) continue;
            Configuration.INSTANCE.setClusterObj(cs);
            Client.get().upsert(JSONConverter.toJson(cs), "cluster_config_data", hostName + ":" + cluster);
            clusterUpdated = true;
        }
        instanceData.put("instanceName", instanceName);
        instanceData.put("instancePort", instancePort);
        instanceData.put("clusterId", clusterId);
        if (httpsEnabled) {
            instanceData.put("https", "true");
        } else {
            instanceData.put("https", "false");
        }
        logger.trace("Instance name and port :" + instanceName + instancePort + "and clusterid " + clusterId);
        return instanceData;
    }
}

