/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.active;

import coldfusion.CfmServlet;
import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.VariableBean;
import coldfusion.monitor.memory.MemoryCalculator;
import coldfusion.monitor.memory.MemoryMonitor;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.sql.QueryMonitor;
import coldfusion.monitor.stack.CFStack;
import coldfusion.monitor.stack.JStackTrace;
import coldfusion.monitor.stack.JStackTraceFactory;
import coldfusion.monitor.util.AttributeTypes;
import coldfusion.monitor.util.CFThreadMonitorData;
import coldfusion.monitor.util.CFthreadDictionary;
import coldfusion.monitor.util.PMTThreadDictionary;
import coldfusion.monitor.util.PMTThreadDictionaryFactory;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.monitor.util.ThreadDictionary;
import coldfusion.monitor.util.ThreadMonitorData;
import coldfusion.monitor.util.ThreadType;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SecurityScopeTracker;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.SessionTracker;
import coldfusion.runtime.Struct;
import coldfusion.runtime.async.Executor;
import coldfusion.server.MetricsService;
import coldfusion.server.ServiceFactory;
import coldfusion.thread.CFThreadManager;
import coldfusion.xml.rpc.CFCServlet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public enum ActiveRequestMonitor {
    INSTANCE;

    private static Logger logger;
    private static final String LINE_SEP;
    private volatile short alertsCounter = 0;
    private static boolean classLoaderSet;

    public static ActiveRequestMonitor getInstance() {
        return INSTANCE;
    }

    public boolean isRejectNewRequestsEnabled() {
        return this.alertsCounter > 0;
    }

    public void rejectNewRequests() {
        this.alertsCounter = (short)(this.alertsCounter + 1);
    }

    public void acceptNewRequests() {
        this.alertsCounter = (short)(this.alertsCounter - 1);
        if (this.alertsCounter < 0) {
            this.alertsCounter = 0;
        }
    }

    public List getAllActiveSessions(String appName) {
        return this.getAllActiveSessions(appName, false);
    }

    public List getAllActiveSessions(String appName, boolean withVariables) {
        ArrayList<Struct> returnList = new ArrayList<Struct>();
        Iterator<String> sessionKeys = SessionTracker.getSessionKeys();
        Set appKeySet = null;
        if (sessionKeys != null) {
            while (sessionKeys.hasNext()) {
                ConcurrentMap<String, Object> appSessions = SessionTracker.getAppSessionMap(sessionKeys.next());
                if (appSessions == null || appSessions.isEmpty() || (appKeySet = appSessions.keySet()) == null) continue;
                Iterator appKeys = appKeySet.iterator();
                while (appKeys != null && appKeys.hasNext()) {
                    List<VariableBean> variables;
                    String appNameKey = (String)appKeys.next();
                    Struct sessionMap = new Struct();
                    long sessionSize = 0L;
                    SessionScope session = (SessionScope)appSessions.get(appNameKey);
                    if (session == null || session.expired() || appName != null && !session.getAppName().equalsIgnoreCase(appName)) continue;
                    MemoryTracker mt = session.getMemoryTracker();
                    if (mt != null) {
                        sessionSize = mt.getEstimatedMemory();
                    }
                    sessionMap.put("CFSESSIONID", (Object)session.getTrackerSessionId());
                    sessionMap.put("SESSIONID", (Object)session.getSessionId());
                    sessionMap.put("APPNAME", (Object)session.getAppName());
                    sessionMap.put("SESSIONSIZE", (Object)new Long(sessionSize));
                    sessionMap.put("ELAPSEDTIME", (Object)new Long(session.getElapsedTime()));
                    sessionMap.put("TIMESINCELASTACCESS", (Object)new Long(session.getTimeSinceLastAccess()));
                    sessionMap.put("MAXINACTIVEINTERVAL", (Object)new Long(session.getMaxInactiveInterval() * 1000L));
                    sessionMap.put("CLIENTIPADDRESS", (Object)(session.getClientIp() == null ? "" : session.getClientIp()));
                    if (withVariables && (variables = MemoryMonitor.getVariablesMemory(session)) != null) {
                        sessionMap.put("SESSIONSCOPESVARIABLES", (Object)variables);
                    }
                    returnList.add(sessionMap);
                }
            }
        }
        return returnList;
    }

    public List getAllActiveRequests() {
        ArrayList<Struct> returnList = new ArrayList<Struct>();
        ArrayList<Struct> scopesVar = null;
        ThreadDictionary.FusionContextExtraInfo[] threadInfo = ThreadDictionary.getInstance().getCurrentValues();
        for (int i = 0; i < threadInfo.length; ++i) {
            Struct requestMap = new Struct();
            ThreadDictionary.FusionContextExtraInfo contextInfo = threadInfo[i];
            RequestMonitorData r = contextInfo.getMonitorData();
            if (contextInfo.getContext() == null || r == null) continue;
            requestMap.put("CLIENTIPADDRESS", (Object)contextInfo.getClientIpAddress());
            requestMap.put("THREADNAME", (Object)contextInfo.getThreadName());
            requestMap.put("THREADPRIORITY", (Object)Integer.toString(contextInfo.getThread().getPriority()));
            requestMap.put("TIMETAKEN", (Object)new Long(System.currentTimeMillis() - contextInfo.getContext().getStartTime().getTime()));
            if (r.getAliasName() != null) {
                requestMap.put("TEMPLATEPATH", (Object)r.getAliasName());
            } else {
                requestMap.put("TEMPLATEPATH", (Object)r.getTemplatePath());
            }
            requestMap.put("REQTYPE", (Object)r.getReqType());
            String functionName = r.getRequestFunctionName();
            if (functionName == null) {
                functionName = "";
            }
            requestMap.put("FUNCTIONNAME", (Object)functionName);
            requestMap.put("URI", (Object)(r.getUri() == null ? "" : r.getUri()));
            requestMap.put("METHOD", (Object)(r.getHttpMethod() == null ? "" : r.getHttpMethod()));
            CFStack cfStack = r.getCFStack();
            ArrayList stackFrames = cfStack != null ? cfStack.getStackFramesAsStrings() : new ArrayList();
            requestMap.put("CFSTACKTRACE", (Object)stackFrames);
            Scope hiddenScope = contextInfo.getContext().hiddenScope;
            Long requestMemory = null;
            if (hiddenScope != null && hiddenScope.keySet() != null) {
                Iterator itrAllScopes = hiddenScope.keySet().iterator();
                scopesVar = new ArrayList<Struct>();
                while (itrAllScopes.hasNext()) {
                    String scpType = (String)itrAllScopes.next();
                    ArrayList<Struct> listVar = null;
                    if (scpType == null || "FILE".equals(scpType)) continue;
                    if ("REQUEST".equals(scpType)) {
                        requestMemory = new Long(MemoryCalculator.calculateMemory(hiddenScope.get("REQUEST")));
                    }
                    if (hiddenScope.get(scpType) != null) {
                        Iterator itrScope = ((Map)hiddenScope.get(scpType)).entrySet().iterator();
                        listVar = new ArrayList<Struct>();
                        while (itrScope.hasNext()) {
                            Struct tempStore = new Struct();
                            Map.Entry entry = itrScope.next();
                            String varType = AttributeTypes.getAttributeType(entry.getValue());
                            tempStore.put("VARIABLENAME", entry.getKey());
                            if ("SIMPLE".equals(varType)) {
                                String varValue = "";
                                if (entry.getValue() != null) {
                                    varValue = entry.getValue().toString();
                                }
                                if (varValue.length() > 100) {
                                    varValue = varValue.substring(0, 99);
                                }
                                tempStore.put("VARIABLEVALUE", (Object)varValue);
                            } else {
                                tempStore.put("VARIABLEVALUE", (Object)varType);
                            }
                            if (Configuration.INSTANCE.getMonitorSettings().isCfadminMonitoringEnabled()) {
                                tempStore.put("size", (Object)new Long(MemoryCalculator.calculateMemory(entry.getValue())));
                            } else {
                                tempStore.put("size", (Object)null);
                            }
                            listVar.add(tempStore);
                        }
                    }
                    Struct toAdd = new Struct();
                    toAdd.put("SCOPE", (Object)scpType);
                    toAdd.put("SCOPEVARIABLES", (Object)listVar);
                    scopesVar.add(toAdd);
                }
            }
            requestMap.put("VARIABLELIST", (Object)scopesVar);
            requestMap.put("REQUESTMEMORY", (Object)requestMemory);
            returnList.add(requestMap);
        }
        return returnList;
    }

    public Struct getActiveThreadStackTrace(String threadName, ThreadType threadType) {
        Struct requestMap = new Struct();
        if (threadName == null || threadType == null) {
            return requestMap;
        }
        PMTThreadDictionary threadDictionary = PMTThreadDictionaryFactory.getInstance(threadType);
        ThreadMonitorData tmd = threadDictionary.getThreadMonitorData(threadName);
        RequestMonitorData rmd = tmd.getParentRequestMonitorData();
        requestMap = (Struct)tmd.getThreadInfoMap();
        return requestMap;
    }

    public Struct getActiveRequestStackTrace(String threadId) {
        ThreadDictionary.FusionContextExtraInfo info = ThreadDictionary.getInstance().get(threadId);
        Struct requestMap = new Struct();
        RequestMonitorData r = info.getMonitorData();
        if (info.getContext() != null && r != null) {
            requestMap.put("CLIENTIPADDRESS", (Object)info.getClientIpAddress());
            requestMap.put("THREADNAME", (Object)info.getThreadName());
            requestMap.put("TIMETAKEN", (Object)new Long(System.currentTimeMillis() - info.getContext().getStartTime().getTime()));
            if (r.getAliasName() != null) {
                requestMap.put("TEMPLATEPATH", (Object)r.getAliasName());
            } else {
                requestMap.put("TEMPLATEPATH", (Object)r.getTemplatePath());
            }
            requestMap.put("REQTYPE", (Object)r.getReqType());
            String functionName = r.getRequestFunctionName();
            if (functionName == null) {
                functionName = "";
            }
            requestMap.put("FUNCTIONNAME", (Object)functionName);
            requestMap.put("URI", (Object)(r.getUri() == null ? "" : r.getUri()));
            requestMap.put("METHOD", (Object)(r.getHttpMethod() == null ? "" : r.getHttpMethod()));
            CFStack cfStack = r.getCFStack();
            ArrayList stackFrames = cfStack != null ? cfStack.getStackFramesAsStrings() : new ArrayList();
            requestMap.put("CFSTACKTRACE", (Object)stackFrames);
            JStackTrace jstack = JStackTraceFactory.providerInstance();
            StackTraceElement[] jStackFrames = jstack.getStackTraceElements(info.getThread());
            if (jStackFrames != null) {
                ArrayList<String> jStackFrameList = new ArrayList<String>();
                for (int j = 0; j < jStackFrames.length; ++j) {
                    jStackFrameList.add(jStackFrames[j].toString());
                }
                requestMap.put("JAVASTACKTRACE", (Object)jStackFrameList);
            }
        }
        return requestMap;
    }

    public List getAllActiveCFThreads() {
        return this.getAllActiveThreads(ThreadType.CFTHREAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getAllActiveThreads(ThreadType threadType) {
        ArrayList<Map> returnList = new ArrayList<Map>();
        ThreadMonitorData[] allActiveThreads = PMTThreadDictionary.getInstance(threadType).getAllActiveThreads();
        for (int i = 0; i < allActiveThreads.length; ++i) {
            ThreadMonitorData tmd;
            ThreadMonitorData threadMonitorData = tmd = allActiveThreads[i];
            synchronized (threadMonitorData) {
                if (tmd.isActive()) {
                    returnList.add(this.getThreadInfoMap(tmd));
                }
                continue;
            }
        }
        return returnList;
    }

    public List getAllActiveCallableThreads() {
        return this.getAllActiveThreads(ThreadType.CALLABLE);
    }

    public int getActiveCFThreadCount() {
        return CFthreadDictionary.getInstance().getActiveThreadCount();
    }

    public int getCFThreadsQueued() {
        return CFThreadManager.getThreadPool().getQueueSize();
    }

    private Map getThreadInfoMap(ThreadMonitorData tmd) {
        Struct threadInfoMap = new Struct();
        threadInfoMap.put("SPAWNEDFROM", (Object)tmd.getTemplatePath());
        threadInfoMap.put("REQUESTTEMPLATE", (Object)tmd.getParentRequestMonitorData().getTemplatePath());
        threadInfoMap.put("LINENO", (Object)Integer.toString(tmd.getLineNo()));
        threadInfoMap.put("CFTHREADNAME", (Object)tmd.getThreadName());
        threadInfoMap.put("THREADNAME", (Object)tmd.getJavaThreadName());
        threadInfoMap.put("TIMETAKEN", (Object)Long.toString(tmd.getElapsedTime()));
        threadInfoMap.put("THREADPRIORITY", (Object)Integer.toString(tmd.getPriority()));
        CFStack cfStack = tmd.getCFStack();
        ArrayList stackFrames = cfStack != null ? cfStack.getStackFramesAsStrings() : new ArrayList();
        threadInfoMap.put("CFSTACKTRACE", (Object)stackFrames);
        JStackTrace jstack = JStackTraceFactory.providerInstance();
        StackTraceElement[] jStackFrames = null;
        if (tmd.getOwnerThread() != null) {
            jStackFrames = jstack.getStackTraceElements(tmd.getOwnerThread());
        }
        if (jStackFrames != null) {
            ArrayList<String> jStackFrameList = new ArrayList<String>();
            for (int j = 0; j < jStackFrames.length; ++j) {
                jStackFrameList.add(jStackFrames[j].toString());
            }
            threadInfoMap.put("JAVASTACKTRACE", (Object)jStackFrameList);
        }
        return threadInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveCFThreads(String requestThreadName) {
        ArrayList<Map> returnList = new ArrayList<Map>();
        ThreadDictionary.FusionContextExtraInfo info = ThreadDictionary.getInstance().get(requestThreadName);
        if (info != null) {
            RequestMonitorData monitorData = info.getMonitorData();
            CFThreadMonitorData[] threadMonitors = monitorData.getThreadMonitorData();
            for (int i = 0; i < threadMonitors.length; ++i) {
                CFThreadMonitorData tmd;
                CFThreadMonitorData cFThreadMonitorData = tmd = threadMonitors[i];
                synchronized (cFThreadMonitorData) {
                    if (tmd.isActive()) {
                        returnList.add(this.getThreadInfoMap(tmd));
                    }
                    continue;
                }
            }
        }
        return returnList;
    }

    public Map getCFThreadDetail(String javaThreadName) {
        CFThreadMonitorData threadMonitorData = CFthreadDictionary.getInstance().getThreadMonitorData(javaThreadName);
        if (threadMonitorData == null || !threadMonitorData.isActive()) {
            return Collections.EMPTY_MAP;
        }
        return this.getThreadInfoMap(threadMonitorData);
    }

    public boolean abortCFThread(String javaThreadName, String threadType) {
        ThreadType type = ThreadType.valueOf(threadType);
        ThreadMonitorData threadMonitorData = PMTThreadDictionary.getInstance(type).getThreadMonitorData(javaThreadName);
        boolean success = false;
        if (threadMonitorData != null) {
            JStackTrace jstack;
            String stackTrace;
            Thread thread = threadMonitorData.getOwnerThread();
            StringBuffer msgBuff = new StringBuffer();
            msgBuff.append("Aborting CFThread ");
            msgBuff.append(threadMonitorData.getThreadName());
            msgBuff.append(" spawned at ");
            msgBuff.append(threadMonitorData.getTemplatePath()).append(" : ").append(threadMonitorData.getLineNo());
            CFStack cfStack = threadMonitorData.getCFStack();
            if (cfStack != null) {
                msgBuff.append(LINE_SEP).append("CFML stack: ").append(LINE_SEP).append(cfStack.toString());
            }
            if ((stackTrace = (jstack = JStackTraceFactory.providerInstance()).getStackTrace(thread)) != null && !stackTrace.trim().equals("")) {
                msgBuff.append(LINE_SEP).append("Java stack: ").append(LINE_SEP).append(stackTrace);
            }
            logger.info(msgBuff.toString());
            thread.interrupt();
            success = true;
        } else {
            logger.info("Abort request failed, thread " + javaThreadName + " is not executing any CFThread");
        }
        return success;
    }

    public List getActiveQueries() {
        return QueryMonitor.INSTANCE.getActiveQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCallableQueueStats() {
        Struct callableThreadStats = new Struct();
        if (classLoaderSet) {
            this.setCallableQueueStatus(callableThreadStats);
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            BootstrapClassLoader bscl = null;
            try {
                bscl = BootstrapClassLoader.instance();
                if (cl != bscl) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)bscl);
                }
                this.setCallableQueueStatus(callableThreadStats);
                classLoaderSet = true;
            }
            finally {
                if (cl != bscl) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        }
        return callableThreadStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCFThreadQueueStats() {
        Struct threadQueueStats = new Struct();
        if (classLoaderSet) {
            this.setThreadQueueStatus(threadQueueStats);
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            BootstrapClassLoader bscl = null;
            try {
                bscl = BootstrapClassLoader.instance();
                if (cl != bscl) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)bscl);
                }
                this.setThreadQueueStatus(threadQueueStats);
                classLoaderSet = true;
            }
            finally {
                if (cl != bscl) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        }
        return threadQueueStats;
    }

    private void setThreadQueueStatus(Map threadQueueStats) {
        threadQueueStats.put("cf_threads_queued", new Integer(this.getCFThreadsQueued()));
        threadQueueStats.put("cf_threads_running", new Integer(this.getActiveCFThreadCount()));
    }

    private void setCallableQueueStatus(Map callableThreadStats) {
        callableThreadStats.put("async_threads_running", Executor.getActiveThreadCount());
        callableThreadStats.put("async_threads_queued", Executor.getQueuedThreadCount());
    }

    public Map getRequestQueueStats() {
        Struct requestQueueStats = new Struct();
        MetricsService metrics = null;
        try {
            metrics = ServiceFactory.getMetricsService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CfmServlet cfmServlet = CfmServlet.getCfmServlet();
        if (cfmServlet != null) {
            int requestsRunning = cfmServlet.getRequestsRunning();
            int requestsQueued = cfmServlet.getRequestsQueued();
            requestQueueStats.put("template_req_running", new Integer(requestsRunning));
            requestQueueStats.put("template_req_queue", new Integer(requestsQueued));
            requestQueueStats.put("template_req_timeout", new Integer(cfmServlet.getRequestsTimedout()));
            CFCServlet cfc = CFCServlet.getCFCServlet();
            int webServiceRunning = cfc.getWebServiceRequestsRunning();
            int webServiceQueued = cfc.getWebServiceRequestsQueued();
            requestQueueStats.put("web_service_req_running", new Integer(webServiceRunning));
            requestQueueStats.put("web_service_req_queued", new Integer(webServiceQueued));
            requestQueueStats.put("web_service_req_timeout", new Integer(cfc.getWebServiceRequestsTimedout()));
            int cfcRunning = cfc.getCFCRequestsRunning();
            int cfcQueued = cfc.getCFCRequestsQueued();
            requestQueueStats.put("cfc_req_running", new Integer(cfcRunning));
            requestQueueStats.put("cfc_req_queued", new Integer(cfcQueued));
            requestQueueStats.put("cfc_req_timeout", new Integer(cfc.getCFCRequestsTimedout()));
            boolean isJRun = false;
            int jrunQueued = 0;
            int jrunRunning = 0;
            int totalQueued = jrunQueued + requestsQueued + webServiceQueued + cfcQueued;
            requestQueueStats.put("req_queued", new Integer(totalQueued));
            int totalRunning = requestsRunning + webServiceRunning + cfcRunning;
            if (isJRun && (totalRunning = jrunRunning - (requestsQueued + webServiceQueued + cfcQueued)) < 0) {
                totalRunning = 0;
            }
            requestQueueStats.put("req_running", new Integer(totalRunning));
        }
        return requestQueueStats;
    }

    public int getLoggedInUserCount() {
        return SecurityScopeTracker.getInstance().getSecurityScopeCount();
    }

    public int getActiveSessionCount(String appName) {
        return SessionTracker.getActiveSessionCount(appName);
    }

    public boolean abortRequest(String threadName) {
        boolean success = false;
        ThreadDictionary.FusionContextExtraInfo info = ThreadDictionary.getInstance().get(threadName);
        if (info != null) {
            JStackTrace jstack;
            String stackTrace;
            RequestMonitorData rmd = info.getMonitorData();
            StringBuffer msgBuff = new StringBuffer();
            msgBuff.append("Interrupting request ");
            msgBuff.append(rmd.getTemplatePath());
            if (rmd.getRequestFunctionName() != null) {
                msgBuff.append(" :: ").append(rmd.getRequestFunctionName()).append("()");
            }
            msgBuff.append(" handled by thread ").append(threadName);
            CFStack cfStack = rmd.getCFStack();
            if (cfStack != null) {
                msgBuff.append(LINE_SEP).append("CFML stack: ").append(LINE_SEP).append(cfStack.toString());
            }
            if ((stackTrace = (jstack = JStackTraceFactory.providerInstance()).getStackTrace(info.getThread())) != null && !stackTrace.trim().equals("")) {
                msgBuff.append(LINE_SEP).append("Java stack: ").append(LINE_SEP).append(stackTrace);
            }
            logger.info(msgBuff.toString());
            Thread thread = info.getThread();
            thread.interrupt();
            success = true;
        } else {
            logger.info("Interrupted request failed, thread " + threadName + " is not handling any requests");
        }
        logger.info("Interrupted thread " + threadName + " current thread " + Thread.currentThread().getName());
        return success;
    }

    static {
        logger = CFLogs.MONITOR_LOG;
        LINE_SEP = System.getProperty("line.separator");
        classLoaderSet = false;
    }

    public static class RequestAbortedException
    extends ApplicationException {
        public RequestAbortedException(Throwable ex) {
            super(ex);
        }
    }
}

